/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class LaserSquadScenarioFile {
    private String[] SourceData = null;
    private int SourceDataPointer = 0;
    private int[] BitCue = new int[128];
    private int BitCueBits = 0;
    private int SourceStringNumber = 0;
    public static final String INARRAY = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890+-";
    private int OutputSameCount;
    private boolean bSameMode;
    private ByteArrayOutputStream baosOutputCompare;
    private DataOutputStream dosOutputCompare;
    private int InputSameCount = 0;
    private boolean bInputSameMode = false;

    public LaserSquadScenarioFile(String[] stringArray) {
        this.SourceData = stringArray;
    }

    protected final String readLine() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(20);
        while ((n = this.getBits(7)) != 10) {
            stringBuffer.append((char)n);
            if (n != 13) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private final void skipBits(int n) {
        if (n <= this.BitCueBits) {
            System.arraycopy(this.BitCue, n, this.BitCue, 0, this.BitCueBits - n);
            this.BitCueBits -= n;
            return;
        }
        this.SourceDataPointer += (n -= this.BitCueBits) / 6;
        this.BitCueBits = 6 - n % 6;
        while (this.SourceDataPointer >= this.SourceData[this.SourceStringNumber].length()) {
            this.SourceDataPointer -= this.SourceData[this.SourceStringNumber++].length();
        }
        int n2 = INARRAY.indexOf(this.SourceData[this.SourceStringNumber].charAt(this.SourceDataPointer++));
        n2 >>= n % 6;
        int n3 = 0;
        while (n3 < this.BitCueBits) {
            this.BitCue[n3] = (int)((long)n2 & 1L);
            ++n3;
            n2 >>= 1;
        }
        if (this.SourceDataPointer == this.SourceData[this.SourceStringNumber].length()) {
            this.SourceDataPointer = 0;
            ++this.SourceStringNumber;
        }
    }

    private final int getBits(int n) {
        int n2;
        while (n > this.BitCueBits) {
            char c = this.SourceData[this.SourceStringNumber].charAt(this.SourceDataPointer++);
            if (this.SourceDataPointer == this.SourceData[this.SourceStringNumber].length()) {
                this.SourceDataPointer = 0;
                ++this.SourceStringNumber;
            }
            long l = INARRAY.indexOf(c);
            n2 = 0;
            while (n2 < 6) {
                this.BitCue[this.BitCueBits++] = (int)(l & 1L);
                ++n2;
                l >>= 1;
            }
        }
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n3 += this.BitCue[n2] << n2;
        }
        for (n2 = 0; n2 < 99 - n; ++n2) {
            this.BitCue[n2] = this.BitCue[n2 + n];
        }
        this.BitCueBits -= n;
        return n3;
    }

    private final int getSignedBits(int n) {
        int n2 = this.getBits(n);
        if (n2 > (n = 1 << n) >> 1) {
            n2 -= n;
        }
        return n2;
    }

    private final int[] getCauseAndEffect() {
        int n = this.getBits(16);
        if ((n += this.getBits(16) << 16) == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.getBits(16);
        }
        return nArray;
    }

    private final Image getImage(Component component) throws LSException {
        int n;
        int[] nArray = new int[256];
        int[] nArray2 = new int[4096];
        int[] nArray3 = new int[4096];
        int n2 = this.getBits(12);
        if (n2 == 0) {
            Image image = null;
            if (component.getClass().getName().equals("LaserSquad")) {
                image = ((LaserSquad)component).getImage(((LaserSquad)component).getDocumentBase(), this.readLine());
            }
            MediaTracker mediaTracker = new MediaTracker(component);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                throw new LSException("/P0B04CAN'T READ GRAPHICS FILES/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
            }
            return image;
        }
        if (n2 == 2) {
            int n3 = this.getBits(8) << 8;
            int n4 = this.getBits(8) << 8;
            int n5 = (n4 += this.getBits(8)) * (n3 += this.getBits(8));
            int[] nArray4 = new int[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                nArray4[n2] = this.getBits(24);
            }
            return component.createImage(new MemoryImageSource(n3, n4, nArray4, 0, n3));
        }
        int n6 = this.getBits(8) << 8;
        int n7 = this.getBits(8) << 8;
        int[] nArray5 = new int[(n7 += this.getBits(8)) * (n6 += this.getBits(8))];
        int n8 = this.getBits(8);
        n2 = 0;
        while (n2 < 1 << n8) {
            nArray[n2] = -16777216;
            int n9 = n2++;
            nArray[n9] = nArray[n9] | this.getBits(24);
        }
        int n10 = n = (n8 <= 1 ? 2 : n8) + 1;
        int n11 = 1 << n - 1;
        int n12 = n11 + 1;
        int n13 = 1 << n;
        int n14 = n12 + 1;
        for (n2 = 0; n2 <= n12; ++n2) {
            nArray2[n2] = n2 | 0xFFFF000;
        }
        int n15 = 0;
        int n16 = -1;
        while ((n2 = this.getBits(n10)) != n12) {
            int n17;
            if (n2 == n11) {
                n14 = n12 + 1;
                n10 = n;
                n13 = 1 << n;
                n16 = -1;
                continue;
            }
            int n18 = n2;
            if (n14 == n13 - 1 && n10 < 12) {
                n13 = 1 << ++n10;
            }
            if (n2 == n14) {
                n17 = 0;
                n2 = nArray2[n16];
                while (true) {
                    nArray3[n17++] = n2 & (1 << n) - 1;
                    if ((n2 & 0xFFFF000) == 0xFFFF000) break;
                    n2 = nArray2[n2 >> 12 & 0xFFF];
                }
                nArray2[n18] = (n16 << 12) + nArray3[n17 - 1];
            }
            n2 = nArray2[n18];
            n17 = 0;
            while (true) {
                nArray3[n17++] = n2 & (1 << n) - 1;
                if ((n2 & 0xFFFF000) == 0xFFFF000) break;
                n2 = nArray2[n2 >> 12 & 0xFFF];
            }
            if (n14 < n13) {
                if (n16 != -1) {
                    nArray2[n14++] = (n16 << 12) + nArray3[n17 - 1];
                }
                n16 = n18;
            }
            while (n17 > 0) {
                nArray5[n15++] = nArray[nArray3[--n17]];
            }
        }
        return component.createImage(new MemoryImageSource(n6, n7, nArray5, 0, n6));
    }

    public final Scenario GetScenario(Component component, String string) throws LSException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[100];
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<Object> vector3 = new Vector<Object>();
        Scenario scenario = new Scenario();
        scenario.ScenarioClassName = string;
        scenario.Items = new Item[50];
        for (n5 = 0; n5 < scenario.Items.length; ++n5) {
            scenario.Items[n5] = null;
        }
        for (n5 = 0; n5 < 64; ++n5) {
            scenario.Counters[n5] = 0;
        }
        try {
            Item item;
            int n6;
            scenario.name = this.readLine();
            if (this.getBits(12) > 1) {
                throw new LSException("/P0806UPDATE YOUR VERSION/P0B09OF LASER SQUAD/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
            }
            scenario.MapHeight = this.getBits(12);
            scenario.MapWidth = this.getBits(12);
            scenario.MaxTurns = this.getBits(16);
            scenario.MaxLevel = this.getBits(8);
            scenario.NumberOfUnitTypes = this.getBits(12);
            scenario.NumberOfTerrainBands = this.getBits(12);
            scenario.NumberOfRegions = this.getBits(16);
            scenario.Nodes = new Point[this.getBits(16)];
            n4 = this.getBits(8);
            n3 = this.getBits(16);
            scenario.Units = new Unit[n3];
            for (n5 = 0; n5 < scenario.Units.length; ++n5) {
                scenario.Units[n5] = null;
            }
            n2 = this.getBits(16);
            n = this.getBits(16);
            scenario.Terrains = new Terrain[n];
            scenario.Map = new int[scenario.MapWidth * scenario.MapHeight];
            int n7 = this.getBits(5);
            for (n5 = 0; n5 < scenario.Map.length; ++n5) {
                scenario.Map[n5] = this.getBits(n7);
            }
            scenario.deployMap = new int[scenario.MapWidth * scenario.MapHeight];
            n7 = 0;
            for (n5 = 0; n5 < scenario.MapHeight; ++n5) {
                n6 = 0;
                while (n6 < scenario.MapWidth) {
                    scenario.deployMap[n7] = this.getBits(n4);
                    ++n6;
                    ++n7;
                }
            }
            scenario.Teams = new Team[n4];
            for (n5 = 0; n5 < n4; ++n5) {
                Team team = new Team();
                team = new Team();
                team.teamNumber = n5;
                team.name = this.readLine();
                team.flags = this.getBits(3);
                team.colour = this.getBits(8);
                team.VPWipeOut = this.getBits(8);
                team.Credits = this.getBits(16);
                if (team.IsHuman() && scenario.MaxLevel > 0) {
                    team.CreditsAtLevel = new int[scenario.MaxLevel];
                    for (n7 = 0; n7 < scenario.MaxLevel; ++n7) {
                        team.CreditsAtLevel[n7] = this.getBits(16);
                    }
                }
                if (team.IsComputer()) {
                    team.MemoryLengthAtLevel = new int[scenario.MaxLevel];
                    for (n7 = 0; n7 < scenario.MaxLevel; ++n7) {
                        team.MemoryLengthAtLevel[n7] = this.getBits(16);
                    }
                }
                if ((n7 = this.getBits(16)) > 0) {
                    team.TerrainsCanDestroy = new int[n7];
                    for (n7 = 0; n7 < team.TerrainsCanDestroy.length; ++n7) {
                        team.TerrainsCanDestroy[n7] = this.getBits(16);
                    }
                }
                if ((n7 = this.getBits(16)) > 0) {
                    team.TargetTerrainLocation = new Point[n7];
                    team.TargetTerrainClosestNode = new int[n7];
                    team.TargetTerrainGenericValue = new int[n7];
                    for (n7 = 0; n7 < team.TargetTerrainClosestNode.length; ++n7) {
                        team.TargetTerrainLocation[n7] = new Point(this.getBits(12), this.getBits(12));
                        team.TargetTerrainClosestNode[n7] = this.getBits(16);
                        team.TargetTerrainGenericValue[n7] = this.getBits(16);
                    }
                }
                team.MapView.setLocation(5, 5);
                team.MapTL.setLocation(scenario.MapWidth - 11 >> 1, scenario.MapHeight - 11 >> 1);
                scenario.Teams[n5] = team;
            }
            scenario.genericItems = new GenericItem[n2];
            for (n5 = 0; n5 < n2; ++n5) {
                GenericItem genericItem = new GenericItem();
                genericItem.picture = n + n5;
                genericItem.name = this.readLine();
                genericItem.flags = this.getBits(8);
                genericItem.weight = this.getBits(12);
                genericItem.size = this.getBits(12);
                genericItem.strength = this.getBits(12);
                genericItem.APtoGetPast = this.getBits(8);
                genericItem.APHandToHandDivisor = this.getBits(8);
                genericItem.BaseAccuracyHandToHand = this.getBits(12);
                genericItem.BaseDamageHandToHand = this.getBits(12);
                genericItem.ExtraDamageHandToHand = this.getBits(8);
                genericItem.ExtraAccuracyHandToHand = this.getBits(8);
                genericItem.APSnapDivisor = this.getBits(8);
                genericItem.APAimDivisor = this.getBits(8);
                genericItem.APAutoShotDivisor = this.getBits(8);
                genericItem.accuracySnap = this.getBits(12);
                genericItem.accuracyAim = this.getBits(12);
                genericItem.accuracyAutoShot = this.getBits(12);
                genericItem.damageShoot = this.getBits(12);
                genericItem.ammo = this.getBits(16);
                genericItem.range = this.getBits(16);
                genericItem.rangedDifficulty = this.getBits(12);
                genericItem.Cost = new int[n4];
                for (n7 = 0; n7 < n4; ++n7) {
                    genericItem.Cost[n7] = this.getBits(12);
                }
                genericItem.ThreatValue = new int[n4];
                for (n7 = 0; n7 < n4; ++n7) {
                    genericItem.ThreatValue[n7] = this.getBits(12);
                }
                genericItem.HitEffects = this.getCauseAndEffect();
                n7 = this.getBits(16);
                if (n7 > 0) {
                    genericItem.AnimationDetails = new int[n7 * 2];
                    for (n7 = 0; n7 < genericItem.AnimationDetails.length; ++n7) {
                        genericItem.AnimationDetails[n7] = this.getBits(16);
                    }
                }
                if ((n7 = this.getBits(16)) > 0) {
                    genericItem.TargettingAnimationDetails = new int[n7 * 2];
                    for (n7 = 0; n7 < genericItem.TargettingAnimationDetails.length; ++n7) {
                        genericItem.TargettingAnimationDetails[n7] = this.getBits(16);
                    }
                }
                scenario.genericItems[n5] = genericItem;
            }
            n7 = scenario.NumberOfUnitTypes;
            n6 = 0;
            while (n7 > 0) {
                n7 >>= 1;
                ++n6;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                Unit unit = new Unit(scenario);
                unit.iOrigionalScenarioPosition = n5;
                scenario.AddUnit(unit, component);
                unit.name = this.readLine();
                unit.unitType = this.getBits(n6);
                unit.headding = this.getBits(3);
                unit.MorraleValues = new int[n4];
                for (n7 = 0; n7 < n4; ++n7) {
                    unit.MorraleValues[n7] = this.getSignedBits(12);
                }
                unit.VictoryPointValues = new int[n4];
                for (n7 = 0; n7 < n4; ++n7) {
                    unit.VictoryPointValues[n7] = this.getBits(12);
                }
                unit.ItemWhenDead = this.getBits(16);
                unit.terrainBand = this.getBits(12);
                unit.team = this.getBits(8);
                unit.strength = this.getBits(12);
                unit.agility = this.getBits(12);
                unit.weaponSkill = this.getBits(12);
                unit.closeCombatDamage = this.getBits(12);
                unit.toughness = this.getBits(12);
                unit.size = this.getBits(12);
                unit.maxSizeCarried = this.getBits(12);
                unit.fatigue = this.getBits(12);
                unit.currentActionPoints = this.getBits(12);
                unit.maxActionPoints = this.getBits(12);
                unit.currentConstitution = this.getBits(12);
                unit.maxConstitution = this.getBits(12);
                unit.currentStamina = this.getBits(12);
                unit.maxStamina = this.getBits(12);
                unit.currentMorrale = this.getBits(12);
                unit.maxMorrale = this.getBits(12);
                for (n7 = 0; n7 < 4; ++n7) {
                    unit.armour[n7] = this.getBits(12);
                }
                unit.armourWeight = this.getBits(12);
                unit.startRound = this.getBits(16);
                unit.startLevels = this.getBits(scenario.MaxLevel + 1);
                unit.startY = this.getBits(12);
                unit.startX = this.getBits(12);
                unit.startDY = this.getBits(12);
                unit.startDX = this.getBits(12);
                unit.flags = this.getBits(20);
                unit.SetIsInPlay(false);
                unit.flags2 = this.getBits(20);
                unit.TargetPatrolWayPointNumber = this.getBits(16);
                n7 = this.getBits(16);
                if (n7 > 0) {
                    unit.PatrolRouteWayPoints = new int[n7];
                    for (n7 = 0; n7 < unit.PatrolRouteWayPoints.length; ++n7) {
                        unit.PatrolRouteWayPoints[n7] = this.getBits(16);
                    }
                }
                if (scenario.NumberOfRegions > 0) {
                    unit.RegionThreatValues = new int[scenario.NumberOfRegions];
                    for (n7 = 0; n7 < scenario.NumberOfRegions; ++n7) {
                        unit.RegionThreatValues[n7] = this.getBits(12);
                    }
                }
                unit.RoundsUntilForgotten = new int[n4];
                for (n7 = 0; n7 < n4; ++n7) {
                    unit.RoundsUntilForgotten[n7] = 0;
                }
                unit.MinRangeAimedAttempted = this.getBits(16);
                unit.MinRangeSnapAttempted = this.getBits(16);
                n7 = this.getBits(16);
                if (n7 > 0) {
                    unit.TerrainsWantToDestroy = new int[n7];
                    for (n7 = 0; n7 < unit.TerrainsWantToDestroy.length; ++n7) {
                        unit.TerrainsWantToDestroy[n7] = this.getBits(16);
                    }
                }
                unit.DeathEffects = this.getCauseAndEffect();
                unit.itemHeld = null;
                for (n7 = this.getBits(16); n7 > 0; --n7) {
                    item = new Item(scenario, this.getBits(16));
                    item.ammo = this.getBits(16);
                    item.owner = unit.number;
                    scenario.AddItem(item);
                    if (this.getBits(1) == 1) {
                        unit.itemHeld = item;
                    }
                    unit.weightCarried += item.GetWeight();
                    unit.sizeCarried += item.GetSize();
                }
            }
            n7 = this.getBits(16);
            n5 = 0;
            while (n5 < n7) {
                item = new Item(scenario, this.getBits(16));
                item.iOrigionalItemNumber = n5++;
                item.MapPos.setLocation(this.getBits(12), this.getBits(12));
                item.terrainUnder = this.getBits(16);
                item.ammo = this.getBits(16);
                item.owner = -1;
                scenario.AddItem(item);
            }
            scenario.ArmourData = new int[5][6 + n4];
            for (n5 = 0; n5 < 5; ++n5) {
                for (n7 = 0; n7 < 6 + n4; ++n7) {
                    scenario.ArmourData[n5][n7] = this.getBits(12);
                }
            }
            for (n5 = 0; n5 < n; ++n5) {
                Terrain terrain = new Terrain();
                terrain.name = this.readLine();
                terrain.picture = n5;
                terrain.strength = this.getBits(12);
                terrain.becomesWhenDammaged = this.getBits(16);
                terrain.forceAbsorbed = this.getBits(12);
                terrain.protection = this.getBits(12);
                terrain.flags = this.getBits(12);
                terrain.maxHideSize = this.getBits(12);
                terrain.explodeForce = this.getBits(12);
                terrain.open = this.getBits(16);
                terrain.lock = this.getBits(16);
                n7 = this.getBits(16);
                if (n7 > 0) {
                    terrain.keys = new int[n7];
                    for (n7 = 0; n7 < terrain.keys.length; ++n7) {
                        terrain.keys[n7] = this.getBits(16);
                    }
                }
                terrain.VictoryPointValues = new int[n4];
                for (n7 = 0; n7 < n4; ++n7) {
                    terrain.VictoryPointValues[n7] = this.getBits(12);
                }
                terrain.MorraleValues = new int[n4];
                for (n7 = 0; n7 < n4; ++n7) {
                    terrain.MorraleValues[n7] = this.getSignedBits(12);
                }
                terrain.MovementCost = new int[scenario.NumberOfTerrainBands];
                for (n7 = 0; n7 < scenario.NumberOfTerrainBands; ++n7) {
                    terrain.MovementCost[n7] = this.getBits(12);
                }
                n7 = this.getBits(16);
                if (n7 > 0) {
                    terrain.AnimationDetails = new int[n7 * 2];
                    for (n7 = 0; n7 < terrain.AnimationDetails.length; ++n7) {
                        terrain.AnimationDetails[n7] = this.getBits(16);
                    }
                }
                if ((n7 = this.getBits(16)) > 0) {
                    terrain.TargettingAnimationDetails = new int[n7 * 2];
                    for (n7 = 0; n7 < terrain.TargettingAnimationDetails.length; ++n7) {
                        terrain.TargettingAnimationDetails[n7] = this.getBits(16);
                    }
                }
                scenario.Terrains[n5] = terrain;
            }
            scenario.UnitTypePictures = new int[scenario.NumberOfUnitTypes][n2 + 1];
            for (n5 = 0; n5 < scenario.NumberOfUnitTypes; ++n5) {
                for (n7 = 0; n7 <= n2; ++n7) {
                    scenario.UnitTypePictures[n5][n7] = this.getBits(16);
                }
            }
            scenario.UnitDeathPictures = new int[scenario.NumberOfUnitTypes][];
            for (n5 = 0; n5 < scenario.NumberOfUnitTypes; ++n5) {
                for (n7 = 0; n7 < 100 && (n6 = this.getBits(16)) != 0; ++n7) {
                    if (n6 > scenario.BaseSpecialPic) {
                        scenario.BaseSpecialPic = n6;
                    }
                    nArray[n7] = n6;
                }
                scenario.UnitDeathPictures[n5] = new int[n7];
                System.arraycopy(nArray, 0, scenario.UnitDeathPictures[n5], 0, n7);
            }
            ++scenario.BaseSpecialPic;
            for (n5 = 0; n5 < scenario.NumberOfUnitTypes; ++n5) {
                this.readLine();
            }
            if (scenario.NumberOfRegions > 0) {
                n7 = this.getBits(16) * 5;
                scenario.RegionDefinition = new int[n7];
                for (n5 = 0; n5 < n7; ++n5) {
                    scenario.RegionDefinition[n5] = this.getBits(12);
                }
                scenario.InterRegionDistance = new int[scenario.NumberOfRegions + 1][scenario.NumberOfRegions + 1];
                for (n5 = 0; n5 <= scenario.NumberOfRegions; ++n5) {
                    for (n6 = 0; n6 <= scenario.NumberOfRegions; ++n6) {
                        scenario.InterRegionDistance[n5][n6] = this.getBits(16);
                    }
                }
                if (scenario.Nodes.length > 0) {
                    for (n5 = 0; n5 < scenario.Nodes.length; ++n5) {
                        scenario.Nodes[n5] = new Point(this.getBits(12), this.getBits(12));
                    }
                }
                scenario.NodeConnections = new int[scenario.Nodes.length][];
                if (scenario.Nodes.length > 0) {
                    for (n5 = 0; n5 < scenario.Nodes.length; ++n5) {
                        scenario.NodeConnections[n5] = new int[n6];
                        n7 = 0;
                        for (n6 = this.getBits(16); n6 > 0; --n6) {
                            scenario.NodeConnections[n5][n7++] = this.getBits(16);
                        }
                    }
                }
            }
            int n8 = -1;
            while ((n6 = this.getBits(8)) != 0) {
                switch (n6) {
                    case 1: {
                        scenario.PreMoveCauseAndEffects = this.getCauseAndEffect();
                        break;
                    }
                    case 2: {
                        scenario.EndOfTurnCauseAndEffects = this.getCauseAndEffect();
                        break;
                    }
                    case 3: {
                        scenario.PathNodeLimit = this.getBits(12);
                        break;
                    }
                    case 4: {
                        vector.add(this.readLine());
                        vector.add(this.getCauseAndEffect());
                        vector.add(this.getCauseAndEffect());
                        break;
                    }
                    case 5: {
                        scenario.SetupEffects = this.getCauseAndEffect();
                        break;
                    }
                    case 6: {
                        scenario.PickUpEffects = this.getCauseAndEffect();
                        break;
                    }
                    case 7: {
                        scenario.DropEffects = this.getCauseAndEffect();
                        break;
                    }
                    case 8: {
                        scenario.Briefing = new String[n4 * 2 + 2];
                        for (n5 = 0; n5 < scenario.Briefing.length; ++n5) {
                            scenario.Briefing[n5] = this.readLine();
                        }
                        break;
                    }
                    case 9: {
                        scenario.ChangeEffects = this.getCauseAndEffect();
                        break;
                    }
                    case 10: {
                        scenario.EndOfGameEffects = this.getCauseAndEffect();
                        break;
                    }
                    case 11: {
                        scenario.SelectUnitEffects = this.getCauseAndEffect();
                        break;
                    }
                    case 12: {
                        scenario.ItemDestroyedEffects = this.getCauseAndEffect();
                        break;
                    }
                    case 13: {
                        scenario.TerrainDestroyedEffects = this.getCauseAndEffect();
                        break;
                    }
                    case 14: {
                        scenario.ScenarioSystemFlags = this.getBits(12);
                        break;
                    }
                    case 15: {
                        n5 = this.getBits(12);
                        if (n5 > n8) {
                            n8 = n5;
                        }
                        vector2.add(new Integer(n5));
                        n5 = this.getBits(16);
                        nArray = new int[n5 += this.getBits(16) << 16];
                        n5 = 0;
                        while (n5 < nArray.length) {
                            nArray[n5++] = this.getSignedBits(32);
                        }
                        vector2.add(nArray);
                        break;
                    }
                    case 16: {
                        vector3.add(this.readLine());
                        vector3.add(this.getCauseAndEffect());
                    }
                }
            }
            if (!vector.isEmpty()) {
                scenario.ExtraPlayerOptionsStrings = new String[vector.size() / 3];
                scenario.ExtraPlayerOptionsCauses = new int[scenario.ExtraPlayerOptionsStrings.length][];
                scenario.ExtraPlayerOptionsEffects = new int[scenario.ExtraPlayerOptionsStrings.length][];
                n7 = 0;
                for (n5 = 0; n5 < scenario.ExtraPlayerOptionsStrings.length; ++n5) {
                    scenario.ExtraPlayerOptionsStrings[n5] = (String)vector.elementAt(n7++);
                    scenario.ExtraPlayerOptionsCauses[n5] = (int[])vector.elementAt(n7++);
                    scenario.ExtraPlayerOptionsEffects[n5] = (int[])vector.elementAt(n7++);
                }
            }
            if (!vector2.isEmpty()) {
                scenario.caeArrays = new int[n8 + 1][];
                while (!vector2.isEmpty()) {
                    n5 = (Integer)vector2.remove(0);
                    scenario.caeArrays[n5] = (int[])vector2.remove(0);
                }
            }
            if (!vector3.isEmpty()) {
                scenario.caeRoutineNames = new String[vector3.size() / 2];
                scenario.caeRoutines = new int[scenario.caeRoutineNames.length][];
                n7 = 0;
                for (n5 = 0; n5 < scenario.caeRoutineNames.length; ++n5) {
                    scenario.caeRoutineNames[n5] = (String)vector3.elementAt(n7++);
                    scenario.caeRoutines[n5] = (int[])vector3.elementAt(n7++);
                }
            }
        }
        catch (Exception exception) {
            throw new LSException("/P0B04CAN'T LOAD SCENARIO FILE/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        scenario.BaseItemPic = n;
        scenario.BaseUnitPic = n2 + n;
        scenario.BaseTargetPic = n3 + n2 + n;
        scenario.CursorPic = scenario.BaseTargetPic * 2;
        scenario.BaseDeployPic = scenario.CursorPic + 1;
        scenario.BaseFlashPic = scenario.BaseDeployPic + n4;
        scenario.Sprites = null;
        if (component.getClass().getName().equals("LaserSquad") && !((LaserSquad)component).RunningInFrame()) {
            ((LaserSquad)component).showStatus("Loading Graphics......");
        }
        Image image = this.getImage(component);
        scenario.Sprites = component.createImage(image.getWidth(component), image.getHeight(component));
        scenario.Sprites.getGraphics().drawImage(image, 0, 0, null);
        image = this.getImage(component);
        scenario.Scanner = component.createImage(image.getWidth(component), image.getHeight(component));
        scenario.Scanner.getGraphics().drawImage(image, 0, 0, null);
        return scenario;
    }

    private void OutputCompareInt(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        if (this.bSameMode) {
            if (n == n2) {
                ++this.OutputSameCount;
            } else {
                dataOutputStream.writeInt(this.OutputSameCount);
                this.OutputSameCount = 1;
                this.bSameMode = false;
                this.baosOutputCompare = new ByteArrayOutputStream();
                this.dosOutputCompare = new DataOutputStream(this.baosOutputCompare);
                int n3 = 0;
                while (n3 < 4) {
                    this.dosOutputCompare.writeByte(n & 0xFF);
                    ++n3;
                    n >>= 8;
                }
            }
            return;
        }
        if (n != n2) {
            int n4 = 0;
            while (n4 < 4) {
                this.dosOutputCompare.writeByte(n & 0xFF);
                ++n4;
                n >>= 8;
            }
            ++this.OutputSameCount;
        } else {
            dataOutputStream.writeInt(this.OutputSameCount);
            this.OutputSameCount = 1;
            this.bSameMode = true;
            this.dosOutputCompare.close();
            this.baosOutputCompare.close();
            byte[] byArray = this.baosOutputCompare.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
        }
    }

    private void OutputCompareShort(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        if (this.bSameMode) {
            if (n == n2) {
                ++this.OutputSameCount;
            } else {
                dataOutputStream.writeInt(this.OutputSameCount);
                this.OutputSameCount = 1;
                this.bSameMode = false;
                this.baosOutputCompare = new ByteArrayOutputStream();
                this.dosOutputCompare = new DataOutputStream(this.baosOutputCompare);
                int n3 = 0;
                while (n3 < 2) {
                    this.dosOutputCompare.writeByte(n & 0xFF);
                    ++n3;
                    n >>= 8;
                }
            }
            return;
        }
        if (n != n2) {
            int n4 = 0;
            while (n4 < 2) {
                this.dosOutputCompare.writeByte(n & 0xFF);
                ++n4;
                n >>= 8;
            }
            ++this.OutputSameCount;
        } else {
            dataOutputStream.writeInt(this.OutputSameCount);
            this.OutputSameCount = 1;
            this.bSameMode = true;
            this.dosOutputCompare.close();
            this.baosOutputCompare.close();
            byte[] byArray = this.baosOutputCompare.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
        }
    }

    private void OutputCompareString(DataOutputStream dataOutputStream, String string, String string2) throws IOException {
        if (this.bSameMode) {
            if (string.equals(string2)) {
                ++this.OutputSameCount;
            } else {
                dataOutputStream.writeInt(this.OutputSameCount);
                this.OutputSameCount = 1;
                this.bSameMode = false;
                this.baosOutputCompare = new ByteArrayOutputStream();
                this.dosOutputCompare = new DataOutputStream(this.baosOutputCompare);
                this.dosOutputCompare.writeUTF(string);
            }
            return;
        }
        if (!string.equals(string2)) {
            this.dosOutputCompare.writeUTF(string);
            ++this.OutputSameCount;
        } else {
            dataOutputStream.writeInt(this.OutputSameCount);
            this.OutputSameCount = 1;
            this.bSameMode = true;
            this.dosOutputCompare.close();
            this.baosOutputCompare.close();
            byte[] byArray = this.baosOutputCompare.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
        }
    }

    public final String GetStringFromScenario(Scenario scenario) {
        int n;
        int n2;
        int n3;
        this.OutputSameCount = 0;
        this.bSameMode = true;
        Item item = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(8));
        DataOutputStream dataOutputStream = new DataOutputStream(deflaterOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream2 = new DeflaterOutputStream((OutputStream)byteArrayOutputStream2, new Deflater(8));
        DataOutputStream dataOutputStream2 = new DataOutputStream(deflaterOutputStream2);
        try {
            Object[] objectArray;
            Unit unit;
            int n4;
            dataOutputStream2.writeUTF(scenario.ScenarioClassName);
            dataOutputStream2.writeShort(scenario.CurrentTurn);
            dataOutputStream2.writeByte(scenario.DifficultyLevel);
            dataOutputStream2.writeShort(scenario.Units.length);
            dataOutputStream2.writeShort(scenario.BaseSpecialPic);
            this.readLine();
            this.skipBits(36);
            this.OutputCompareInt(dataOutputStream, scenario.MaxTurns, this.getBits(16));
            this.skipBits(32);
            int n5 = this.getBits(16);
            dataOutputStream2.writeInt(scenario.NumberOfRegions);
            int n6 = this.getBits(16);
            this.skipBits(8);
            int n7 = this.getBits(16);
            this.skipBits(32);
            n3 = this.getBits(5);
            for (n2 = 0; n2 < scenario.Map.length; ++n2) {
                this.OutputCompareInt(dataOutputStream, scenario.Map[n2], this.getBits(n3));
            }
            for (n2 = 0; n2 < scenario.deployMap.length; ++n2) {
                this.OutputCompareInt(dataOutputStream, scenario.deployMap[n2], this.getBits(scenario.Teams.length));
            }
            for (n2 = 0; n2 < scenario.Teams.length; ++n2) {
                Team team = scenario.Teams[n2];
                this.readLine();
                n4 = this.getBits(3);
                this.OutputCompareShort(dataOutputStream, team.flags, n4);
                this.skipBits(16);
                this.OutputCompareInt(dataOutputStream, team.Credits, this.getBits(16));
                if ((n4 & 1) == 1 && scenario.MaxLevel > 0) {
                    this.skipBits(16 * scenario.MaxLevel);
                }
                if ((n4 & 2) == 2) {
                    this.skipBits(16 * scenario.MaxLevel);
                }
                if ((n3 = this.getBits(16)) > 0) {
                    this.skipBits(16 * team.TerrainsCanDestroy.length);
                }
                if ((n3 = this.getBits(16)) > 0) {
                    for (n3 = 0; n3 < team.TargetTerrainClosestNode.length; ++n3) {
                        this.skipBits(24);
                        this.OutputCompareInt(dataOutputStream, team.TargetTerrainClosestNode[n3], this.getBits(16));
                        this.skipBits(16);
                    }
                }
                dataOutputStream2.writeShort(team.MapView.x);
                dataOutputStream2.writeShort(team.MapView.y);
                dataOutputStream2.writeShort(team.MapTL.x);
                dataOutputStream2.writeShort(team.MapTL.y);
                dataOutputStream2.writeShort(team.MemoryLength);
            }
            for (n2 = 0; n2 < scenario.genericItems.length; ++n2) {
                this.readLine();
                this.skipBits(216 + 24 * scenario.Teams.length);
                this.getCauseAndEffect();
                n3 = this.getBits(16);
                if (n3 > 0) {
                    this.skipBits(32 * n3);
                }
                if ((n3 = this.getBits(16)) <= 0) continue;
                this.skipBits(32 * n3);
            }
            dataOutputStream2.writeShort(scenario.Items.length);
            for (n2 = 0; n2 < scenario.Items.length; ++n2) {
                item = scenario.Items[n2];
                if (item == null) {
                    dataOutputStream2.writeByte(0);
                    continue;
                }
                if (item.iOrigionalItemNumber != -1) {
                    dataOutputStream2.writeByte(2);
                    continue;
                }
                dataOutputStream2.writeByte(1);
                dataOutputStream2.writeInt(item.genericNumber);
                dataOutputStream2.writeShort(item.MapPos.x);
                dataOutputStream2.writeShort(item.MapPos.y);
                dataOutputStream2.writeInt(item.terrainUnder);
                dataOutputStream2.writeInt(item.ammo);
                dataOutputStream2.writeInt(item.owner);
            }
            block16: for (n2 = 0; n2 < scenario.Units.length; ++n2) {
                unit = scenario.Units[n2];
                if (unit == null) {
                    dataOutputStream2.writeByte(0);
                    continue;
                }
                if (unit.iOrigionalScenarioPosition != -1) {
                    dataOutputStream2.writeByte(2);
                    continue;
                }
                dataOutputStream2.writeByte(1);
                dataOutputStream2.writeUTF(unit.name);
                dataOutputStream2.writeByte(unit.unitType);
                dataOutputStream2.writeByte(unit.headding);
                for (n = 0; n < scenario.Teams.length; ++n) {
                    dataOutputStream2.writeShort(unit.MorraleValues[n]);
                }
                for (n = 0; n < scenario.Teams.length; ++n) {
                    dataOutputStream2.writeShort(unit.VictoryPointValues[n]);
                }
                dataOutputStream2.writeInt(unit.ItemWhenDead);
                dataOutputStream2.writeShort(unit.terrainBand);
                dataOutputStream2.writeByte(unit.team);
                dataOutputStream2.writeShort(unit.strength);
                dataOutputStream2.writeShort(unit.agility);
                dataOutputStream2.writeShort(unit.weaponSkill);
                dataOutputStream2.writeShort(unit.closeCombatDamage);
                dataOutputStream2.writeShort(unit.toughness);
                dataOutputStream2.writeShort(unit.size);
                dataOutputStream2.writeShort(unit.maxSizeCarried);
                dataOutputStream2.writeShort(unit.fatigue);
                dataOutputStream2.writeShort(unit.currentActionPoints);
                dataOutputStream2.writeShort(unit.maxActionPoints);
                dataOutputStream2.writeShort(unit.currentConstitution);
                dataOutputStream2.writeShort(unit.maxConstitution);
                dataOutputStream2.writeShort(unit.currentStamina);
                dataOutputStream2.writeShort(unit.maxStamina);
                dataOutputStream2.writeShort(unit.currentMorrale);
                dataOutputStream2.writeShort(unit.maxMorrale);
                dataOutputStream2.writeShort(unit.burdonAdjustedActionPoints);
                dataOutputStream2.writeShort(unit.VisibleEnemies);
                for (n = 0; n < 4; ++n) {
                    dataOutputStream2.writeShort(unit.armour[n]);
                }
                dataOutputStream2.writeShort(unit.armourWeight);
                dataOutputStream2.writeShort(unit.burdon);
                dataOutputStream2.writeShort(unit.weightCarried);
                dataOutputStream2.writeShort(unit.sizeCarried);
                dataOutputStream2.writeInt(unit.startRound);
                dataOutputStream2.writeShort(unit.startLevels);
                dataOutputStream2.writeShort(unit.startY);
                dataOutputStream2.writeShort(unit.startX);
                dataOutputStream2.writeShort(unit.startDY);
                dataOutputStream2.writeShort(unit.startDX);
                dataOutputStream2.writeInt(unit.flags);
                dataOutputStream2.writeInt(unit.flags2);
                dataOutputStream2.writeInt(unit.TargetPatrolWayPointNumber);
                dataOutputStream2.writeInt(unit.PatrolRouteWayPoints != null ? unit.PatrolRouteWayPoints.length : 0);
                if (unit.PatrolRouteWayPoints != null) {
                    for (n = 0; n < unit.PatrolRouteWayPoints.length; ++n) {
                        dataOutputStream2.writeInt(unit.PatrolRouteWayPoints[n]);
                    }
                }
                dataOutputStream2.writeByte(unit.RegionThreatValues == null ? 0 : 1);
                if (unit.RegionThreatValues != null) {
                    for (n = 0; n < unit.RegionThreatValues.length; ++n) {
                        dataOutputStream2.writeShort(unit.RegionThreatValues[n]);
                    }
                }
                dataOutputStream2.writeInt(unit.MinRangeAimedAttempted);
                dataOutputStream2.writeInt(unit.MinRangeSnapAttempted);
                dataOutputStream2.writeInt(unit.TerrainsWantToDestroy == null ? 0 : unit.TerrainsWantToDestroy.length);
                if (unit.TerrainsWantToDestroy != null) {
                    for (n = 0; n < unit.TerrainsWantToDestroy.length; ++n) {
                        dataOutputStream2.writeInt(unit.TerrainsWantToDestroy[n]);
                    }
                }
                if (unit.DeathEffects == null) {
                    dataOutputStream2.writeInt(0);
                } else {
                    dataOutputStream2.writeInt(unit.DeathEffects.length);
                    for (n = 0; n < unit.DeathEffects.length; ++n) {
                        dataOutputStream2.writeInt(unit.DeathEffects[n]);
                    }
                }
                for (n = 0; n < scenario.Teams.length; ++n) {
                    dataOutputStream2.writeShort(unit.RoundsUntilForgotten[n]);
                }
                dataOutputStream2.writeInt(unit.UnderneathUnit);
                dataOutputStream2.writeShort(unit.MapPos.x);
                dataOutputStream2.writeShort(unit.MapPos.y);
                if (unit.itemHeld == null) {
                    dataOutputStream2.writeInt(-1);
                    continue;
                }
                for (n = 0; n < scenario.Items.length; ++n) {
                    if (unit.itemHeld != scenario.Items[n]) continue;
                    dataOutputStream2.writeInt(n);
                    continue block16;
                }
            }
            n3 = scenario.NumberOfUnitTypes;
            n4 = 0;
            while (n3 > 0) {
                n3 >>= 1;
                ++n4;
            }
            block27: for (n2 = 0; n2 < n7; ++n2) {
                for (n = 0; n < scenario.Units.length && (scenario.Units[n] == null || scenario.Units[n].iOrigionalScenarioPosition != n2); ++n) {
                }
                if (n < scenario.Units.length) {
                    dataOutputStream2.writeInt(n);
                    unit = scenario.Units[n];
                    this.OutputCompareString(dataOutputStream, unit.name, this.readLine());
                    this.OutputCompareShort(dataOutputStream, unit.unitType, this.getBits(n4));
                    this.OutputCompareShort(dataOutputStream, unit.headding, this.getBits(3));
                    for (n3 = 0; n3 < scenario.Teams.length; ++n3) {
                        this.OutputCompareShort(dataOutputStream, unit.MorraleValues[n3], this.getSignedBits(12));
                    }
                    for (n3 = 0; n3 < scenario.Teams.length; ++n3) {
                        this.OutputCompareShort(dataOutputStream, unit.VictoryPointValues[n3], this.getBits(12));
                    }
                    this.OutputCompareInt(dataOutputStream, unit.ItemWhenDead, this.getBits(16));
                    this.OutputCompareShort(dataOutputStream, unit.terrainBand, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.team, this.getBits(8));
                    this.OutputCompareShort(dataOutputStream, unit.strength, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.agility, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.weaponSkill, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.closeCombatDamage, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.toughness, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.size, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.maxSizeCarried, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.fatigue, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.currentActionPoints, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.maxActionPoints, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.currentConstitution, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.maxConstitution, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.currentStamina, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.maxStamina, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.currentMorrale, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.maxMorrale, this.getBits(12));
                    dataOutputStream2.writeShort(unit.burdonAdjustedActionPoints);
                    dataOutputStream2.writeShort(unit.VisibleEnemies);
                    for (n3 = 0; n3 < 4; ++n3) {
                        this.OutputCompareShort(dataOutputStream, unit.armour[n3], this.getBits(12));
                    }
                    this.OutputCompareShort(dataOutputStream, unit.armourWeight, this.getBits(12));
                    dataOutputStream2.writeShort(unit.burdon);
                    dataOutputStream2.writeShort(unit.weightCarried);
                    dataOutputStream2.writeShort(unit.sizeCarried);
                    this.OutputCompareInt(dataOutputStream, unit.startRound, this.getBits(16));
                    this.OutputCompareShort(dataOutputStream, unit.startLevels, this.getBits(scenario.MaxLevel + 1));
                    this.OutputCompareShort(dataOutputStream, unit.startY, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.startX, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.startDY, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, unit.startDX, this.getBits(12));
                    this.OutputCompareInt(dataOutputStream, unit.flags, this.getBits(20));
                    this.OutputCompareInt(dataOutputStream, unit.flags2, this.getBits(20));
                    this.OutputCompareInt(dataOutputStream, unit.TargetPatrolWayPointNumber, this.getBits(16));
                    n3 = this.getBits(16);
                    if (n3 > 0) {
                        for (n3 = 0; n3 < unit.PatrolRouteWayPoints.length; ++n3) {
                            this.OutputCompareInt(dataOutputStream, unit.PatrolRouteWayPoints[n3], this.getBits(16));
                        }
                    }
                    if (scenario.NumberOfRegions > 0) {
                        if (n5 == scenario.NumberOfRegions) {
                            for (n3 = 0; n3 < scenario.NumberOfRegions; ++n3) {
                                this.OutputCompareInt(dataOutputStream, unit.RegionThreatValues[n3], this.getBits(12));
                            }
                        } else {
                            for (n3 = 0; n3 < scenario.NumberOfRegions; ++n3) {
                                dataOutputStream.writeInt(unit.RegionThreatValues[n3]);
                            }
                            if (n5 > 0) {
                                for (n3 = 0; n3 < n5; ++n3) {
                                    this.getBits(12);
                                }
                            }
                        }
                    }
                    for (n3 = 0; n3 < scenario.Teams.length; ++n3) {
                        this.OutputCompareShort(dataOutputStream, unit.RoundsUntilForgotten[n3], 0);
                    }
                    this.OutputCompareInt(dataOutputStream, unit.MinRangeAimedAttempted, this.getBits(16));
                    this.OutputCompareInt(dataOutputStream, unit.MinRangeSnapAttempted, this.getBits(16));
                    n3 = this.getBits(16);
                    if (n3 > 0) {
                        this.skipBits(16 * n3);
                    }
                    dataOutputStream2.writeInt(unit.UnderneathUnit);
                    dataOutputStream2.writeShort(unit.MapPos.x);
                    dataOutputStream2.writeShort(unit.MapPos.y);
                    this.getCauseAndEffect();
                    n3 = this.getBits(16);
                    if (n3 > 0) {
                        this.skipBits(33 * n3);
                    }
                    if (unit.itemHeld == null) {
                        dataOutputStream2.writeInt(-1);
                        continue;
                    }
                    for (n3 = 0; n3 < scenario.Items.length; ++n3) {
                        if (unit.itemHeld != scenario.Items[n3]) continue;
                        dataOutputStream2.writeInt(n3);
                        continue block27;
                    }
                    continue;
                }
                dataOutputStream2.writeInt(-1);
                this.readLine();
                this.getBits(n4);
                this.skipBits(412 + scenario.MaxLevel + 24 * scenario.Teams.length);
                n3 = this.getBits(16);
                if (n3 > 0) {
                    this.skipBits(16 * n3);
                }
                this.skipBits(32 + 12 * n5);
                n3 = this.getBits(16);
                if (n3 > 0) {
                    this.skipBits(16 * n3);
                }
                this.getCauseAndEffect();
                n3 = this.getBits(16);
                if (n3 <= 0) continue;
                this.skipBits(n3 * 33);
            }
            n3 = this.getBits(16);
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < scenario.Items.length && ((item = scenario.Items[n]) == null || item.iOrigionalItemNumber != n2); ++n) {
                }
                if (n < scenario.Items.length) {
                    dataOutputStream2.writeInt(n);
                    this.skipBits(16);
                    this.OutputCompareShort(dataOutputStream, item.MapPos.x, this.getBits(12));
                    this.OutputCompareShort(dataOutputStream, item.MapPos.y, this.getBits(12));
                    this.OutputCompareInt(dataOutputStream, item.terrainUnder, this.getBits(16));
                    this.OutputCompareInt(dataOutputStream, item.ammo, this.getBits(16));
                    dataOutputStream2.writeInt(item.owner);
                    continue;
                }
                dataOutputStream2.writeInt(-1);
                this.skipBits(72);
            }
            this.skipBits(60 * (6 + scenario.Teams.length));
            for (n2 = 0; n2 < scenario.Terrains.length; ++n2) {
                this.readLine();
                this.skipBits(120);
                n3 = this.getBits(16);
                if (n3 > 0) {
                    this.skipBits(16 * n3);
                }
                this.skipBits(24 * scenario.Teams.length + 12 * scenario.NumberOfTerrainBands);
                n3 = this.getBits(16);
                if (n3 > 0) {
                    this.skipBits(32 * n3);
                }
                if ((n3 = this.getBits(16)) <= 0) continue;
                this.skipBits(32 * n3);
            }
            this.skipBits(16 * scenario.NumberOfUnitTypes * (1 + scenario.genericItems.length));
            for (n2 = 0; n2 < scenario.NumberOfUnitTypes; ++n2) {
                for (n3 = 0; n3 < 100 && (n4 = this.getBits(16)) != 0; ++n3) {
                }
            }
            for (n2 = 0; n2 < scenario.NumberOfUnitTypes; ++n2) {
                this.readLine();
            }
            if (n5 != 0) {
                if (scenario.NumberOfRegions == n5) {
                    n3 = this.getBits(16) * 5;
                    dataOutputStream2.writeInt(scenario.RegionDefinition.length);
                    if (n3 == scenario.RegionDefinition.length) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.OutputCompareShort(dataOutputStream, scenario.RegionDefinition[n2], this.getBits(12));
                        }
                    } else {
                        this.skipBits(n3 * 12);
                        for (n2 = 0; n2 < scenario.RegionDefinition.length; ++n2) {
                            dataOutputStream2.writeShort(scenario.RegionDefinition[n2]);
                        }
                    }
                    for (n2 = 0; n2 <= scenario.NumberOfRegions; ++n2) {
                        for (n4 = 0; n4 <= scenario.NumberOfRegions; ++n4) {
                            this.OutputCompareInt(dataOutputStream, scenario.InterRegionDistance[n2][n4], this.getBits(16));
                        }
                    }
                } else {
                    this.skipBits(60 * this.getBits(16));
                    this.skipBits(16 * (1 + n5) * (1 + n5));
                    dataOutputStream2.writeInt(scenario.RegionDefinition.length);
                    for (n2 = 0; n2 < scenario.RegionDefinition.length; ++n2) {
                        dataOutputStream2.writeShort(scenario.RegionDefinition[n2]);
                    }
                    for (n2 = 0; n2 <= scenario.NumberOfRegions; ++n2) {
                        for (n4 = 0; n4 <= scenario.NumberOfRegions; ++n4) {
                            dataOutputStream2.writeInt(scenario.InterRegionDistance[n2][n4]);
                        }
                    }
                }
            } else if (scenario.NumberOfRegions > 0) {
                dataOutputStream2.writeInt(scenario.RegionDefinition.length);
                for (n2 = 0; n2 < scenario.RegionDefinition.length; ++n2) {
                    dataOutputStream2.writeShort(scenario.RegionDefinition[n2]);
                }
                for (n2 = 0; n2 <= scenario.NumberOfRegions; ++n2) {
                    for (n4 = 0; n4 <= scenario.NumberOfRegions; ++n4) {
                        dataOutputStream2.writeInt(scenario.InterRegionDistance[n2][n4]);
                    }
                }
            }
            dataOutputStream2.writeInt(scenario.Nodes.length);
            if (n5 != 0) {
                if (n6 == scenario.Nodes.length) {
                    if (n6 > 0) {
                        for (n2 = 0; n2 < n6; ++n2) {
                            this.OutputCompareShort(dataOutputStream, scenario.Nodes[n2].x, this.getBits(12));
                            this.OutputCompareShort(dataOutputStream, scenario.Nodes[n2].y, this.getBits(12));
                        }
                    }
                    if (n6 > 0) {
                        for (n2 = 0; n2 < n6; ++n2) {
                            n4 = this.getBits(16);
                            this.OutputCompareInt(dataOutputStream, scenario.NodeConnections[n2].length, n4);
                            dataOutputStream2.writeByte(scenario.NodeConnections[n2].length == n4 ? 1 : 0);
                            if (scenario.NodeConnections[n2].length == n4) {
                                for (n3 = 0; n3 < n4; ++n3) {
                                    this.OutputCompareInt(dataOutputStream, scenario.NodeConnections[n2][n3], this.getBits(16));
                                }
                                continue;
                            }
                            for (n3 = 0; n3 < scenario.NodeConnections[n2].length; ++n3) {
                                dataOutputStream2.writeInt(scenario.NodeConnections[n2][n3]);
                            }
                            this.skipBits(16 * n4);
                        }
                    }
                } else {
                    this.skipBits(24 * n6);
                    if (scenario.Nodes.length > 0) {
                        for (n2 = 0; n2 < scenario.Nodes.length; ++n2) {
                            dataOutputStream2.writeShort(scenario.Nodes[n2].x);
                            dataOutputStream2.writeShort(scenario.Nodes[n2].y);
                        }
                    }
                    if (n6 > 0) {
                        for (n2 = 0; n2 < n6; ++n2) {
                            this.skipBits(16 * this.getBits(16));
                        }
                    }
                    if (scenario.Nodes.length > 0) {
                        for (n2 = 0; n2 < scenario.Nodes.length; ++n2) {
                            dataOutputStream2.writeInt(scenario.NodeConnections[n2].length);
                            n = 0;
                            while (n < scenario.NodeConnections[n2].length) {
                                dataOutputStream2.writeInt(scenario.NodeConnections[n2][n++]);
                            }
                        }
                    }
                }
            } else if (scenario.Nodes.length > 0) {
                for (n2 = 0; n2 < scenario.Nodes.length; ++n2) {
                    dataOutputStream2.writeShort(scenario.Nodes[n2].x);
                    dataOutputStream2.writeShort(scenario.Nodes[n2].y);
                }
                for (n2 = 0; n2 < scenario.Nodes.length; ++n2) {
                    dataOutputStream2.writeInt(scenario.NodeConnections[n2].length);
                    n = 0;
                    while (n < scenario.NodeConnections[n2].length) {
                        dataOutputStream2.writeInt(scenario.NodeConnections[n2][n++]);
                    }
                }
            }
            Vector<Object> vector = new Vector<Object>();
            while ((n4 = this.getBits(8)) != 0) {
                switch (n4) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        this.getCauseAndEffect();
                        break;
                    }
                    case 3: 
                    case 14: {
                        this.skipBits(12);
                        break;
                    }
                    case 4: {
                        this.readLine();
                        this.getCauseAndEffect();
                        this.getCauseAndEffect();
                        break;
                    }
                    case 8: {
                        for (n2 = 0; n2 < scenario.Teams.length * 2 + 2; ++n2) {
                            this.readLine();
                        }
                        break;
                    }
                    case 15: {
                        vector.add(new Integer(this.getBits(12)));
                        n2 = this.getBits(16);
                        objectArray = new int[n2 += this.getBits(16) << 16];
                        n2 = 0;
                        while (n2 < objectArray.length) {
                            objectArray[n2++] = this.getSignedBits(32);
                        }
                        vector.add(objectArray);
                        break;
                    }
                    case 16: {
                        this.readLine();
                        this.getCauseAndEffect();
                    }
                }
            }
            dataOutputStream2.writeShort(scenario.caeArrays == null ? 0 : scenario.caeArrays.length);
            if (scenario.caeArrays != null) {
                for (n2 = 0; n2 < scenario.caeArrays.length; ++n2) {
                    if (scenario.caeArrays[n2] == null) {
                        dataOutputStream2.writeByte(0);
                        continue;
                    }
                    if (!vector.isEmpty()) {
                        for (n = 0; n < vector.size() && n2 != (Integer)vector.elementAt(n); n += 2) {
                        }
                        if (n < vector.size()) {
                            vector.remove(n);
                            objectArray = (int[])vector.remove(n);
                            if (objectArray.length == scenario.caeArrays[n2].length) {
                                dataOutputStream2.writeByte(1);
                                for (n3 = 0; n3 < scenario.caeArrays[n2].length; ++n3) {
                                    this.OutputCompareInt(dataOutputStream, scenario.caeArrays[n2][n3], objectArray[n3]);
                                }
                                continue;
                            }
                        }
                    }
                    dataOutputStream2.writeByte(2);
                    dataOutputStream2.writeInt(scenario.caeArrays[n2].length);
                    for (n3 = 0; n3 < scenario.caeArrays[n2].length; ++n3) {
                        dataOutputStream2.writeInt(scenario.caeArrays[n2][n3]);
                    }
                }
            }
            for (n2 = 0; n2 < 64; ++n2) {
                this.OutputCompareShort(dataOutputStream, scenario.Counters[n2], 0);
            }
            dataOutputStream2.writeInt((int)(scenario.ScenarioFlags & 0xFFFFFFFFFFFFFFFFL));
            dataOutputStream2.writeInt((int)(scenario.ScenarioFlags >> 32 & 0xFFFFFFFFFFFFFFFFL));
            dataOutputStream.writeInt(this.OutputSameCount);
            if (!this.bSameMode) {
                this.dosOutputCompare.close();
                this.baosOutputCompare.close();
                objectArray = this.baosOutputCompare.toByteArray();
                dataOutputStream.write((byte[])objectArray, 0, objectArray.length);
            }
            dataOutputStream.close();
            deflaterOutputStream.finish();
            deflaterOutputStream = null;
            byteArrayOutputStream.close();
            dataOutputStream2.close();
            deflaterOutputStream2.finish();
            deflaterOutputStream2 = null;
            byteArrayOutputStream2.close();
        }
        catch (IOException iOException) {
            System.gc();
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(INARRAY.charAt(1));
        int n8 = 1;
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream = null;
        n = 0;
        n3 = 0;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n += (byArray[n2] & 0xFF) << n3;
            n3 += 8;
            while (n3 >= 6) {
                stringBuffer.append(INARRAY.charAt(n & 0x3F));
                n >>= 6;
                n3 -= 6;
                if (++n8 != 80) continue;
                stringBuffer.append("\r\n");
                n8 = 0;
            }
        }
        if (n3 > 0) {
            stringBuffer.append(INARRAY.charAt(n & 0x3F));
            if (++n8 == 80) {
                stringBuffer.append("\r\n");
                n8 = 0;
            }
        }
        stringBuffer.append("=");
        if (++n8 == 80) {
            stringBuffer.append("\r\n");
            n8 = 0;
        }
        byArray = byteArrayOutputStream2.toByteArray();
        byteArrayOutputStream2 = null;
        n = 0;
        n3 = 0;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n += (byArray[n2] & 0xFF) << n3;
            n3 += 8;
            while (n3 >= 6) {
                stringBuffer.append(INARRAY.charAt(n & 0x3F));
                n >>= 6;
                n3 -= 6;
                if (++n8 != 80) continue;
                stringBuffer.append("\r\n");
                n8 = 0;
            }
        }
        if (n3 > 0) {
            stringBuffer.append(INARRAY.charAt(n & 0x3F));
            if (++n8 == 80) {
                stringBuffer.append("\r\n");
            }
        }
        stringBuffer.append("=");
        if (++n8 == 80) {
            stringBuffer.append("\r\n");
            n8 = 0;
        }
        System.gc();
        return stringBuffer.toString();
    }

    private int InputCompareInt(DataInputStream dataInputStream, int n) throws IOException {
        while (this.InputSameCount == 0) {
            this.bInputSameMode = !this.bInputSameMode;
            this.InputSameCount = dataInputStream.readInt();
        }
        --this.InputSameCount;
        if (this.bInputSameMode) {
            return n;
        }
        n = 0;
        for (int i = 0; i < 32; i += 8) {
            n |= (dataInputStream.readByte() & 0xFF) << i;
        }
        return n;
    }

    private int InputCompareShort(DataInputStream dataInputStream, int n) throws IOException {
        while (this.InputSameCount == 0) {
            this.bInputSameMode = !this.bInputSameMode;
            this.InputSameCount = dataInputStream.readInt();
        }
        --this.InputSameCount;
        if (this.bInputSameMode) {
            return n;
        }
        n = 0;
        for (int i = 0; i < 16; i += 8) {
            n |= (dataInputStream.readByte() & 0xFF) << i;
        }
        return n;
    }

    private String InputCompareString(DataInputStream dataInputStream, String string) throws IOException {
        while (this.InputSameCount == 0) {
            this.bInputSameMode = !this.bInputSameMode;
            this.InputSameCount = dataInputStream.readInt();
        }
        --this.InputSameCount;
        return this.bInputSameMode ? string : dataInputStream.readUTF();
    }

    public static final Scenario GetScenarioFromString(String string, Component component) throws LSException {
        Image image;
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        Object object2;
        if (string.indexOf(61) == -1) {
            return LaserSquadScenarioFile.InputScenario(component, string);
        }
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<Object> vector3 = new Vector<Object>();
        int n5 = INARRAY.indexOf(string.charAt(0));
        if (n5 > 1) {
            throw new LSException("/P0B04UNRECOGNISED SAVE FORMAT/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        String string2 = string.substring(1, string.indexOf(61));
        String string3 = string.substring(string.indexOf(61) + 1);
        if (string3.indexOf(61) != -1) {
            string3 = string3.substring(0, string3.indexOf(61));
        }
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayInputStream byteArrayInputStream2 = null;
        try {
            object2 = new ByteArrayOutputStream();
            n4 = 0;
            int n6 = 0;
            for (n3 = 0; n3 < string2.length(); ++n3) {
                n2 = INARRAY.indexOf(string2.charAt(n3));
                if (n2 == -1) continue;
                n6 += n2 << n4;
                if ((n4 += 6) < 8) continue;
                ((ByteArrayOutputStream)object2).write(n6 & 0xFF);
                n6 >>= 8;
                n4 -= 8;
            }
            string2 = null;
            byteArrayInputStream2 = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
            object2 = new ByteArrayOutputStream();
            n4 = 0;
            n6 = 0;
            for (n3 = 0; n3 < string3.length(); ++n3) {
                n2 = INARRAY.indexOf(string3.charAt(n3));
                if (n2 == -1) continue;
                n6 += n2 << n4;
                if ((n4 += 6) < 8) continue;
                ((ByteArrayOutputStream)object2).write(n6 & 0xFF);
                n6 >>= 8;
                n4 -= 8;
            }
            string3 = null;
            byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.gc();
            throw new LSException("/P0B06SAVED GAME IS CORRUPT/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        object2 = new Scenario();
        try {
            Unit unit;
            Item item;
            int n7;
            object = new InflaterInputStream(byteArrayInputStream2, new Inflater());
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
            DataInputStream dataInputStream2 = new DataInputStream(inflaterInputStream);
            String string4 = dataInputStream2.readUTF();
            LaserSquadScenarioFile laserSquadScenarioFile = LaserSquadScenarioFile.GetLaserSquadScenarioFile(string4);
            ((Scenario)object2).ScenarioClassName = string4;
            ((Scenario)object2).CurrentTurn = dataInputStream2.readShort();
            ((Scenario)object2).DifficultyLevel = dataInputStream2.readByte();
            ((Scenario)object2).Units = new Unit[dataInputStream2.readShort()];
            ((Scenario)object2).BaseSpecialPic = dataInputStream2.readShort();
            ((Scenario)object2).name = laserSquadScenarioFile.readLine();
            laserSquadScenarioFile.getBits(12);
            ((Scenario)object2).MapHeight = laserSquadScenarioFile.getBits(12);
            ((Scenario)object2).MapWidth = laserSquadScenarioFile.getBits(12);
            ((Scenario)object2).MaxTurns = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
            ((Scenario)object2).MaxLevel = laserSquadScenarioFile.getBits(8);
            ((Scenario)object2).NumberOfUnitTypes = laserSquadScenarioFile.getBits(12);
            ((Scenario)object2).NumberOfTerrainBands = laserSquadScenarioFile.getBits(12);
            int n8 = laserSquadScenarioFile.getBits(16);
            ((Scenario)object2).NumberOfRegions = dataInputStream2.readInt();
            int n9 = laserSquadScenarioFile.getBits(16);
            ((Scenario)object2).Teams = new Team[laserSquadScenarioFile.getBits(8)];
            n = laserSquadScenarioFile.getBits(16);
            ((Scenario)object2).genericItems = new GenericItem[laserSquadScenarioFile.getBits(16)];
            ((Scenario)object2).Terrains = new Terrain[laserSquadScenarioFile.getBits(16)];
            ((Scenario)object2).Map = new int[((Scenario)object2).MapWidth * ((Scenario)object2).MapHeight];
            n4 = laserSquadScenarioFile.getBits(5);
            for (n3 = 0; n3 < ((Scenario)object2).Map.length; ++n3) {
                ((Scenario)object2).Map[n3] = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(n4));
            }
            ((Scenario)object2).deployMap = new int[((Scenario)object2).MapWidth * ((Scenario)object2).MapHeight];
            for (n3 = 0; n3 < ((Scenario)object2).deployMap.length; ++n3) {
                ((Scenario)object2).deployMap[n4] = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(((Scenario)object2).Teams.length));
            }
            for (n3 = 0; n3 < ((Scenario)object2).Teams.length; ++n3) {
                Team team = new Team();
                team.teamNumber = n3;
                team.name = laserSquadScenarioFile.readLine();
                n7 = laserSquadScenarioFile.getBits(3);
                team.flags = laserSquadScenarioFile.InputCompareShort(dataInputStream, n7);
                team.colour = laserSquadScenarioFile.getBits(8);
                team.VPWipeOut = laserSquadScenarioFile.getBits(8);
                team.Credits = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                if ((n7 & 1) == 1 && ((Scenario)object2).MaxLevel > 0) {
                    team.CreditsAtLevel = new int[((Scenario)object2).MaxLevel];
                    for (n4 = 0; n4 < ((Scenario)object2).MaxLevel; ++n4) {
                        team.CreditsAtLevel[n4] = laserSquadScenarioFile.getBits(16);
                    }
                }
                if ((n7 & 2) == 2) {
                    team.MemoryLengthAtLevel = new int[((Scenario)object2).MaxLevel];
                    for (n4 = 0; n4 < ((Scenario)object2).MaxLevel; ++n4) {
                        team.MemoryLengthAtLevel[n4] = laserSquadScenarioFile.getBits(16);
                    }
                }
                if ((n4 = laserSquadScenarioFile.getBits(16)) > 0) {
                    team.TerrainsCanDestroy = new int[n4];
                    for (n4 = 0; n4 < team.TerrainsCanDestroy.length; ++n4) {
                        team.TerrainsCanDestroy[n4] = laserSquadScenarioFile.getBits(16);
                    }
                }
                if ((n4 = laserSquadScenarioFile.getBits(16)) > 0) {
                    team.TargetTerrainLocation = new Point[n4];
                    team.TargetTerrainClosestNode = new int[n4];
                    team.TargetTerrainGenericValue = new int[n4];
                    for (n4 = 0; n4 < team.TargetTerrainClosestNode.length; ++n4) {
                        team.TargetTerrainLocation[n4] = new Point(laserSquadScenarioFile.getBits(12), laserSquadScenarioFile.getBits(12));
                        team.TargetTerrainClosestNode[n4] = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                        team.TargetTerrainGenericValue[n4] = laserSquadScenarioFile.getBits(16);
                    }
                }
                team.MapView.setLocation(dataInputStream2.readShort(), dataInputStream2.readShort());
                team.MapTL.setLocation(dataInputStream2.readShort(), dataInputStream2.readShort());
                team.MemoryLength = dataInputStream2.readShort();
                ((Scenario)object2).Teams[n3] = team;
            }
            for (n3 = 0; n3 < ((Scenario)object2).genericItems.length; ++n3) {
                GenericItem genericItem = new GenericItem();
                genericItem.picture = ((Scenario)object2).Terrains.length + n3;
                genericItem.name = laserSquadScenarioFile.readLine();
                genericItem.flags = laserSquadScenarioFile.getBits(8);
                genericItem.weight = laserSquadScenarioFile.getBits(12);
                genericItem.size = laserSquadScenarioFile.getBits(12);
                genericItem.strength = laserSquadScenarioFile.getBits(12);
                genericItem.APtoGetPast = laserSquadScenarioFile.getBits(8);
                genericItem.APHandToHandDivisor = laserSquadScenarioFile.getBits(8);
                genericItem.BaseAccuracyHandToHand = laserSquadScenarioFile.getBits(12);
                genericItem.BaseDamageHandToHand = laserSquadScenarioFile.getBits(12);
                genericItem.ExtraDamageHandToHand = laserSquadScenarioFile.getBits(8);
                genericItem.ExtraAccuracyHandToHand = laserSquadScenarioFile.getBits(8);
                genericItem.APSnapDivisor = laserSquadScenarioFile.getBits(8);
                genericItem.APAimDivisor = laserSquadScenarioFile.getBits(8);
                genericItem.APAutoShotDivisor = laserSquadScenarioFile.getBits(8);
                genericItem.accuracySnap = laserSquadScenarioFile.getBits(12);
                genericItem.accuracyAim = laserSquadScenarioFile.getBits(12);
                genericItem.accuracyAutoShot = laserSquadScenarioFile.getBits(12);
                genericItem.damageShoot = laserSquadScenarioFile.getBits(12);
                genericItem.ammo = laserSquadScenarioFile.getBits(16);
                genericItem.range = laserSquadScenarioFile.getBits(16);
                genericItem.rangedDifficulty = laserSquadScenarioFile.getBits(12);
                genericItem.Cost = new int[((Scenario)object2).Teams.length];
                for (n4 = 0; n4 < ((Scenario)object2).Teams.length; ++n4) {
                    genericItem.Cost[n4] = laserSquadScenarioFile.getBits(12);
                }
                genericItem.ThreatValue = new int[((Scenario)object2).Teams.length];
                for (n4 = 0; n4 < ((Scenario)object2).Teams.length; ++n4) {
                    genericItem.ThreatValue[n4] = laserSquadScenarioFile.getBits(12);
                }
                genericItem.HitEffects = laserSquadScenarioFile.getCauseAndEffect();
                n4 = laserSquadScenarioFile.getBits(16);
                if (n4 > 0) {
                    genericItem.AnimationDetails = new int[n4 * 2];
                    for (n4 = 0; n4 < genericItem.AnimationDetails.length; ++n4) {
                        genericItem.AnimationDetails[n4] = laserSquadScenarioFile.getBits(16);
                    }
                }
                if ((n4 = laserSquadScenarioFile.getBits(16)) > 0) {
                    genericItem.TargettingAnimationDetails = new int[n4 * 2];
                    for (n4 = 0; n4 < genericItem.TargettingAnimationDetails.length; ++n4) {
                        genericItem.TargettingAnimationDetails[n4] = laserSquadScenarioFile.getBits(16);
                    }
                }
                ((Scenario)object2).genericItems[n3] = genericItem;
            }
            ((Scenario)object2).Items = new Item[dataInputStream2.readShort()];
            for (n3 = 0; n3 < ((Scenario)object2).Items.length; ++n3) {
                if (dataInputStream2.readByte() != 1) continue;
                item = new Item((Scenario)object2, dataInputStream2.readInt());
                item.MapPos.setLocation(dataInputStream2.readShort(), dataInputStream2.readShort());
                item.terrainUnder = dataInputStream2.readInt();
                item.ammo = dataInputStream2.readInt();
                item.owner = dataInputStream2.readInt();
                ((Scenario)object2).Items[n3] = item;
            }
            int[] nArray = new int[((Scenario)object2).Units.length];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = -1;
            }
            for (n3 = 0; n3 < ((Scenario)object2).Units.length; ++n3) {
                if (dataInputStream2.readByte() != 1) continue;
                unit = new Unit((Scenario)object2);
                unit.number = n3;
                unit.picture = n3 + ((Scenario)object2).genericItems.length + ((Scenario)object2).Terrains.length;
                unit.name = dataInputStream2.readUTF();
                unit.unitType = dataInputStream2.readByte();
                unit.headding = dataInputStream2.readByte();
                unit.MorraleValues = new int[((Scenario)object2).Teams.length];
                for (n2 = 0; n2 < ((Scenario)object2).Teams.length; ++n2) {
                    unit.MorraleValues[n2] = dataInputStream2.readShort();
                }
                unit.VictoryPointValues = new int[((Scenario)object2).Teams.length];
                for (n2 = 0; n2 < ((Scenario)object2).Teams.length; ++n2) {
                    unit.VictoryPointValues[n2] = dataInputStream2.readShort();
                }
                unit.ItemWhenDead = dataInputStream2.readInt();
                unit.terrainBand = dataInputStream2.readShort();
                unit.team = dataInputStream2.readByte();
                unit.strength = dataInputStream2.readShort();
                unit.agility = dataInputStream2.readShort();
                unit.weaponSkill = dataInputStream2.readShort();
                unit.closeCombatDamage = dataInputStream2.readShort();
                unit.toughness = dataInputStream2.readShort();
                unit.size = dataInputStream2.readShort();
                unit.maxSizeCarried = dataInputStream2.readShort();
                unit.fatigue = dataInputStream2.readShort();
                unit.currentActionPoints = dataInputStream2.readShort();
                unit.maxActionPoints = dataInputStream2.readShort();
                unit.currentConstitution = dataInputStream2.readShort();
                unit.maxConstitution = dataInputStream2.readShort();
                unit.currentStamina = dataInputStream2.readShort();
                unit.maxStamina = dataInputStream2.readShort();
                unit.currentMorrale = dataInputStream2.readShort();
                unit.maxMorrale = dataInputStream2.readShort();
                unit.burdonAdjustedActionPoints = 0;
                unit.VisibleEnemies = 0;
                if (n5 > 0) {
                    unit.burdonAdjustedActionPoints = dataInputStream2.readShort();
                    unit.VisibleEnemies = dataInputStream2.readShort();
                }
                for (n2 = 0; n2 < 4; ++n2) {
                    unit.armour[n2] = dataInputStream2.readShort();
                }
                unit.armourWeight = dataInputStream2.readShort();
                unit.burdon = dataInputStream2.readShort();
                unit.weightCarried = dataInputStream2.readShort();
                unit.sizeCarried = dataInputStream2.readShort();
                unit.startRound = dataInputStream2.readInt();
                unit.startLevels = dataInputStream2.readShort();
                unit.startY = dataInputStream2.readShort();
                unit.startX = dataInputStream2.readShort();
                unit.startDY = dataInputStream2.readShort();
                unit.startDX = dataInputStream2.readShort();
                unit.flags = dataInputStream2.readInt();
                unit.flags2 = dataInputStream2.readInt();
                unit.TargetPatrolWayPointNumber = dataInputStream2.readInt();
                n2 = dataInputStream2.readInt();
                if (n2 > 0) {
                    unit.PatrolRouteWayPoints = new int[n2];
                    for (n2 = 0; n2 < unit.PatrolRouteWayPoints.length; ++n2) {
                        unit.PatrolRouteWayPoints[n2] = dataInputStream2.readInt();
                    }
                }
                if (dataInputStream2.readByte() == 1) {
                    unit.RegionThreatValues = new int[((Scenario)object2).NumberOfRegions];
                    for (n2 = 0; n2 < ((Scenario)object2).NumberOfRegions; ++n2) {
                        unit.RegionThreatValues[n2] = dataInputStream2.readShort();
                    }
                }
                unit.MinRangeAimedAttempted = dataInputStream2.readInt();
                unit.MinRangeSnapAttempted = dataInputStream2.readInt();
                n2 = dataInputStream2.readInt();
                if (n2 > 0) {
                    unit.TerrainsWantToDestroy = new int[n2];
                    for (n2 = 0; n2 < unit.TerrainsWantToDestroy.length; ++n2) {
                        unit.TerrainsWantToDestroy[n2] = dataInputStream2.readInt();
                    }
                }
                if ((n2 = dataInputStream2.readInt()) > 0) {
                    unit.DeathEffects = new int[n2];
                    for (n2 = 0; n2 < unit.DeathEffects.length; ++n2) {
                        unit.DeathEffects[n2] = dataInputStream2.readInt();
                    }
                }
                unit.RoundsUntilForgotten = new int[((Scenario)object2).Teams.length];
                for (n2 = 0; n2 < ((Scenario)object2).Teams.length; ++n2) {
                    unit.RoundsUntilForgotten[n2] = dataInputStream2.readShort();
                }
                unit.UnderneathUnit = dataInputStream2.readInt();
                unit.MapPos = new Point(dataInputStream2.readShort(), dataInputStream2.readShort());
                nArray[n3] = dataInputStream2.readInt();
                ((Scenario)object2).Units[n3] = unit;
            }
            n4 = ((Scenario)object2).NumberOfUnitTypes;
            n7 = 0;
            while (n4 > 0) {
                n4 >>= 1;
                ++n7;
            }
            for (n2 = 0; n2 < n; ++n2) {
                n3 = dataInputStream2.readInt();
                if (n3 != -1) {
                    unit = new Unit((Scenario)object2);
                    unit.iOrigionalScenarioPosition = n2;
                    unit.number = n3;
                    unit.picture = n3 + ((Scenario)object2).genericItems.length + ((Scenario)object2).Terrains.length;
                    unit.name = laserSquadScenarioFile.InputCompareString(dataInputStream, laserSquadScenarioFile.readLine());
                    unit.unitType = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(n7));
                    unit.headding = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(3));
                    unit.MorraleValues = new int[((Scenario)object2).Teams.length];
                    for (n4 = 0; n4 < ((Scenario)object2).Teams.length; ++n4) {
                        unit.MorraleValues[n4] = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getSignedBits(12));
                    }
                    unit.VictoryPointValues = new int[((Scenario)object2).Teams.length];
                    for (n4 = 0; n4 < ((Scenario)object2).Teams.length; ++n4) {
                        unit.VictoryPointValues[n4] = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    }
                    unit.ItemWhenDead = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                    unit.terrainBand = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.team = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(8));
                    unit.strength = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.agility = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.weaponSkill = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.closeCombatDamage = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.toughness = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.size = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.maxSizeCarried = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.fatigue = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.currentActionPoints = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.maxActionPoints = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.currentConstitution = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.maxConstitution = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.currentStamina = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.maxStamina = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.currentMorrale = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.maxMorrale = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.burdonAdjustedActionPoints = 0;
                    unit.VisibleEnemies = 0;
                    if (n5 > 0) {
                        unit.burdonAdjustedActionPoints = dataInputStream2.readShort();
                        unit.VisibleEnemies = dataInputStream2.readShort();
                    }
                    for (n4 = 0; n4 < 4; ++n4) {
                        unit.armour[n4] = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    }
                    unit.armourWeight = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.burdon = dataInputStream2.readShort();
                    unit.weightCarried = dataInputStream2.readShort();
                    unit.sizeCarried = dataInputStream2.readShort();
                    unit.startRound = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                    unit.startLevels = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(((Scenario)object2).MaxLevel + 1));
                    unit.startY = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.startX = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.startDY = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.startDX = laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                    unit.flags = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(20));
                    unit.flags2 = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(20));
                    unit.TargetPatrolWayPointNumber = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                    n4 = laserSquadScenarioFile.getBits(16);
                    if (n4 > 0) {
                        unit.PatrolRouteWayPoints = new int[n4];
                        for (n4 = 0; n4 < unit.PatrolRouteWayPoints.length; ++n4) {
                            unit.PatrolRouteWayPoints[n4] = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                        }
                    }
                    if (((Scenario)object2).NumberOfRegions > 0) {
                        unit.RegionThreatValues = new int[((Scenario)object2).NumberOfRegions];
                        if (n8 == ((Scenario)object2).NumberOfRegions) {
                            for (n4 = 0; n4 < ((Scenario)object2).NumberOfRegions; ++n4) {
                                unit.RegionThreatValues[n4] = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(12));
                            }
                        } else {
                            for (n4 = 0; n4 < ((Scenario)object2).NumberOfRegions; ++n4) {
                                unit.RegionThreatValues[n4] = dataInputStream2.readInt();
                            }
                            if (n8 > 0) {
                                for (n4 = 0; n4 < n8; ++n4) {
                                    laserSquadScenarioFile.getBits(12);
                                }
                            }
                        }
                    }
                    unit.RoundsUntilForgotten = new int[((Scenario)object2).Teams.length];
                    for (n4 = 0; n4 < ((Scenario)object2).Teams.length; ++n4) {
                        unit.RoundsUntilForgotten[n4] = laserSquadScenarioFile.InputCompareShort(dataInputStream, 0);
                    }
                    unit.MinRangeAimedAttempted = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                    unit.MinRangeSnapAttempted = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                    n4 = laserSquadScenarioFile.getBits(16);
                    if (n4 > 0) {
                        unit.TerrainsWantToDestroy = new int[n4];
                        for (n4 = 0; n4 < unit.TerrainsWantToDestroy.length; ++n4) {
                            unit.TerrainsWantToDestroy[n4] = laserSquadScenarioFile.getBits(16);
                        }
                    }
                    unit.UnderneathUnit = dataInputStream2.readInt();
                    unit.MapPos = new Point(dataInputStream2.readShort(), dataInputStream2.readShort());
                    unit.DeathEffects = laserSquadScenarioFile.getCauseAndEffect();
                    n4 = laserSquadScenarioFile.getBits(16);
                    if (n4 > 0) {
                        laserSquadScenarioFile.skipBits(33 * n4);
                    }
                    nArray[n3] = dataInputStream2.readInt();
                    ((Scenario)object2).Units[n3] = unit;
                    continue;
                }
                laserSquadScenarioFile.readLine();
                laserSquadScenarioFile.getBits(n7);
                laserSquadScenarioFile.skipBits(412 + ((Scenario)object2).MaxLevel + 24 * ((Scenario)object2).Teams.length);
                n4 = laserSquadScenarioFile.getBits(16);
                if (n4 > 0) {
                    laserSquadScenarioFile.skipBits(16 * n4);
                }
                laserSquadScenarioFile.skipBits(32 + 12 * n8);
                n4 = laserSquadScenarioFile.getBits(16);
                if (n4 > 0) {
                    laserSquadScenarioFile.skipBits(16 * n4);
                }
                laserSquadScenarioFile.getCauseAndEffect();
                n4 = laserSquadScenarioFile.getBits(16);
                if (n4 <= 0) continue;
                laserSquadScenarioFile.skipBits(n4 * 33);
            }
            n4 = laserSquadScenarioFile.getBits(16);
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = dataInputStream2.readInt();
                if (n2 == -1) {
                    laserSquadScenarioFile.skipBits(72);
                    continue;
                }
                item = new Item((Scenario)object2, laserSquadScenarioFile.getBits(16));
                item.MapPos.setLocation(laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12)), laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12)));
                item.terrainUnder = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                item.ammo = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                item.owner = dataInputStream2.readInt();
                ((Scenario)object2).Items[n2] = item;
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] == -1) continue;
                ((Scenario)object2).Units[n3].itemHeld = ((Scenario)object2).Items[nArray[n3]];
            }
            ((Scenario)object2).ArmourData = new int[5][6 + ((Scenario)object2).Teams.length];
            for (n3 = 0; n3 < 5; ++n3) {
                for (n4 = 0; n4 < 6 + ((Scenario)object2).Teams.length; ++n4) {
                    ((Scenario)object2).ArmourData[n3][n4] = laserSquadScenarioFile.getBits(12);
                }
            }
            for (n3 = 0; n3 < ((Scenario)object2).Terrains.length; ++n3) {
                Terrain terrain = new Terrain();
                terrain.name = laserSquadScenarioFile.readLine();
                terrain.picture = n3;
                terrain.strength = laserSquadScenarioFile.getBits(12);
                terrain.becomesWhenDammaged = laserSquadScenarioFile.getBits(16);
                terrain.forceAbsorbed = laserSquadScenarioFile.getBits(12);
                terrain.protection = laserSquadScenarioFile.getBits(12);
                terrain.flags = laserSquadScenarioFile.getBits(12);
                terrain.maxHideSize = laserSquadScenarioFile.getBits(12);
                terrain.explodeForce = laserSquadScenarioFile.getBits(12);
                terrain.open = laserSquadScenarioFile.getBits(16);
                terrain.lock = laserSquadScenarioFile.getBits(16);
                n4 = laserSquadScenarioFile.getBits(16);
                if (n4 > 0) {
                    terrain.keys = new int[n4];
                    for (n4 = 0; n4 < terrain.keys.length; ++n4) {
                        terrain.keys[n4] = laserSquadScenarioFile.getBits(16);
                    }
                }
                terrain.VictoryPointValues = new int[((Scenario)object2).Teams.length];
                for (n4 = 0; n4 < ((Scenario)object2).Teams.length; ++n4) {
                    terrain.VictoryPointValues[n4] = laserSquadScenarioFile.getBits(12);
                }
                terrain.MorraleValues = new int[((Scenario)object2).Teams.length];
                for (n4 = 0; n4 < ((Scenario)object2).Teams.length; ++n4) {
                    terrain.MorraleValues[n4] = laserSquadScenarioFile.getSignedBits(12);
                }
                terrain.MovementCost = new int[((Scenario)object2).NumberOfTerrainBands];
                for (n4 = 0; n4 < ((Scenario)object2).NumberOfTerrainBands; ++n4) {
                    terrain.MovementCost[n4] = laserSquadScenarioFile.getBits(12);
                }
                n4 = laserSquadScenarioFile.getBits(16);
                if (n4 > 0) {
                    terrain.AnimationDetails = new int[n4 * 2];
                    for (n4 = 0; n4 < terrain.AnimationDetails.length; ++n4) {
                        terrain.AnimationDetails[n4] = laserSquadScenarioFile.getBits(16);
                    }
                }
                if ((n4 = laserSquadScenarioFile.getBits(16)) > 0) {
                    terrain.TargettingAnimationDetails = new int[n4 * 2];
                    for (n4 = 0; n4 < terrain.TargettingAnimationDetails.length; ++n4) {
                        terrain.TargettingAnimationDetails[n4] = laserSquadScenarioFile.getBits(16);
                    }
                }
                ((Scenario)object2).Terrains[n3] = terrain;
            }
            ((Scenario)object2).UnitTypePictures = new int[((Scenario)object2).NumberOfUnitTypes][((Scenario)object2).genericItems.length + 1];
            for (n3 = 0; n3 < ((Scenario)object2).NumberOfUnitTypes; ++n3) {
                for (n4 = 0; n4 <= ((Scenario)object2).genericItems.length; ++n4) {
                    ((Scenario)object2).UnitTypePictures[n3][n4] = laserSquadScenarioFile.getBits(16);
                }
            }
            int[] nArray2 = new int[100];
            ((Scenario)object2).UnitDeathPictures = new int[((Scenario)object2).NumberOfUnitTypes][];
            for (n3 = 0; n3 < ((Scenario)object2).NumberOfUnitTypes; ++n3) {
                for (n4 = 0; n4 < 100 && (n7 = laserSquadScenarioFile.getBits(16)) != 0; ++n4) {
                    nArray2[n4] = n7;
                }
                ((Scenario)object2).UnitDeathPictures[n3] = new int[n4];
                System.arraycopy(nArray2, 0, ((Scenario)object2).UnitDeathPictures[n3], 0, n4);
            }
            for (n3 = 0; n3 < ((Scenario)object2).NumberOfUnitTypes; ++n3) {
                laserSquadScenarioFile.readLine();
            }
            if (n8 != 0) {
                if (((Scenario)object2).NumberOfRegions == n8) {
                    n4 = laserSquadScenarioFile.getBits(16) * 5;
                    ((Scenario)object2).RegionDefinition = new int[dataInputStream2.readInt()];
                    if (n4 == ((Scenario)object2).RegionDefinition.length) {
                        for (n3 = 0; n3 < n4; ++n3) {
                            laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12));
                        }
                    } else {
                        laserSquadScenarioFile.skipBits(n4 * 12);
                        for (n3 = 0; n3 < ((Scenario)object2).RegionDefinition.length; ++n3) {
                            ((Scenario)object2).RegionDefinition[n3] = dataInputStream2.readShort();
                        }
                    }
                    ((Scenario)object2).InterRegionDistance = new int[1 + ((Scenario)object2).NumberOfRegions][1 + ((Scenario)object2).NumberOfRegions];
                    for (n3 = 0; n3 <= ((Scenario)object2).NumberOfRegions; ++n3) {
                        for (n7 = 0; n7 <= ((Scenario)object2).NumberOfRegions; ++n7) {
                            ((Scenario)object2).InterRegionDistance[n3][n7] = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                        }
                    }
                } else {
                    laserSquadScenarioFile.skipBits(60 * laserSquadScenarioFile.getBits(16));
                    laserSquadScenarioFile.skipBits(16 * (1 + n8) * (1 + n8));
                    ((Scenario)object2).RegionDefinition = new int[dataInputStream2.readInt()];
                    for (n3 = 0; n3 < ((Scenario)object2).RegionDefinition.length; ++n3) {
                        ((Scenario)object2).RegionDefinition[n3] = dataInputStream2.readShort();
                    }
                    ((Scenario)object2).InterRegionDistance = new int[1 + ((Scenario)object2).NumberOfRegions][1 + ((Scenario)object2).NumberOfRegions];
                    for (n3 = 0; n3 <= ((Scenario)object2).NumberOfRegions; ++n3) {
                        for (n7 = 0; n7 <= ((Scenario)object2).NumberOfRegions; ++n7) {
                            ((Scenario)object2).InterRegionDistance[n3][n7] = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                        }
                    }
                }
            } else if (((Scenario)object2).NumberOfRegions > 0) {
                ((Scenario)object2).RegionDefinition = new int[dataInputStream2.readInt()];
                for (n3 = 0; n3 < ((Scenario)object2).RegionDefinition.length; ++n3) {
                    ((Scenario)object2).RegionDefinition[n3] = dataInputStream2.readShort();
                }
                ((Scenario)object2).InterRegionDistance = new int[1 + ((Scenario)object2).NumberOfRegions][1 + ((Scenario)object2).NumberOfRegions];
                for (n3 = 0; n3 <= ((Scenario)object2).NumberOfRegions; ++n3) {
                    for (n7 = 0; n7 <= ((Scenario)object2).NumberOfRegions; ++n7) {
                        ((Scenario)object2).InterRegionDistance[n3][n7] = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                    }
                }
            }
            ((Scenario)object2).Nodes = new Point[dataInputStream2.readInt()];
            if (n8 != 0) {
                if (n9 == ((Scenario)object2).Nodes.length) {
                    if (n9 > 0) {
                        for (n3 = 0; n3 < n9; ++n3) {
                            ((Scenario)object2).Nodes[n3] = new Point(laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12)), laserSquadScenarioFile.InputCompareShort(dataInputStream, laserSquadScenarioFile.getBits(12)));
                        }
                    }
                    ((Scenario)object2).NodeConnections = new int[n9][];
                    if (n9 > 0) {
                        for (n3 = 0; n3 < n9; ++n3) {
                            n7 = laserSquadScenarioFile.getBits(16);
                            ((Scenario)object2).NodeConnections[n3] = new int[laserSquadScenarioFile.InputCompareInt(dataInputStream, n7)];
                            if (dataInputStream2.readByte() == 1) {
                                for (n4 = 0; n4 < n7; ++n4) {
                                    ((Scenario)object2).NodeConnections[n3][n4] = laserSquadScenarioFile.InputCompareInt(dataInputStream, laserSquadScenarioFile.getBits(16));
                                }
                                continue;
                            }
                            for (n4 = 0; n4 < ((Scenario)object2).NodeConnections[n3].length; ++n4) {
                                ((Scenario)object2).NodeConnections[n3][n4] = dataInputStream2.readInt();
                            }
                            laserSquadScenarioFile.skipBits(16 * n7);
                        }
                    }
                } else {
                    laserSquadScenarioFile.skipBits(24 * n9);
                    if (((Scenario)object2).Nodes.length > 0) {
                        for (n3 = 0; n3 < ((Scenario)object2).Nodes.length; ++n3) {
                            ((Scenario)object2).Nodes[n3] = new Point(dataInputStream2.readShort(), dataInputStream2.readShort());
                        }
                    }
                    if (n9 > 0) {
                        for (n3 = 0; n3 < n9; ++n3) {
                            laserSquadScenarioFile.skipBits(16 * laserSquadScenarioFile.getBits(16));
                        }
                    }
                    ((Scenario)object2).NodeConnections = new int[((Scenario)object2).Nodes.length][];
                    if (((Scenario)object2).Nodes.length > 0) {
                        for (n3 = 0; n3 < ((Scenario)object2).Nodes.length; ++n3) {
                            ((Scenario)object2).NodeConnections[n3] = new int[dataInputStream2.readInt()];
                            n2 = 0;
                            while (n2 < ((Scenario)object2).NodeConnections[n3].length) {
                                ((Scenario)object2).NodeConnections[n3][n2++] = dataInputStream2.readInt();
                            }
                        }
                    }
                }
            } else if (((Scenario)object2).Nodes.length > 0) {
                for (n3 = 0; n3 < ((Scenario)object2).Nodes.length; ++n3) {
                    ((Scenario)object2).Nodes[n3] = new Point(dataInputStream2.readShort(), dataInputStream2.readShort());
                }
                ((Scenario)object2).NodeConnections = new int[((Scenario)object2).Nodes.length][];
                for (n3 = 0; n3 < ((Scenario)object2).Nodes.length; ++n3) {
                    ((Scenario)object2).NodeConnections[n3] = new int[dataInputStream2.readInt()];
                    n2 = 0;
                    while (n2 < ((Scenario)object2).NodeConnections[n3].length) {
                        ((Scenario)object2).NodeConnections[n3][n2++] = dataInputStream2.readInt();
                    }
                }
            }
            while ((n7 = laserSquadScenarioFile.getBits(8)) != 0) {
                switch (n7) {
                    case 1: {
                        ((Scenario)object2).PreMoveCauseAndEffects = laserSquadScenarioFile.getCauseAndEffect();
                        break;
                    }
                    case 2: {
                        ((Scenario)object2).EndOfTurnCauseAndEffects = laserSquadScenarioFile.getCauseAndEffect();
                        break;
                    }
                    case 3: {
                        ((Scenario)object2).PathNodeLimit = laserSquadScenarioFile.getBits(12);
                        break;
                    }
                    case 4: {
                        vector.add(laserSquadScenarioFile.readLine());
                        vector.add(laserSquadScenarioFile.getCauseAndEffect());
                        vector.add(laserSquadScenarioFile.getCauseAndEffect());
                        break;
                    }
                    case 5: {
                        ((Scenario)object2).SetupEffects = laserSquadScenarioFile.getCauseAndEffect();
                        break;
                    }
                    case 6: {
                        ((Scenario)object2).PickUpEffects = laserSquadScenarioFile.getCauseAndEffect();
                        break;
                    }
                    case 7: {
                        ((Scenario)object2).DropEffects = laserSquadScenarioFile.getCauseAndEffect();
                        break;
                    }
                    case 8: {
                        ((Scenario)object2).Briefing = new String[((Scenario)object2).Teams.length * 2 + 2];
                        for (n3 = 0; n3 < ((Scenario)object2).Briefing.length; ++n3) {
                            ((Scenario)object2).Briefing[n3] = laserSquadScenarioFile.readLine();
                        }
                        break;
                    }
                    case 9: {
                        ((Scenario)object2).ChangeEffects = laserSquadScenarioFile.getCauseAndEffect();
                        break;
                    }
                    case 10: {
                        ((Scenario)object2).EndOfGameEffects = laserSquadScenarioFile.getCauseAndEffect();
                        break;
                    }
                    case 11: {
                        ((Scenario)object2).SelectUnitEffects = laserSquadScenarioFile.getCauseAndEffect();
                        break;
                    }
                    case 12: {
                        ((Scenario)object2).ItemDestroyedEffects = laserSquadScenarioFile.getCauseAndEffect();
                        break;
                    }
                    case 13: {
                        ((Scenario)object2).TerrainDestroyedEffects = laserSquadScenarioFile.getCauseAndEffect();
                        break;
                    }
                    case 14: {
                        ((Scenario)object2).ScenarioSystemFlags = laserSquadScenarioFile.getBits(12);
                        break;
                    }
                    case 15: {
                        vector2.add(new Integer(laserSquadScenarioFile.getBits(12)));
                        n3 = laserSquadScenarioFile.getBits(16);
                        nArray2 = new int[n3 += laserSquadScenarioFile.getBits(16) << 16];
                        n3 = 0;
                        while (n3 < nArray2.length) {
                            nArray2[n3++] = laserSquadScenarioFile.getSignedBits(32);
                        }
                        vector2.add(nArray2);
                        break;
                    }
                    case 16: {
                        vector3.add(laserSquadScenarioFile.readLine());
                        vector3.add(laserSquadScenarioFile.getCauseAndEffect());
                    }
                }
            }
            if (!vector.isEmpty()) {
                ((Scenario)object2).ExtraPlayerOptionsStrings = new String[vector.size() / 3];
                ((Scenario)object2).ExtraPlayerOptionsCauses = new int[((Scenario)object2).ExtraPlayerOptionsStrings.length][];
                ((Scenario)object2).ExtraPlayerOptionsEffects = new int[((Scenario)object2).ExtraPlayerOptionsStrings.length][];
                n4 = 0;
                for (n3 = 0; n3 < ((Scenario)object2).ExtraPlayerOptionsStrings.length; ++n3) {
                    ((Scenario)object2).ExtraPlayerOptionsStrings[n3] = (String)vector.elementAt(n4++);
                    ((Scenario)object2).ExtraPlayerOptionsCauses[n3] = (int[])vector.elementAt(n4++);
                    ((Scenario)object2).ExtraPlayerOptionsEffects[n3] = (int[])vector.elementAt(n4++);
                }
            }
            if (!vector3.isEmpty()) {
                ((Scenario)object2).caeRoutineNames = new String[vector3.size() / 2];
                ((Scenario)object2).caeRoutines = new int[((Scenario)object2).caeRoutineNames.length][];
                n4 = 0;
                for (n3 = 0; n3 < ((Scenario)object2).caeRoutineNames.length; ++n3) {
                    ((Scenario)object2).caeRoutineNames[n3] = (String)vector3.elementAt(n4++);
                    ((Scenario)object2).caeRoutines[n3] = (int[])vector3.elementAt(n4++);
                }
            }
            if ((n4 = (int)dataInputStream2.readShort()) != 0) {
                ((Scenario)object2).caeArrays = new int[n4][];
                for (n3 = 0; n3 < ((Scenario)object2).caeArrays.length; ++n3) {
                    n4 = dataInputStream2.readByte();
                    if (n4 == 0) continue;
                    if (n4 == 1) {
                        for (n2 = 0; n2 < vector2.size() && n3 != (Integer)vector2.elementAt(n2); n2 += 2) {
                        }
                        vector2.remove(n2);
                        nArray2 = (int[])vector2.remove(n2);
                        ((Scenario)object2).caeArrays[n3] = new int[nArray2.length];
                        for (n4 = 0; n4 < ((Scenario)object2).caeArrays[n3].length; ++n4) {
                            ((Scenario)object2).caeArrays[n3][n4] = laserSquadScenarioFile.InputCompareInt(dataInputStream, nArray2[n4]);
                        }
                        continue;
                    }
                    ((Scenario)object2).caeArrays[n3] = new int[dataInputStream2.readInt()];
                    for (n4 = 0; n4 < ((Scenario)object2).caeArrays[n3].length; ++n4) {
                        ((Scenario)object2).caeArrays[n3][n4] = dataInputStream2.readInt();
                    }
                }
            }
            for (n3 = 0; n3 < 64; ++n3) {
                ((Scenario)object2).Counters[n3] = laserSquadScenarioFile.InputCompareShort(dataInputStream, 0);
            }
            ((Scenario)object2).ScenarioFlags = (long)dataInputStream2.readInt() & 0xFFFFFFFFFFFFFFFFL;
            ((Scenario)object2).ScenarioFlags += ((long)dataInputStream2.readInt() & 0xFFFFFFFFFFFFFFFFL) << 32;
            ((Scenario)object2).Sprites = null;
            image = laserSquadScenarioFile.getImage(component);
            ((Scenario)object2).Sprites = component.createImage(image.getWidth(component), image.getHeight(component));
            ((Scenario)object2).Sprites.getGraphics().drawImage(image, 0, 0, null);
            image = laserSquadScenarioFile.getImage(component);
            ((Scenario)object2).Scanner = component.createImage(image.getWidth(component), image.getHeight(component));
            ((Scenario)object2).Scanner.getGraphics().drawImage(image, 0, 0, null);
            dataInputStream.close();
            object = null;
            byteArrayInputStream2.close();
            dataInputStream2.close();
            inflaterInputStream = null;
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            System.gc();
            throw new LSException("/P0B06SAVED GAME IS CORRUPT/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        ((Scenario)object2).BaseItemPic = ((Scenario)object2).Terrains.length;
        ((Scenario)object2).BaseUnitPic = ((Scenario)object2).genericItems.length + ((Scenario)object2).BaseItemPic;
        ((Scenario)object2).BaseTargetPic = ((Scenario)object2).Units.length + ((Scenario)object2).BaseUnitPic;
        ((Scenario)object2).CursorPic = ((Scenario)object2).BaseTargetPic * 2;
        ((Scenario)object2).BaseDeployPic = ((Scenario)object2).CursorPic + 1;
        ((Scenario)object2).BaseFlashPic = ((Scenario)object2).BaseDeployPic + ((Scenario)object2).Teams.length;
        if (n != ((Scenario)object2).Units.length) {
            n4 = ((Scenario)object2).Units.length - n;
            image = ((Scenario)object2).Sprites;
            ((Scenario)object2).Sprites = component.createImage(512, image.getHeight(component) + (n4 << 2));
            ((Scenario)object2).Sprites.getGraphics().drawImage(image, 0, 0, null);
            n3 = (((Scenario)object2).genericItems.length + ((Scenario)object2).Terrains.length + n) / 16 << 5;
            object = ((Scenario)object2).Sprites.getGraphics().create(0, n3 += n4 << 1, 512, n3);
            ((Graphics)object).drawImage(image, n4 << 1, 0, null);
            n3 = (((Scenario)object2).genericItems.length + ((Scenario)object2).Terrains.length + n) * 2 / 16 << 5;
            object = ((Scenario)object2).Sprites.getGraphics().create(0, n3 += n4 << 2, 512, ((Scenario)object2).Sprites.getHeight(component) - n3);
            ((Graphics)object).drawImage(image, n4 << 2, 0, null);
            for (n3 = 0; n3 < ((Scenario)object2).UnitTypePictures.length; ++n3) {
                n2 = 0;
                while (n2 < ((Scenario)object2).UnitTypePictures[n3].length) {
                    int[] nArray = ((Scenario)object2).UnitTypePictures[n3];
                    int n10 = n2++;
                    nArray[n10] = nArray[n10] + n4 * 2;
                }
            }
            for (n3 = 0; n3 < ((Scenario)object2).UnitDeathPictures.length; ++n3) {
                n2 = 0;
                while (n2 < ((Scenario)object2).UnitDeathPictures[n3].length) {
                    int[] nArray = ((Scenario)object2).UnitDeathPictures[n3];
                    int n11 = n2++;
                    nArray[n11] = nArray[n11] + n4 * 2;
                }
            }
        }
        for (n3 = 0; n3 < ((Scenario)object2).Units.length; ++n3) {
            if (((Scenario)object2).Units[n3] == null) continue;
            ((Scenario)object2).Units[n3].CalculateUnitPicture();
        }
        System.gc();
        return object2;
    }

    private static Scenario InputScenario(Component component, String string) throws LSException {
        Scenario scenario;
        int n;
        int n2;
        int n3;
        Closeable closeable;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            closeable = new ByteArrayOutputStream();
            n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < string.length(); ++n2) {
                n = INARRAY.indexOf(string.charAt(n2));
                if (n == -1) continue;
                n4 += n << n3;
                if ((n3 += 6) < 8) continue;
                ((ByteArrayOutputStream)closeable).write(n4 & 0xFF);
                n4 >>= 8;
                n3 -= 8;
            }
            string = null;
            byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)closeable).toByteArray());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new LSException("/P0B06SAVED GAME IS CORRUPT/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        closeable = new InflaterInputStream(byteArrayInputStream);
        DataInputStream dataInputStream = new DataInputStream((InputStream)closeable);
        try {
            dataInputStream.readUnsignedShort();
            scenario = Scenario.LoadScenario(component, dataInputStream.readUTF());
            scenario.SetupEffects = null;
            scenario.CurrentTurn = dataInputStream.readUnsignedShort();
            scenario.DifficultyLevel = dataInputStream.readUnsignedByte();
            scenario.Units = new Unit[dataInputStream.readUnsignedShort()];
            n2 = dataInputStream.readUnsignedShort();
            if (n2 != scenario.BaseSpecialPic) {
                n3 = n2 - scenario.BaseSpecialPic >> 1;
                Image image = scenario.Sprites;
                scenario.Sprites = component.createImage(512, image.getHeight(component) + (n3 << 2));
                scenario.Sprites.getGraphics().drawImage(image, 0, 0, null);
                n2 = scenario.BaseTargetPic / 16 << 5;
                Graphics graphics = scenario.Sprites.getGraphics().create(0, n2 += n3, 512, n2);
                graphics.drawImage(image, n3 << 1, 0, null);
                graphics = scenario.Sprites.getGraphics().create(0, n2 * 2, 512, scenario.Sprites.getHeight(component) - n2 * 2);
                graphics.drawImage(image, n3 << 2, 0, null);
                scenario.CursorPic += n3 * 2;
                scenario.BaseDeployPic += n3 * 2;
                scenario.BaseTargetPic += n3;
                scenario.BaseFlashPic += n3 * 2;
                scenario.BaseSpecialPic += n3 * 2;
                for (n2 = 0; n2 < scenario.UnitTypePictures.length; ++n2) {
                    n = 0;
                    while (n < scenario.UnitTypePictures[n2].length) {
                        int[] nArray = scenario.UnitTypePictures[n2];
                        int n5 = n++;
                        nArray[n5] = nArray[n5] + n3 * 2;
                    }
                }
                for (n2 = 0; n2 < scenario.UnitDeathPictures.length; ++n2) {
                    n = 0;
                    while (n < scenario.UnitDeathPictures[n2].length) {
                        int[] nArray = scenario.UnitDeathPictures[n2];
                        int n6 = n++;
                        nArray[n6] = nArray[n6] + n3 * 2;
                    }
                }
            }
            dataInputStream.readUnsignedByte();
            for (n2 = 0; n2 < scenario.MapWidth * scenario.MapHeight; ++n2) {
                scenario.SetMapContents(n2, dataInputStream.readUnsignedShort());
            }
            for (n2 = 0; n2 < scenario.Teams.length; ++n2) {
                Team team = new Team();
                team.flags = dataInputStream.readUnsignedByte();
                team.MemoryLength = dataInputStream.readUnsignedShort();
                n = dataInputStream.readUnsignedShort();
                team.TargetTerrainLocation = null;
                team.TargetTerrainClosestNode = null;
                team.TargetTerrainGenericValue = null;
                if (n > 0) {
                    team.TargetTerrainLocation = new Point[n];
                    team.TargetTerrainClosestNode = new int[n];
                    team.TargetTerrainGenericValue = new int[n];
                    for (n = 0; n < team.TargetTerrainClosestNode.length; ++n) {
                        team.TargetTerrainLocation[n] = new Point(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                        if (team.TargetTerrainLocation[n].x == 65535) {
                            team.TargetTerrainLocation[n] = null;
                        }
                        team.TargetTerrainClosestNode[n] = dataInputStream.readShort();
                        team.TargetTerrainGenericValue[n] = dataInputStream.readUnsignedShort();
                    }
                }
                team.MapView.setLocation(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                team.MapTL.setLocation(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                scenario.Teams[n2] = team;
            }
            scenario.Items = new Item[dataInputStream.readUnsignedShort()];
            for (n2 = 0; n2 < scenario.Items.length; ++n2) {
                if (dataInputStream.readUnsignedByte() == 0) {
                    scenario.Items[n2] = null;
                    continue;
                }
                Item item = new Item(scenario, dataInputStream.readUnsignedShort());
                item.MapPos.setLocation(dataInputStream.readShort(), dataInputStream.readShort());
                item.terrainUnder = dataInputStream.readUnsignedShort();
                item.ammo = dataInputStream.readUnsignedShort();
                item.owner = dataInputStream.readShort();
                scenario.Items[n2] = item;
            }
            for (n2 = 0; n2 < scenario.Units.length; ++n2) {
                if (dataInputStream.readUnsignedByte() == 0) {
                    scenario.Units[n2] = null;
                    continue;
                }
                Unit unit = new Unit(scenario);
                unit.name = dataInputStream.readUTF();
                unit.picture = scenario.genericItems.length + scenario.Terrains.length + n2;
                unit.number = n2;
                unit.unitType = dataInputStream.readUnsignedByte();
                unit.headding = dataInputStream.readUnsignedByte();
                unit.MorraleValues = new int[scenario.Teams.length];
                for (n = 0; n < scenario.Teams.length; ++n) {
                    unit.MorraleValues[n] = dataInputStream.readShort();
                }
                unit.VictoryPointValues = new int[scenario.Teams.length];
                for (n = 0; n < scenario.Teams.length; ++n) {
                    unit.VictoryPointValues[n] = dataInputStream.readUnsignedShort();
                }
                unit.ItemWhenDead = dataInputStream.readUnsignedShort();
                unit.terrainBand = dataInputStream.readUnsignedShort();
                unit.team = dataInputStream.readUnsignedByte();
                unit.strength = dataInputStream.readUnsignedShort();
                unit.agility = dataInputStream.readUnsignedShort();
                unit.weaponSkill = dataInputStream.readUnsignedShort();
                unit.closeCombatDamage = dataInputStream.readUnsignedShort();
                unit.toughness = dataInputStream.readUnsignedShort();
                unit.size = dataInputStream.readUnsignedShort();
                unit.maxSizeCarried = dataInputStream.readUnsignedShort();
                unit.fatigue = dataInputStream.readUnsignedShort();
                unit.currentActionPoints = dataInputStream.readUnsignedShort();
                unit.maxActionPoints = dataInputStream.readUnsignedShort();
                unit.currentConstitution = dataInputStream.readUnsignedShort();
                unit.maxConstitution = dataInputStream.readUnsignedShort();
                unit.currentStamina = dataInputStream.readUnsignedShort();
                unit.maxStamina = dataInputStream.readUnsignedShort();
                unit.currentMorrale = dataInputStream.readUnsignedShort();
                unit.maxMorrale = dataInputStream.readUnsignedShort();
                for (n = 0; n < 4; ++n) {
                    unit.armour[n] = dataInputStream.readUnsignedShort();
                }
                unit.armourWeight = dataInputStream.readUnsignedShort();
                unit.burdon = dataInputStream.readUnsignedShort();
                unit.weightCarried = dataInputStream.readUnsignedShort();
                unit.sizeCarried = dataInputStream.readUnsignedShort();
                unit.startRound = dataInputStream.readUnsignedShort();
                unit.startLevels = dataInputStream.readUnsignedShort();
                unit.startY = dataInputStream.readUnsignedShort();
                unit.startX = dataInputStream.readUnsignedShort();
                unit.startDY = dataInputStream.readUnsignedShort();
                unit.startDX = dataInputStream.readUnsignedShort();
                unit.flags = dataInputStream.readInt();
                unit.flags2 = dataInputStream.readInt();
                unit.TargetPatrolWayPointNumber = dataInputStream.readUnsignedShort();
                n = dataInputStream.readUnsignedShort();
                if (n > 0) {
                    unit.PatrolRouteWayPoints = new int[n];
                    for (n = 0; n < unit.PatrolRouteWayPoints.length; ++n) {
                        unit.PatrolRouteWayPoints[n] = dataInputStream.readUnsignedShort();
                    }
                }
                if (dataInputStream.readUnsignedByte() == 1) {
                    unit.RegionThreatValues = new int[scenario.NumberOfRegions];
                    for (n = 0; n < scenario.NumberOfRegions; ++n) {
                        unit.RegionThreatValues[n] = dataInputStream.readUnsignedShort();
                    }
                } else {
                    unit.RegionThreatValues = null;
                }
                unit.MinRangeAimedAttempted = dataInputStream.readUnsignedShort();
                unit.MinRangeSnapAttempted = dataInputStream.readUnsignedShort();
                n = dataInputStream.readUnsignedShort();
                if (n > 0) {
                    unit.TerrainsWantToDestroy = new int[n];
                    for (n = 0; n < unit.TerrainsWantToDestroy.length; ++n) {
                        unit.TerrainsWantToDestroy[n] = dataInputStream.readUnsignedShort();
                    }
                }
                if ((n = dataInputStream.readInt()) > 0) {
                    unit.DeathEffects = new int[n];
                    for (n = 0; n < unit.DeathEffects.length; ++n) {
                        unit.DeathEffects[n] = dataInputStream.readShort();
                    }
                }
                unit.RoundsUntilForgotten = new int[scenario.Teams.length];
                for (n = 0; n < scenario.Teams.length; ++n) {
                    unit.RoundsUntilForgotten[n] = dataInputStream.readUnsignedShort();
                }
                unit.UnderneathUnit = dataInputStream.readUnsignedShort();
                unit.MapPos.setLocation(dataInputStream.readShort(), dataInputStream.readShort());
                n = dataInputStream.readUnsignedShort();
                unit.itemHeld = n == 65535 ? null : scenario.Items[n];
                unit.CalculateUnitPicture();
                scenario.Units[n2] = unit;
            }
            for (n2 = 0; n2 < 64; ++n2) {
                scenario.Counters[n2] = dataInputStream.readShort();
            }
            scenario.ScenarioFlags = (long)dataInputStream.readInt() & 0xFFFFFFFFFFFFFFFFL;
            scenario.ScenarioFlags += ((long)dataInputStream.readInt() & 0xFFFFFFFFFFFFFFFFL) << 32;
            byteArrayInputStream.close();
            dataInputStream = null;
            closeable = null;
            byteArrayInputStream = null;
        }
        catch (IOException iOException) {
            throw new LSException("/P0B06SAVED GAME IS CORRUPT/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        System.gc();
        return scenario;
    }

    public static final LaserSquadScenarioFile GetLaserSquadScenarioFile(String string) throws LSException {
        LaserSquadScenarioFile laserSquadScenarioFile;
        Class clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            clazz = null;
        }
        if (clazz == null) {
            try {
                clazz = new LaserSquadScenarioClassLoader().findClass(string);
            }
            catch (Exception exception) {
                clazz = null;
            }
        }
        if (clazz == null) {
            throw new LSException("/P0B04CAN'T FIND SCENARIO FILE/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        if (!clazz.getSuperclass().getName().equals("LaserSquadScenarioFile")) {
            throw new LSException("/P0B04THIS IS NOT A SCENARIO FILE/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        try {
            laserSquadScenarioFile = (LaserSquadScenarioFile)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new LSException("/P0B04CAN'T OPEN SCENARIO FILE/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        return laserSquadScenarioFile;
    }
}

