/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

class LaserSquadSoundObject
extends InputStream
implements Runnable {
    private SourceDataLine sdLine;
    private boolean bIsPlaying = false;
    private boolean bIsLooping;
    private long lEndTime = 0L;
    private Thread tEndNotifyer;
    private long lLengthMilli;
    private LaserSquad ls;
    private int iSoundNumber = -1;
    private URL urlSoundFile = null;
    private int[] headder = null;
    private boolean bMute = false;
    private Clip clip = null;
    private static final String[] Data = new String[]{"EAEAEAEAJAHAGAGAMAKAIAIAQAOAKAKATARAMAMAWAUAOAOAZAXAQAQACBABSASAFBDBUAUAJBHBWAWAMBKBYAYAPBNBABABSBQBCBCBVBTBEBEBYBWBGBGBBA", "IAIAIAIALAKALAOAMALAOAVAMANASABBNAOAVAHBOAQAYAOBPASABBUBQATAEBACQAVAHBHCRAWALBNCBA", "BABABABADABADAFADACAFAJAEADAIAOAEAEAKASAEAEAMAWAFAFAPABBFAGARAFBGAHAUAJBGAIAWAOBGAIAYASBHAJABBWBHAKADBBCIALAFBFCIAMAIBKCIAMAKBOCJANANBSCJAOAPBXCKAPARBBDKAQAUBFDKAQAWBKDLARAYBODLASABCTDMATADCXDMAUAGCEAMAUAICIANAVAKCMANAWANCRAOAXAPCVAOAXASCZABA", "YAYAYAYAFBDBEBEBJBHBLBLBOBMBRBRBTBRBXBXBYBWBECECBA", "BABABABAVDFAEDUAQDKAKCOBLDOAQBICHDTAWABDCDYACAVDBA", "UCUCBDBDRCPCUCUCMCKCMCMCVCFCECECCCACWBWBYBWBOBOBPA", "WBECSBUCWBECSBUCWBECSBUCUBACRBOCTBACRBOCTBACRBOCRBWBPBICQBWBPBICQBWBPBICOBTBOBDCNBTBOBDCNBTBOBDCLBPBNBXBJBPBNBXBJBPBNBXBIBMBMBSBGBMBMBSBGBMBMBSBFBIBLBMBDBIBLBMBDBIBLBMBBBFBJBHBABFBJBHBABFBJBHBYABBIBBBXABBIBBBXABBIBBBVAXAHBWATAXAHBWATAXAHBWASAUAGBQAQAUAGBQAQAUAGBQAPAQAFBKANAQAFBKANAQAFBKAMANADBFAKANADBFAKANADBFAIAJACBXDHAJACBXDHAJACBXDFAGABBRDEAGABBRDEAGABBRDCACAABMDBACAABMDBACAABMDBA", "OBWBGBGBPBVBFBFBOBUBEBEBNBTBDBDBNBTBDBDBMBSBCBCBLBRBBBBBKBQBABABJBPBZAZAJBPBZAZAVBOBYAYAHBNBXAXAGBMBWAWAFBLBWAWAFBLBVAVAEBKBUAUADBJBTATACBIBSASABBHBSASABBHBRARAPA", "BABABABABABABABAEACAGAMACACAGAMAFADALAXADADALAXAGAEAQAJBEAEAQAJBHAFAVAVBGAFAVAVBIAGAABGCHAGAABGCKAIAFBSCIAIAFBSCLAJALBDDJAJALBDDMAKAQBPDKAKAQBPDNALAVBCAMALAVBCAOAMAACOANAMAACOAQAOAFCZAOAOAFCZARAPAKCLBPAPAKCLBSAQAQCWBQAQAQCWBTARAVCICRARAVCICUASAADUCTASAADUCVAUAFDFDUAUAFDFDXAVAKDRDVAVAKDRDYAWAPDEAWAWAPDEAZAXAVDQAXAXAVDQAIB", "VAUAUAUAVAUAUAUAXAWAZADBWAWAZADBZAXAEBNBXAXAEBNBNBYAJBWBYAYAJBWBBBZANBFCZAZANBFCCBABSBOCBBABSBOCQBBBXBXCCBBBXBXCFBDBCCGDDBDBCCGDGBEBGCPDEBEBGCPDTBFBLCBAFBFBLCBAIBGBQCKAHBGBQCKAJBHBVCTAIBHBVCTAXBJBZCCBJBJBZCCBMBKBEDLBKBKBEDLBNBLBJDVBLBLBJDVBCA", "CACAFAKACACAFAKACACAFAKAFADAIAVAEADAIAVAEADAIAVAHAFAMAHBFAFAMAHBFAFAMAHBIAGAQASBHAGAQASBHAGAQASBKAIATAECIAIATAECIAIATAECYAKAXAPCKAKAXAPCKAKAXAPCNALAABBDMALAABBDMALAABBDPANAEBMDNANAEBMDNANAEBMDQAOAHBBAPAOAHBBAPAOAHBBASAQALBMAQAQALBMAQAQALBMAGBSAPBXASASAPBXASASAPBXAVATASBJBTATASBJBTATASBJBXAVAWBUBVAVAWBUBVAVAWBUBYAWAZBGCXAWAZBGCXAWAZBGCABYADCRCYAYADCRCYAYADCRCOBZAGCDDABZAGCDDABZAGCDDDBBBKCODBBBBKCODBBBBKCODFBDBOCCADBDBOCCADBDBOCCAGBEBRCOAFBEBRCOAFBEBRCOAIBGBVCZAGBGBVCZAGBGBVCZACA", "IAMACBACIAMACBACIAMACBACIAMACBACLANAFBHCJANAFBHCJANAFBHCJANAFBHCMAOAIBPCKAOAIBPCKAOAIBPCKAOAIBPCMAQALBWCLAQALBWCLAQALBWCLAQALBWCNARAPBEDMARAPBEDMARAPBEDMARAPBEDOASASBLDMASASBLDMASASBLDMASASBLDPATAVBTDNATAVBTDNATAVBTDNATAVBTDQAUAYBDAOAUAYBDAOAUAYBDAOAUAYBDAQAWABCKAPAWABCKAPAWABCKAPAWABCKARAXAECSAQAXAECSAQAXAECSAQAXAECSASAYAICZAQAYAICZAQAYAICZAQAYAICZATAZALCHBRAZALCHBRAZALCHBRAZALCHBTAABOCPBSAABOCPBSAABOCPBSAABOCPBUABBRCWBTABBRCWBTABBRCWBTABBRCWBVADBUCECTADBUCECTADBUCECTADBUCECWAEBXCLCUAEBXCLCUAEBXCLCUAEBXCLCXAFBBDTCVAFBBDTCVAFBBDTCVAFBBDTCXAGBEDADWAGBEDADWAGBEDADWAGBEDADYAHBHDIDXAHBHDIDXAHBHDIDXAHBHDIDZAJBKDPDXAJBKDPDXAJBKDPDXAJBKDPDABKBNDXDYAKBNDXDYAKBNDXDYAKBNDXDBBLBRDHAZALBRDHAZALBRDHAZALBRDHABBMBUDOAABMBUDOAABMBUDOAABMBUDOACBNBXDWABBNBXDWABBNBXDWABBNBXDWADBPBCADBBBPBCADBBBPBCADBBBPBCADBEBQBGALBCBQBGALBCBQBGALBCBQBGALBFBRBJATBDBRBJATBDBRBJATBDBRBJATBFBSBMAACEBSBMAACEBSBMAACEBSBMAACGBTBPAICFBTBPAICFBTBPAICFBTBPAICHBVBSAPCFBVBSAPCFBVBSAPCFBVBSAPCBA", "WDVDVDVDWDVDVDVDRA", "VAUAUAUAVAUAUAUAXAWAZADBWAWAZADBZAXAEBNBXAXAEBNBMBYAJBWBYAYAJBWBBBZANBFCZAZANBFCCBABSBOCBBABSBOCQBBBXBXCCBBBXBXCFBDBCCGDDBDBCCGDGBEBGCPDEBEBGCPDNA", "VAUAUAUAVAUAUAUAXAWAZADBWAWAZADBZAXAEBNBXAXAEBNBIEYAJBWBYAYAJBWBBBZANBFCZAZANBFCCBABSBOCBBABSBOCMEBBXBXCCBBBXBXCFBDBCCGDDBDBCCGDGBEBGCPDEBEBGCPDQEFBLCBAFBFBLCBAIBGBQCKAHBGBQCKAJBHBVCTAIBHBVCTATEJBZCCBJBJBZCCBMBKBEDLBKBKBEDLBNBLBJDVBLBLBJDVBXEMBODECNBMBODECPBNBTDNCOBNBTDNCQBPBXDWCPBPBXDWCAFQBEAFDQBQBEAFDTBRBJAODRBRBJAODUBSBOAXDSBSBOAXDKD", "BABAFACABABABACACABACACABADADACADACACAEADAHBEADAFAEAEAFAFAEAFAJBFAGAHAFAGAKBGAHAHAGALBGAIAHALBHAHAJAMBIAIAJANBJAJAJANBJAKAJAJAPBKALAPBKAKAMAPBLAPBLAQBLAQBMAMARBMARBNARBRBNASBOAOASBTBOAOATBTBPAPAUBUBPAPAUBQAVBVBQAQAVBVBRARAWBSAWBSAXBXBSAXBTATAXBTAYBTAYBYBUAZBUAUAZBZBVABCVACCVAWANA", "XAOEXAXAQDTCXAXAVBVBXAXAXAXAXAVBTCXAXAOEUCXAHHXAXAVBXAVBQDTCXAXAXAXAXAXAXAXAXAXAXAOEWBVBVBXAXAXAXAVBXAVBVBVBVBOEVBTCXAXAVBTCXAUCXAXAXAXAVBVBVBXAXAXAVBXAOEVBXAVBVBXAXAXAXAXAXAXAXAXAXAWBVBVBVBOEXAMFXAVBXAVBVBXAVBXAMFAHTCXAXAXATCVBTCTCXAXAXATCTCTCXAOEXAVBZAXAXAOEXAVBVBXAXAXATCVBVBXATCXAXAXAXAOEVBVBZAVBXAXAXAXAXAVBTCVBXAXAVBXAQDQDQDVBXAXATCXAWBVBVBXAVBXAXAVBXATCXAXAXAXAXAVBTCXAVBXAVBTCTCXAZAVBXATCVBTCXAMFXATCXAXAVBXAXAXAXAXAQDXAXACGXAXAXATCVBTCVBXAXAQDXAXAXAXAVBVBXAVBOEVBXAXAUCXAVBXAVBTCXAXAVBVBVBXAXAVBXAVBTCVBVBTCXAVBWBXAVBVBOEXATCTCXAXAXAQDXAXATCOEXAXAXAUCXAVBTCXAXAXATCQDXAXAXAVBXAXAXAXATCXAVBXAXAXAQDUCVBQDXAOEVBQDVBXAKGQDXAYHQDXAXAXAXAXAOEXAQDXAVBTCVBXATCTCVBVBUCVBXAXAVBVBXAXAXAQDTCVBQDVBXAXAXAOEVBUCVBOEXAXAXAVBVBVBTCXATCQDOEXAXAXAXAXAXAXAZAQDTCXAXAXAXAVBXAVBXAXAVBTCVBXAVBXAXAVBVBXATCXAUCTCXAVBMFXAXAXAVBXAVBVBTCTCXAVBXAQDAHXAXAXATCQDXAVBXAXAXATCXAVBTCXAXAXAVBXAXAGIXAQDVBTCXATCXAXAVBXATCXATCVBXAXAQDVBZAVBTCTCXAQDXAVBXAVBXAKGXAVBVBVBXAVBVBWBQDVBXAXAVBQDXAVBVBTCXAQDVBXAXAXAXAXATCXAZATCXAMFXAVBXAXAXATCOEQDVBOEXAXAVBWITCQDXAVBXAXAVBXAXATCXAVBXAXATCQDXAPEXAXAXAVBXAVBQDXAXAMFXATCXAVBVBVBXAXAXAVBXAZAXAXAVBXAXATCVBQDTCXAVBXAVBXAXAQDOEVBXASDXATCXAXAXAXAXATCXATCVBXAQDTCVBVBQDPEXAXAHHXAVBQDXAXAXAVBXAVBVBTCXAMFXAHEVBTCXATCXAXAVBVBXADJVBVBXAQDQDZAVBXAXAXAXAOEXAVBQDOEVBMFXAVBVBVBXASDXAXAXAXAXAXAXAXAKGOEVBVBVBXAVBQDXAPEVBVBVBVBXAXATCVBOETCQDTCXAQDXAPEXAVBXAXAXAXAVBVBVBXAQDXAVBTCXAVBXAXAVBXAXAVBXAHEXAQDVBXAXAVBXAVBMFXAVBXAXAKGVBXAXAXAVBSDHHXAVBXAVBMFXAVBMFQDTCPEXATCXAQDXAXAQDVBVBXAXAVBVBXAXAXAXAJHQDMFXAQDTCXAXAXATCVBXAXAXAXAVBTCVBXAZATCXATCXAXAXAVBTCOEXAXATCXAVBVBXAVBTCVBWIXAVBXAXAVBVBXAXAVBQDXATCXAOEVBVBXATCZATCXAVBTCXAXATCXAXAOEOETCXAXAQDXAVBXAPEVBXATCXAXATCXAXAXAXAXAMFXAOETCXAXAVBWBXAXAVBVBXAVBQDXATCVBXAVBXAVBXATCXAXAXAXAXAXAXAUCXAVBXAVBXATCVBTCTCXAVBOEVBXAVBMFCGXAVBVBXAXAXAXATCXATCXAOETCXAQDXATCVBXAXAWBVBVBXAXAVBTCOEXATCXAXAVBVBVBXAXATCTCXAXAXAUCXAXAXAVBVBXAXAHHVBXAXAXAXAXAVBQDOEVBUCVBVBHHOEXATCVBTCXAXAVBXAVBXAVBXAZAXAXAVBXAXAXAOEXAXAXAXAQDXAVBQDXAVBVBXAXAXATCXAJD"};
    private static final int[] Sourceheadder = new int[]{82, 73, 70, 70, 255, 255, 255, 255, 87, 65, 86, 69, 102, 109, 116, 32, 18, 0, 0, 0, 1, 0, 1, 0, 34, 86, 0, 0, 34, 86, 0, 0, 1, 0, 8, 0, 40, 0, 102, 97, 99, 116, 4, 0, 0, 0, 0, 233, 2, 0, 100, 97, 116, 97, 255, 255, 255, 255};
    private long lPosition = 0L;
    private long lMark = -1L;
    private long lLength = 0L;
    private int iCycleNumber = 0;
    private int iCycleCount = 0;
    private int volume = 0;
    private int iMarkCycleNumber;
    private int iMarkCycleCount;
    private int iMarkVolume;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public LaserSquadSoundObject(URL uRL, LaserSquad laserSquad, boolean bl) throws LSException {
        this.urlSoundFile = uRL;
        this.ls = laserSquad;
        this.bMute = bl;
    }

    public LaserSquadSoundObject(int n, LaserSquad laserSquad, boolean bl) throws LSException {
        this.iSoundNumber = n;
        this.ls = laserSquad;
        this.bMute = bl;
        this.headder = new int[58];
        System.arraycopy(Sourceheadder, 0, this.headder, 0, 58);
        int n2 = 0;
        while (n2 < Data[n].length()) {
            this.lLength += (long)(Data[n].charAt(n2++) - 65);
            this.lLength += (long)((Data[n].charAt(n2++) - 65) * 26);
        }
        this.lLengthMilli = this.lLength * 100L / 2205L;
        this.headder[54] = (int)(this.lLength & 0xFFL);
        this.headder[55] = (int)(this.lLength >> 8 & 0xFFL);
        this.headder[56] = (int)(this.lLength >> 16 & 0xFFL);
        this.headder[57] = (int)(this.lLength >> 24 & 0xFFL);
        this.lLength += 58L;
        this.headder[4] = (int)(this.lLength & 0xFFL);
        this.headder[5] = (int)(this.lLength >> 8 & 0xFFL);
        this.headder[6] = (int)(this.lLength >> 16 & 0xFFL);
        this.headder[7] = (int)(this.lLength >> 24 & 0xFFL);
    }

    public void PlayWait() {
        this.Play();
        this.Wait();
    }

    public void Play() {
        this.bIsLooping = false;
        this.lEndTime = this.lLengthMilli + System.currentTimeMillis();
        this.SetIsRunning(true);
        if (this.urlSoundFile == null && !this.bMute) {
            this.OpenClip();
            if (this.clip != null) {
                this.clip.start();
            }
        }
        this.tEndNotifyer = new Thread(this);
        this.tEndNotifyer.start();
    }

    public void Loop() {
        this.bIsLooping = true;
        if (this.urlSoundFile == null && !this.bMute) {
            this.OpenClip();
            if (this.clip != null) {
                this.clip.loop(-1);
            }
        }
        this.SetIsRunning(true);
        if (this.urlSoundFile != null) {
            this.tEndNotifyer = new Thread(this);
            this.tEndNotifyer.start();
        }
    }

    private void OpenClip() {
        this.lPosition = 0L;
        this.lMark = -1L;
        this.iCycleNumber = 2;
        this.volume = 0;
        this.iCycleCount = Data[this.iSoundNumber].charAt(0) - 65;
        this.iCycleCount += (Data[this.iSoundNumber].charAt(1) - 65) * 26;
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(this);
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            // empty catch block
        }
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = LaserSquadSoundObject.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, audioInputStream.getFormat());
        try {
            this.clip = (Clip)AudioSystem.getLine(info);
            if (this.clip != null) {
                this.clip.open(audioInputStream);
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void Wait() {
        while (this.IsRunning()) {
            Thread.currentThread();
            Thread.yield();
        }
        this.clip = null;
        this.sdLine = null;
    }

    public void Stop() {
        if (!this.IsRunning()) {
            return;
        }
        if (this.urlSoundFile == null) {
            try {
                if (this.clip != null && this.clip.isRunning()) {
                    this.clip.stop();
                }
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            this.sdLine.stop();
        }
        if (this.tEndNotifyer != null) {
            this.tEndNotifyer.interrupt();
        }
        this.tEndNotifyer = null;
        this.SetIsRunning(false);
    }

    public long GetSoundLength() {
        return this.lLengthMilli;
    }

    private synchronized void SetIsRunning(boolean bl) {
        this.bIsPlaying = bl;
    }

    public synchronized boolean IsRunning() {
        return this.bIsPlaying;
    }

    protected void SetMute(boolean bl) {
        if (this.urlSoundFile == null && bl && !this.bMute && this.clip != null) {
            try {
                this.clip.stop();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.bMute = bl;
    }

    public void run() {
        if (this.urlSoundFile != null) {
            do {
                AudioInputStream audioInputStream = null;
                try {
                    audioInputStream = AudioSystem.getAudioInputStream(this.urlSoundFile.openStream());
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    System.out.println("Sound File \"" + this.urlSoundFile + "\" not supported!");
                }
                catch (IOException iOException) {
                    System.out.println("Failed to get Sound File \"" + this.urlSoundFile + "\"");
                }
                DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? LaserSquadSoundObject.class$("javax.sound.sampled.SourceDataLine") : class$javax$sound$sampled$SourceDataLine, audioInputStream.getFormat());
                try {
                    this.sdLine = (SourceDataLine)AudioSystem.getLine(info);
                    this.sdLine.open(audioInputStream.getFormat(), 10000);
                    this.sdLine.start();
                }
                catch (LineUnavailableException lineUnavailableException) {
                    System.out.println("Failed to open Sound file \"" + this.urlSoundFile + "\"");
                }
                int n = 0;
                byte[] byArray = new byte[10000];
                while (n != -1 && this.tEndNotifyer != null) {
                    try {
                        n = audioInputStream.read(byArray, 0, byArray.length);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (n < 0) continue;
                    this.sdLine.write(byArray, 0, n);
                }
                this.sdLine.drain();
                this.sdLine.close();
            } while (this.bIsLooping);
        } else {
            long l = System.currentTimeMillis();
            if (l < this.lEndTime) {
                try {
                    Thread.sleep(this.lEndTime - l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.tEndNotifyer = null;
        this.sdLine = null;
        this.clip = null;
        this.SetIsRunning(false);
    }

    public int available() {
        return (int)(this.lLength - this.lPosition);
    }

    public void close() {
    }

    public void mark(int n) {
        this.lMark = this.lPosition;
        this.iMarkCycleNumber = this.iCycleNumber;
        this.iMarkCycleCount = this.iCycleCount;
        this.iMarkVolume = this.volume;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() {
        if (this.lPosition == this.lLength) {
            return -1;
        }
        if (this.lPosition < 58L) {
            ++this.lPosition;
            return this.headder[(int)(this.lPosition - 1L)];
        }
        int n = this.volume;
        if (this.iCycleCount == 0) {
            this.iCycleCount = Data[this.iSoundNumber].charAt(this.iCycleNumber++) - 65;
            this.iCycleCount += (Data[this.iSoundNumber].charAt(this.iCycleNumber++) - 65) * 26;
            this.volume = 255 - this.volume;
        }
        --this.iCycleCount;
        ++this.lPosition;
        return n;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n2 && (n4 = this.read()) != -1; ++n3) {
            byArray[n + n3] = (byte)n4;
        }
        if (n3 == 0 && n4 == -1) {
            return -1;
        }
        return n3;
    }

    public void reset() {
        if (this.lMark == -1L) {
            return;
        }
        this.lPosition = this.lMark;
        this.iCycleNumber = this.iMarkCycleNumber;
        this.iCycleCount = this.iMarkCycleCount;
        this.volume = this.iMarkVolume;
    }

    public long skip(long l) {
        long l2 = 0L;
        while (l > 0L && this.read() != -1) {
            ++l2;
            --l;
        }
        return l2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

