/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.TextArea;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

final class Scenario {
    public String name;
    protected String ScenarioClassName;
    protected int ScenarioSystemFlags = 0;
    public int MapWidth;
    public int MapHeight;
    protected int[] Map;
    public int[] deployMap;
    public Image Sprites;
    public Image Scanner;
    public Unit[] Units;
    public Item[] Items;
    public Team[] Teams;
    public GenericItem[] genericItems;
    public Terrain[] Terrains;
    public int MaxTurns;
    public int MaxLevel;
    public int NumberOfUnitTypes;
    protected int NumberOfTerrainBands;
    protected int NumberOfRegions;
    protected int[] RegionDefinition = null;
    protected int[][] InterRegionDistance = null;
    protected Point[] Nodes = new Point[0];
    protected int[][] NodeConnections = null;
    protected int PathNodeLimit = -1;
    protected int[][] ArmourData;
    public int[][] UnitTypePictures;
    public int[][] UnitDeathPictures;
    public int CursorPic;
    public int BaseDeployPic;
    public int BaseItemPic;
    public int BaseUnitPic;
    public int BaseTargetPic;
    public int BaseFlashPic;
    public int BaseSpecialPic = 0;
    public int[] PreMoveCauseAndEffects = null;
    public int[] EndOfTurnCauseAndEffects = null;
    public String[] ExtraPlayerOptionsStrings = null;
    public int[][] ExtraPlayerOptionsCauses = null;
    public int[][] ExtraPlayerOptionsEffects = null;
    public int[] SetupEffects = null;
    public int[] PickUpEffects = null;
    public int[] DropEffects = null;
    public int[] ChangeEffects = null;
    public int[] EndOfGameEffects = null;
    public int[] SelectUnitEffects = null;
    public int[] ItemDestroyedEffects = null;
    public int[] TerrainDestroyedEffects = null;
    public String[] Briefing = null;
    public int[][] caeArrays = null;
    public String[] caeRoutineNames = null;
    public int[][] caeRoutines = null;
    public int DifficultyLevel;
    public int CurrentTurn = 0;
    public long ScenarioFlags = 0L;
    public int[] Counters = new int[64];

    Scenario() {
    }

    public static Scenario LoadScenario(Component component, String string) throws LSException {
        LaserSquadScenarioFile laserSquadScenarioFile = LaserSquadScenarioFile.GetLaserSquadScenarioFile(string);
        return laserSquadScenarioFile.GetScenario(component, string);
    }

    public final int GetMapContents(Point point) {
        return this.Map[point.x + point.y * this.MapWidth];
    }

    public final int GetMapContents(int n, int n2) {
        return this.Map[n + n2 * this.MapWidth];
    }

    public final int GetMapContents(int n) {
        return this.Map[n];
    }

    final void SetMapContents(Point point, int n) {
        this.Map[point.x + point.y * this.MapWidth] = n;
    }

    final void SetMapContents(int n, int n2, int n3) {
        this.Map[n + n2 * this.MapWidth] = n3;
    }

    final void SetMapContents(int n, int n2) {
        this.Map[n] = n2;
    }

    final boolean IsOnMap(Point point) {
        if (point.x < 0 || point.x >= this.MapWidth) {
            return false;
        }
        return point.y >= 0 && point.y < this.MapHeight;
    }

    public final void AddUnit(Unit unit, Component component) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.Units.length; ++n2) {
            if (this.Units[n2] != null) continue;
            this.Units[n2] = unit;
            unit.number = n2;
            unit.picture = n2 + this.genericItems.length + this.Terrains.length;
            return;
        }
        Image image = this.Sprites;
        this.Sprites = component.createImage(512, image.getHeight(component) + 64);
        this.Sprites.getGraphics().drawImage(image, 0, 0, null);
        n2 = this.BaseTargetPic / 16 << 5;
        Graphics graphics = this.Sprites.getGraphics().create(0, n2 += 32, 512, n2);
        graphics.drawImage(image, 32, 0, null);
        graphics = this.Sprites.getGraphics().create(0, n2 * 2, 512, this.Sprites.getHeight(component) - n2 * 2);
        graphics.drawImage(image, 64, 0, null);
        this.CursorPic += 32;
        this.BaseDeployPic += 32;
        this.BaseTargetPic += 16;
        this.BaseFlashPic += 32;
        this.BaseSpecialPic += 32;
        for (n2 = 0; n2 < this.UnitTypePictures.length; ++n2) {
            n = 0;
            while (n < this.UnitTypePictures[n2].length) {
                int[] nArray = this.UnitTypePictures[n2];
                int n3 = n++;
                nArray[n3] = nArray[n3] + 32;
            }
        }
        for (n2 = 0; n2 < this.UnitDeathPictures.length; ++n2) {
            n = 0;
            while (n < this.UnitDeathPictures[n2].length) {
                int[] nArray = this.UnitDeathPictures[n2];
                int n4 = n++;
                nArray[n4] = nArray[n4] + 32;
            }
        }
        Unit[] unitArray = new Unit[this.Units.length + 16];
        for (n2 = 0; n2 < 16; ++n2) {
            unitArray[this.Units.length + n2] = null;
        }
        System.arraycopy(this.Units, 0, unitArray, 0, this.Units.length);
        unitArray[this.Units.length] = unit;
        unit.number = this.Units.length;
        unit.picture = this.Units.length + this.genericItems.length + this.Terrains.length;
        this.Units = unitArray;
    }

    public final void RemoveUnit(Unit unit) {
        for (int i = 0; i < this.Units.length; ++i) {
            if (this.Units[i] != unit) continue;
            this.RemoveUnit(i);
            break;
        }
    }

    public final void RemoveUnit(int n) {
        if (n >= 0 && n < this.Units.length) {
            if (this.Units[n] != null) {
                this.Units[n].SetIsDead();
                this.Units[n].SetIsInPlay(false);
                this.Units[n].MapPos.setLocation(-1, -1);
            }
            this.Units[n] = null;
        }
    }

    public final int GetNumberOfUnitsOnTeam(int n) {
        int n2 = 0;
        for (int i = 0; i < this.Units.length; ++i) {
            if (this.Units[i] == null || this.Units[i].team != n) continue;
            ++n2;
        }
        return n2;
    }

    public final void AddItem(Item item) {
        int n;
        for (n = 0; n < this.Items.length; ++n) {
            if (this.Items[n] != null) continue;
            this.Items[n] = item;
            return;
        }
        Item[] itemArray = new Item[this.Items.length + 10];
        for (n = 0; n < 10; ++n) {
            itemArray[this.Items.length + n] = null;
        }
        System.arraycopy(this.Items, 0, itemArray, 0, this.Items.length);
        itemArray[this.Items.length] = item;
        this.Items = itemArray;
    }

    public final void RemoveItem(Item item) {
        for (int i = 0; i < this.Items.length; ++i) {
            if (this.Items[i] != item) continue;
            this.Items[i] = null;
            break;
        }
    }

    public final Item GetLargestItem(Point point) {
        Item item = null;
        int n = 0;
        for (int i = 0; i < this.Items.length; ++i) {
            if (this.Items[i] == null || point.x != this.Items[i].MapPos.x || point.y != this.Items[i].MapPos.y || this.Items[i].GetSize() <= n) continue;
            item = this.Items[i];
            n = item.GetSize();
        }
        return item;
    }

    public final Vector GetUnitItemList(Unit unit) {
        Vector<Item> vector = new Vector<Item>(10, 1);
        for (int i = 0; i < this.Items.length; ++i) {
            if (this.Items[i] == null || unit.number != this.Items[i].owner) continue;
            vector.addElement(this.Items[i]);
        }
        return vector;
    }

    public final Vector GetItemsAtPos(Point point) {
        Vector<Item> vector = new Vector<Item>(10, 1);
        for (int i = 0; i < this.Items.length; ++i) {
            if (this.Items[i] == null || this.Items[i].MapPos.x != point.x || this.Items[i].MapPos.y != point.y || this.Items[i].terrainUnder == 65535) continue;
            vector.addElement(this.Items[i]);
        }
        return vector;
    }

    public final boolean CanDeploy(int n, int n2, int n3) {
        return this.CanDeploy(n + n2 * this.MapWidth, n3);
    }

    public final boolean CanDeploy(int n, int n2) {
        for (int i = 0; i < this.Units.length; ++i) {
            if (this.Units[i] == null || !this.Units[i].IsInPlay() || this.Units[i].MapPos.x != n % this.MapWidth || this.Units[i].MapPos.y != n / this.MapWidth) continue;
            return false;
        }
        return (this.deployMap[n] & 1 << n2) != 0;
    }

    public final boolean IsTerrain(int n) {
        return n < this.BaseItemPic;
    }

    public final boolean IsTerrain(Point point) {
        return this.Map[point.x + point.y * this.MapWidth] < this.BaseItemPic;
    }

    public final boolean IsItem(int n) {
        return n >= this.BaseItemPic && n < this.BaseUnitPic;
    }

    public final boolean IsItem(Point point) {
        return this.IsItem(this.Map[point.x + point.y * this.MapWidth]);
    }

    public final boolean IsUnit(int n) {
        return n >= this.BaseUnitPic && n < this.BaseTargetPic;
    }

    public final boolean IsUnit(Point point) {
        return this.IsUnit(this.Map[point.x + point.y * this.MapWidth]);
    }

    public final int GetRegion(Point point) {
        for (int i = 0; i < this.RegionDefinition.length; i += 5) {
            if (this.RegionDefinition[i] > point.y || this.RegionDefinition[i + 1] <= point.y || this.RegionDefinition[i + 2] > point.x || this.RegionDefinition[i + 3] <= point.x) continue;
            return this.RegionDefinition[i + 4];
        }
        return 0;
    }

    public final int GetRegion(Unit unit) {
        return this.GetRegion(unit.MapPos);
    }

    public final int GetNode(Point point) {
        for (int i = 0; i < this.Nodes.length; ++i) {
            if (!this.Nodes[i].equals(point)) continue;
            return i;
        }
        return -1;
    }

    public final int GetRouteBetweenNodes(int n, int n2, int[] nArray) {
        int n3;
        int[] nArray2 = new int[this.Nodes.length];
        int[] nArray3 = new int[this.Nodes.length];
        int[] nArray4 = new int[this.Nodes.length];
        boolean bl = false;
        int[] nArray5 = new int[1];
        if (n == n2) {
            nArray[0] = n;
            return 0;
        }
        int n4 = this.GetRegion(this.Nodes[n]);
        int n5 = this.GetRegion(this.Nodes[n2]);
        int n6 = this.InterRegionDistance[n4][n5];
        for (n3 = 0; n3 < this.Nodes.length; ++n3) {
            nArray4[n3] = Integer.MAX_VALUE;
        }
        int n7 = 0;
        nArray[0] = n;
        nArray2[0] = -2;
        nArray3[0] = -1;
        block1: while (n7 >= 0) {
            if (nArray[n7] == n2) {
                bl = true;
                n6 = nArray3[n7];
                nArray5 = new int[n7 + 1];
                for (n3 = 0; n3 <= n7; ++n3) {
                    nArray5[n3] = nArray[n3];
                }
                --n7;
                continue;
            }
            int n8 = n7;
            nArray2[n8] = nArray2[n8] + 2;
            if (nArray2[n7] >= this.NodeConnections[nArray[n7]].length) {
                --n7;
                continue;
            }
            if (this.PathNodeLimit != -1 && this.PathNodeLimit == n7) {
                --n7;
                continue;
            }
            nArray[n7 + 1] = this.NodeConnections[nArray[n7]][nArray2[n7]];
            if (n7 > 0) {
                for (n3 = 0; n3 < n7; ++n3) {
                    if (nArray[n3] == nArray[n7 + 1]) continue block1;
                }
            }
            if (nArray3[n7] + this.NodeConnections[nArray[n7]][nArray2[n7] + 1] > nArray4[nArray[n7 + 1]]) continue;
            nArray4[nArray[n7 + 1]] = nArray3[n7] + this.NodeConnections[nArray[n7]][nArray2[n7] + 1];
            if (nArray3[n7] + this.NodeConnections[nArray[n7]][nArray2[n7] + 1] > n6) continue;
            nArray3[n7 + 1] = nArray3[n7] + this.NodeConnections[nArray[n7]][nArray2[n7] + 1];
            nArray2[++n7] = -2;
        }
        if (!bl) {
            return -1;
        }
        n3 = 0;
        do {
            nArray[n3] = nArray5[n3];
        } while (nArray[++n3 - 1] != n2);
        nArray[n3] = -1;
        return n6;
    }

    public static Scenario InputScenario(LaserSquad laserSquad, TextArea textArea, String string, StringBuffer stringBuffer) throws LSException {
        int n;
        Object object;
        String string2 = null;
        if (textArea != null) {
            string2 = textArea.getText();
        } else {
            object = null;
            try {
                n = (int)new File(string).length();
                object = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new LSException("/U/P0A08/Q8682CANNOT FIND FILE/T/Q0C0C/P0D0APRESS ANY KEY");
            }
            try {
                byte[] byArray = new byte[n];
                ((FileInputStream)object).read(byArray);
                ((FileInputStream)object).close();
                string2 = new String(byArray);
            }
            catch (IOException iOException) {
                throw new LSException("/U/P0A08/Q8682CANNOT LOAD FILE/T/Q0C0C/P0D0APRESS ANY KEY");
            }
        }
        n = string2.indexOf("Saved at:");
        if (n == -1) {
            throw new LSException("/P0B06SAVED GAME IS CORRUPT/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        if ((n = string2.indexOf(10, n)) == -1) {
            throw new LSException("/P0B06SAVED GAME IS CORRUPT/Q0D0D>/Q0C0C/P0D0APRESS ANY KEY");
        }
        object = Integer.toHexString(string2.length() - ++n);
        stringBuffer.append("K" + "00000000".substring(((String)object).length()) + ((String)object).toUpperCase() + string2.substring(n));
        Scenario scenario = LaserSquadScenarioFile.GetScenarioFromString(string2.substring(n), laserSquad);
        System.gc();
        return scenario;
    }

    public final String OutputScenario(TextArea textArea, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Laser Squad saved game.\r\n");
        stringBuffer.append(this.name);
        stringBuffer.append("    Turn number: ");
        stringBuffer.append(Integer.toString(this.CurrentTurn));
        stringBuffer.append("    Saved at: ");
        Date date = new Date(System.currentTimeMillis());
        stringBuffer.append(date.toString());
        stringBuffer.append("\r\n");
        try {
            stringBuffer.append(this.ScenarioToText());
        }
        catch (LSException lSException) {
            System.gc();
            return lSException.getMessage();
        }
        if (textArea != null) {
            textArea.append(stringBuffer.toString());
            System.gc();
            return null;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.gc();
            return "/U/P0A04/Q8682CANNOT CREATE SAVE FILE!/Q0707/T/P0E06ARE YOU OVERWRITING// A READ-ONLY FILE?";
        }
        try {
            fileOutputStream.write(stringBuffer.toString().getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.gc();
            return "/U/P0A04/Q8682CANNOT SAVE DATA TO FILE";
        }
        System.gc();
        return "/U/P0A09/Q8584SAVE SUCESSFUL";
    }

    public String ScenarioToText() throws LSException {
        LaserSquadScenarioFile laserSquadScenarioFile = LaserSquadScenarioFile.GetLaserSquadScenarioFile(this.ScenarioClassName);
        return laserSquadScenarioFile.GetStringFromScenario(this);
    }
}

