/*
 * Decompiled with CFR 0.152.
 */
final class Terrain {
    public String name;
    public int picture;
    public int[] MovementCost;
    public int[] VictoryPointValues;
    public int[] MorraleValues;
    public int flags;
    public int maxHideSize;
    public int open;
    public int lock;
    public int[] keys = null;
    public int protection;
    public int strength;
    public int becomesWhenDammaged;
    public int forceAbsorbed;
    public int explodeForce;
    public int[] AnimationDetails = null;
    public int[] TargettingAnimationDetails = null;

    Terrain() {
    }

    public final boolean WillLock(int n) {
        if (n == 0 || this.keys == null) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] != n) continue;
            return true;
        }
        return false;
    }

    public final boolean WillExplode() {
        return (this.flags & 8) == 8;
    }

    public final boolean CanClose() {
        return (this.flags & 1) == 0 && this.open != 65535;
    }

    public final boolean IsClosed() {
        return (this.flags & 1) == 1;
    }

    public final boolean CanOpen() {
        return (this.flags & 1) == 1 && this.open != 65535;
    }

    public final boolean IsOpen() {
        return (this.flags & 1) == 0;
    }

    public final boolean IsLocked() {
        return (this.flags & 2) == 2;
    }

    public final boolean CanHide() {
        return (this.flags & 4) == 4;
    }

    public final boolean Allows(Unit unit) {
        return this.MovementCost[unit.terrainBand] != 4095;
    }

    public final boolean CanSeeThrough() {
        return (this.flags & 0x40) == 0;
    }

    public final boolean CanShootThrough() {
        return (this.flags & 0x20) == 0;
    }

    public final boolean CanComputerMoveThrough() {
        return (this.flags & 0x10) == 0;
    }

    public final boolean CanDestroyTerrainToPass(Team team) {
        if (team.TerrainsCanDestroy != null) {
            for (int i = 0; i < team.TerrainsCanDestroy.length; ++i) {
                if (team.TerrainsCanDestroy[i] != this.picture) continue;
                return true;
            }
        }
        return false;
    }
}

