/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;

final class Unit {
    public static final int ARMOUR_FRONT = 0;
    public static final int ARMOUR_RIGHT = 1;
    public static final int ARMOUR_REAR = 2;
    public static final int ARMOUR_LEFT = 3;
    private Scenario scenario;
    public int number;
    public String name;
    public int picture;
    public int ItemWhenDead;
    public int unitType;
    public int currentActionPoints;
    public int maxActionPoints;
    public int burdonAdjustedActionPoints;
    public int currentStamina;
    public int maxStamina;
    public int toughness;
    public int currentConstitution;
    public int maxConstitution;
    public int currentMorrale;
    public int maxMorrale;
    public int strength;
    public int agility;
    public int weaponSkill;
    public int closeCombatDamage;
    public int burdon;
    public int fatigue;
    public int[] VictoryPointValues;
    public int[] MorraleValues;
    public int[] DeathEffects = null;
    public int TargetPatrolWayPointNumber;
    public int[] PatrolRouteWayPoints = null;
    public int[] RegionThreatValues = null;
    public int[] TerrainsWantToDestroy = null;
    public int MinRangeAimedAttempted;
    public int MinRangeSnapAttempted;
    public int VisibleEnemies = 0;
    public Unit MaxThreat;
    public int[] RoundsUntilForgotten;
    public int team;
    public int flags;
    public int flags2;
    public int size;
    public int terrainBand;
    public int startX;
    public int startY;
    public int startDX;
    public int startDY;
    public int startRound;
    public int startLevels;
    public Item itemHeld = null;
    public int headding = 0;
    public int UnderneathUnit;
    public Point MapPos;
    public int weightCarried;
    public int sizeCarried;
    public int maxSizeCarried;
    public int[] armour = new int[]{0, 0, 0, 0};
    public int armourWeight;
    private int LastValidHeadding;
    private int LastValidAP;
    private Point LastValidPos;
    private Point LastValidView;
    private Point LastValidTopLeftView;
    public int iOrigionalScenarioPosition = -1;

    public Unit(Scenario scenario) {
        this.scenario = scenario;
        this.MapPos = new Point(-1, -1);
        this.LastValidPos = new Point();
        this.LastValidView = new Point();
        this.LastValidTopLeftView = new Point();
    }

    public final void MoveUnit(int n, int n2) {
        this.MoveUnit(new Point(n, n2));
    }

    public final void MoveUnit(Point point) {
        if (this.MapPos.x != -1) {
            this.scenario.SetMapContents(this.MapPos, this.UnderneathUnit);
        }
        if (point == null) {
            this.MapPos.setLocation(-1, -1);
            this.UnderneathUnit = -1;
        } else {
            this.MapPos.setLocation(point);
            this.UnderneathUnit = this.scenario.GetMapContents(this.MapPos);
            this.scenario.SetMapContents(this.MapPos, this.picture);
        }
    }

    public final int GetWound() {
        int n = this.maxConstitution - this.currentConstitution;
        n += this.toughness >> 1;
        return n /= this.toughness;
    }

    public final boolean IsVisibleToEnemies() {
        return (this.flags & 0x1000000) == 0x1000000;
    }

    public final void SetIsVisibleToEnemies(boolean bl) {
        this.flags -= this.flags & 0x1000000;
        if (bl) {
            this.flags += 0x1000000;
        }
    }

    public final boolean IsDead() {
        return (this.flags & 0x400000) == 0x400000;
    }

    public final void SetIsDead() {
        this.flags |= 0x400000;
    }

    public final boolean isOnTeam(int n) {
        return this.team == n;
    }

    public final boolean canBeEquipped() {
        return (this.flags & 1) == 1;
    }

    public final boolean canChange() {
        return (this.flags & 4) != 4;
    }

    public final boolean canDrop() {
        return (this.flags & 2) != 2;
    }

    public final void SetPanicked(boolean bl) {
        this.flags -= this.flags & 0x800000;
        if (bl) {
            this.flags += 0x800000;
        }
    }

    public final boolean IsPanicked() {
        return (this.flags & 0x800000) == 0x800000;
    }

    public final boolean IgnoresMorale() {
        return (this.flags & 0x10) == 16;
    }

    public final boolean ItemsDestroyedWithUnit() {
        return (this.flags & 8) == 8;
    }

    public final boolean IsManuallyDeployable() {
        return (this.flags & 0x80) == 128;
    }

    public final boolean UsesBurdonedActionPointsToCalculateThreateningUnit() {
        return (this.flags & 0x20) == 32;
    }

    public final boolean NeverReserveActionPointsWhenPatrolling() {
        return (this.flags & 0x100) == 256;
    }

    public final boolean AlwaysReserveActionPointsWhenPatrolling() {
        return (this.flags & 0x200) == 512;
    }

    public final boolean MovesCautiously() {
        return (this.flags & 0x400) == 1024;
    }

    public final boolean PatrolsRatherThanHeadsTowardsThreats() {
        return (this.flags & 0x800) == 2048;
    }

    public final boolean AutoReloadsWeapon() {
        return (this.flags & 0x2000) == 8192;
    }

    public final boolean HeadsForTargetTerrain() {
        return (this.flags & 0x4000) == 16384;
    }

    public final boolean HeadsForNearestVisibleEnemy() {
        return (this.flags & 0x1000) == 4096;
    }

    public final boolean IgnoresRegionThreat() {
        return (this.flags & 0x8000) == 32768;
    }

    public final boolean IgnoresItemThreat() {
        return (this.flags & 0x40) == 64;
    }

    public final boolean IgnoresEnemiesWithZeroThreat() {
        return (this.flags & 0x10000) == 65536;
    }

    public final boolean CanOpportunityFire() {
        return (this.flags & 0x100000) == 0x100000;
    }

    public final void SetHasOpportunityFired() {
        this.flags -= this.flags & 0x100000;
    }

    public final void SetCanOpportunityFire() {
        this.flags |= 0x100000;
    }

    public final boolean IsInPlay() {
        return (this.flags & 0x200000) == 0x200000;
    }

    public final void SetIsInPlay(boolean bl) {
        this.flags -= this.flags & 0x200000;
        if (bl) {
            this.flags |= 0x200000;
        }
    }

    public final void StoreLastValidPosition(LaserSquad laserSquad) {
        if (this.scenario.IsUnit(this.UnderneathUnit)) {
            return;
        }
        this.LastValidPos.setLocation(this.MapPos);
        this.LastValidHeadding = this.headding;
        this.LastValidAP = this.currentActionPoints;
        this.LastValidView.setLocation(laserSquad.MapView);
        this.LastValidTopLeftView.setLocation(laserSquad.MapTL);
    }

    public final void RestoreLastValidPosition(LaserSquad laserSquad) {
        if (!this.scenario.IsUnit(this.UnderneathUnit)) {
            return;
        }
        this.scenario.SetMapContents(this.MapPos, this.UnderneathUnit);
        this.UnderneathUnit = this.scenario.GetMapContents(this.LastValidPos);
        this.scenario.SetMapContents(this.LastValidPos, this.picture);
        this.headding = this.LastValidHeadding;
        this.currentActionPoints = this.LastValidAP;
        this.MapPos.setLocation(this.LastValidPos);
        laserSquad.MapView.setLocation(this.LastValidView);
        laserSquad.MapTL.setLocation(this.LastValidTopLeftView);
        this.CalculateUnitPicture();
    }

    public final void CalculateUnitPicture() {
        int n = this.scenario.UnitTypePictures[this.unitType][this.itemHeld == null ? 0 : this.itemHeld.genericNumber + 1] + this.headding;
        Graphics graphics = this.scenario.Sprites.getGraphics().create(this.picture % 16 << 5, this.picture / 16 << 5, 32, 32);
        graphics.drawImage(this.scenario.Sprites, -(n % 16 << 5), -(n / 16 << 5), null);
        n = this.scenario.UnitTypePictures[this.unitType][this.itemHeld == null ? 0 : this.itemHeld.genericNumber + 1] + 8 + this.headding;
        int n2 = this.picture + this.scenario.BaseTargetPic;
        graphics = this.scenario.Sprites.getGraphics().create(n2 % 16 << 5, n2 / 16 << 5, 32, 32);
        graphics.drawImage(this.scenario.Sprites, -(n % 16 << 5), -(n / 16 << 5), null);
    }

    public final Item GetFirstItem(int n) {
        for (int i = 0; i < this.scenario.Items.length; ++i) {
            if (this.scenario.Items[i] == null || this.scenario.Items[i].owner != this.number || this.scenario.Items[i].genericNumber != n) continue;
            return this.scenario.Items[i];
        }
        return null;
    }
}

