/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

class AnnimationEditor
extends Dialog
implements ActionListener,
WindowListener {
    private LaserSquadScenarioEditor lsse;
    private Panel holder;
    private int job;
    protected Vector Pics;
    protected Vector Times;
    private AnnimationImagesList ail;
    private AnimationPanel ap;

    public AnnimationEditor(LaserSquadScenarioEditor laserSquadScenarioEditor, Panel panel, int n, String string, Image[] imageArray, int[] nArray) {
        super(laserSquadScenarioEditor, string, true);
        this.setBounds(laserSquadScenarioEditor.getInsets().left + laserSquadScenarioEditor.getX(), laserSquadScenarioEditor.getInsets().top + laserSquadScenarioEditor.getY(), 250, 300);
        this.lsse = laserSquadScenarioEditor;
        this.holder = panel;
        this.job = n;
        this.addWindowListener(this);
        this.Pics = new Vector();
        this.Times = new Vector();
        for (int i = 0; i < imageArray.length; ++i) {
            this.Pics.add(imageArray[i]);
            this.Times.add(new Integer(nArray[i]));
        }
        this.setLayout(new BorderLayout());
        this.ail = new AnnimationImagesList(laserSquadScenarioEditor, this, this.Pics, this.Times, this.job);
        this.add("Center", this.ail);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(this.job == 3 || this.job == 4 ? 6 : 8, 1));
        Button button = new Button("Add above");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Add below");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Delete");
        button.addActionListener(this);
        panel2.add(button);
        panel2.add(new Panel());
        if (this.job != 3 && this.job != 4) {
            button = new Button("Stop Animation");
            button.addActionListener(this);
            panel2.add(button);
            panel2.add(new Panel());
        }
        button = new Button("Ok");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Cancel");
        button.addActionListener(this);
        panel2.add(button);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("South", panel2);
        this.ap = new AnimationPanel(imageArray, nArray);
        panel3.add("Center", this.ap);
        this.add("West", panel3);
        this.validate();
        this.show();
    }

    protected void notifyAnimationChange() {
        Image[] imageArray = new Image[this.Pics.size()];
        int[] nArray = new int[this.Pics.size()];
        for (int i = 0; i < this.Pics.size(); ++i) {
            imageArray[i] = (Image)this.Pics.elementAt(i);
            nArray[i] = (Integer)this.Times.elementAt(i);
        }
        this.ap.reset(imageArray, nArray);
        this.ail.RequestUpdate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("Ok")) {
            Image[] imageArray = new Image[this.Pics.size()];
            int[] nArray = new int[this.Pics.size()];
            for (int i = 0; i < this.Pics.size(); ++i) {
                imageArray[i] = (Image)this.Pics.elementAt(i);
                nArray[i] = (Integer)this.Times.elementAt(i);
            }
            if (this.job == 1) {
                ((TerrainEditor)this.holder).ChangeMapAnnimation(imageArray, nArray);
            }
            if (this.job == 2) {
                ((TerrainEditor)this.holder).ChangeTargetAnnimation(imageArray, nArray);
            }
            if (this.job == 3) {
                ((GenericUnitEditor)this.holder).ChangeDeathAnnimation(imageArray, nArray);
            }
            if (this.job == 4) {
                ((CauseAndEffectPanel)this.holder).ChangeTerrainAnnimation(imageArray, nArray);
            }
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("Stop Animation")) {
            if (this.job == 1) {
                ((TerrainEditor)this.holder).ChangeMapAnnimation(null, null);
            }
            if (this.job == 2) {
                ((TerrainEditor)this.holder).ChangeTargetAnnimation(null, null);
            }
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("Add above")) {
            if ((this.job == 3 || this.job == 4) && this.ail.GetPointer() == 0) {
                return;
            }
            this.Pics.insertElementAt(this.Pics.elementAt(this.ail.GetPointer()), this.ail.GetPointer());
            this.Times.insertElementAt(new Integer(this.job == 3 ? 12 : 50), this.ail.GetPointer());
            this.notifyAnimationChange();
            if (this.job != 3) {
                this.ail.tf.setText("50");
            }
            return;
        }
        if (actionEvent.getActionCommand().equals("Add below")) {
            if ((this.job == 3 || this.job == 4) && this.ail.GetPointer() == this.Pics.size() - 1) {
                return;
            }
            this.Pics.insertElementAt(this.Pics.elementAt(this.ail.GetPointer()), this.ail.GetPointer() + 1);
            this.Times.insertElementAt(new Integer(this.job == 3 ? 12 : 50), this.ail.GetPointer() + 1);
            this.notifyAnimationChange();
            if (this.job != 3) {
                this.ail.tf.setText("50");
            }
            this.ail.incrementPointer();
            return;
        }
        if (actionEvent.getActionCommand().equals("Delete")) {
            if (this.Pics.size() == 1) {
                return;
            }
            this.ail.DeleteSelected();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.hide();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

