/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

class AnnimationImagesList
extends Panel
implements AdjustmentListener,
MouseListener,
KeyListener,
TextListener {
    private LaserSquadScenarioEditor lsse;
    private int pointer;
    private Scrollbar sb;
    private int AILWidth = -1;
    private int AILHeight = -1;
    private AnnimationEditor holder;
    private Image AILImage = null;
    private Graphics AILGraph;
    private Vector vPics;
    private Vector vTimes;
    protected TextField tf = null;
    private int job;

    public AnnimationImagesList(LaserSquadScenarioEditor laserSquadScenarioEditor, AnnimationEditor annimationEditor, Vector vector, Vector vector2, int n) {
        this.lsse = laserSquadScenarioEditor;
        this.holder = annimationEditor;
        this.vPics = vector;
        this.vTimes = vector2;
        this.job = n;
        this.pointer = 0;
        this.sb = new Scrollbar(1, 0, 1, 0, this.vPics.size());
        this.sb.addAdjustmentListener(this);
        this.add(this.sb);
        this.addMouseListener(this);
        this.setBackground(new Color(240, 240, 240));
        if (n != 3) {
            this.tf = new TextField(4);
            this.tf.setFont(LaserSquadScenarioEditor.font);
            this.tf.setText(((Integer)this.vTimes.elementAt(0)).toString());
            this.tf.addKeyListener(this);
            this.tf.addTextListener(this);
            this.add(this.tf);
            this.tf.requestFocus();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.AILWidth || n4 != this.AILHeight) {
            this.AILWidth = n3;
            this.AILHeight = n4;
            this.AILImage = this.createImage(n3 - 16, n4);
            if (this.AILImage != null) {
                this.AILGraph = this.AILImage.getGraphics();
                this.RequestUpdate();
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        int n = this.AILHeight;
        if (this.AILGraph == null) {
            return;
        }
        this.AILGraph.setColor(Color.WHITE);
        this.AILGraph.fillRect(0, 0, this.AILWidth - 16, n);
        this.sb.setBounds(this.AILWidth - 16, 0, 16, n);
        this.sb.setVisibleAmount(n /= 34);
        this.AILGraph.setColor(Color.BLACK);
        this.AILGraph.setFont(LaserSquadScenarioEditor.font);
        if (this.tf != null) {
            this.tf.setVisible(false);
        }
        int n2 = this.sb.getValue();
        if (this.vPics.size() > 0) {
            for (int i = 0; i < n && i + n2 < this.vPics.size(); ++i) {
                this.AILGraph.drawImage((Image)this.vPics.elementAt(i + n2), 1, 1 + i * 34, null);
                if (this.tf != null && (this.job != 4 || i + n2 != 0 && i + n2 != this.vPics.size() - 1)) {
                    this.AILGraph.drawString(((Integer)this.vTimes.elementAt(i + n2)).toString(), 38, 21 + i * 34);
                }
                if (i + n2 != this.pointer) continue;
                this.AILGraph.setColor(Color.RED);
                this.AILGraph.drawRect(0, i * 34, this.AILWidth - 17, 33);
                this.AILGraph.setColor(Color.BLACK);
                if (this.tf == null || this.job == 4 && (i + n2 == 0 || i + n2 == this.vPics.size() - 1)) continue;
                this.tf.setVisible(true);
            }
        }
    }

    protected int GetPointer() {
        return this.pointer;
    }

    protected void incrementPointer() {
        ++this.pointer;
        this.RepaintOffScreenImage();
        this.repaint();
        if (this.tf != null) {
            this.tf.requestFocus();
        }
    }

    protected void DeleteSelected() {
        if (!(this.job != 3 && this.job != 4 || this.pointer != 0 && this.pointer != this.vPics.size() - 1)) {
            return;
        }
        this.vPics.removeElementAt(this.pointer);
        this.vTimes.removeElementAt(this.pointer);
        if (this.pointer >= this.vPics.size()) {
            this.pointer = this.vPics.size() - 1;
        }
        if (this.tf != null) {
            this.tf.setText(((Integer)this.vTimes.elementAt(this.pointer)).toString());
        }
        this.holder.notifyAnimationChange();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.AILGraph.setColor(Color.WHITE);
        this.AILGraph.drawLine(this.AILWidth - 18, 1, this.AILWidth - 18, 2);
        if (this.AILImage != null) {
            graphics.drawImage(this.AILImage, 0, 0, null);
        }
        this.sb.setBounds(this.AILWidth - 16, 0, 16, this.AILHeight);
        if (this.tf != null) {
            this.tf.setBounds(34, (this.pointer - this.sb.getValue()) * 34 + 7, 60, 20);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RequestUpdate();
    }

    protected void RequestUpdate() {
        this.sb.setValues(this.sb.getValue() >= this.vPics.size() - 1 ? this.vPics.size() : this.sb.getValue(), 1, 0, this.vPics.size());
        this.RepaintOffScreenImage();
        this.repaint();
        if (this.tf != null) {
            this.tf.requestFocus();
        }
    }

    protected void ChangePic(Image image) {
        this.vPics.setElementAt(image, this.pointer);
        this.holder.notifyAnimationChange();
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getID() == 900) {
            int n;
            try {
                n = Integer.parseInt(this.tf.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            this.vTimes.setElementAt(new Integer(n), this.pointer);
            this.holder.notifyAnimationChange();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (n < 0 || n > this.AILWidth - 16) {
            return;
        }
        n = mouseEvent.getY();
        int n2 = this.AILHeight / 34;
        if (n < 0 || n > (n2 *= 34)) {
            return;
        }
        n = mouseEvent.getY() / 34;
        if ((n += this.sb.getValue()) >= this.vPics.size()) {
            return;
        }
        if (n != this.pointer) {
            this.pointer = n;
            if (this.tf != null) {
                this.tf.setText(((Integer)this.vTimes.elementAt(this.pointer)).toString());
            }
        } else if (mouseEvent.getX() >= 1 && mouseEvent.getX() < 33 && mouseEvent.getY() >= 1 + (this.pointer - this.sb.getValue()) * 34 && mouseEvent.getY() < 33 + (this.pointer - this.sb.getValue()) * 34 && (this.job != 3 && this.job != 4 || this.pointer != 0 && this.pointer != this.vPics.size() - 1)) {
            new ImageSelector(this.lsse, this, 3, "Select animation picture", (Image)this.vPics.elementAt(this.pointer));
        }
        this.RequestUpdate();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) && c != '\b' && keyEvent.getKeyCode() != 127) {
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

