/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

class ArraysEditorWindow
extends Dialog
implements WindowListener,
ActionListener,
ItemListener {
    private LaserSquadScenarioEditor lsse;
    private Panel parent;
    private int[][] aData;
    private int[] aNumbers;
    private List lData;
    private TextField tfSize;
    private TextField tfValue;
    private TextField tfMove;
    private TextField tfNew;
    private Choice cArray;
    private Button butApply;

    public ArraysEditorWindow(LaserSquadScenarioEditor laserSquadScenarioEditor, Panel panel) {
        super(laserSquadScenarioEditor, "Array Editor", true);
        Object object;
        Object object2;
        this.lsse = laserSquadScenarioEditor;
        this.parent = panel;
        this.addWindowListener(this);
        this.cArray = new Choice();
        this.aData = new int[laserSquadScenarioEditor.CAEArrays.size()][];
        this.aNumbers = new int[laserSquadScenarioEditor.CAEArrays.size()];
        if (laserSquadScenarioEditor.CAEArrays.size() > 0) {
            for (int i = 0; i < laserSquadScenarioEditor.CAEArrays.size(); ++i) {
                object2 = (Object[])laserSquadScenarioEditor.CAEArrays.elementAt(i);
                this.aNumbers[i] = (Integer)object2[0];
                object = (int[])object2[1];
                this.aData[i] = new int[((int[])object).length];
                System.arraycopy(object, 0, this.aData[i], 0, ((int[])object).length);
                this.cArray.add(Integer.toString(this.aNumbers[i]));
            }
        }
        this.lData = new List(0, false);
        this.lData.setFont(LaserSquadScenarioEditor.font);
        this.lData.addItemListener(this);
        this.add("East", this.lData);
        object2 = new Panel(new FlowLayout(0));
        object = new Panel();
        Label label = new Label("Array:");
        ((Container)object).add(label);
        this.cArray.addItemListener(this);
        ((Container)object).add(this.cArray);
        ((Container)object2).add((Component)object);
        object = new Panel();
        Button button = new Button("Set Value");
        button.addActionListener(this);
        ((Container)object).add(button);
        this.tfValue = new TextField(20);
        ((Container)object).add(this.tfValue);
        ((Container)object2).add((Component)object);
        object = new Panel();
        button = new Button("Set Size");
        button.addActionListener(this);
        ((Container)object).add(button);
        this.tfSize = new TextField(20);
        ((Container)object).add(this.tfSize);
        ((Container)object2).add((Component)object);
        object = new Panel();
        button = new Button("Move to");
        button.addActionListener(this);
        ((Container)object).add(button);
        this.tfMove = new TextField(20);
        ((Container)object).add(this.tfMove);
        ((Container)object2).add((Component)object);
        object = new Panel();
        button = new Button("Delete Array");
        button.addActionListener(this);
        ((Container)object).add(button);
        button = new Button("Load Array Data");
        button.addActionListener(this);
        ((Container)object).add(button);
        ((Container)object2).add((Component)object);
        object = new Panel();
        button = new Button("New Array");
        button.addActionListener(this);
        ((Container)object).add(button);
        this.tfNew = new TextField(20);
        ((Container)object).add(this.tfNew);
        ((Container)object2).add((Component)object);
        this.add("Center", (Component)object2);
        if (this.aData.length > 0) {
            this.SelectArray(0, 0);
        }
        object2 = new Panel();
        button = new Button("OK");
        button.addActionListener(this);
        ((Container)object2).add(button);
        button = new Button("Cancel");
        button.addActionListener(this);
        ((Container)object2).add(button);
        this.butApply = new Button("Apply Changes");
        this.butApply.setEnabled(false);
        this.butApply.addActionListener(this);
        ((Container)object2).add(this.butApply);
        this.add("South", (Component)object2);
        this.setBounds(laserSquadScenarioEditor.getX() + (laserSquadScenarioEditor.getWidth() - 450) / 2, laserSquadScenarioEditor.getY() + (laserSquadScenarioEditor.getHeight() - 350) / 2, 450, 350);
        this.show();
    }

    private void SelectArray(int n, int n2) {
        this.tfSize.setText(Integer.toString(this.aData[n].length));
        this.tfValue.setText(Integer.toString(this.aData[n][n2]));
        this.lData.removeAll();
        for (int i = 0; i < this.aData[n].length; ++i) {
            this.lData.add(i + "=" + this.aData[n][i]);
        }
        this.lData.select(n2);
    }

    private int InsertArray(int n, int[] nArray) {
        int n2;
        for (n2 = 0; n2 < this.aNumbers.length && n > this.aNumbers[n2]; ++n2) {
        }
        int[] nArray2 = new int[this.aNumbers.length + 1];
        int[][] nArrayArray = new int[this.aData.length + 1][];
        if (n2 != 0) {
            System.arraycopy(this.aNumbers, 0, nArray2, 0, n2);
            System.arraycopy(this.aData, 0, nArrayArray, 0, n2);
        }
        if (n2 != this.aNumbers.length) {
            System.arraycopy(this.aNumbers, n2, nArray2, n2 + 1, this.aNumbers.length - n2);
            System.arraycopy(this.aData, n2, nArrayArray, n2 + 1, this.aData.length - n2);
        }
        this.aNumbers = nArray2;
        this.aData = nArrayArray;
        this.aNumbers[n2] = n;
        this.aData[n2] = nArray;
        return n2;
    }

    private void DeleteArray(int n) {
        int[] nArray = new int[this.aNumbers.length - 1];
        int[][] nArrayArray = new int[this.aData.length - 1][];
        if (n != 0) {
            System.arraycopy(this.aNumbers, 0, nArray, 0, n);
            System.arraycopy(this.aData, 0, nArrayArray, 0, n);
        }
        if (n != this.aNumbers.length - 1) {
            System.arraycopy(this.aNumbers, n + 1, nArray, n, this.aNumbers.length - n - 1);
            System.arraycopy(this.aData, n + 1, nArrayArray, n, this.aData.length - n - 1);
        }
        this.aNumbers = nArray;
        this.aData = nArrayArray;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.cArray.getSelectedIndex();
        if (itemEvent.getSource() == this.cArray && itemEvent.getStateChange() == 1 && n != -1) {
            this.SelectArray(n, 0);
        }
        if (itemEvent.getSource() == this.lData && itemEvent.getStateChange() == 1 && n != -1 && this.lData.getSelectedIndex() != -1) {
            this.SelectArray(n, this.lData.getSelectedIndex());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2 = this.cArray.getSelectedIndex();
        int n3 = 0;
        if (actionEvent.getActionCommand().equals("New Array")) {
            try {
                n2 = Integer.parseInt(this.tfNew.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new MessageBox(this.lsse, "Error!", "Need an ID number for the new Array.", MessageBox.MB_OK);
                return;
            }
            if (n2 < 0 || n2 >= 4096) {
                new MessageBox(this.lsse, "Error!", "Need an ID number between 0 and 4095 inclusive.", MessageBox.MB_OK);
                return;
            }
            for (n = 0; n < this.aNumbers.length; ++n) {
                if (this.aNumbers[n] != n2) continue;
                new MessageBox(this.lsse, "Error!", "Need an unused ID number for the new Array.", MessageBox.MB_OK);
                return;
            }
            n = this.InsertArray(n2, new int[1]);
            this.cArray.removeAll();
            for (n2 = 0; n2 < this.aNumbers.length; ++n2) {
                this.cArray.add(Integer.toString(this.aNumbers[n2]));
            }
            this.cArray.select(n);
            this.SelectArray(n, 0);
            this.show();
            this.butApply.setEnabled(true);
            return;
        }
        if (actionEvent.getActionCommand().equals("Set Value")) {
            if (n2 == -1) {
                new MessageBox(this.lsse, "Error!", "No Array selected to alter.", MessageBox.MB_OK);
                return;
            }
            n = this.lData.getSelectedIndex();
            if (n == -1) {
                new MessageBox(this.lsse, "Error!", "No Array entry selected to alter.", MessageBox.MB_OK);
                return;
            }
            try {
                n3 = Integer.parseInt(this.tfValue.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new MessageBox(this.lsse, "Error!", "Need a valid number.\n(between -2147483648 and 2147483647)", MessageBox.MB_OK);
                return;
            }
            this.aData[n2][n] = n3;
            this.lData.replaceItem(n + "=" + n3, n);
            this.lData.select(n);
            this.butApply.setEnabled(true);
            return;
        }
        if (actionEvent.getActionCommand().equals("Set Size")) {
            if (n2 == -1) {
                new MessageBox(this.lsse, "Error!", "No Array selected to resize.", MessageBox.MB_OK);
                return;
            }
            try {
                n = Integer.parseInt(this.tfSize.getText());
                if (n < 1) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                new MessageBox(this.lsse, "Error!", "Need a valid array size.\n(between 1 and 2147483647)", MessageBox.MB_OK);
                return;
            }
            if (n != this.aData[n2].length) {
                int[] nArray = new int[n];
                System.arraycopy(this.aData[n2], 0, nArray, 0, Math.min(this.aData[n2].length, n));
                this.aData[n2] = nArray;
                n = Math.min(this.lData.getSelectedIndex(), n - 1);
                this.SelectArray(n2, n);
                this.butApply.setEnabled(true);
            }
            return;
        }
        if (actionEvent.getActionCommand().equals("Move to")) {
            if (n2 == -1) {
                new MessageBox(this.lsse, "Error!", "No Array selected to move.", MessageBox.MB_OK);
                return;
            }
            try {
                n = Integer.parseInt(this.tfMove.getText());
                if (n < 0 || n > 4095) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                new MessageBox(this.lsse, "Error!", "Need an ID number between 0 and 4095 inclusive.", MessageBox.MB_OK);
                return;
            }
            if (this.aNumbers[n2] == n) {
                return;
            }
            for (n3 = 0; n3 < this.aNumbers.length; ++n3) {
                if (n3 == n2 || this.aNumbers[n3] != n) continue;
                new MessageBox(this.lsse, "Error!", "Need an ID number " + n + " is already\nin use by another array.", MessageBox.MB_OK);
                return;
            }
            int[] nArray = this.aData[n2];
            this.DeleteArray(n2);
            n = this.InsertArray(n, nArray);
            this.cArray.removeAll();
            for (n2 = 0; n2 < this.aNumbers.length; ++n2) {
                this.cArray.add(Integer.toString(this.aNumbers[n2]));
            }
            this.cArray.select(n);
            this.SelectArray(n, 0);
            this.show();
            this.butApply.setEnabled(true);
            return;
        }
        if (actionEvent.getActionCommand().equals("Delete Array")) {
            if (n2 == -1) {
                new MessageBox(this.lsse, "Error!", "No Array selected to move.", MessageBox.MB_OK);
                return;
            }
            this.DeleteArray(n2);
            this.cArray.removeAll();
            if (this.aNumbers.length > 0) {
                for (n2 = 0; n2 < this.aNumbers.length; ++n2) {
                    this.cArray.add(Integer.toString(this.aNumbers[n2]));
                }
                this.cArray.select(0);
                this.SelectArray(0, 0);
            } else {
                this.lData.removeAll();
            }
            this.show();
            this.butApply.setEnabled(true);
            return;
        }
        if (actionEvent.getActionCommand().equals("Load Array Data")) {
            if (n2 == -1) {
                new MessageBox(this.lsse, "Error!", "No Array selected to load data into.", MessageBox.MB_OK);
                return;
            }
            FileDialog fileDialog = new FileDialog((Frame)this.lsse, "Select data file", 0);
            fileDialog.setFilenameFilter(this.lsse);
            fileDialog.setFile("*.*");
            fileDialog.show();
            if (fileDialog.getFile() == null) {
                return;
            }
            StringTokenizer stringTokenizer = null;
            try {
                File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
                byte[] byArray = new byte[(int)file.length()];
                new FileInputStream(file).read(byArray);
                stringTokenizer = new StringTokenizer(new String(byArray));
            }
            catch (IOException iOException) {
                return;
            }
            this.aData[n2] = new int[stringTokenizer.countTokens()];
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                this.aData[n2][n++] = n3;
            }
            this.SelectArray(n2, 0);
            this.butApply.setEnabled(true);
            return;
        }
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("OK") || actionEvent.getActionCommand().equals("Apply Changes")) {
            Vector<Object[]> vector = new Vector<Object[]>();
            n2 = 0;
            while (n2 < this.aNumbers.length) {
                Object[] objectArray = new Object[]{new Integer(this.aNumbers[n2]), this.aData[n2++]};
                vector.add(objectArray);
            }
            this.lsse.CAEArrays = vector;
            this.butApply.setEnabled(false);
            if (actionEvent.getActionCommand().equals("OK")) {
                this.hide();
                this.dispose();
            }
            return;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.hide();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

