/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class ArrowButton
extends Button
implements MouseListener {
    private boolean bButtonDown = false;
    private int[] xPoints = new int[3];
    private int[] yPoints = new int[3];
    private int width;
    private int height;
    private boolean bUp;

    public ArrowButton(boolean bl) {
        this.bUp = bl;
        this.addMouseListener(this);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
        super.setBounds(n, n2, n3, n4);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.xPoints[0] = this.width / 4 + (this.bButtonDown ? 0 : -1);
        this.xPoints[1] = this.width - this.width / 4 - (this.bButtonDown ? 0 : 1);
        this.xPoints[2] = this.width / 2 - (this.bButtonDown ? 0 : 1);
        this.yPoints[0] = (this.bUp ? 5 : 3) * this.height / 8 + (this.bButtonDown ? 1 : 0);
        this.yPoints[1] = this.yPoints[0];
        this.yPoints[2] = (this.bUp ? 2 : 5) * this.height / 8 + (this.bButtonDown ? 1 : 0);
        graphics.fillPolygon(this.xPoints, this.yPoints, 3);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.bButtonDown = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.bButtonDown = false;
    }
}

