/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class DeployMapEditorDialog
extends Dialog
implements WindowListener,
ActionListener {
    private LaserSquadScenarioEditor lsse;
    private TeamEditor parent;
    private TerrainDisplay td;
    protected boolean[] bDeploymentMap;
    protected int iTeam;

    public DeployMapEditorDialog(LaserSquadScenarioEditor laserSquadScenarioEditor, TeamEditor teamEditor, int n) {
        super(laserSquadScenarioEditor, "Select Deployment Squares", true);
        this.lsse = laserSquadScenarioEditor;
        this.parent = teamEditor;
        this.iTeam = n;
        this.bDeploymentMap = new boolean[laserSquadScenarioEditor.DeploymentMap.length];
        int n2 = 1 << n;
        for (int i = 0; i < this.bDeploymentMap.length; ++i) {
            this.bDeploymentMap[i] = (laserSquadScenarioEditor.DeploymentMap[i] & n2) == n2;
        }
        this.addWindowListener(this);
        this.setBounds(laserSquadScenarioEditor.getInsets().left + laserSquadScenarioEditor.getX(), laserSquadScenarioEditor.getInsets().top + laserSquadScenarioEditor.getY(), 480, 480);
        this.td = new TerrainDisplay(laserSquadScenarioEditor, this);
        this.add("Center", this.td);
        Panel panel = new Panel();
        Button button = new Button("OK");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Cancel");
        button.addActionListener(this);
        panel.add(button);
        this.add("South", panel);
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("OK")) {
            int n = 1 << this.iTeam;
            for (int i = 0; i < this.bDeploymentMap.length; ++i) {
                int n2 = i;
                this.lsse.DeploymentMap[n2] = this.lsse.DeploymentMap[n2] - (this.lsse.DeploymentMap[i] & n);
                if (!this.bDeploymentMap[i]) continue;
                int n3 = i;
                this.lsse.DeploymentMap[n3] = this.lsse.DeploymentMap[n3] + n;
            }
            this.hide();
            this.dispose();
            return;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.hide();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

