/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

class EditorUnit
implements DisplayDetails {
    String name;
    LaserSquadScenarioEditor lsse;
    int UnitType;
    int[] MorraleValue;
    int[] VictoryPoint;
    int TerrainMovementBand;
    int TeamNumber;
    int Strength;
    int Agility;
    int WeaponSkill;
    int CloseCombatDamage;
    int Toughness;
    int Size;
    int MaxSizeCanCarry;
    int Fatigue;
    int CurrentActionPoints;
    int MaxActionPoints;
    int CurrentConstitution;
    int MaxConstitution;
    int CurrentStamina;
    int MaxStamina;
    int CurrentMorrale;
    int MaxMorrale;
    int ArmourFront;
    int ArmourRight;
    int ArmourRear;
    int ArmourLeft;
    int ArmourWeight;
    int StartRound;
    int DifficultyLevelsAllowedOn;
    int StartY;
    int StartX;
    int StartDY;
    int StartDX;
    int Flags;
    int UserDefinedFlags;
    int InitialPatrolNode;
    int[] PatrolNodes = null;
    int[] RegionThreatValue = null;
    int MinAimedRange;
    int MinSnapRange;
    int[] TargetTerrainsClosestNodes = null;
    Point[] TargetTerrainsPositions = null;
    CauseAndEffect DeathEffects = null;
    EditorItem[] ItemsHeld = null;
    EditorItem ItemHeld = null;
    int Headding = 4;

    public EditorUnit(LaserSquadScenarioEditor laserSquadScenarioEditor) {
        this.lsse = laserSquadScenarioEditor;
    }

    public EditorUnit(EditorUnit editorUnit) {
        int n;
        this.name = new String(editorUnit.name);
        this.lsse = editorUnit.lsse;
        this.UnitType = editorUnit.UnitType;
        this.MorraleValue = new int[editorUnit.MorraleValue.length];
        System.arraycopy(editorUnit.MorraleValue, 0, this.MorraleValue, 0, this.MorraleValue.length);
        this.VictoryPoint = new int[editorUnit.VictoryPoint.length];
        System.arraycopy(editorUnit.VictoryPoint, 0, this.VictoryPoint, 0, this.VictoryPoint.length);
        this.TerrainMovementBand = editorUnit.TerrainMovementBand;
        this.TeamNumber = editorUnit.TeamNumber;
        this.Strength = editorUnit.Strength;
        this.Agility = editorUnit.Agility;
        this.WeaponSkill = editorUnit.WeaponSkill;
        this.CloseCombatDamage = editorUnit.CloseCombatDamage;
        this.Toughness = editorUnit.Toughness;
        this.Size = editorUnit.Size;
        this.MaxSizeCanCarry = editorUnit.MaxSizeCanCarry;
        this.Fatigue = editorUnit.Fatigue;
        this.CurrentActionPoints = editorUnit.CurrentActionPoints;
        this.MaxActionPoints = editorUnit.MaxActionPoints;
        this.CurrentConstitution = editorUnit.CurrentConstitution;
        this.MaxConstitution = editorUnit.MaxConstitution;
        this.CurrentStamina = editorUnit.CurrentStamina;
        this.MaxStamina = editorUnit.MaxStamina;
        this.CurrentMorrale = editorUnit.CurrentMorrale;
        this.MaxMorrale = editorUnit.MaxMorrale;
        this.ArmourFront = editorUnit.ArmourFront;
        this.ArmourRight = editorUnit.ArmourRight;
        this.ArmourRear = editorUnit.ArmourRear;
        this.ArmourLeft = editorUnit.ArmourLeft;
        this.ArmourWeight = editorUnit.ArmourWeight;
        this.StartRound = editorUnit.StartRound;
        this.DifficultyLevelsAllowedOn = editorUnit.DifficultyLevelsAllowedOn;
        this.StartY = editorUnit.StartY;
        this.StartX = editorUnit.StartX;
        this.StartDY = editorUnit.StartDY;
        this.StartDX = editorUnit.StartDX;
        this.Flags = editorUnit.Flags;
        this.UserDefinedFlags = editorUnit.UserDefinedFlags;
        this.InitialPatrolNode = editorUnit.InitialPatrolNode;
        if (editorUnit.PatrolNodes != null) {
            this.PatrolNodes = new int[editorUnit.PatrolNodes.length];
            System.arraycopy(editorUnit.PatrolNodes, 0, this.PatrolNodes, 0, this.PatrolNodes.length);
        }
        if (editorUnit.RegionThreatValue != null) {
            this.RegionThreatValue = new int[editorUnit.RegionThreatValue.length];
            System.arraycopy(editorUnit.RegionThreatValue, 0, this.RegionThreatValue, 0, this.RegionThreatValue.length);
        }
        this.MinAimedRange = editorUnit.MinAimedRange;
        this.MinSnapRange = editorUnit.MinSnapRange;
        if (editorUnit.TargetTerrainsClosestNodes != null) {
            this.TargetTerrainsClosestNodes = new int[editorUnit.TargetTerrainsClosestNodes.length];
            System.arraycopy(editorUnit.TargetTerrainsClosestNodes, 0, this.TargetTerrainsClosestNodes, 0, this.TargetTerrainsClosestNodes.length);
            this.TargetTerrainsPositions = new Point[this.TargetTerrainsClosestNodes.length];
            for (n = 0; n < this.TargetTerrainsPositions.length; ++n) {
                this.TargetTerrainsPositions[n] = new Point(editorUnit.TargetTerrainsPositions[n]);
            }
        }
        this.DeathEffects = new CauseAndEffect(editorUnit.DeathEffects);
        if (editorUnit.ItemsHeld != null) {
            this.ItemsHeld = new EditorItem[editorUnit.ItemsHeld.length];
            for (n = 0; n < this.ItemsHeld.length; ++n) {
                this.ItemsHeld[n] = new EditorItem(editorUnit.ItemsHeld[n]);
                if (editorUnit.ItemHeld != editorUnit.ItemsHeld[n]) continue;
                this.ItemHeld = this.ItemsHeld[n];
            }
        }
        this.Headding = editorUnit.Headding;
    }

    public static EditorUnit read(DataInputStream dataInputStream, LaserSquadScenarioEditor laserSquadScenarioEditor) throws IOException {
        EditorUnit editorUnit = new EditorUnit(laserSquadScenarioEditor);
        editorUnit.name = dataInputStream.readUTF();
        editorUnit.UnitType = dataInputStream.readInt();
        editorUnit.MorraleValue = ScenarioEditorUtility.ReadArray(dataInputStream);
        editorUnit.VictoryPoint = ScenarioEditorUtility.ReadArray(dataInputStream);
        editorUnit.TerrainMovementBand = dataInputStream.readInt();
        editorUnit.TeamNumber = dataInputStream.readInt();
        editorUnit.Strength = dataInputStream.readInt();
        editorUnit.Agility = dataInputStream.readInt();
        editorUnit.WeaponSkill = dataInputStream.readInt();
        editorUnit.CloseCombatDamage = dataInputStream.readInt();
        editorUnit.Toughness = dataInputStream.readInt();
        editorUnit.Size = dataInputStream.readInt();
        editorUnit.MaxSizeCanCarry = dataInputStream.readInt();
        editorUnit.Fatigue = dataInputStream.readInt();
        editorUnit.CurrentActionPoints = dataInputStream.readInt();
        editorUnit.MaxActionPoints = dataInputStream.readInt();
        editorUnit.CurrentConstitution = dataInputStream.readInt();
        editorUnit.MaxConstitution = dataInputStream.readInt();
        editorUnit.CurrentStamina = dataInputStream.readInt();
        editorUnit.MaxStamina = dataInputStream.readInt();
        editorUnit.CurrentMorrale = dataInputStream.readInt();
        editorUnit.MaxMorrale = dataInputStream.readInt();
        editorUnit.ArmourFront = dataInputStream.readInt();
        editorUnit.ArmourRight = dataInputStream.readInt();
        editorUnit.ArmourRear = dataInputStream.readInt();
        editorUnit.ArmourLeft = dataInputStream.readInt();
        editorUnit.ArmourWeight = dataInputStream.readInt();
        editorUnit.StartRound = dataInputStream.readInt();
        editorUnit.DifficultyLevelsAllowedOn = dataInputStream.readInt();
        editorUnit.StartY = dataInputStream.readInt();
        editorUnit.StartX = dataInputStream.readInt();
        editorUnit.StartDY = dataInputStream.readInt();
        editorUnit.StartDX = dataInputStream.readInt();
        editorUnit.Flags = dataInputStream.readInt();
        editorUnit.UserDefinedFlags = dataInputStream.readInt();
        editorUnit.InitialPatrolNode = dataInputStream.readInt();
        editorUnit.PatrolNodes = ScenarioEditorUtility.ReadArray(dataInputStream);
        editorUnit.RegionThreatValue = ScenarioEditorUtility.ReadArray(dataInputStream);
        editorUnit.MinAimedRange = dataInputStream.readInt();
        editorUnit.MinSnapRange = dataInputStream.readInt();
        editorUnit.TargetTerrainsClosestNodes = ScenarioEditorUtility.ReadArray(dataInputStream);
        int n = dataInputStream.readInt();
        if (n != 0) {
            editorUnit.TargetTerrainsPositions = new Point[n];
            for (n = 0; n < editorUnit.TargetTerrainsPositions.length; ++n) {
                editorUnit.TargetTerrainsPositions[n] = new Point(dataInputStream.readInt(), dataInputStream.readInt());
            }
        }
        editorUnit.DeathEffects = CauseAndEffect.read(dataInputStream, laserSquadScenarioEditor);
        n = dataInputStream.readInt();
        if (n != 0) {
            editorUnit.ItemsHeld = new EditorItem[n];
            for (n = 0; n < editorUnit.ItemsHeld.length; ++n) {
                editorUnit.ItemsHeld[n] = EditorItem.read(dataInputStream);
                editorUnit.ItemsHeld[n].Owner = editorUnit;
                if (!dataInputStream.readBoolean()) continue;
                editorUnit.ItemHeld = editorUnit.ItemsHeld[n];
            }
        }
        editorUnit.Headding = dataInputStream.readInt();
        return editorUnit;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeInt(this.UnitType);
        ScenarioEditorUtility.WriteArray(dataOutputStream, this.MorraleValue);
        ScenarioEditorUtility.WriteArray(dataOutputStream, this.VictoryPoint);
        dataOutputStream.writeInt(this.TerrainMovementBand);
        dataOutputStream.writeInt(this.TeamNumber);
        dataOutputStream.writeInt(this.Strength);
        dataOutputStream.writeInt(this.Agility);
        dataOutputStream.writeInt(this.WeaponSkill);
        dataOutputStream.writeInt(this.CloseCombatDamage);
        dataOutputStream.writeInt(this.Toughness);
        dataOutputStream.writeInt(this.Size);
        dataOutputStream.writeInt(this.MaxSizeCanCarry);
        dataOutputStream.writeInt(this.Fatigue);
        dataOutputStream.writeInt(this.CurrentActionPoints);
        dataOutputStream.writeInt(this.MaxActionPoints);
        dataOutputStream.writeInt(this.CurrentConstitution);
        dataOutputStream.writeInt(this.MaxConstitution);
        dataOutputStream.writeInt(this.CurrentStamina);
        dataOutputStream.writeInt(this.MaxStamina);
        dataOutputStream.writeInt(this.CurrentMorrale);
        dataOutputStream.writeInt(this.MaxMorrale);
        dataOutputStream.writeInt(this.ArmourFront);
        dataOutputStream.writeInt(this.ArmourRight);
        dataOutputStream.writeInt(this.ArmourRear);
        dataOutputStream.writeInt(this.ArmourLeft);
        dataOutputStream.writeInt(this.ArmourWeight);
        dataOutputStream.writeInt(this.StartRound);
        dataOutputStream.writeInt(this.DifficultyLevelsAllowedOn);
        dataOutputStream.writeInt(this.StartY);
        dataOutputStream.writeInt(this.StartX);
        dataOutputStream.writeInt(this.StartDY);
        dataOutputStream.writeInt(this.StartDX);
        dataOutputStream.writeInt(this.Flags);
        dataOutputStream.writeInt(this.UserDefinedFlags);
        dataOutputStream.writeInt(this.InitialPatrolNode);
        ScenarioEditorUtility.WriteArray(dataOutputStream, this.PatrolNodes);
        ScenarioEditorUtility.WriteArray(dataOutputStream, this.RegionThreatValue);
        dataOutputStream.writeInt(this.MinAimedRange);
        dataOutputStream.writeInt(this.MinSnapRange);
        ScenarioEditorUtility.WriteArray(dataOutputStream, this.TargetTerrainsClosestNodes);
        dataOutputStream.writeInt(this.TargetTerrainsPositions == null ? 0 : this.TargetTerrainsPositions.length);
        if (this.TargetTerrainsPositions != null) {
            for (n = 0; n < this.TargetTerrainsPositions.length; ++n) {
                dataOutputStream.writeInt(this.TargetTerrainsPositions[n].x);
                dataOutputStream.writeInt(this.TargetTerrainsPositions[n].y);
            }
        }
        this.DeathEffects.write(dataOutputStream);
        dataOutputStream.writeInt(this.ItemsHeld == null ? 0 : this.ItemsHeld.length);
        if (this.ItemsHeld != null) {
            for (n = 0; n < this.ItemsHeld.length; ++n) {
                this.ItemsHeld[n].write(dataOutputStream);
                dataOutputStream.writeBoolean(this.ItemsHeld[n] == this.ItemHeld);
            }
        }
        dataOutputStream.writeInt(this.Headding);
    }

    public void CheckDeploy(int n, int n2) {
        switch (n) {
            case 0: {
                if (this.StartY >= n2) {
                    ++this.StartY;
                    break;
                }
                if (this.StartY + this.StartDY <= n2) break;
                ++this.StartDY;
                break;
            }
            case 1: {
                if (this.StartX >= n2) {
                    ++this.StartX;
                    break;
                }
                if (this.StartX + this.StartDX <= n2) break;
                ++this.StartDX;
                break;
            }
            case 2: {
                if (this.StartY > n2) {
                    --this.StartY;
                } else if (this.StartY + this.StartDY > n2 && this.StartDY != 1) {
                    --this.StartDY;
                }
                if (this.StartY + this.StartDY < this.lsse.MapHeight) break;
                --this.StartY;
                break;
            }
            case 3: {
                if (this.StartX > n2) {
                    --this.StartX;
                } else if (this.StartX + this.StartDX > n2 && this.StartDX != 1) {
                    --this.StartDX;
                }
                if (this.StartX + this.StartDX < this.lsse.MapWidth) break;
                --this.StartX;
            }
        }
    }

    public void CheckPatrolRoute(int n) {
        if (this.PatrolNodes == null) {
            return;
        }
        int n2 = ScenarioEditorUtility.arrayPos(this.PatrolNodes, n);
        if (n2 == -1) {
            return;
        }
        if (this.InitialPatrolNode >= n2 && this.InitialPatrolNode != 0) {
            --this.InitialPatrolNode;
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.PatrolNodes.length; ++n2) {
            if (this.PatrolNodes[n2] == n) continue;
            ++n3;
        }
        if (n3 > 0) {
            int[] nArray = new int[n3];
            n3 = 0;
            for (n2 = 0; n2 < this.PatrolNodes.length; ++n2) {
                if (this.PatrolNodes[n2] == n) continue;
                nArray[n3++] = this.PatrolNodes[n2] > n ? this.PatrolNodes[n2] - 1 : this.PatrolNodes[n2];
            }
            this.PatrolNodes = nArray;
        } else {
            this.PatrolNodes = null;
        }
    }

    public void AdjustRegions(int n) {
        if (n == -1) {
            this.RegionThreatValue = this.RegionThreatValue == null ? new int[1] : ScenarioEditorUtility.arrayAdd(this.RegionThreatValue, 0);
            return;
        }
        if (this.RegionThreatValue == null) {
            return;
        }
        this.RegionThreatValue = (int[])(this.RegionThreatValue.length == 1 ? null : ScenarioEditorUtility.arrayDeleteElementAt(this.RegionThreatValue, n));
    }

    public void GetTargetTerrains(int n, int[][] nArray) {
        if (this.TeamNumber != n || this.TargetTerrainsClosestNodes == null) {
            return;
        }
        for (int i = 0; i < this.TargetTerrainsClosestNodes.length; ++i) {
            ScenarioEditorUtility.AddTarget(nArray, this.TargetTerrainsClosestNodes[i], this.TargetTerrainsPositions[i]);
        }
    }

    public void DisplayDetails(Graphics graphics, int n, int n2, Vector vector) {
        int n3 = this.lsse.GenericUnits[this.UnitType].GetProfile(this.ItemHeld);
        graphics.drawImage(this.lsse.GenericUnits[this.UnitType].UnitPics[n3][4], n, n2, null);
        graphics.drawImage(this.lsse.GenericUnits[this.UnitType].UnitPics[n3][12], n + 33, n2, null);
        StringTokenizer stringTokenizer = new StringTokenizer(this.name, "//", false);
        n2 += 13;
        while (stringTokenizer.hasMoreTokens()) {
            graphics.drawString(stringTokenizer.nextToken(), n + 68, n2);
            n2 += 16;
        }
    }

    public void DisplayImage(Graphics graphics, int n, int n2, Vector vector, boolean bl) {
        graphics.drawImage(this.lsse.GenericUnits[this.UnitType].UnitPics[this.lsse.GenericUnits[this.UnitType].GetProfile(this.ItemHeld)][bl ? 12 : 4], n, n2, null);
    }
}

