/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Arrays;
import java.util.StringTokenizer;

class GenericUnitEditor
extends Panel
implements ActionListener,
TextListener,
MouseListener,
AdjustmentListener {
    private LaserSquadScenarioEditor lsse;
    private UnitSelector us;
    private int GUEWidth = -1;
    private int GUEHeight = -1;
    private Image GUEImage = null;
    private Graphics GUEGraph;
    private Button butAdd;
    private Button butCopy;
    private Button butRemove;
    private Button butAnim;
    private Button butAddPic;
    private Button butDelPic;
    private TextArea uName;
    private AnimationPanel ap;
    private Scrollbar sb;
    private PullDown[] ipds = null;
    private Button[] ipbs = null;
    private int iPictureToChange;
    private int iMoveItemTo;
    protected int iSelected = 0;
    private static final String[] sDirectionsNames = new String[]{"North", "NorthEast", "East", "SouthEast", "South", "SouthWest", "West", "NorthWest"};

    public GenericUnitEditor(LaserSquadScenarioEditor laserSquadScenarioEditor) {
        this.lsse = laserSquadScenarioEditor;
        this.us = new UnitSelector(this.lsse, this, 0, 0);
        this.add(this.us);
        this.butAdd = new Button("Add New Generic Unit");
        this.butAdd.addActionListener(this);
        this.add(this.butAdd);
        this.butCopy = new Button("Copy Generic Unit");
        this.butCopy.addActionListener(this);
        this.add(this.butCopy);
        this.butRemove = new Button("Remove Generic Unit");
        this.butRemove.addActionListener(this);
        this.add(this.butRemove);
        this.uName = new TextArea("", 2, 8, 3);
        this.uName.setFont(LaserSquadScenarioEditor.font);
        this.uName.addTextListener(this);
        this.add(this.uName);
        Image[] imageArray = new Image[]{(Image)this.lsse.ImagePool.elementAt(0)};
        this.ap = new AnimationPanel(imageArray, null);
        this.add(this.ap);
        this.butAnim = new Button("Change Animation");
        this.butAnim.addActionListener(this);
        this.add(this.butAnim);
        this.butAddPic = new Button("Add New Profile");
        this.butAddPic.addActionListener(this);
        this.add(this.butAddPic);
        this.butDelPic = new Button("Remove Profile");
        this.butDelPic.addActionListener(this);
        this.add(this.butDelPic);
        this.sb = new Scrollbar(1, 0, 1, 0, 0);
        this.sb.addAdjustmentListener(this);
        this.add(this.sb);
        this.addMouseListener(this);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.GUEWidth || n4 != this.GUEHeight) {
            this.GUEWidth = n3;
            this.GUEHeight = n4;
            this.GUEImage = this.createImage(n3 - 176, n4);
            this.GUEGraph = this.GUEImage.getGraphics();
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void reset() {
        if (this.ipds != null) {
            for (int i = 0; i < this.ipds.length && this.ipds[i] != null; ++i) {
                this.remove(this.ipds[i]);
                this.remove(this.ipbs[i]);
            }
        }
        this.us.reset();
        this.RepaintOffScreenImage();
        this.repaint();
    }

    private void RepaintOffScreenImage() {
        int n;
        EditorGenericUnit editorGenericUnit = this.lsse.GenericUnits[this.us.GetPointer()];
        if (this.GUEGraph == null) {
            return;
        }
        this.GUEGraph.setColor(new Color(240, 240, 240));
        this.GUEGraph.fillRect(0, 0, this.GUEWidth, this.GUEHeight);
        this.GUEGraph.setColor(Color.BLACK);
        this.GUEGraph.setFont(LaserSquadScenarioEditor.font);
        this.GUEGraph.drawString("Generic", 5, 14);
        this.GUEGraph.drawString("Unit Name:", 5, 30);
        StringTokenizer stringTokenizer = new StringTokenizer(editorGenericUnit.name, "//", false);
        String string = new String((stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "") + (editorGenericUnit.name.indexOf("//") != -1 ? "\r\n" : "") + (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : ""));
        this.uName.setText(string);
        this.GUEGraph.drawString("Becomes if", 210, 14);
        this.GUEGraph.drawString("killed:", 210, 30);
        this.GUEGraph.drawRect(319, 0, 150, 33);
        int n2 = editorGenericUnit.GenericItemNumberOfCorpse;
        if (n2 != -1) {
            this.lsse.GenericItems[n2].DisplayDetails(this.GUEGraph, 320, 1, null);
        }
        this.GUEGraph.drawString("Death", 5, 59);
        this.GUEGraph.drawString("Annimation:", 5, 75);
        Image[] imageArray = new Image[editorGenericUnit.DeathPics == null ? 2 : editorGenericUnit.DeathPics.length + 2];
        imageArray[0] = editorGenericUnit.UnitPics[0][4];
        if (editorGenericUnit.DeathPics != null) {
            System.arraycopy(editorGenericUnit.DeathPics, 0, imageArray, 1, editorGenericUnit.DeathPics.length);
        }
        imageArray[imageArray.length - 1] = editorGenericUnit.GenericItemNumberOfCorpse == -1 ? (Image)this.lsse.ImagePool.elementAt(0) : this.lsse.GenericItems[editorGenericUnit.GenericItemNumberOfCorpse].MapPic;
        int[] nArray = new int[imageArray.length];
        Arrays.fill(nArray, 12);
        nArray[0] = 100;
        nArray[nArray.length - 1] = 200;
        this.ap.reset(imageArray, nArray);
        this.GUEGraph.drawString("Profile Images:", 10, 110);
        this.GUEGraph.drawString("Profile Items:", 275, 110);
        n2 = this.GUEHeight - 120;
        n2 -= 2;
        this.sb.setBlockIncrement(n2 /= 67);
        this.sb.setMaximum(editorGenericUnit.UnitPics.length);
        this.sb.setVisibleAmount(n2);
        this.GUEGraph.drawRect(5, 120, 473, 3 + 67 * n2);
        if (this.ipds != null) {
            for (n = 0; n < this.ipds.length && this.ipds[n] != null; ++n) {
                this.remove(this.ipds[n]);
                this.remove(this.ipbs[n]);
            }
        }
        this.ipds = new PullDown[n2];
        this.ipbs = new Button[n2];
        for (n = 0; n < n2; ++n) {
            this.ipds[n] = null;
            this.ipbs[n] = null;
        }
        int n3 = this.sb.getValue();
        for (n = 0; n < n2; ++n) {
            int n4;
            if (n >= editorGenericUnit.UnitPics.length) continue;
            this.GUEGraph.setColor((n + n3 & 1) == 0 ? Color.WHITE : Color.CYAN);
            this.GUEGraph.fillRect(6, n * 67 + 121, 471, 67);
            for (n4 = 0; n4 < 8; ++n4) {
                this.GUEGraph.drawImage(editorGenericUnit.UnitPics[n + n3][n4], n4 * 33 + 7, n * 67 + 122, null);
            }
            for (n4 = 0; n4 < 8; ++n4) {
                this.GUEGraph.drawImage(editorGenericUnit.UnitPics[n + n3][n4 + 8], n4 * 33 + 7, n * 67 + 122 + 33, null);
            }
            this.ipds[n] = new PullDown(this.lsse, this, editorGenericUnit.Items[n + n3], 0);
            this.add(this.ipds[n]);
            this.ipbs[n] = new Button("Add Item to Profile");
            this.ipbs[n].addActionListener(this);
            this.add(this.ipbs[n]);
            if (this.iSelected != n + n3) continue;
            this.GUEGraph.setColor(Color.RED);
            this.GUEGraph.drawRect(6, n * 67 + 121, 455, 66);
        }
    }

    public void paint(Graphics graphics) {
        int n = this.us.GetPointer();
        int n2 = this.GUEHeight;
        this.butAdd.setBounds(this.GUEWidth - 176, 3, 170, 25);
        this.butCopy.setBounds(this.GUEWidth - 176, 31, 170, 25);
        this.butRemove.setBounds(this.GUEWidth - 176, 59, 170, 25);
        n2 -= 87;
        this.us.setBounds(this.GUEWidth - 176, 87, 174, (n2 /= 34) * 34);
        this.GUEGraph.setColor(new Color(240, 240, 240));
        this.GUEGraph.drawLine(0, 0, 0, 1);
        graphics.drawImage(this.GUEImage, 0, 0, null);
        this.uName.setBounds(105, 1, 90, 41);
        this.ap.setBounds(120, 48, 32, 32);
        this.butAnim.setBounds(165, 49, 170, 30);
        if (this.ipds != null) {
            for (int i = 0; i < this.ipds.length && this.ipds[i] != null; ++i) {
                this.ipds[i].setBounds(275, i * 67 + 122 + 5, 182, 34);
                this.ipbs[i].setBounds(275, i * 67 + 122 + 40, 182, 20);
            }
        }
        this.sb.setBounds(462, 121, 16, 2 + 67 * this.ipds.length);
        this.butAddPic.setBounds(488, 120, 120, 30);
        this.butDelPic.setBounds(488, 155, 120, 30);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void NotifyCorpseChange(int n) {
        this.lsse.GenericUnits[this.us.GetPointer()].GenericItemNumberOfCorpse = n;
        this.us.RepaintOffScreenImage();
        this.us.repaint();
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void NotifyClick() {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void SelectChangeNotify(PullDown pullDown) {
        for (int i = 0; i < this.ipds.length; ++i) {
            if (this.ipds[i] != pullDown) continue;
            this.iSelected = i + this.sb.getValue();
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
    }

    protected void ChangeDeathAnnimation(Image[] imageArray, int[] nArray) {
        int n = this.us.GetPointer();
        if (imageArray.length == 2) {
            this.lsse.GenericUnits[n].DeathPics = null;
        } else {
            this.lsse.GenericUnits[n].DeathPics = new Image[imageArray.length - 2];
            System.arraycopy(imageArray, 1, this.lsse.GenericUnits[n].DeathPics, 0, imageArray.length - 2);
        }
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void NotifyItemMove(int n) {
        int n2 = this.us.GetPointer();
        for (int i = 0; i < this.lsse.GenericUnits[n2].Items.length; ++i) {
            this.lsse.GenericUnits[n2].Items[i] = ScenarioEditorUtility.arrayDeleteItem(this.lsse.GenericUnits[n2].Items[i], n);
        }
        this.lsse.GenericUnits[n2].Items[this.iMoveItemTo] = ScenarioEditorUtility.arrayAdd(this.lsse.GenericUnits[n2].Items[this.iMoveItemTo], n);
        Arrays.sort(this.lsse.GenericUnits[n2].Items[this.iMoveItemTo]);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.us.GetPointer();
        if (actionEvent.getSource() == this.butAnim) {
            Image[] imageArray = new Image[this.lsse.GenericUnits[n].DeathPics == null ? 2 : this.lsse.GenericUnits[n].DeathPics.length + 2];
            imageArray[0] = this.lsse.GenericUnits[n].UnitPics[0][4];
            if (this.lsse.GenericUnits[n].DeathPics != null) {
                System.arraycopy(this.lsse.GenericUnits[n].DeathPics, 0, imageArray, 1, this.lsse.GenericUnits[n].DeathPics.length);
            }
            imageArray[imageArray.length - 1] = this.lsse.GenericUnits[n].GenericItemNumberOfCorpse == -1 ? (Image)this.lsse.ImagePool.elementAt(0) : this.lsse.GenericItems[this.lsse.GenericUnits[n].GenericItemNumberOfCorpse].MapPic;
            int[] nArray = new int[imageArray.length];
            Arrays.fill(nArray, 12);
            nArray[0] = 100;
            nArray[nArray.length - 1] = 200;
            new AnnimationEditor(this.lsse, this, 3, "Death Animation", imageArray, nArray);
            return;
        }
        if (actionEvent.getSource() == this.butAddPic) {
            Image[][] imageArray = new Image[this.lsse.GenericUnits[n].UnitPics.length + 1][16];
            System.arraycopy(this.lsse.GenericUnits[n].UnitPics, 0, imageArray, 0, this.lsse.GenericUnits[n].UnitPics.length);
            for (int i = 0; i < 16; ++i) {
                imageArray[imageArray.length - 1][i] = (Image)this.lsse.ImagePool.elementAt(0);
            }
            this.lsse.GenericUnits[n].UnitPics = imageArray;
            int[][] nArrayArray = new int[this.lsse.GenericUnits[n].Items.length + 1][];
            System.arraycopy(this.lsse.GenericUnits[n].Items, 0, nArrayArray, 0, this.lsse.GenericUnits[n].Items.length);
            nArrayArray[nArrayArray.length - 1] = new int[0];
            this.lsse.GenericUnits[n].Items = nArrayArray;
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butDelPic && this.lsse.GenericUnits[n].UnitPics.length > 1) {
            int n2 = this.iSelected == 0 ? 1 : 0;
            int[] nArray = new int[this.lsse.GenericUnits[n].Items[n2].length + this.lsse.GenericUnits[n].Items[this.iSelected].length];
            System.arraycopy(this.lsse.GenericUnits[n].Items[n2], 0, nArray, 0, this.lsse.GenericUnits[n].Items[n2].length);
            System.arraycopy(this.lsse.GenericUnits[n].Items[this.iSelected], 0, nArray, this.lsse.GenericUnits[n].Items[n2].length, this.lsse.GenericUnits[n].Items[this.iSelected].length);
            Arrays.sort(nArray);
            this.lsse.GenericUnits[n].Items[n2] = nArray;
            int[][] nArrayArray = new int[this.lsse.GenericUnits[n].Items.length - 1][];
            if (this.iSelected != 0) {
                System.arraycopy(this.lsse.GenericUnits[n].Items, 0, nArrayArray, 0, this.iSelected);
            }
            if (this.iSelected != nArrayArray.length) {
                System.arraycopy(this.lsse.GenericUnits[n].Items, this.iSelected + 1, nArrayArray, this.iSelected, nArrayArray.length - this.iSelected);
            }
            this.lsse.GenericUnits[n].Items = nArrayArray;
            Image[][] imageArrayArray = new Image[this.lsse.GenericUnits[n].UnitPics.length - 1][];
            if (this.iSelected != 0) {
                System.arraycopy(this.lsse.GenericUnits[n].UnitPics, 0, imageArrayArray, 0, this.iSelected);
            }
            if (this.iSelected != imageArrayArray.length) {
                System.arraycopy(this.lsse.GenericUnits[n].UnitPics, this.iSelected + 1, imageArrayArray, this.iSelected, imageArrayArray.length - this.iSelected);
            }
            this.lsse.GenericUnits[n].UnitPics = imageArrayArray;
            if (this.iSelected >= this.lsse.GenericUnits[n].UnitPics.length) {
                --this.iSelected;
            }
            this.us.RepaintOffScreenImage();
            this.us.repaint();
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butAdd) {
            int n3;
            EditorGenericUnit[] editorGenericUnitArray = new EditorGenericUnit[this.lsse.GenericUnits.length + 1];
            System.arraycopy(this.lsse.GenericUnits, 0, editorGenericUnitArray, 0, editorGenericUnitArray.length - 1);
            editorGenericUnitArray[editorGenericUnitArray.length - 1] = new EditorGenericUnit(this.lsse);
            editorGenericUnitArray[editorGenericUnitArray.length - 1].name = new String("UNKNOWN");
            editorGenericUnitArray[editorGenericUnitArray.length - 1].DeathPics = null;
            editorGenericUnitArray[editorGenericUnitArray.length - 1].GenericItemNumberOfCorpse = -1;
            editorGenericUnitArray[editorGenericUnitArray.length - 1].UnitPics = new Image[1][16];
            for (n3 = 0; n3 < 16; ++n3) {
                editorGenericUnitArray[editorGenericUnitArray.length - 1].UnitPics[0][n3] = (Image)this.lsse.ImagePool.elementAt(0);
            }
            editorGenericUnitArray[editorGenericUnitArray.length - 1].Items = new int[1][this.lsse.GenericItems.length];
            for (n3 = 0; n3 < this.lsse.GenericItems.length; ++n3) {
                editorGenericUnitArray[editorGenericUnitArray.length - 1].Items[0][n3] = n3;
            }
            this.lsse.GenericUnits = editorGenericUnitArray;
            this.us.RecheckPointer();
            this.us.RepaintOffScreenImage();
            this.us.repaint();
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butCopy) {
            EditorGenericUnit[] editorGenericUnitArray = new EditorGenericUnit[this.lsse.GenericUnits.length + 1];
            System.arraycopy(this.lsse.GenericUnits, 0, editorGenericUnitArray, 0, editorGenericUnitArray.length - 1);
            editorGenericUnitArray[editorGenericUnitArray.length - 1] = new EditorGenericUnit(this.lsse.GenericUnits[n]);
            this.lsse.GenericUnits = editorGenericUnitArray;
            this.us.RecheckPointer();
            this.us.RepaintOffScreenImage();
            this.us.repaint();
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butRemove && this.lsse.GenericUnits.length > 1) {
            EditorGenericUnit[] editorGenericUnitArray = new EditorGenericUnit[this.lsse.GenericUnits.length - 1];
            if (n != 0) {
                System.arraycopy(this.lsse.GenericUnits, 0, editorGenericUnitArray, 0, n);
            }
            if (n != editorGenericUnitArray.length) {
                System.arraycopy(this.lsse.GenericUnits, n + 1, editorGenericUnitArray, n, editorGenericUnitArray.length - n);
            }
            this.lsse.GenericUnits = editorGenericUnitArray;
            if (this.lsse.Units.length > 0) {
                for (int i = 0; i < this.lsse.Units.length; ++i) {
                    if (this.lsse.Units[i].UnitType == n) {
                        this.lsse.Units[i].UnitType = 0;
                    }
                    if (this.lsse.Units[i].UnitType <= n) continue;
                    --this.lsse.Units[i].UnitType;
                }
            }
            this.lsse.CheckCAEChange(2, n);
            this.us.RecheckPointer();
            this.us.RepaintOffScreenImage();
            this.us.repaint();
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        for (int i = 0; i < this.ipbs.length; ++i) {
            if (this.ipbs[i] != actionEvent.getSource()) continue;
            this.iSelected = i + this.sb.getValue();
            this.RepaintOffScreenImage();
            this.repaint();
            if (this.lsse.GenericUnits[n].Items[i].length == this.lsse.GenericItems.length) {
                return;
            }
            this.iMoveItemTo = i;
            new ItemSelectorWindow(this.lsse, this, 4, "Select item for profile", i + (n << 16));
            return;
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        int n = 0;
        int n2 = this.us.GetPointer();
        if (textEvent.getSource() == this.uName && textEvent.getID() == 900) {
            n = this.uName.getCaretPosition();
            StringBuffer stringBuffer = new StringBuffer(this.uName.getText().toUpperCase());
            if (stringBuffer.indexOf("\r\n") > 8 || stringBuffer.indexOf("\r\n") == -1 && stringBuffer.length() > 8) {
                stringBuffer.insert(8, "\r\n");
                if (n > stringBuffer.indexOf("\r\n")) {
                    n += 2;
                }
            }
            if (stringBuffer.indexOf("\r\n") != -1) {
                stringBuffer.replace(stringBuffer.indexOf("\r\n"), stringBuffer.indexOf("\r\n") + 2, "//");
            }
            if (!stringBuffer.toString().equals(this.lsse.GenericUnits[n2].name)) {
                while (stringBuffer.indexOf("\r\n") != -1) {
                    stringBuffer.delete(stringBuffer.indexOf("\r\n"), stringBuffer.indexOf("\r\n") + 2);
                }
                if (stringBuffer.indexOf("//") != -1 && stringBuffer.length() > stringBuffer.indexOf("//") + 10) {
                    stringBuffer.setLength(stringBuffer.indexOf("//") + 10);
                }
                if (n > stringBuffer.indexOf("//") && stringBuffer.indexOf("//") != -1) {
                    --n;
                }
                this.lsse.GenericUnits[n2].name = stringBuffer.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(this.lsse.GenericUnits[n2].name, "//", false);
                String string = new String((stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "") + (stringBuffer.indexOf("//") != -1 ? "\r\n" : "") + (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : ""));
                this.uName.setText(string);
                this.us.RepaintOffScreenImage();
                this.us.repaint();
                this.uName.setCaretPosition(n);
            }
        }
    }

    protected void ChangeUnitPic(Image image) {
        this.lsse.GenericUnits[this.us.GetPointer()].UnitPics[this.iPictureToChange / 16][this.iPictureToChange & 0xF] = image;
        this.us.RepaintOffScreenImage();
        this.us.repaint();
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.us.GetPointer();
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (n2 >= 320 && n2 < 470 && n3 >= 1 && n3 < 33) {
            new ItemSelectorWindow(this.lsse, this, 3, "Select Corpse", this.lsse.GenericUnits[n].GenericItemNumberOfCorpse);
        }
        int n4 = this.GUEHeight - 120;
        n4 -= 2;
        if ((n4 /= 67) > this.lsse.GenericUnits[n].UnitPics.length) {
            n4 = this.lsse.GenericUnits[n].UnitPics.length;
        }
        if (n2 > 5 && n3 > 120 && n2 < 467 && n3 < 120 + n4 * 67) {
            n4 = n3 - 121;
            this.iSelected = (n4 /= 67) + this.sb.getValue();
            this.RepaintOffScreenImage();
            this.repaint();
        }
        if (n2 < 7 || n2 > 270 || n3 < 122 || (n2 - 7) % 33 == 32) {
            return;
        }
        n2 -= 7;
        n2 /= 33;
        n4 = (n3 -= 122) / 67;
        n3 -= n4 * 67;
        if ((n4 += this.sb.getValue()) >= this.lsse.GenericUnits[n].UnitPics.length) {
            return;
        }
        if (n3 == 66 || n3 % 33 == 32) {
            return;
        }
        this.iPictureToChange = (n2 += (n3 /= 33) * 8) + n4 * 16;
        new ImageSelector(this.lsse, this, 6, (n3 == 0 ? "Select Map image Facing " : "Select Target image Facing ") + sDirectionsNames[n2 & 7], this.lsse.GenericUnits[n].UnitPics[n4][n2]);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

