/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class ImageDisplay
extends Panel
implements AdjustmentListener,
MouseListener {
    private LaserSquadScenarioEditor lsse;
    private Scrollbar sb;
    private int Selected = -1;
    private Dialog holder;
    private Image IDImage = null;
    private Graphics IDGraph;
    private int IDWidth = -1;
    private int IDHeight = -1;
    private Image[] images;
    private int iSpacing;

    public ImageDisplay(LaserSquadScenarioEditor laserSquadScenarioEditor, Dialog dialog, Image image, int n) {
        this.lsse = laserSquadScenarioEditor;
        this.holder = dialog;
        this.iSpacing = n;
        this.sb = new Scrollbar(1, 0, 1, 0, 1);
        this.sb.addAdjustmentListener(this);
        this.add(this.sb);
        this.addMouseListener(this);
        Image[] imageArray = this.images = n == 34 ? this.lsse.GetAllAvailableImages() : this.lsse.GetAllAvailableScannerImages();
        if (image != null) {
            for (int i = 0; i < this.images.length; ++i) {
                if (!ScenarioEditorUtility.ImagesIdentical(this.images[i], image)) continue;
                this.Selected = i;
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.IDWidth || n4 != this.IDHeight) {
            this.IDWidth = n3;
            this.IDHeight = n4;
            this.IDImage = this.createImage(n3 - 16, n4);
            this.IDGraph = this.IDImage.getGraphics();
            int n5 = (n3 - 16) / this.iSpacing;
            int n6 = this.Selected / n5;
            int n7 = (n4 - 1) / this.iSpacing;
            n5 = (this.images.length + (n5 - 1)) / n5;
            this.sb.setMaximum(n5);
            if (this.Selected != -1 && n7 <= n6) {
                this.sb.setValue(n6 - n7 + 1);
            }
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        this.IDGraph.setColor(new Color(240, 240, 240));
        this.IDGraph.fillRect(0, 0, this.IDWidth, this.IDHeight);
        int n = this.IDWidth - 16;
        int n2 = this.IDHeight;
        n2 /= this.iSpacing;
        int n3 = this.sb.getValue() * (n /= this.iSpacing);
        for (int i = 0; i < n2 && n3 < this.images.length; ++i) {
            for (int j = 0; j < n && n3 < this.images.length; ++j, ++n3) {
                if (this.iSpacing == 34) {
                    this.IDGraph.drawImage(this.images[n3], j * 34 + 1, i * 34 + 1, null);
                } else {
                    this.IDGraph.drawImage(this.images[n3], j * 14 + 1, i * 14 + 1, j * 14 + 13, i * 14 + 13, 0, 0, 6, 6, null);
                }
                if (n3 != this.Selected) continue;
                this.IDGraph.setColor(Color.RED);
                this.IDGraph.drawRect(j * this.iSpacing, i * this.iSpacing, this.iSpacing - 1, this.iSpacing - 1);
            }
        }
    }

    protected void reset() {
        int n = (this.IDWidth - 16) / this.iSpacing;
        this.images = this.iSpacing == 34 ? this.lsse.GetAllAvailableImages() : this.lsse.GetAllAvailableScannerImages();
        this.Selected = -1;
        this.sb.setValues(0, 1, 0, (this.images.length + (n - 1)) / n);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.IDWidth - 16;
        int n2 = this.IDHeight;
        this.sb.setBounds(n, 0, 16, n2);
        n /= this.iSpacing;
        this.sb.setVisibleAmount(n2 /= this.iSpacing);
        this.IDGraph.setColor(new Color(240, 240, 240));
        this.IDGraph.drawLine(this.IDWidth - 17, this.IDHeight - 1, this.IDWidth - 17, this.IDHeight - 2);
        if (this.IDImage != null) {
            graphics.drawImage(this.IDImage, 0, 0, null);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n >= this.IDWidth - 16 || n2 >= this.IDHeight) {
            this.Selected = -1;
            return;
        }
        this.Selected = (n /= this.iSpacing) + (this.sb.getValue() + (n2 /= this.iSpacing)) * ((this.IDWidth - 16) / this.iSpacing);
        if (this.Selected >= this.images.length) {
            this.Selected = -1;
        }
        this.RepaintOffScreenImage();
        this.repaint();
        if (mouseEvent.getClickCount() == 2 && this.Selected != -1) {
            ((ImageSelector)this.holder).NotifyDoubleclick();
        }
    }

    protected Image GetSelected() {
        if (this.Selected == -1) {
            return null;
        }
        return this.images[this.Selected];
    }

    protected void DeleteSelected() {
        if (this.Selected == -1) {
            return;
        }
        if (this.iSpacing == 34) {
            this.lsse.DeleteImageFromPool(this.images[this.Selected]);
        } else {
            this.lsse.DeleteImageFromScannerPool(this.images[this.Selected]);
        }
        if (this.images.length == 1) {
            this.images = null;
        } else {
            Image[] imageArray = new Image[this.images.length - 1];
            if (this.Selected != 0) {
                System.arraycopy(this.images, 0, imageArray, 0, this.Selected);
            }
            if (this.Selected != this.images.length - 1) {
                System.arraycopy(this.images, this.Selected + 1, imageArray, this.Selected, this.images.length - this.Selected - 1);
            }
            this.images = imageArray;
        }
        if (this.Selected == this.images.length) {
            this.Selected = -1;
        }
        int n = (this.IDWidth - 16) / this.iSpacing;
        this.sb.setMaximum((this.images.length + (n - 1)) / n);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void AddImage(Image image, boolean bl) {
        int n;
        int n2;
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        if (n3 == 0 || n4 == 0) {
            new MessageBox(this.lsse, "Image error", "Blank Image in clipboard.", MessageBox.MB_OK);
            return;
        }
        if (bl && (n3 % 32 != 0 || n4 % 32 != 0)) {
            new MessageBox(this.lsse, "Image error", "Image in clipboard cannot be broken\ninto 32 pixel squares.", MessageBox.MB_OK);
            return;
        }
        if (!(bl || n3 % 6 == 0 && n4 % 6 == 0)) {
            new MessageBox(this.lsse, "Image error", "Image in clipboard cannot be broken\ninto 6 pixel squares.", MessageBox.MB_OK);
            return;
        }
        for (n2 = 0; n2 < n4; n2 += bl ? 32 : 6) {
            for (n = 0; n < n3; n += bl ? 32 : 6) {
                Image image2 = this.createImage(bl ? 32 : 6, bl ? 32 : 6);
                image2.getGraphics().drawImage(image, -n, -n2, null);
                if (bl) {
                    this.lsse.AddImageToPool(image2);
                    continue;
                }
                this.lsse.AddImageToScannerPool(image2);
            }
        }
        n = (this.IDWidth - 16) / this.iSpacing;
        this.images = this.iSpacing == 34 ? this.lsse.GetAllAvailableImages() : this.lsse.GetAllAvailableScannerImages();
        n2 = this.sb.getValue();
        this.sb.setValues(n2, 1, 0, (this.images.length + (n - 1)) / n);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

