/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;

class ImageSelector
extends Dialog
implements ActionListener,
WindowListener {
    private LaserSquadScenarioEditor lsse;
    private ImageDisplay id;
    private Panel holder;
    private int job;

    public ImageSelector(LaserSquadScenarioEditor laserSquadScenarioEditor, Panel panel, int n, String string, Image image) {
        super(laserSquadScenarioEditor, string, true);
        this.lsse = laserSquadScenarioEditor;
        this.holder = panel;
        this.job = n;
        if (!this.lsse.bImagePoolsHaveLoaded) {
            this.lsse.lsmd2.show();
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.lsse.bImagePoolsAreUpdated) {
            this.lsse.lsmd3.show();
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.lsse.bImagePoolsAreSaveing) {
            this.lsse.lsmd2.show();
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setBounds(this.lsse.getInsets().left + this.lsse.getX(), this.lsse.getInsets().top + this.lsse.getY(), 560, 400);
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        this.id = new ImageDisplay(this.lsse, this, image, this.job <= 7 || this.job > 10 ? 34 : 14);
        this.add("Center", this.id);
        Panel panel2 = new Panel();
        Button button = new Button("Ok");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Cancel");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Delete image");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Add from file");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Add from clipboard");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Copy to clipboard");
        button.addActionListener(this);
        panel2.add(button);
        this.add("South", panel2);
        this.validate();
        this.show();
    }

    private void NotifyParent() {
        Image image = this.id.GetSelected();
        if (this.job == 1 && image != null) {
            ((TerrainEditor)this.holder).ChangeMapPic(image);
        }
        if (this.job == 2 && image != null) {
            ((TerrainEditor)this.holder).ChangeTargetPic(image);
        }
        if (this.job == 3 && image != null) {
            ((AnnimationImagesList)this.holder).ChangePic(image);
        }
        if (this.job == 4 && image != null) {
            ((GenericItemEditor)this.holder).ChangeMapPic(image);
        }
        if (this.job == 5 && image != null) {
            ((GenericItemEditor)this.holder).ChangeTargetPic(image);
        }
        if (this.job == 6 && image != null) {
            ((GenericUnitEditor)this.holder).ChangeUnitPic(image);
        }
        if (this.job == 7 && image != null) {
            ((TeamEditor)this.holder).ChangeDeployPic(image);
        }
        if (this.job == 8 && image != null) {
            ((TeamEditor)this.holder).ChangeScannerPic(image);
        }
        if (this.job == 9 && image != null) {
            ((TerrainEditor)this.holder).ChangeScannerPic(image);
        }
        if (this.job == 10 && image != null) {
            ((GenericItemEditor)this.holder).ChangeScannerPic(image);
        }
        if (this.job == 11 && image != null) {
            ((ScenarioEditor)this.holder).NotifyChangePic(image);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Image image;
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.lsse.CheckAndSaveImagePool();
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("Ok")) {
            this.lsse.CheckAndSaveImagePool();
            this.NotifyParent();
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("Delete image")) {
            this.id.DeleteSelected();
            return;
        }
        if (actionEvent.getActionCommand().equals("Add from file")) {
            FileDialog fileDialog = new FileDialog((Frame)this.lsse, "Select image file", 0);
            fileDialog.show();
            Image image2 = Toolkit.getDefaultToolkit().createImage(fileDialog.getDirectory() + fileDialog.getFile());
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image2, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                new MessageBox(this.lsse, "Image error", "Can't load image file.", MessageBox.MB_OK);
                return;
            }
            this.id.AddImage(image2, this.job <= 7 || this.job > 10);
            return;
        }
        if (actionEvent.getActionCommand().equals("Add from clipboard")) {
            Image image3;
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            if (!transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                new MessageBox(this.lsse, "Image error", "No Image in clipboard.", MessageBox.MB_OK);
                return;
            }
            try {
                image3 = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                new MessageBox(this.lsse, "Image error", "Can't get Image from clipboard.", MessageBox.MB_OK);
                return;
            }
            catch (IOException iOException) {
                new MessageBox(this.lsse, "Image error", "Can't get Image from clipboard.", MessageBox.MB_OK);
                return;
            }
            this.id.AddImage(image3, this.job <= 7 || this.job > 10);
            return;
        }
        if (actionEvent.getActionCommand().equals("Copy to clipboard") && (image = this.id.GetSelected()) != null) {
            this.lsse.SetClipboardContent(image);
        }
    }

    protected void NotifyDoubleclick() {
        this.lsse.CheckAndSaveImagePool();
        this.NotifyParent();
        this.hide();
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.lsse.CheckAndSaveImagePool();
        this.hide();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

