/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class ItemEditor
extends Panel
implements ActionListener {
    private LaserSquadScenarioEditor lsse;
    private ItemSelector is;
    private ItemEditorPanel iep;
    private TerrainDisplay td;
    private int IEWidth = -1;
    private int IEHeight = -1;
    private Button butAdd;
    private Button butRemove;
    private Button butCopy;
    private Point pOld = new Point(-1, -1);
    private int iOld = -1;
    private boolean bOld = false;
    private boolean tOld = true;

    public ItemEditor(LaserSquadScenarioEditor laserSquadScenarioEditor) {
        this.lsse = laserSquadScenarioEditor;
        this.is = new ItemSelector(this.lsse, this, 0, 2);
        this.add(this.is);
        this.td = new TerrainDisplay(this.lsse, this);
        this.add(this.td);
        this.iep = new ItemEditorPanel(this.lsse, this, this.is.GetPointer() == -1 ? null : this.lsse.Items[this.is.GetPointer()]);
        this.add(this.iep);
        this.butAdd = new Button("Add Item");
        this.butAdd.addActionListener(this);
        this.add(this.butAdd);
        this.butCopy = new Button("Copy Item");
        this.butCopy.addActionListener(this);
        this.add(this.butCopy);
        this.butRemove = new Button("Remove Item");
        this.butRemove.addActionListener(this);
        this.add(this.butRemove);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.IEWidth || n4 != this.IEHeight) {
            this.IEWidth = n3;
            this.IEHeight = n4;
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butAdd) {
            EditorItem editorItem = new EditorItem();
            editorItem.GenericItemNumber = 0;
            editorItem.Position = new Point(-1, -1);
            editorItem.bHidden = false;
            editorItem.Owner = null;
            editorItem.AmmoLeftOrPrime = 0;
            editorItem.TerrainUnder = 0;
            this.lsse.AddItemToPool(editorItem);
            this.is.RecheckPointer();
            this.is.RepaintOffScreenImage();
            this.is.repaint();
            this.ItemSelectorNotifyingChange();
            this.repaint();
        }
        if (actionEvent.getSource() == this.butCopy) {
            if (this.lsse.Items == null || this.lsse.Items.length == 0) {
                return;
            }
            this.lsse.AddItemToPool(new EditorItem(this.lsse.Items[this.is.GetPointer()]));
            this.is.RecheckPointer();
            this.is.RepaintOffScreenImage();
            this.is.repaint();
            this.ItemSelectorNotifyingChange();
            this.repaint();
        }
        if (actionEvent.getSource() == this.butRemove) {
            if (this.lsse.Items == null || this.lsse.Items.length == 0) {
                return;
            }
            int n = this.is.GetPointer();
            if (this.lsse.Items[n].bTop && this.lsse.Items[n].Position.x != -1 && this.lsse.Items[n].Position.y != -1) {
                this.lsse.Map[this.lsse.Items[n].Position.x + this.lsse.MapWidth * this.lsse.Items[n].Position.y] = this.lsse.Items[n].TerrainUnder;
                for (int i = 0; i < this.lsse.Items.length; ++i) {
                    if (i == n || !this.lsse.Items[i].Position.equals(this.lsse.Items[n].Position) || this.lsse.Items[i].bHidden) continue;
                    this.lsse.Map[this.lsse.Items[i].Position.x + this.lsse.MapWidth * this.lsse.Items[i].Position.y] = this.lsse.Terrains.length + this.lsse.Items[i].GenericItemNumber;
                    this.lsse.Items[i].bTop = true;
                    break;
                }
            }
            this.lsse.RemoveItemFromPool(n);
            this.is.RecheckPointer();
            this.is.RepaintOffScreenImage();
            this.is.repaint();
            this.ItemSelectorNotifyingChange();
            this.td.RepaintOffScreenImage();
            this.td.repaint();
        }
    }

    protected void ItemEditorPanelRequestingCenter() {
        this.td.CenterOn(this.lsse.Items[this.is.GetPointer()].Position);
    }

    protected void TerrainDisplayNotifyingChange() {
        if (this.is.GetPointer() == -1) {
            return;
        }
        this.lsse.Items[this.is.GetPointer()].bTop = true;
        this.MoveItemTo(this.td.getPos());
        this.iep.ChangePos(this.td.getPos());
        this.iep.RepaintOffScreenImage();
        this.iep.repaint();
    }

    protected void ItemSelectorNotifyingChange() {
        EditorItem editorItem = this.is.GetPointer() == -1 ? null : this.lsse.Items[this.is.GetPointer()];
        this.pOld.setLocation(editorItem == null ? new Point(-1, -1) : editorItem.Position);
        this.iOld = editorItem == null ? -1 : editorItem.GenericItemNumber;
        this.bOld = editorItem == null ? false : editorItem.bHidden;
        this.tOld = editorItem == null ? true : editorItem.bTop;
        this.iep.ChangeItem(editorItem);
        this.td.NotifyHighlightChange(this.pOld);
        this.iep.RepaintOffScreenImage();
        this.iep.repaint();
    }

    protected void ItemEditorPanelNotifyingChange(Point point) {
        this.MoveItemTo(point);
        this.td.RepaintOffScreenImage();
        this.td.repaint();
        this.td.NotifyHighlightChange(this.is.GetPointer() == -1 ? new Point(-1, -1) : this.lsse.Items[this.is.GetPointer()].Position);
        this.is.FillInternalArray(this.is.GetPointer());
        this.is.RepaintOffScreenImage();
        this.is.repaint();
    }

    protected void MoveItemTo(Point point) {
        int n;
        if (this.is.GetPointer() == -1) {
            return;
        }
        EditorItem editorItem = this.lsse.Items[this.is.GetPointer()];
        if (!this.bOld && this.pOld.x != -1 && this.pOld.y != -1 && this.pOld.x < this.lsse.MapWidth && this.pOld.y < this.lsse.MapHeight) {
            this.lsse.Map[this.pOld.x + this.lsse.MapWidth * this.pOld.y] = editorItem.TerrainUnder;
            for (n = 0; n < this.lsse.Items.length; ++n) {
                if (n == this.is.GetPointer() || !this.lsse.Items[n].Position.equals(this.pOld) || this.lsse.Items[n].bHidden) continue;
                this.lsse.Map[this.pOld.x + this.lsse.MapWidth * this.pOld.y] = this.lsse.Terrains.length + this.lsse.Items[n].GenericItemNumber;
                this.lsse.Items[n].bTop = true;
                break;
            }
        }
        if (point.x >= this.lsse.MapWidth) {
            point.x = -1;
        }
        if (point.y >= this.lsse.MapHeight) {
            point.y = -1;
        }
        if (point.x == -1 || point.y == -1) {
            editorItem.bHidden = false;
        }
        int n2 = editorItem.TerrainUnder = point.x != -1 && point.y != -1 ? this.lsse.GetTerrainAt(point.x, point.y) : 0;
        if (!editorItem.bHidden) {
            for (n = 0; !(n >= this.lsse.Items.length || this.lsse.Items[n].Position.equals(this.pOld) && !this.lsse.Items[n].bHidden && this.lsse.Items[n].bTop); ++n) {
            }
            if (n == this.lsse.Items.length) {
                editorItem.bTop = true;
            }
        }
        editorItem.Position.setLocation(point);
        this.iOld = editorItem.GenericItemNumber;
        this.bOld = editorItem.bHidden;
        this.pOld.setLocation(point);
        this.tOld = editorItem.bTop;
        if (this.tOld && !this.bOld && this.pOld.x != -1 && this.pOld.y != -1) {
            for (n = 0; n < this.lsse.Items.length; ++n) {
                if (!this.lsse.Items[n].bTop || !this.lsse.Items[n].Position.equals(this.pOld)) continue;
                this.lsse.Items[n].bTop = false;
            }
            this.lsse.Map[this.pOld.x + this.lsse.MapWidth * this.pOld.y] = this.lsse.Terrains.length + this.iOld;
            editorItem.bTop = true;
        }
        this.td.RepaintOffScreenImage();
        this.td.repaint();
    }

    protected void reset() {
        this.is.reset();
        this.td.reset();
        this.ItemSelectorNotifyingChange();
        this.ItemSelectorNotifyingChange();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = this.IEHeight;
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, 0, this.IEWidth, this.IEHeight);
        this.butAdd.setBounds(this.IEWidth - 176, 3, 170, 25);
        this.butCopy.setBounds(this.IEWidth - 176, 31, 170, 25);
        this.butRemove.setBounds(this.IEWidth - 176, 59, 170, 25);
        n -= 87;
        this.is.setBounds(this.IEWidth - 176, 87, 174, (n /= 34) * 34);
        this.td.setBounds(0, 0, this.IEWidth - 182 - 160, this.IEHeight);
        this.iep.setBounds(this.IEWidth - 181 - 160, 0, 160, this.IEHeight);
    }
}

