/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

class ItemEditorPanel
extends Panel
implements TextListener,
KeyListener,
ItemListener,
MouseListener,
ActionListener {
    private LaserSquadScenarioEditor lsse;
    private Container parent;
    private EditorItem ei;
    private int IEPWidth = -1;
    private int IEPHeight = -1;
    private Image IEPImage = null;
    private Graphics IEPGraph;
    private TextField tfX = null;
    private TextField tfY = null;
    private TextField tfAmmoOrPrime;
    private Checkbox cbIsHidden = null;
    private Button butCenter = null;

    public ItemEditorPanel(LaserSquadScenarioEditor laserSquadScenarioEditor, Container container, EditorItem editorItem) {
        this.lsse = laserSquadScenarioEditor;
        this.parent = container;
        this.ei = editorItem;
        if (!this.parent.getClass().getName().equals("UnitItemEditor")) {
            this.tfX = new TextField(4);
            this.tfX.setFont(LaserSquadScenarioEditor.font);
            this.tfX.addKeyListener(this);
            this.tfX.addTextListener(this);
            this.add(this.tfX);
            this.tfY = new TextField(4);
            this.tfY.setFont(LaserSquadScenarioEditor.font);
            this.tfY.addKeyListener(this);
            this.tfY.addTextListener(this);
            this.add(this.tfY);
            this.cbIsHidden = new Checkbox("Is Hidden");
            this.cbIsHidden.setFont(LaserSquadScenarioEditor.font);
            this.cbIsHidden.addItemListener(this);
            this.add(this.cbIsHidden);
            this.butCenter = new Button("Center Item");
            this.butCenter.addActionListener(this);
            this.add(this.butCenter);
        }
        this.tfAmmoOrPrime = new TextField(4);
        this.tfAmmoOrPrime.setFont(LaserSquadScenarioEditor.font);
        this.tfAmmoOrPrime.addKeyListener(this);
        this.tfAmmoOrPrime.addTextListener(this);
        this.add(this.tfAmmoOrPrime);
        this.tfAmmoOrPrime.setBounds(65, 46, 60, 20);
        this.addMouseListener(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(160, 70);
    }

    public Dimension getMinimumSize() {
        return new Dimension(160, 70);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.IEPWidth || n4 != this.IEPHeight) {
            this.IEPWidth = n3;
            this.IEPHeight = n4;
            this.IEPImage = this.createImage(n3, n4);
            this.IEPGraph = this.IEPImage.getGraphics();
            this.RepaintOffScreenImage();
            this.repaint();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void ChangeItem(EditorItem editorItem) {
        this.ei = editorItem;
    }

    protected void ChangePos(Point point) {
        if (this.ei == null) {
            return;
        }
        if (point == null) {
            this.ei.Position.setLocation(-1, -1);
        } else {
            this.ei.Position.setLocation(point);
        }
    }

    protected void RepaintOffScreenImage() {
        if (this.IEPImage == null) {
            return;
        }
        this.IEPGraph.setColor(new Color(240, 240, 240));
        this.IEPGraph.fillRect(0, 0, this.IEPWidth, this.IEPHeight);
        this.IEPGraph.setColor(Color.BLACK);
        this.IEPGraph.setFont(LaserSquadScenarioEditor.font);
        this.IEPGraph.drawRect(5, 5, 150, 33);
        if (this.ei == null) {
            if (this.tfX != null) {
                this.tfX.setVisible(false);
                this.tfY.setVisible(false);
                this.butCenter.setVisible(false);
                this.cbIsHidden.setVisible(false);
            }
            this.tfAmmoOrPrime.setVisible(false);
            return;
        }
        if (this.tfX != null) {
            this.tfX.setVisible(true);
            this.tfY.setVisible(true);
            this.butCenter.setVisible(true);
            this.cbIsHidden.setVisible(true);
        }
        this.tfAmmoOrPrime.setVisible(true);
        this.lsse.GenericItems[this.ei.GenericItemNumber].DisplayDetails(this.IEPGraph, 6, 6, null);
        int n = 60;
        if (this.tfX != null) {
            this.IEPGraph.drawString("Co-ordinates:", 5, 70);
            this.IEPGraph.drawString("X = ", 5, 90);
            this.tfX.setBounds(40, 76, 60, 20);
            this.tfX.setText(this.ei.Position.x == -1 ? "" : Integer.toString(this.ei.Position.x));
            this.IEPGraph.drawString("Y = ", 5, 110);
            this.tfY.setBounds(40, 96, 60, 20);
            this.tfY.setText(this.ei.Position.y == -1 ? "" : Integer.toString(this.ei.Position.y));
            this.butCenter.setBounds(5, 126, 100, 25);
            this.butCenter.setEnabled(this.ei.Position.x != -1 && this.ei.Position.x != -1);
            this.cbIsHidden.setBounds(5, 156, 150, 20);
            if (this.ei.Position.x != -1 && this.ei.Position.y != -1) {
                this.cbIsHidden.setEnabled(true);
                this.cbIsHidden.setState(this.ei.bHidden);
            } else {
                this.cbIsHidden.setEnabled(false);
                this.cbIsHidden.setState(false);
            }
            n = 200;
        }
        if ((this.lsse.GenericItems[this.ei.GenericItemNumber].flags & 0x20) == 32) {
            this.tfAmmoOrPrime.setVisible(false);
            return;
        }
        this.tfAmmoOrPrime.setText(this.ei.AmmoLeftOrPrime == 65535 ? "" : Integer.toString(this.ei.AmmoLeftOrPrime));
        this.IEPGraph.drawString((this.lsse.GenericItems[this.ei.GenericItemNumber].flags & 8) == 8 ? "Prime:" : "Ammo:", 5, n);
        this.tfAmmoOrPrime.setBounds((this.lsse.GenericItems[this.ei.GenericItemNumber].flags & 8) == 8 ? 65 : 60, n - 14, 60, 20);
    }

    public void paint(Graphics graphics) {
        this.IEPGraph.setColor(new Color(240, 240, 240));
        this.IEPGraph.drawLine(0, 0, 0, 1);
        if (this.IEPImage != null) {
            graphics.drawImage(this.IEPImage, 0, 0, null);
        }
    }

    protected void NotifyItemChange(int n) {
        this.ei.GenericItemNumber = n;
        this.RepaintOffScreenImage();
        this.repaint();
        if (this.parent.getClass().getName().equals("ItemEditor")) {
            ((ItemEditor)this.parent).ItemEditorPanelNotifyingChange(this.ei.Position);
        }
        if (this.parent.getClass().getName().equals("UnitItemEditor")) {
            ((UnitItemEditor)this.parent).ItemEditorPanelNotifyingChange();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butCenter) {
            ((ItemEditor)this.parent).ItemEditorPanelRequestingCenter();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.ei == null || mouseEvent.isPopupTrigger()) {
            return;
        }
        if (mouseEvent.getX() >= 5 && mouseEvent.getX() < 155 && mouseEvent.getY() >= 5 && mouseEvent.getY() < 38) {
            new ItemSelectorWindow(this.lsse, this, 2, "Select Item", this.ei.GenericItemNumber);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void textValueChanged(TextEvent textEvent) {
        Point point = new Point(this.ei.Position);
        if (textEvent.getSource() == this.tfX && textEvent.getID() == 900) {
            int n;
            try {
                n = Integer.parseInt(this.tfX.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n > 4094 || n < 0) {
                n = -1;
            }
            if (n >= this.lsse.MapWidth) {
                n = this.lsse.MapWidth - 1;
            }
            point.x = n;
            if (!this.tfX.getText().equals(n == -1 ? "" : Integer.toString(n))) {
                n = this.tfX.getCaretPosition();
                this.RepaintOffScreenImage();
                this.repaint();
                this.tfX.setCaretPosition(n);
            }
            if (this.parent.getClass().getName().equals("ItemEditor")) {
                ((ItemEditor)this.parent).ItemEditorPanelNotifyingChange(point);
            }
            return;
        }
        if (textEvent.getSource() == this.tfY && textEvent.getID() == 900) {
            int n;
            try {
                n = Integer.parseInt(this.tfY.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n > 4094 || n < 0) {
                n = -1;
            }
            if (n >= this.lsse.MapHeight) {
                n = this.lsse.MapHeight - 1;
            }
            point.y = n;
            if (!this.tfY.getText().equals(n == -1 ? "" : Integer.toString(n))) {
                n = this.tfY.getCaretPosition();
                this.RepaintOffScreenImage();
                this.repaint();
                this.tfY.setCaretPosition(n);
            }
            if (this.parent.getClass().getName().equals("ItemEditor")) {
                ((ItemEditor)this.parent).ItemEditorPanelNotifyingChange(point);
            }
            return;
        }
        if (textEvent.getSource() == this.tfAmmoOrPrime && textEvent.getID() == 900) {
            int n;
            try {
                n = Integer.parseInt(this.tfAmmoOrPrime.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n > 65535 || n < 0) {
                n = 65535;
            }
            this.ei.AmmoLeftOrPrime = n;
            if (!this.tfAmmoOrPrime.getText().equals(n == 65535 ? "" : Integer.toString(n))) {
                n = this.tfAmmoOrPrime.getCaretPosition();
                this.RepaintOffScreenImage();
                this.repaint();
                this.tfAmmoOrPrime.setCaretPosition(n);
            }
            return;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) && c != '\b') {
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getID() == 701 && itemEvent.getSource() == this.cbIsHidden) {
            boolean bl = this.ei.bHidden = itemEvent.getStateChange() == 1;
            if (this.parent.getClass().getName().equals("ItemEditor")) {
                ((ItemEditor)this.parent).ItemEditorPanelNotifyingChange(this.ei.Position);
            }
        }
    }
}

