/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

class ItemSelector
extends Panel
implements AdjustmentListener,
MouseListener {
    private LaserSquadScenarioEditor lsse;
    private Container holder;
    private int pointer;
    private Scrollbar sb;
    private Image ISImage = null;
    private Graphics ISGraph;
    private int ISWidth = -1;
    private int ISHeight = -1;
    private int View = 0;
    private int[] items = null;

    public ItemSelector(LaserSquadScenarioEditor laserSquadScenarioEditor, Container container, int n, int n2) {
        this.lsse = laserSquadScenarioEditor;
        this.holder = container;
        this.View = n2;
        this.FillInternalArray(n);
        this.sb = new Scrollbar(1, this.pointer, 1, 0, this.items.length);
        this.sb.addAdjustmentListener(this);
        this.add(this.sb);
        this.addMouseListener(this);
        this.setBackground(new Color(240, 240, 240));
    }

    public void FillInternalArray(int n) {
        int n2;
        Vector<Integer> vector = new Vector<Integer>();
        if (this.View == 0) {
            this.pointer = n;
            for (n2 = 0; n2 < this.lsse.GenericItems.length; ++n2) {
                vector.add(new Integer(n2));
            }
        }
        if (this.View == 1) {
            this.pointer = 0;
            for (n2 = 0; n2 < this.lsse.GenericItems.length; ++n2) {
                if ((this.lsse.GenericItems[n2].flags & 0x20) != 32) continue;
                if (n2 == n) {
                    this.pointer = vector.size();
                }
                vector.add(new Integer(n2));
            }
        }
        if (this.View == 2) {
            this.pointer = 0;
            if (this.lsse.Items != null) {
                for (n2 = 0; n2 < this.lsse.Items.length; ++n2) {
                    if (this.lsse.Items[n2].Owner != null) continue;
                    if (n2 == n) {
                        this.pointer = vector.size();
                    }
                    vector.add(new Integer(this.lsse.Items[n2].GenericItemNumber));
                }
            }
        }
        if (this.View == 3) {
            this.pointer = 0;
            if (this.lsse.Items != null) {
                for (n2 = 0; n2 < this.lsse.Items.length; ++n2) {
                    if (this.lsse.Items[n2].Owner == null) continue;
                    if (n2 == n) {
                        this.pointer = vector.size();
                    }
                    vector.add(new Integer(this.lsse.Items[n2].GenericItemNumber));
                }
            }
        }
        if (this.View == 4) {
            for (n2 = 0; n2 < this.lsse.GenericItems.length; ++n2) {
                if (ScenarioEditorUtility.arrayPos(this.lsse.GenericUnits[n >> 16].Items[n & 0xFFFF], n2) != -1) continue;
                vector.add(new Integer(n2));
            }
            this.pointer = 0;
        }
        if (this.View == 5) {
            this.pointer = n;
            if (((UnitItemEditor)this.holder).eiItems != null) {
                for (n2 = 0; n2 < ((UnitItemEditor)this.holder).eiItems.length; ++n2) {
                    vector.add(new Integer(((UnitItemEditor)this.holder).eiItems[n2].GenericItemNumber));
                }
            }
        }
        this.items = new int[vector.size()];
        if (this.items.length > 0) {
            for (n2 = 0; n2 < this.items.length; ++n2) {
                this.items[n2] = (Integer)vector.elementAt(n2);
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 > 30 && n4 > 30 && (n3 != this.ISWidth || n4 != this.ISHeight)) {
            this.ISWidth = n3;
            this.ISHeight = n4;
            this.ISImage = this.createImage(n3 - 16, n4);
            this.ISGraph = this.ISImage.getGraphics();
            this.RepaintOffScreenImage();
            this.repaint();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        int n = this.ISHeight;
        if (this.ISGraph == null) {
            return;
        }
        this.ISGraph.setColor(Color.WHITE);
        this.ISGraph.fillRect(0, 0, this.ISWidth, n);
        if (this.items.length == 0) {
            this.sb.setVisible(false);
            return;
        }
        this.sb.setVisible(true);
        this.sb.setBounds(158, 0, 16, n);
        this.sb.setVisibleAmount(n /= 34);
        if (this.sb.getMaximum() != this.items.length) {
            this.sb.setMaximum(this.items.length);
        }
        this.ISGraph.setColor(Color.BLACK);
        this.ISGraph.setFont(LaserSquadScenarioEditor.font);
        int n2 = this.sb.getValue();
        for (int i = 0; i < n && i + n2 < this.items.length; ++i) {
            this.lsse.GenericItems[this.items[i + n2]].DisplayDetails(this.ISGraph, 1, 1 + i * 34, null);
            if (i + n2 != this.pointer) continue;
            this.ISGraph.setColor(Color.RED);
            this.ISGraph.drawRect(0, i * 34, this.ISWidth - 17, 33);
            this.ISGraph.setColor(Color.BLACK);
        }
    }

    protected void reset() {
        this.FillInternalArray(0);
        this.sb.setValues(0, 1, 0, this.items.length);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.ISImage != null) {
            this.ISGraph.setColor(Color.WHITE);
            this.ISGraph.drawLine(this.ISWidth - 18, 1, this.ISWidth - 18, 2);
            graphics.drawImage(this.ISImage, 0, 0, null);
        }
        this.sb.setBounds(158, 0, 16, this.ISHeight);
    }

    public int GetPointer() {
        if (this.View == 1) {
            return this.lsse.GenericItems != null ? this.items[this.pointer] : 0;
        }
        if (this.View == 2) {
            if (this.items.length == 0) {
                return -1;
            }
            if (this.lsse.Items != null) {
                int n = 0;
                for (int i = 0; i < this.lsse.Items.length; ++i) {
                    if (this.lsse.Items[i].Owner != null) continue;
                    if (this.pointer == n) {
                        return i;
                    }
                    ++n;
                }
            }
            return 0;
        }
        if (this.View == 3) {
            if (this.lsse.Items != null) {
                int n = 0;
                for (int i = 0; i < this.lsse.Items.length; ++i) {
                    if (this.lsse.Items[i].Owner == null) continue;
                    if (this.pointer == n) {
                        return i;
                    }
                    ++n;
                }
            }
            return 0;
        }
        if (this.View == 4) {
            return this.lsse.GenericItems != null ? this.items[this.pointer] : 0;
        }
        return this.pointer;
    }

    protected void RecheckPointer() {
        int n = this.pointer;
        this.FillInternalArray(0);
        this.sb.setValues(0, 1, 0, this.items.length);
        this.pointer = n;
        if (this.pointer >= this.items.length) {
            --this.pointer;
        }
        if (this.pointer < 0) {
            this.pointer = 0;
        }
        this.sb.setValues(this.pointer, 1, 0, this.items.length);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (n < 0 || n > this.getSize().width - 16) {
            return;
        }
        n = mouseEvent.getY();
        int n2 = this.getSize().height / 34;
        if (n < 0 || n > (n2 *= 34)) {
            return;
        }
        n = mouseEvent.getY() / 34;
        if ((n += this.sb.getValue()) >= this.items.length) {
            return;
        }
        this.pointer = n;
        this.RepaintOffScreenImage();
        this.repaint();
        if (this.holder.getClass().getName().equals("GenericItemEditor")) {
            ((GenericItemEditor)this.holder).NotifyClick();
        }
        if (this.holder.getClass().getName().equals("ItemEditor")) {
            ((ItemEditor)this.holder).ItemSelectorNotifyingChange();
        }
        if (this.holder.getClass().getName().equals("UnitItemEditor")) {
            ((UnitItemEditor)this.holder).ItemSelectorNotifyingChange();
        }
        if (mouseEvent.getClickCount() == 2 && this.holder.getClass().getName().equals("ItemSelectorWindow")) {
            ((ItemSelectorWindow)this.holder).InformParentOfChange();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

