/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class LaserSquadScenarioEditor
extends Frame
implements WindowListener,
ActionListener,
FilenameFilter,
ComponentListener,
ClipboardOwner,
Runnable,
ItemListener {
    private String debug = null;
    private String sFileName;
    protected String ScenarioName;
    protected int MapHeight;
    protected int MapWidth;
    protected int iScenarioFlags;
    protected int MaxNumberOfTurns;
    protected int MaxDifficultyLevel;
    protected int NumberOfRegions;
    protected String sIntroductionText;
    protected int[] Map;
    protected int[] DeploymentMap;
    protected EditorTeam[] Teams;
    protected EditorGenericItem[] GenericItems = null;
    protected EditorUnit[] Units;
    protected EditorItem[] Items;
    protected EditorArmour[] Armours;
    protected EditorTerrain[] Terrains;
    protected EditorGenericUnit[] GenericUnits;
    protected Point[] Nodes;
    protected int[][] NodeLinks;
    protected Rectangle[] RegionBlocks;
    protected int[] RegionNumbers;
    protected Vector ImagePool = new Vector();
    protected Vector ScannerImagePool = new Vector();
    protected static final Font font = new Font("Monospaced", 1, 16);
    private int ViewPoint = -1;
    private MapEditor MapSheet;
    private UnitEditor UnitSheet;
    private TeamEditor TeamSheet;
    private ItemEditor ItemSheet;
    private TerrainEditor TerrainsSheet;
    private GenericUnitEditor GenericUnitSheet;
    private GenericItemEditor GenericItemsSheet;
    private ScenarioEditor ScenarioSheet;
    private RegionEditor RegionSheet;
    private NodeEditor NodeSheet;
    private MenuBar menuBar = new MenuBar();
    private Menu editMenu = new Menu("Edit");
    private boolean bHasChanged = false;
    protected CauseAndEffect PreMoveCauseAndEffects;
    protected CauseAndEffect EndOfTurnCauseAndEffects;
    protected int iPathNodeLimit;
    protected CauseAndEffect SetupEffects;
    protected Vector ExtraPlayerOptions = new Vector();
    protected CauseAndEffect AfterPickupItem;
    protected CauseAndEffect AfterDropItem;
    protected CauseAndEffect ChangeItem;
    protected CauseAndEffect EndGameItem;
    protected CauseAndEffect SelectUnitItem;
    protected CauseAndEffect ItemDestroyed;
    protected CauseAndEffect TerrainDestroyed;
    protected CauseAndEffect[] CallableRoutines = new CauseAndEffect[0];
    protected Vector CAEArrays = new Vector();
    protected Vector CAERoutines = new Vector();
    protected Image[] IHitImages = new Image[4];
    protected Image[] IDamageImages = new Image[2];
    protected Image ICursor;
    private LoadSaveMessageDialog lsmd;
    protected LoadSaveMessageDialog lsmd2;
    protected LoadSaveMessageDialog lsmd3;
    private boolean bImagePoolsHaveChanged = false;
    protected boolean bImagePoolsHaveLoaded = false;
    protected boolean bImagePoolsAreSaveing = false;
    protected boolean bImagePoolsAreUpdated = true;
    private Vector vImagePoolBuffer = new Vector();
    private boolean bImportImages = true;
    private boolean bRememberState = true;
    private ErrorLoggerOutputStream elos = null;
    private ClipboardImage clipImg = null;

    public void finalize() throws Throwable {
        System.setErr(System.out);
        super.finalize();
    }

    public LaserSquadScenarioEditor() {
        Object object;
        if (this.debug == null) {
            // empty if block
        }
        try {
            object = new RandomAccessFile(this.GetJarPath() + "EditorSettings.dat", "r");
            ((RandomAccessFile)object).seek(1L);
            byte by = ((RandomAccessFile)object).readByte();
            int n = ((RandomAccessFile)object).readInt();
            int n2 = ((RandomAccessFile)object).readInt();
            ((RandomAccessFile)object).close();
            this.bImportImages = (by & 1) == 1;
            boolean bl = this.bRememberState = (by & 2) == 2;
            if (this.bRememberState) {
                this.setBounds(n, n2, 800, 600);
                switch (by & 0xC) {
                    case 0: {
                        this.setExtendedState(0);
                        break;
                    }
                    case 4: {
                        this.setExtendedState(1);
                        break;
                    }
                    case 8: {
                        this.setExtendedState(6);
                    }
                }
            } else {
                this.setSize(800, 600);
            }
        }
        catch (IOException iOException) {
            this.setSize(800, 600);
        }
        this.setBackground(new Color(240, 240, 240));
        this.show();
        this.NewScenario();
        this.bImagePoolsHaveChanged = false;
        object = new Menu("File");
        MenuItem menuItem = new MenuItem("New Scenario");
        ((Menu)object).add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Open Scenario");
        ((Menu)object).add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Save");
        ((Menu)object).add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Save As");
        ((Menu)object).add(menuItem);
        menuItem.addActionListener(this);
        ((Menu)object).addSeparator();
        menuItem = new MenuItem("Import Scenario");
        ((Menu)object).add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Export Scenario");
        ((Menu)object).add(menuItem);
        menuItem.addActionListener(this);
        ((Menu)object).addSeparator();
        menuItem = new MenuItem("Exit");
        ((Menu)object).add(menuItem);
        menuItem.addActionListener(this);
        this.menuBar.add((Menu)object);
        this.menuBar.add(this.editMenu);
        Menu menu = new Menu("View");
        menuItem = new MenuItem("Map");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Units");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Items");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Teams");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Scenario Details");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menu.addSeparator();
        menuItem = new MenuItem("Terrains");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Generic Units");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Generic Items");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menu.addSeparator();
        menuItem = new MenuItem("Regions");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Nodes");
        menu.add(menuItem);
        menuItem.addActionListener(this);
        this.menuBar.add(menu);
        Menu menu2 = new Menu("Options");
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem("Import Images", this.bImportImages);
        menu2.add(checkboxMenuItem);
        checkboxMenuItem.addItemListener(this);
        checkboxMenuItem = new CheckboxMenuItem("Remember state", this.bRememberState);
        menu2.add(checkboxMenuItem);
        checkboxMenuItem.addItemListener(this);
        this.menuBar.add(menu2);
        this.setMenuBar(this.menuBar);
        this.ChangeEditorSheet(0);
        this.addWindowListener(this);
        this.addComponentListener(this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (((CheckboxMenuItem)itemEvent.getSource()).getLabel().equals("Import Images")) {
            this.bImportImages = ((CheckboxMenuItem)itemEvent.getSource()).getState();
        }
        if (((CheckboxMenuItem)itemEvent.getSource()).getLabel().equals("Remember state")) {
            this.bRememberState = ((CheckboxMenuItem)itemEvent.getSource()).getState();
        }
    }

    private void NewScenario() {
        this.sFileName = new String("");
        this.setTitle("Laser Squad Scenario Editor (new scenario)");
        this.Terrains = new EditorTerrain[1];
        this.Terrains[0] = new EditorTerrain();
        this.Terrains[0].MapPic = this.createImage(32, 32);
        this.Terrains[0].MapPic.getGraphics().setColor(Color.BLACK);
        this.Terrains[0].MapPic.getGraphics().fillRect(0, 0, 32, 32);
        this.Terrains[0].TargetPic = this.Terrains[0].MapPic;
        this.AddImageToPool(this.Terrains[0].MapPic);
        this.Terrains[0].ScannerPic = this.createImage(6, 6);
        this.Terrains[0].ScannerPic.getGraphics().setColor(Color.BLACK);
        this.Terrains[0].ScannerPic.getGraphics().fillRect(0, 0, 6, 6);
        this.AddImageToScannerPool(this.Terrains[0].ScannerPic);
        this.Terrains[0].name = new String("");
        this.Terrains[0].Strength = 4095;
        this.Terrains[0].WhatItBecomesWhenDestroyed = 65535;
        this.Terrains[0].ForceAbsorbed = 0;
        this.Terrains[0].ProtectionToUnit = 0;
        this.Terrains[0].flags = 0;
        this.Terrains[0].MaxHideSize = 0;
        this.Terrains[0].ExplosionForce = 0;
        this.Terrains[0].ChangesToWhenOpenedOrClosed = 65535;
        this.Terrains[0].ChangesToWhenLockedOrUnlocked = 65535;
        this.Terrains[0].Keys = null;
        this.Terrains[0].VictoryPoints = new int[2];
        this.Terrains[0].VictoryPoints[0] = 0;
        this.Terrains[0].VictoryPoints[1] = 0;
        this.Terrains[0].Morrale = new int[2];
        this.Terrains[0].Morrale[0] = 0;
        this.Terrains[0].Morrale[1] = 0;
        this.Terrains[0].MovementCost = new int[1];
        this.Terrains[0].MovementCost[0] = 4;
        this.Terrains[0].AnnimationPics = null;
        this.Terrains[0].AnnimationTimes = null;
        this.Terrains[0].TargettingAnnimationPics = null;
        this.Terrains[0].TargettingAnnimationTimes = null;
        this.ScenarioName = new String("NEW SCENARIO");
        this.MapHeight = 50;
        this.MapWidth = 80;
        this.MaxNumberOfTurns = 65535;
        this.MaxDifficultyLevel = 0;
        this.NumberOfRegions = 0;
        this.sIntroductionText = new String("");
        this.Map = new int[this.MapHeight * this.MapWidth];
        this.DeploymentMap = new int[this.MapHeight * this.MapWidth];
        Arrays.fill(this.Map, 0);
        Arrays.fill(this.DeploymentMap, 0);
        this.Teams = new EditorTeam[2];
        this.Teams[0] = new EditorTeam();
        this.Teams[0].name = new String("TEAM 1");
        this.Teams[0].flags = 1;
        this.Teams[0].ColourOfBorders = 14;
        this.Teams[0].VictoryPointsForWipeingOutEntirelyTeam = 100;
        this.Teams[0].StartCredits = 200;
        this.Teams[0].CreditsAtDifficultyLevel = null;
        this.Teams[0].MemoryLength = null;
        this.Teams[0].iDeployPic = this.createImage(32, 32);
        this.Teams[0].iDeployPic.getGraphics().setColor(Color.BLACK);
        this.Teams[0].iDeployPic.getGraphics().fillRect(0, 0, 32, 32);
        this.Teams[0].ScannerPic = this.createImage(6, 6);
        this.Teams[0].ScannerPic.getGraphics().setColor(Color.BLACK);
        this.Teams[0].ScannerPic.getGraphics().fillRect(0, 0, 6, 6);
        this.AddImageToScannerPool(this.Teams[0].ScannerPic);
        this.Teams[1] = new EditorTeam();
        this.Teams[1].name = new String("TEAM 2");
        this.Teams[1].flags = 1;
        this.Teams[1].ColourOfBorders = 12;
        this.Teams[1].VictoryPointsForWipeingOutEntirelyTeam = 100;
        this.Teams[1].StartCredits = 200;
        this.Teams[1].CreditsAtDifficultyLevel = null;
        this.Teams[1].MemoryLength = null;
        this.Teams[1].iDeployPic = this.createImage(32, 32);
        this.Teams[1].iDeployPic.getGraphics().setColor(Color.BLACK);
        this.Teams[1].iDeployPic.getGraphics().fillRect(0, 0, 32, 32);
        this.Teams[1].ScannerPic = this.createImage(6, 6);
        this.Teams[1].ScannerPic.getGraphics().setColor(Color.BLACK);
        this.Teams[1].ScannerPic.getGraphics().fillRect(0, 0, 6, 6);
        this.Units = new EditorUnit[0];
        this.GenericItems = new EditorGenericItem[1];
        this.GenericItems[0] = new EditorGenericItem();
        this.GenericItems[0].name = new String("ITEM");
        this.GenericItems[0].MapPic = this.createImage(32, 32);
        this.GenericItems[0].MapPic.getGraphics().setColor(Color.BLACK);
        this.GenericItems[0].MapPic.getGraphics().fillRect(0, 0, 32, 32);
        this.GenericItems[0].TargetPic = this.Terrains[0].MapPic;
        this.AddImageToPool(this.GenericItems[0].MapPic);
        this.GenericItems[0].ScannerPic = this.createImage(6, 6);
        this.GenericItems[0].ScannerPic.getGraphics().setColor(Color.BLACK);
        this.GenericItems[0].ScannerPic.getGraphics().fillRect(0, 0, 6, 6);
        this.AddImageToScannerPool(this.GenericItems[0].ScannerPic);
        this.GenericItems[0].flags = 0;
        this.GenericItems[0].Weight = 0;
        this.GenericItems[0].Size = 0;
        this.GenericItems[0].Strength = 0;
        this.GenericItems[0].ActionPointsToGetPastItem = 0;
        this.GenericItems[0].FractionOfAPsForHTH = 0;
        this.GenericItems[0].BaseAccuracyHTH = 0;
        this.GenericItems[0].BaseDamageHTH = 0;
        this.GenericItems[0].ExtraDamageHTH = 0;
        this.GenericItems[0].ExtraAccuracyHTH = 0;
        this.GenericItems[0].APDivisorSnap = 0;
        this.GenericItems[0].APDivisorAimed = 0;
        this.GenericItems[0].APDivisorAuto = 0;
        this.GenericItems[0].AccuracySnap = 0;
        this.GenericItems[0].AccuracyAimed = 0;
        this.GenericItems[0].AccuracyAuto = 0;
        this.GenericItems[0].DamageShot = 0;
        this.GenericItems[0].Ammo = 0;
        this.GenericItems[0].MaxRange = 0;
        this.GenericItems[0].RangedDifficulty = 0;
        this.GenericItems[0].Cost = new int[2];
        this.GenericItems[0].Cost[0] = 0;
        this.GenericItems[0].Cost[1] = 0;
        this.GenericItems[0].ThreatValue = new int[2];
        this.GenericItems[0].ThreatValue[0] = 0;
        this.GenericItems[0].ThreatValue[1] = 0;
        this.GenericItems[0].HitEffects = new CauseAndEffect(this);
        this.Items = null;
        this.GenericUnits = new EditorGenericUnit[1];
        this.GenericUnits[0] = new EditorGenericUnit(this);
        this.GenericUnits[0].name = new String("UNKNOWN");
        this.GenericUnits[0].DeathPics = null;
        this.GenericUnits[0].GenericItemNumberOfCorpse = -1;
        this.GenericUnits[0].UnitPics = new Image[1][16];
        for (int i = 0; i < 16; ++i) {
            this.GenericUnits[0].UnitPics[0][i] = this.GenericItems[0].MapPic;
        }
        this.GenericUnits[0].Items = new int[1][];
        this.GenericUnits[0].Items[0] = new int[1];
        this.GenericUnits[0].Items[0][0] = 0;
        this.Armours = new EditorArmour[5];
        this.Armours[0] = new EditorArmour();
        this.Armours[0].Front = 0;
        this.Armours[0].Left = 0;
        this.Armours[0].Right = 0;
        this.Armours[0].Rear = 0;
        this.Armours[0].Weight = 0;
        this.Armours[0].Carry = 110;
        this.Armours[0].Cost = new int[2];
        this.Armours[0].Cost[0] = 0;
        this.Armours[0].Cost[1] = 0;
        this.Armours[1] = new EditorArmour();
        this.Armours[1].Front = 10;
        this.Armours[1].Left = 8;
        this.Armours[1].Right = 8;
        this.Armours[1].Rear = 6;
        this.Armours[1].Weight = 1;
        this.Armours[1].Carry = 96;
        this.Armours[1].Cost = new int[2];
        this.Armours[1].Cost[0] = 6;
        this.Armours[1].Cost[1] = 6;
        this.Armours[2] = new EditorArmour();
        this.Armours[2].Front = 20;
        this.Armours[2].Left = 16;
        this.Armours[2].Right = 16;
        this.Armours[2].Rear = 12;
        this.Armours[2].Weight = 2;
        this.Armours[2].Carry = 90;
        this.Armours[2].Cost = new int[2];
        this.Armours[2].Cost[0] = 10;
        this.Armours[2].Cost[1] = 10;
        this.Armours[3] = new EditorArmour();
        this.Armours[3].Front = 30;
        this.Armours[3].Left = 22;
        this.Armours[3].Right = 22;
        this.Armours[3].Rear = 18;
        this.Armours[3].Weight = 4;
        this.Armours[3].Carry = 80;
        this.Armours[3].Cost = new int[2];
        this.Armours[3].Cost[0] = 14;
        this.Armours[3].Cost[1] = 14;
        this.Armours[4] = new EditorArmour();
        this.Armours[4].Front = 40;
        this.Armours[4].Left = 30;
        this.Armours[4].Right = 30;
        this.Armours[4].Rear = 26;
        this.Armours[4].Weight = 2;
        this.Armours[4].Carry = 80;
        this.Armours[4].Cost = new int[2];
        this.Armours[4].Cost[0] = 19;
        this.Armours[4].Cost[1] = 19;
        this.Nodes = null;
        this.NodeLinks = null;
        this.RegionBlocks = null;
        this.RegionNumbers = null;
        this.PreMoveCauseAndEffects = new CauseAndEffect(this);
        this.EndOfTurnCauseAndEffects = new CauseAndEffect(this);
        this.iPathNodeLimit = -1;
        this.SetupEffects = new CauseAndEffect(this);
        this.ExtraPlayerOptions.clear();
        this.AfterPickupItem = new CauseAndEffect(this);
        this.AfterDropItem = new CauseAndEffect(this);
        this.ChangeItem = new CauseAndEffect(this);
        this.EndGameItem = new CauseAndEffect(this);
        this.SelectUnitItem = new CauseAndEffect(this);
        this.ItemDestroyed = new CauseAndEffect(this);
        this.TerrainDestroyed = new CauseAndEffect(this);
        this.CAEArrays = new Vector();
        this.CAERoutines = new Vector();
        this.IHitImages[0] = this.GenericItems[0].MapPic;
        this.IHitImages[1] = this.GenericItems[0].MapPic;
        this.IHitImages[2] = this.GenericItems[0].MapPic;
        this.IHitImages[3] = this.GenericItems[0].MapPic;
        this.IDamageImages[0] = this.GenericItems[0].MapPic;
        this.IDamageImages[1] = this.GenericItems[0].MapPic;
        this.ICursor = this.GenericItems[0].MapPic;
        this.iScenarioFlags = 0;
    }

    private void OpenScenario(String string) {
        this.lsmd = new LoadSaveMessageDialog((Frame)this, "Open scenario", "Opening file.");
        Thread thread = new Thread((Runnable)this, "0" + string);
        thread.start();
        this.lsmd.show();
        this.setTitle("Laser Squad Scenario Editor (" + string + ")");
    }

    private void ImportScenario() {
        Object object;
        File file;
        if (this.debug != null) {
            file = new File(this.debug);
        } else {
            object = new FileDialog((Frame)this, "Select .class file", 0);
            ((FileDialog)object).setFilenameFilter(new LSScenarioEditorFileFilter(".class", (FileDialog)object));
            ((FileDialog)object).setFile("*.class");
            ((Dialog)object).show();
            if (((FileDialog)object).getFile() == null) {
                return;
            }
            file = new File(((FileDialog)object).getDirectory() + ((FileDialog)object).getFile());
        }
        this.lsmd = new LoadSaveMessageDialog((Frame)this, "Import scenario", "Opening file.");
        object = new Thread((Runnable)this, "2" + file.getAbsolutePath());
        ((Thread)object).start();
        this.lsmd.show();
        this.setTitle("Laser Squad Scenario Editor (imported scenario)");
        this.ResetChildren();
        object = new Thread((Runnable)this, "7");
        ((Thread)object).start();
    }

    private void SaveScenario(String string) {
        Object object;
        if (string.equals("")) {
            object = new FileDialog((Frame)this, "Save scenario", 1);
            ((FileDialog)object).setFilenameFilter(new LSScenarioEditorFileFilter(".scenario", (FileDialog)object));
            ((FileDialog)object).setFile("*.scenario");
            ((Dialog)object).show();
            if (((FileDialog)object).getFile() == null) {
                return;
            }
            string = ((FileDialog)object).getDirectory().concat(((FileDialog)object).getFile());
        }
        this.lsmd = new LoadSaveMessageDialog((Frame)this, "Save scenario", "Opening file.");
        object = new Thread((Runnable)this, "1" + string);
        ((Thread)object).start();
        this.lsmd.show();
        this.setTitle("Laser Squad Scenario Editor (" + string + ")");
    }

    private void ExportScenario() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Select .class file", 1);
        fileDialog.setFilenameFilter(new LSScenarioEditorFileFilter(".class", fileDialog));
        fileDialog.setFile("*.class");
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        String string = fileDialog.getDirectory().concat(fileDialog.getFile());
        if (!string.endsWith(".class")) {
            new MessageBox(this, "Export Error", "Must be a .class file.", MessageBox.MB_OK);
            return;
        }
        String string2 = string.substring(0, string.length() - 6);
        if (string2.lastIndexOf(92) != -1) {
            string2 = string2.substring(string2.lastIndexOf(92) + 1);
        }
        if (string2.indexOf(42) != -1 || string2.indexOf(63) != -1 || string2.indexOf(32) != -1) {
            new MessageBox(this, "Export Error", "Can't have a filename\nwith *, ? or a space in it.", MessageBox.MB_OK);
            return;
        }
        this.lsmd = new LoadSaveMessageDialog((Frame)this, "Export scenario", "Opening file.");
        Thread thread = new Thread((Runnable)this, "3" + string.concat("\n").concat(string2));
        thread.start();
        this.lsmd.show();
    }

    protected void CheckAndSaveImagePool() {
        if (!this.bImagePoolsHaveChanged) {
            return;
        }
        while (this.bImagePoolsAreSaveing) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.bImagePoolsAreSaveing = true;
        this.lsmd2 = new LoadSaveMessageDialog((Frame)this, "Working", "Saving image pool.");
        Thread thread = new Thread((Runnable)this, "4");
        thread.start();
    }

    public void run() {
        Object[] objectArray;
        int n;
        int n2;
        Object object;
        int n3;
        Object object2;
        Closeable closeable;
        String string = Thread.currentThread().getName();
        int n4 = string.charAt(0) - 48;
        string = string.substring(1);
        if (n4 == 0 || n4 == 6) {
            Image image;
            Image[] imageArray;
            Image[] imageArray2;
            CauseAndEffect causeAndEffect;
            CauseAndEffect causeAndEffect2;
            CauseAndEffect causeAndEffect3;
            CauseAndEffect causeAndEffect4;
            CauseAndEffect causeAndEffect5;
            CauseAndEffect causeAndEffect6;
            CauseAndEffect causeAndEffect7;
            CauseAndEffect causeAndEffect8;
            int n5;
            CauseAndEffect causeAndEffect9;
            CauseAndEffect causeAndEffect10;
            EditorGenericUnit[] editorGenericUnitArray;
            EditorTerrain[] editorTerrainArray;
            EditorGenericItem[] editorGenericItemArray;
            EditorTeam[] editorTeamArray;
            int[] nArray;
            int[] nArray2;
            String string2;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            closeable = null;
            object2 = null;
            try {
                closeable = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.lsmd.CloseDialog();
                new MessageBox(this, "Open Error", "Can't open file", MessageBox.MB_OK);
                return;
            }
            EditorUnit[] editorUnitArray = new EditorUnit[]{};
            EditorItem[] editorItemArray = null;
            EditorArmour[] editorArmourArray = new EditorArmour[5];
            Point[] pointArray = null;
            Object object3 = null;
            Rectangle[] rectangleArray = null;
            int[] nArray3 = null;
            Vector<Object[]> vector = new Vector<Object[]>();
            Vector<Object[]> vector2 = new Vector<Object[]>();
            Vector<Object[]> vector3 = new Vector<Object[]>();
            this.lsmd.ChangeMessage("Loading data.");
            try {
                n3 = ((FileInputStream)closeable).read();
                n3 <<= 8;
                n3 += ((FileInputStream)closeable).read();
                n3 <<= 8;
                n3 += ((FileInputStream)closeable).read();
                n3 <<= 8;
                object2 = (n3 += ((FileInputStream)closeable).read()) == 0 ? new DataInputStream((InputStream)closeable) : new DataInputStream(new InflaterInputStream((InputStream)closeable));
                object = ((DataInputStream)object2).readUTF();
                if (n3 > 0) {
                    this.iScenarioFlags = ((DataInputStream)object2).readInt();
                }
                n10 = ((DataInputStream)object2).readInt();
                n9 = ((DataInputStream)object2).readInt();
                n8 = ((DataInputStream)object2).readInt();
                n7 = ((DataInputStream)object2).readInt();
                n6 = ((DataInputStream)object2).readInt();
                string2 = ((DataInputStream)object2).readUTF();
                this.lsmd.SetProgres("Loading Map.", 0, 134);
                nArray2 = new int[n10 * n9];
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    nArray2[n2] = ((DataInputStream)object2).readInt();
                }
                this.lsmd.SetPercent(1, 134);
                nArray = new int[n10 * n9];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = ((DataInputStream)object2).readInt();
                }
                this.lsmd.SetProgres("Loading Teams.", 2, 134);
                editorTeamArray = new EditorTeam[((DataInputStream)object2).readInt()];
                for (n2 = 0; n2 < editorTeamArray.length; ++n2) {
                    editorTeamArray[n2] = EditorTeam.read((DataInputStream)object2);
                    this.lsmd.SetPercent(2 + (n2 + n2) / editorTeamArray.length, 134);
                    if (editorTeamArray[n2].ColourOfBorders <= 7) continue;
                    editorTeamArray[n2].ColourOfBorders = (editorTeamArray[n2].ColourOfBorders & 7) + 8;
                }
                this.lsmd.SetProgres("Loading Generic Items.", 4, 134);
                editorGenericItemArray = new EditorGenericItem[((DataInputStream)object2).readInt()];
                for (n2 = 0; n2 < editorGenericItemArray.length; ++n2) {
                    editorGenericItemArray[n2] = EditorGenericItem.read((DataInputStream)object2, this);
                    this.lsmd.SetPercent(4 + n2 * 40 / editorGenericItemArray.length, 134);
                }
                this.lsmd.SetProgres("Loading Units.", 24, 134);
                n2 = ((DataInputStream)object2).readInt();
                if (n2 != 0) {
                    editorUnitArray = new EditorUnit[n2];
                    for (n2 = 0; n2 < editorUnitArray.length; ++n2) {
                        editorUnitArray[n2] = EditorUnit.read((DataInputStream)object2, this);
                        this.lsmd.SetPercent(24 + n2 * 10 / editorUnitArray.length, 134);
                    }
                }
                if ((n2 = ((DataInputStream)object2).readInt()) != 0) {
                    this.lsmd.SetProgres("Loading Items.", 34, 134);
                    editorItemArray = new EditorItem[n2];
                    for (n2 = 0; n2 < editorItemArray.length; ++n2) {
                        editorItemArray[n2] = EditorItem.read((DataInputStream)object2);
                        this.lsmd.SetPercent(34 + n2 * 10 / editorItemArray.length, 134);
                        n = ((DataInputStream)object2).readInt();
                        if (n == -1) continue;
                        editorItemArray[n2].Owner = editorUnitArray[n];
                        if (!((DataInputStream)object2).readBoolean()) continue;
                        editorUnitArray[n].ItemHeld = editorItemArray[n2];
                    }
                }
                for (n2 = 0; n2 < 5; ++n2) {
                    editorArmourArray[n2] = EditorArmour.read((DataInputStream)object2);
                }
                this.lsmd.SetProgres("Loading Terrains.", 44, 134);
                editorTerrainArray = new EditorTerrain[((DataInputStream)object2).readInt()];
                for (n2 = 0; n2 < editorTerrainArray.length; ++n2) {
                    editorTerrainArray[n2] = EditorTerrain.read((DataInputStream)object2);
                    this.lsmd.SetPercent(44 + n2 * 40 / editorTerrainArray.length, 134);
                }
                this.lsmd.SetProgres("Loading Generic Units.", 84, 134);
                editorGenericUnitArray = new EditorGenericUnit[((DataInputStream)object2).readInt()];
                for (n2 = 0; n2 < editorGenericUnitArray.length; ++n2) {
                    editorGenericUnitArray[n2] = EditorGenericUnit.read((DataInputStream)object2, this, this.lsmd, 84 + n2 * 30 / editorGenericUnitArray.length, editorGenericUnitArray.length);
                }
                n2 = ((DataInputStream)object2).readInt();
                if (n2 != 0) {
                    this.lsmd.SetProgres("Loading Nodes.", 114, 134);
                    pointArray = new Point[n2];
                    object3 = new int[n2][];
                    for (n2 = 0; n2 < pointArray.length; ++n2) {
                        pointArray[n2] = new Point();
                        pointArray[n2].x = ((DataInputStream)object2).readInt();
                        pointArray[n2].y = ((DataInputStream)object2).readInt();
                        object3[n2] = ScenarioEditorUtility.ReadArray((DataInputStream)object2);
                        if (object3[n2] != null) continue;
                        object3[n2] = new int[0];
                    }
                }
                this.lsmd.SetProgres("Loading Regions.", 115, 134);
                nArray3 = ScenarioEditorUtility.ReadArray((DataInputStream)object2);
                if (nArray3 != null) {
                    rectangleArray = new Rectangle[nArray3.length];
                    for (n2 = 0; n2 < nArray3.length; ++n2) {
                        rectangleArray[n2] = new Rectangle();
                        rectangleArray[n2].x = ((DataInputStream)object2).readInt();
                        rectangleArray[n2].y = ((DataInputStream)object2).readInt();
                        rectangleArray[n2].width = ((DataInputStream)object2).readInt();
                        rectangleArray[n2].height = ((DataInputStream)object2).readInt();
                        this.lsmd.SetPercent(115 + n2 * 5 / nArray3.length, 134);
                    }
                }
                this.lsmd.SetProgres("Loading Effects.", 120, 134);
                causeAndEffect10 = CauseAndEffect.read((DataInputStream)object2, this);
                this.lsmd.SetPercent(121, 134);
                causeAndEffect9 = CauseAndEffect.read((DataInputStream)object2, this);
                this.lsmd.SetPercent(122, 134);
                n5 = ((DataInputStream)object2).readInt();
                causeAndEffect8 = CauseAndEffect.read((DataInputStream)object2, this);
                this.lsmd.SetPercent(123, 134);
                for (n2 = ((DataInputStream)object2).readInt(); n2 != 0; --n2) {
                    objectArray = new Object[]{((DataInputStream)object2).readUTF(), CauseAndEffect.read((DataInputStream)object2, this), CauseAndEffect.read((DataInputStream)object2, this)};
                    vector.add(objectArray);
                }
                this.lsmd.SetPercent(124, 134);
                causeAndEffect7 = CauseAndEffect.read((DataInputStream)object2, this);
                this.lsmd.SetPercent(125, 134);
                causeAndEffect6 = CauseAndEffect.read((DataInputStream)object2, this);
                this.lsmd.SetPercent(126, 134);
                causeAndEffect5 = CauseAndEffect.read((DataInputStream)object2, this);
                this.lsmd.SetPercent(127, 134);
                causeAndEffect4 = CauseAndEffect.read((DataInputStream)object2, this);
                this.lsmd.SetPercent(128, 134);
                causeAndEffect3 = CauseAndEffect.read((DataInputStream)object2, this);
                this.lsmd.SetPercent(129, 134);
                causeAndEffect2 = CauseAndEffect.read((DataInputStream)object2, this);
                this.lsmd.SetPercent(130, 134);
                causeAndEffect = CauseAndEffect.read((DataInputStream)object2, this);
                if (n3 >= 2) {
                    for (n2 = ((DataInputStream)object2).readInt(); n2 != 0; --n2) {
                        objectArray = new Object[]{new Integer(((DataInputStream)object2).readInt()), ScenarioEditorUtility.ReadArray((DataInputStream)object2)};
                        vector2.add(objectArray);
                    }
                    for (n2 = ((DataInputStream)object2).readInt(); n2 != 0; --n2) {
                        objectArray = new Object[]{((DataInputStream)object2).readUTF(), CauseAndEffect.read((DataInputStream)object2, this)};
                        vector3.add(objectArray);
                    }
                }
                this.lsmd.SetProgres("Loading Images.", 131, 134);
                imageArray2 = ScenarioEditorUtility.ReadMapPicArray((DataInputStream)object2);
                this.lsmd.SetPercent(132, 134);
                imageArray = ScenarioEditorUtility.ReadMapPicArray((DataInputStream)object2);
                this.lsmd.SetPercent(133, 134);
                image = ScenarioEditorUtility.ReadMapImage((DataInputStream)object2);
                this.lsmd.SetPercent(134, 134);
                ((FilterInputStream)object2).close();
                ((FileInputStream)closeable).close();
            }
            catch (IOException iOException) {
                this.lsmd.CloseDialog();
                new MessageBox(this, "Open Error", "Can't read file", MessageBox.MB_OK);
                return;
            }
            this.lsmd.ChangeMessage("Extracting data.");
            this.sFileName = string;
            this.ScenarioName = object;
            this.MapHeight = n10;
            this.MapWidth = n9;
            this.MaxNumberOfTurns = n8;
            this.MaxDifficultyLevel = n7;
            this.NumberOfRegions = n6;
            this.sIntroductionText = string2;
            this.Map = nArray2;
            this.DeploymentMap = nArray;
            this.Teams = editorTeamArray;
            this.GenericItems = editorGenericItemArray;
            this.Units = editorUnitArray;
            this.Items = editorItemArray;
            this.Armours = editorArmourArray;
            this.Terrains = editorTerrainArray;
            this.GenericUnits = editorGenericUnitArray;
            this.Nodes = pointArray;
            this.NodeLinks = object3;
            this.RegionBlocks = rectangleArray;
            this.RegionNumbers = nArray3;
            this.PreMoveCauseAndEffects = causeAndEffect10;
            this.EndOfTurnCauseAndEffects = causeAndEffect9;
            this.iPathNodeLimit = n5;
            this.SetupEffects = causeAndEffect8;
            this.ExtraPlayerOptions = vector;
            this.AfterPickupItem = causeAndEffect7;
            this.AfterDropItem = causeAndEffect6;
            this.ChangeItem = causeAndEffect5;
            this.EndGameItem = causeAndEffect4;
            this.SelectUnitItem = causeAndEffect3;
            this.ItemDestroyed = causeAndEffect2;
            this.TerrainDestroyed = causeAndEffect;
            this.CAEArrays = vector2;
            this.CAERoutines = vector3;
            this.IHitImages = imageArray2;
            this.IDamageImages = imageArray;
            this.ICursor = image;
            this.bHasChanged = false;
            this.ResetChildren();
            System.gc();
            this.lsmd.CloseDialog();
            if (n4 == 0) {
                return;
            }
        }
        if (n4 == 1) {
            objectArray = null;
            try {
                objectArray = new FileOutputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.lsmd.CloseDialog();
                new MessageBox(this, "Save Error", "Can't create output file!", MessageBox.MB_OK);
                return;
            }
            closeable = new DeflaterOutputStream((OutputStream)objectArray);
            object2 = new DataOutputStream((OutputStream)closeable);
            this.lsmd.ChangeMessage("Saving data.");
            try {
                objectArray.write(0);
                objectArray.write(0);
                objectArray.write(0);
                objectArray.write(2);
                ((DataOutputStream)object2).writeUTF(this.ScenarioName);
                ((DataOutputStream)object2).writeInt(this.iScenarioFlags);
                ((DataOutputStream)object2).writeInt(this.MapHeight);
                ((DataOutputStream)object2).writeInt(this.MapWidth);
                ((DataOutputStream)object2).writeInt(this.MaxNumberOfTurns);
                ((DataOutputStream)object2).writeInt(this.MaxDifficultyLevel);
                ((DataOutputStream)object2).writeInt(this.NumberOfRegions);
                ((DataOutputStream)object2).writeUTF(this.sIntroductionText);
                this.lsmd.SetProgres("Saving Map.", 0, 134);
                for (n2 = 0; n2 < this.Map.length; ++n2) {
                    ((DataOutputStream)object2).writeInt(this.Map[n2]);
                }
                this.lsmd.SetPercent(1, 134);
                for (n2 = 0; n2 < this.DeploymentMap.length; ++n2) {
                    ((DataOutputStream)object2).writeInt(this.DeploymentMap[n2]);
                }
                this.lsmd.SetProgres("Saving Teams.", 2, 134);
                ((DataOutputStream)object2).writeInt(this.Teams.length);
                for (n2 = 0; n2 < this.Teams.length; ++n2) {
                    this.Teams[n2].write((DataOutputStream)object2);
                    this.lsmd.SetPercent(2 + (n2 + n2) / this.Teams.length, 134);
                }
                this.lsmd.SetProgres("Saving Generic Items.", 4, 134);
                ((DataOutputStream)object2).writeInt(this.GenericItems.length);
                for (n2 = 0; n2 < this.GenericItems.length; ++n2) {
                    this.GenericItems[n2].write((DataOutputStream)object2);
                    this.lsmd.SetPercent(4 + n2 * 40 / this.GenericItems.length, 134);
                }
                this.lsmd.SetProgres("Saving Units.", 24, 134);
                ((DataOutputStream)object2).writeInt(this.Units.length);
                if (this.Units.length != 0) {
                    for (n2 = 0; n2 < this.Units.length; ++n2) {
                        this.Units[n2].write((DataOutputStream)object2);
                        this.lsmd.SetPercent(24 + n2 * 10 / this.Units.length, 134);
                    }
                }
                ((DataOutputStream)object2).writeInt(this.Items == null ? 0 : this.Items.length);
                this.lsmd.SetProgres("Saving Items.", 34, 134);
                if (this.Items != null) {
                    block37: for (n2 = 0; n2 < this.Items.length; ++n2) {
                        this.Items[n2].write((DataOutputStream)object2);
                        this.lsmd.SetPercent(34 + n2 * 10 / this.Items.length, 134);
                        if (this.Items[n2].Owner == null) {
                            ((DataOutputStream)object2).writeInt(-1);
                            continue;
                        }
                        for (n = 0; n < this.Units.length; ++n) {
                            if (this.Units[n] != this.Items[n2].Owner) continue;
                            ((DataOutputStream)object2).writeInt(n);
                            ((DataOutputStream)object2).writeBoolean(this.Items[n2] == this.Units[n].ItemHeld);
                            continue block37;
                        }
                    }
                }
                for (n2 = 0; n2 < 5; ++n2) {
                    this.Armours[n2].write((DataOutputStream)object2);
                }
                this.lsmd.SetProgres("Saving Terrains.", 44, 134);
                ((DataOutputStream)object2).writeInt(this.Terrains.length);
                for (n2 = 0; n2 < this.Terrains.length; ++n2) {
                    this.Terrains[n2].write((DataOutputStream)object2);
                    this.lsmd.SetPercent(44 + n2 * 40 / this.Terrains.length, 134);
                }
                this.lsmd.SetProgres("Saving Generic Units.", 84, 134);
                ((DataOutputStream)object2).writeInt(this.GenericUnits.length);
                for (n2 = 0; n2 < this.GenericUnits.length; ++n2) {
                    this.GenericUnits[n2].write((DataOutputStream)object2);
                    this.lsmd.SetPercent(84 + n2 * 30 / this.GenericUnits.length, 134);
                }
                this.lsmd.SetProgres("Saving Nodes.", 114, 134);
                ((DataOutputStream)object2).writeInt(this.Nodes == null ? 0 : this.Nodes.length);
                if (this.Nodes != null) {
                    for (n2 = 0; n2 < this.Nodes.length; ++n2) {
                        ((DataOutputStream)object2).writeInt(this.Nodes[n2].x);
                        ((DataOutputStream)object2).writeInt(this.Nodes[n2].y);
                        ScenarioEditorUtility.WriteArray((DataOutputStream)object2, this.NodeLinks[n2]);
                    }
                }
                this.lsmd.SetProgres("Saving Regions.", 115, 134);
                ScenarioEditorUtility.WriteArray((DataOutputStream)object2, this.RegionNumbers);
                if (this.RegionBlocks != null) {
                    for (n2 = 0; n2 < this.RegionBlocks.length; ++n2) {
                        ((DataOutputStream)object2).writeInt(this.RegionBlocks[n2].x);
                        ((DataOutputStream)object2).writeInt(this.RegionBlocks[n2].y);
                        ((DataOutputStream)object2).writeInt(this.RegionBlocks[n2].width);
                        ((DataOutputStream)object2).writeInt(this.RegionBlocks[n2].height);
                        this.lsmd.SetPercent(115 + n2 * 5 / this.RegionNumbers.length, 134);
                    }
                }
                this.lsmd.SetProgres("Saving Effects.", 120, 134);
                this.PreMoveCauseAndEffects.write((DataOutputStream)object2);
                this.lsmd.SetPercent(121, 134);
                this.EndOfTurnCauseAndEffects.write((DataOutputStream)object2);
                this.lsmd.SetPercent(122, 134);
                ((DataOutputStream)object2).writeInt(this.iPathNodeLimit);
                this.SetupEffects.write((DataOutputStream)object2);
                this.lsmd.SetPercent(123, 134);
                ((DataOutputStream)object2).writeInt(this.ExtraPlayerOptions.size());
                if (this.ExtraPlayerOptions.size() > 0) {
                    for (n2 = 0; n2 < this.ExtraPlayerOptions.size(); ++n2) {
                        Object[] objectArray2 = (Object[])this.ExtraPlayerOptions.elementAt(n2);
                        ((DataOutputStream)object2).writeUTF((String)objectArray2[0]);
                        ((CauseAndEffect)objectArray2[1]).write((DataOutputStream)object2);
                        ((CauseAndEffect)objectArray2[2]).write((DataOutputStream)object2);
                    }
                }
                this.lsmd.SetPercent(124, 134);
                this.AfterPickupItem.write((DataOutputStream)object2);
                this.lsmd.SetPercent(125, 134);
                this.AfterDropItem.write((DataOutputStream)object2);
                this.lsmd.SetPercent(126, 134);
                this.ChangeItem.write((DataOutputStream)object2);
                this.lsmd.SetPercent(127, 134);
                this.EndGameItem.write((DataOutputStream)object2);
                this.lsmd.SetPercent(128, 134);
                this.SelectUnitItem.write((DataOutputStream)object2);
                this.lsmd.SetPercent(129, 134);
                this.ItemDestroyed.write((DataOutputStream)object2);
                this.lsmd.SetPercent(130, 134);
                this.TerrainDestroyed.write((DataOutputStream)object2);
                ((DataOutputStream)object2).writeInt(this.CAEArrays.size());
                if (this.CAEArrays.size() > 0) {
                    for (n2 = 0; n2 < this.CAEArrays.size(); ++n2) {
                        Object[] objectArray3 = (Object[])this.CAEArrays.elementAt(n2);
                        ((DataOutputStream)object2).writeInt((Integer)objectArray3[0]);
                        ScenarioEditorUtility.WriteArray((DataOutputStream)object2, (int[])objectArray3[1]);
                    }
                }
                ((DataOutputStream)object2).writeInt(this.CAERoutines.size());
                if (this.CAERoutines.size() > 0) {
                    for (n2 = 0; n2 < this.CAERoutines.size(); ++n2) {
                        Object[] objectArray4 = (Object[])this.CAERoutines.elementAt(n2);
                        ((DataOutputStream)object2).writeUTF((String)objectArray4[0]);
                        ((CauseAndEffect)objectArray4[1]).write((DataOutputStream)object2);
                    }
                }
                this.lsmd.SetProgres("Saving Images.", 131, 134);
                ScenarioEditorUtility.WriteMapPicArray((DataOutputStream)object2, this.IHitImages);
                this.lsmd.SetPercent(132, 134);
                ScenarioEditorUtility.WriteMapPicArray((DataOutputStream)object2, this.IDamageImages);
                this.lsmd.SetPercent(133, 134);
                ScenarioEditorUtility.WriteMapImage((DataOutputStream)object2, this.ICursor);
                this.lsmd.SetPercent(134, 134);
                ((DeflaterOutputStream)closeable).finish();
                objectArray.close();
            }
            catch (IOException iOException) {
                this.lsmd.CloseDialog();
                new MessageBox(this, "Save Error", "Can't write output file!", MessageBox.MB_OK);
                return;
            }
            this.bHasChanged = false;
            this.lsmd.CloseDialog();
            return;
        }
        if (n4 == 2) {
            new ScenarioIO().ImportScenario(this, string, this.lsmd);
            this.lsmd.CloseDialog();
            this.sFileName = new String("");
            System.gc();
            return;
        }
        if (n4 == 3) {
            new ScenarioIO().ExportScenario(this, string.substring(0, string.indexOf(10)), string.substring(string.indexOf(10) + 1, string.length()), this.lsmd);
            this.lsmd.CloseDialog();
            System.gc();
            return;
        }
        if (n4 == 4) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.GetJarPath() + "EditorSettings.dat");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.lsmd2.hide();
                new MessageBox(this, "Close Error", "Failure to create\nEditorSettings.dat.", MessageBox.MB_OK);
                this.bImagePoolsAreSaveing = false;
                this.lsmd2.CloseDialog();
                return;
            }
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(fileOutputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(deflaterOutputStream);
            try {
                fileOutputStream.write(1);
                fileOutputStream.write(0);
                fileOutputStream.write(0);
                fileOutputStream.write(0);
                fileOutputStream.write(0);
                fileOutputStream.write(0);
                fileOutputStream.write(0);
                fileOutputStream.write(0);
                fileOutputStream.write(0);
                fileOutputStream.write(0);
                objectArray = this.GetAllAvailableImages();
                closeable = this.GetAllAvailableScannerImages();
                dataOutputStream.writeInt(objectArray == null ? 0 : objectArray.length);
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        ScenarioEditorUtility.WriteMapImage(dataOutputStream, objectArray[i]);
                        this.lsmd2.SetPercent(i, objectArray.length + ((Closeable)closeable).length);
                    }
                }
                dataOutputStream.writeInt(closeable == null ? 0 : ((Closeable)closeable).length);
                if (closeable != null) {
                    for (int i = 0; i < ((Closeable)closeable).length; ++i) {
                        ScenarioEditorUtility.WriteScannerImage(dataOutputStream, (Image)((Object)closeable[i]));
                        this.lsmd2.SetPercent(i + objectArray.length, objectArray.length + ((Closeable)closeable).length);
                    }
                }
                dataOutputStream.flush();
                deflaterOutputStream.close();
            }
            catch (IOException iOException) {
                this.lsmd2.hide();
                new MessageBox(this, "Close Error", "Failure to save image pool.", MessageBox.MB_OK);
                this.bImagePoolsAreSaveing = false;
                this.lsmd2.CloseDialog();
                return;
            }
            this.bImagePoolsAreSaveing = false;
            this.bImagePoolsHaveChanged = false;
            this.lsmd2.CloseDialog();
            return;
        }
        if (n4 == 5 || n4 == 6) {
            DataInputStream dataInputStream = null;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.GetJarPath() + "EditorSettings.dat");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.bImagePoolsHaveLoaded = true;
                this.lsmd2.CloseDialog();
                this.ImagePool.clear();
                object = this.createImage(32, 32);
                ((Image)object).getGraphics().setColor(Color.BLACK);
                ((Image)object).getGraphics().fillRect(0, 0, 32, 32);
                this.ImagePool.add(object);
                this.ScannerImagePool.clear();
                object = this.createImage(6, 6);
                ((Image)object).getGraphics().setColor(Color.BLACK);
                ((Image)object).getGraphics().fillRect(0, 0, 6, 6);
                this.ScannerImagePool.add(object);
                this.bImagePoolsHaveChanged = true;
                this.CheckAndSaveImagePool();
                return;
            }
            try {
                int n11 = fileInputStream.read();
                fileInputStream.read();
                fileInputStream.read();
                fileInputStream.read();
                fileInputStream.read();
                fileInputStream.read();
                fileInputStream.read();
                fileInputStream.read();
                fileInputStream.read();
                fileInputStream.read();
                dataInputStream = n11 == 0 ? new DataInputStream(fileInputStream) : new DataInputStream(new InflaterInputStream(fileInputStream));
                this.ImagePool.clear();
                n3 = dataInputStream.readInt();
                if (n3 == 0) {
                    object2 = this.createImage(32, 32);
                    ((Image)object2).getGraphics().setColor(Color.BLACK);
                    ((Image)object2).getGraphics().fillRect(0, 0, 32, 32);
                    this.ImagePool.add(object2);
                    this.bImagePoolsHaveChanged = true;
                } else {
                    for (int i = 0; i < n3; ++i) {
                        this.ImagePool.add(ScenarioEditorUtility.ReadMapImage(dataInputStream));
                        this.lsmd2.SetPercent(i * 96 / n3, 100);
                    }
                }
                this.ScannerImagePool.clear();
                n3 = dataInputStream.readInt();
                if (n3 == 0) {
                    Image image = this.createImage(6, 6);
                    image.getGraphics().setColor(Color.BLACK);
                    image.getGraphics().fillRect(0, 0, 6, 6);
                    this.ScannerImagePool.add(image);
                    this.bImagePoolsHaveChanged = true;
                } else {
                    for (int i = 0; i < n3; ++i) {
                        this.ScannerImagePool.add(ScenarioEditorUtility.ReadScannerImage(dataInputStream));
                        this.lsmd2.SetPercent((28 * n3 + i) * 100 / (29 * n3), 100);
                    }
                }
            }
            catch (IOException iOException) {
                this.bImagePoolsHaveLoaded = true;
                this.lsmd2.CloseDialog();
                if (this.ImagePool.isEmpty()) {
                    object = this.createImage(32, 32);
                    ((Image)object).getGraphics().setColor(Color.BLACK);
                    ((Image)object).getGraphics().fillRect(0, 0, 32, 32);
                    this.ImagePool.add(object);
                    this.bImagePoolsHaveChanged = true;
                }
                if (this.ScannerImagePool.isEmpty()) {
                    object = this.createImage(6, 6);
                    ((Image)object).getGraphics().setColor(Color.BLACK);
                    ((Image)object).getGraphics().fillRect(0, 0, 6, 6);
                    this.ScannerImagePool.add(object);
                    this.bImagePoolsHaveChanged = true;
                }
                this.CheckAndSaveImagePool();
                new MessageBox(this, "Startup Error", "Failure to load image pool.", MessageBox.MB_OK);
                return;
            }
            this.bImagePoolsHaveLoaded = true;
            this.lsmd2.CloseDialog();
            this.CheckAndSaveImagePool();
            return;
        }
        if (n4 == 7) {
            while (!this.bImagePoolsHaveLoaded || this.bImagePoolsAreSaveing || !this.bImagePoolsAreUpdated) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.lsmd3 = new LoadSaveMessageDialog((Frame)this, "Image Pool", "Adding new images.");
            this.bImagePoolsAreUpdated = false;
            int n12 = 0;
            while (this.vImagePoolBuffer.size() > 0) {
                this.lsmd3.SetPercent(n12, n12 + this.vImagePoolBuffer.size());
                ++n12;
                Image image = (Image)this.vImagePoolBuffer.remove(0);
                if (image.getWidth(null) == 6) {
                    this.AddImageToScannerPool(image);
                }
                if (image.getWidth(null) != 32) continue;
                this.AddImageToPool(image);
            }
            this.vImagePoolBuffer.clear();
            this.bImagePoolsAreUpdated = true;
            this.lsmd3.CloseDialog();
            this.CheckAndSaveImagePool();
            return;
        }
    }

    protected void AddRegion() {
        ++this.NumberOfRegions;
        if (this.Units.length != 0) {
            for (int i = 0; i < this.Units.length; ++i) {
                this.Units[i].AdjustRegions(-1);
            }
        }
        this.CheckCAEChange(12, -1);
    }

    protected void RemoveRegion(int n) {
        if (this.Units.length != 0) {
            for (int i = 0; i < this.Units.length; ++i) {
                this.Units[i].AdjustRegions(n);
            }
        }
        this.CheckCAEChange(12, n);
    }

    protected void AddNode(Point point) {
        if (this.Nodes == null) {
            this.Nodes = new Point[1];
            this.NodeLinks = new int[1][0];
        } else {
            Point[] pointArray = new Point[this.Nodes.length + 1];
            System.arraycopy(this.Nodes, 0, pointArray, 0, this.Nodes.length);
            this.Nodes = pointArray;
            int[][] nArrayArray = new int[this.Nodes.length][];
            System.arraycopy(this.NodeLinks, 0, nArrayArray, 0, this.NodeLinks.length);
            nArrayArray[this.NodeLinks.length] = new int[0];
            this.NodeLinks = nArrayArray;
        }
        this.Nodes[this.Nodes.length - 1] = point;
    }

    protected void RemoveNode(int n) {
        int n2;
        if (this.Nodes == null) {
            return;
        }
        if (this.Nodes.length == 1) {
            this.Nodes = null;
            this.NodeLinks = null;
            return;
        }
        Point[] pointArray = new Point[this.Nodes.length - 1];
        int[][] nArrayArray = new int[pointArray.length][];
        int n3 = 0;
        for (n2 = 0; n2 < this.Nodes.length; ++n2) {
            int n4;
            if (n2 == n) continue;
            pointArray[n3] = this.Nodes[n2];
            int n5 = 0;
            if (this.NodeLinks[n2].length > 0) {
                for (n4 = 0; n4 < this.NodeLinks[n2].length; ++n4) {
                    if (this.NodeLinks[n2][n4] == n) continue;
                    ++n5;
                }
            }
            nArrayArray[n3] = new int[n5];
            if (n5 > 0) {
                n5 = 0;
                for (n4 = 0; n4 < this.NodeLinks[n2].length; ++n4) {
                    if (this.NodeLinks[n2][n4] < n) {
                        nArrayArray[n3][n5++] = this.NodeLinks[n2][n4];
                    }
                    if (this.NodeLinks[n2][n4] <= n) continue;
                    nArrayArray[n3][n5++] = this.NodeLinks[n2][n4] - 1;
                }
            }
            ++n3;
        }
        this.Nodes = pointArray;
        this.NodeLinks = nArrayArray;
        if (this.Units.length != 0) {
            for (n2 = 0; n2 < this.Units.length; ++n2) {
                this.Units[n2].CheckPatrolRoute(n);
            }
        }
        this.CheckCAEChange(11, n);
    }

    protected void AddGenericItemToPool(EditorGenericItem editorGenericItem) {
        EditorGenericItem[] editorGenericItemArray = new EditorGenericItem[this.GenericItems.length + 1];
        System.arraycopy(this.GenericItems, 0, editorGenericItemArray, 0, this.GenericItems.length);
        editorGenericItemArray[this.GenericItems.length] = editorGenericItem;
        this.GenericItems = editorGenericItemArray;
        for (int i = 0; i < this.GenericUnits.length; ++i) {
            this.GenericUnits[i].Items[0] = ScenarioEditorUtility.arrayAdd(this.GenericUnits[i].Items[0], this.GenericItems.length - 1);
        }
    }

    protected void RemoveGenericItemFromPool(EditorGenericItem editorGenericItem) {
        for (int i = 0; i < this.GenericItems.length; ++i) {
            if (!this.GenericItems[i].equals(editorGenericItem)) continue;
            EditorGenericItem[] editorGenericItemArray = new EditorGenericItem[this.GenericItems.length - 1];
            if (i != 0) {
                System.arraycopy(this.GenericItems, 0, editorGenericItemArray, 0, i);
            }
            if (i != this.GenericItems.length - 1) {
                System.arraycopy(this.GenericItems, i + 1, editorGenericItemArray, i, this.GenericItems.length - i - 1);
            }
            this.GenericItems = editorGenericItemArray;
            for (int j = 0; j < this.GenericUnits.length; ++j) {
                for (int k = 0; k < this.GenericUnits[j].Items.length; ++k) {
                    this.GenericUnits[j].Items[k] = ScenarioEditorUtility.arrayDeleteItem(this.GenericUnits[j].Items[k], i);
                    if (this.GenericUnits[j].Items[k].length <= 0) continue;
                    for (int i2 = 0; i2 < this.GenericUnits[j].Items[k].length; ++i2) {
                        if (this.GenericUnits[j].Items[k][i2] <= i) continue;
                        int[] nArray = this.GenericUnits[j].Items[k];
                        int n = i2;
                        nArray[n] = nArray[n] - 1;
                    }
                }
            }
            return;
        }
    }

    protected void AddItemToPool(EditorItem editorItem) {
        if (this.Items == null) {
            this.Items = new EditorItem[1];
            this.Items[0] = editorItem;
            return;
        }
        EditorItem[] editorItemArray = new EditorItem[this.Items.length + 1];
        System.arraycopy(this.Items, 0, editorItemArray, 0, this.Items.length);
        editorItemArray[this.Items.length] = editorItem;
        this.Items = editorItemArray;
    }

    protected void RemoveItemFromPool(int n) {
        if (this.Items.length == 1) {
            this.Items = null;
            return;
        }
        EditorItem[] editorItemArray = new EditorItem[this.Items.length - 1];
        if (n != 0) {
            System.arraycopy(this.Items, 0, editorItemArray, 0, n);
        }
        if (n != this.Items.length - 1) {
            System.arraycopy(this.Items, n + 1, editorItemArray, n, this.Items.length - n - 1);
        }
        this.Items = editorItemArray;
    }

    protected int GetTerrainAt(int n, int n2) {
        if (this.Items != null) {
            for (int i = 0; i < this.Items.length; ++i) {
                if (this.Items[i].Position.x != n || this.Items[i].Position.y != n2 || this.Items[i].TerrainUnder >= this.Terrains.length) continue;
                return this.Items[i].TerrainUnder;
            }
        }
        return this.Map[n + n2 * this.MapWidth];
    }

    protected void AddTerrainToPool(EditorTerrain editorTerrain) {
        EditorTerrain[] editorTerrainArray = new EditorTerrain[this.Terrains.length + 1];
        System.arraycopy(this.Terrains, 0, editorTerrainArray, 0, this.Terrains.length);
        editorTerrainArray[this.Terrains.length] = editorTerrain;
        this.Terrains = editorTerrainArray;
    }

    protected void RemoveTerrainFromPool(EditorTerrain editorTerrain) {
        for (int i = 0; i < this.Terrains.length; ++i) {
            if (!this.Terrains[i].equals(editorTerrain)) continue;
            EditorTerrain[] editorTerrainArray = new EditorTerrain[this.Terrains.length - 1];
            if (i != 0) {
                System.arraycopy(this.Terrains, 0, editorTerrainArray, 0, i);
            }
            if (i != this.Terrains.length - 1) {
                System.arraycopy(this.Terrains, i + 1, editorTerrainArray, i, this.Terrains.length - i - 1);
            }
            this.Terrains = editorTerrainArray;
            return;
        }
    }

    protected Image[] GetAllAvailableImages() {
        Image[] imageArray = new Image[this.ImagePool.size()];
        for (int i = 0; i < imageArray.length; ++i) {
            imageArray[i] = (Image)this.ImagePool.elementAt(i);
        }
        return imageArray;
    }

    protected void AddImageToPool(Image image) {
        for (int i = 0; i < this.ImagePool.size(); ++i) {
            if (!ScenarioEditorUtility.ImagesIdentical(image, (Image)this.ImagePool.elementAt(i))) continue;
            return;
        }
        this.ImagePool.add(image);
        this.bImagePoolsHaveChanged = true;
    }

    protected void DeleteImageFromPool(Image image) {
        for (int i = 0; i < this.ImagePool.size(); ++i) {
            if (!ScenarioEditorUtility.ImagesIdentical(image, (Image)this.ImagePool.elementAt(i))) continue;
            this.ImagePool.removeElementAt(i);
            this.bImagePoolsHaveChanged = true;
            return;
        }
    }

    protected Image[] GetAllAvailableScannerImages() {
        Image[] imageArray = new Image[this.ScannerImagePool.size()];
        for (int i = 0; i < imageArray.length; ++i) {
            imageArray[i] = (Image)this.ScannerImagePool.elementAt(i);
        }
        return imageArray;
    }

    protected void DeleteImageFromScannerPool(Image image) {
        for (int i = 0; i < this.ScannerImagePool.size(); ++i) {
            if (!ScenarioEditorUtility.ScannerImagesIdentical(image, (Image)this.ScannerImagePool.elementAt(i))) continue;
            this.ScannerImagePool.removeElementAt(i);
            this.bImagePoolsHaveChanged = true;
            return;
        }
    }

    protected void AddImageToScannerPool(Image image) {
        for (int i = 0; i < this.ScannerImagePool.size(); ++i) {
            if (!ScenarioEditorUtility.ScannerImagesIdentical(image, (Image)this.ScannerImagePool.elementAt(i))) continue;
            return;
        }
        this.ScannerImagePool.add(image);
        this.bImagePoolsHaveChanged = true;
    }

    protected void DelayedAddImageToPool(Image image) {
        if (this.bImportImages) {
            this.vImagePoolBuffer.add(image);
        }
    }

    private void ChangeEditorSheet(int n) {
        if (this.ViewPoint == n) {
            return;
        }
        switch (this.ViewPoint) {
            case 0: {
                this.remove(this.MapSheet);
                this.MapSheet = null;
                break;
            }
            case 1: {
                this.remove(this.UnitSheet);
                this.UnitSheet = null;
                break;
            }
            case 2: {
                this.remove(this.ItemSheet);
                this.ItemSheet = null;
                break;
            }
            case 3: {
                this.remove(this.TeamSheet);
                this.TeamSheet = null;
                break;
            }
            case 4: {
                this.remove(this.ScenarioSheet);
                this.ScenarioSheet = null;
                break;
            }
            case 5: {
                this.remove(this.TerrainsSheet);
                this.TerrainsSheet = null;
                break;
            }
            case 6: {
                this.remove(this.GenericUnitSheet);
                this.GenericUnitSheet = null;
                break;
            }
            case 7: {
                this.remove(this.GenericItemsSheet);
                this.GenericItemsSheet = null;
                break;
            }
            case 8: {
                this.remove(this.RegionSheet);
                this.RegionSheet = null;
                break;
            }
            case 9: {
                this.remove(this.NodeSheet);
                this.NodeSheet = null;
            }
        }
        switch (n) {
            case 0: {
                this.MapSheet = new MapEditor(this);
                this.add("Center", this.MapSheet);
                break;
            }
            case 1: {
                this.UnitSheet = new UnitEditor(this);
                this.add("Center", this.UnitSheet);
                break;
            }
            case 2: {
                this.ItemSheet = new ItemEditor(this);
                this.add("Center", this.ItemSheet);
                break;
            }
            case 3: {
                this.TeamSheet = new TeamEditor(this);
                this.add("Center", this.TeamSheet);
                break;
            }
            case 4: {
                this.ScenarioSheet = new ScenarioEditor(this);
                this.add("Center", this.ScenarioSheet);
                break;
            }
            case 5: {
                this.TerrainsSheet = new TerrainEditor(this);
                this.add("Center", this.TerrainsSheet);
                break;
            }
            case 6: {
                this.GenericUnitSheet = new GenericUnitEditor(this);
                this.add("Center", this.GenericUnitSheet);
                break;
            }
            case 7: {
                this.GenericItemsSheet = new GenericItemEditor(this);
                this.add("Center", this.GenericItemsSheet);
                break;
            }
            case 8: {
                this.RegionSheet = new RegionEditor(this);
                this.add("Center", this.RegionSheet);
                break;
            }
            case 9: {
                this.NodeSheet = new NodeEditor(this);
                this.add("Center", this.NodeSheet);
            }
        }
        this.ViewPoint = n;
        this.validate();
        this.repaint();
    }

    protected void ResetChildren() {
        switch (this.ViewPoint) {
            case 0: {
                this.MapSheet.reset();
                break;
            }
            case 1: {
                this.UnitSheet.reset();
                break;
            }
            case 2: {
                this.ItemSheet.reset();
                break;
            }
            case 3: {
                this.TeamSheet.reset();
                break;
            }
            case 4: {
                this.remove(this.ScenarioSheet);
                this.ScenarioSheet = null;
                this.ScenarioSheet = new ScenarioEditor(this);
                this.add("Center", this.ScenarioSheet);
                this.validate();
                this.repaint();
                break;
            }
            case 5: {
                this.TerrainsSheet.Reset();
                break;
            }
            case 6: {
                this.GenericUnitSheet.reset();
                break;
            }
            case 7: {
                this.remove(this.GenericItemsSheet);
                this.GenericItemsSheet = null;
                this.GenericItemsSheet = new GenericItemEditor(this);
                this.add("Center", this.GenericItemsSheet);
                this.validate();
                this.repaint();
                break;
            }
            case 8: {
                this.RegionSheet.reset();
                break;
            }
            case 9: {
                this.NodeSheet.reset();
                break;
            }
        }
    }

    protected void CheckCAEChange(int n, int n2) {
        int n3;
        this.PreMoveCauseAndEffects.CheckCAEChange(n, n2);
        this.EndOfTurnCauseAndEffects.CheckCAEChange(n, n2);
        this.SetupEffects.CheckCAEChange(n, n2);
        if (this.ExtraPlayerOptions.size() > 0) {
            for (n3 = 0; n3 < this.ExtraPlayerOptions.size(); ++n3) {
                ((CauseAndEffect)((Object[])this.ExtraPlayerOptions.elementAt(n3))[1]).CheckCAEChange(n, n2);
                ((CauseAndEffect)((Object[])this.ExtraPlayerOptions.elementAt(n3))[2]).CheckCAEChange(n, n2);
            }
        }
        this.AfterPickupItem.CheckCAEChange(n, n2);
        this.AfterDropItem.CheckCAEChange(n, n2);
        this.ChangeItem.CheckCAEChange(n, n2);
        this.EndGameItem.CheckCAEChange(n, n2);
        this.SelectUnitItem.CheckCAEChange(n, n2);
        for (n3 = 0; n3 < this.GenericItems.length; ++n3) {
            this.GenericItems[n3].HitEffects.CheckCAEChange(n, n2);
        }
        if (this.Units.length > 0) {
            for (n3 = 0; n3 < this.Units.length; ++n3) {
                this.Units[n3].DeathEffects.CheckCAEChange(n, n2);
            }
        }
        this.ItemDestroyed.CheckCAEChange(n, n2);
        this.TerrainDestroyed.CheckCAEChange(n, n2);
    }

    protected void GetTargetTerrains(int n, int[][] nArray, Point[][] pointArray) {
        int n2;
        int[][] nArray2 = new int[3][0];
        if (this.Units.length > 0) {
            for (n2 = 0; n2 < this.Units.length; ++n2) {
                this.Units[n2].GetTargetTerrains(n, nArray2);
            }
        }
        this.PreMoveCauseAndEffects.GetTargetTerrains(n, nArray2);
        this.EndOfTurnCauseAndEffects.GetTargetTerrains(n, nArray2);
        this.SetupEffects.GetTargetTerrains(n, nArray2);
        if (this.ExtraPlayerOptions.size() > 0) {
            for (n2 = 0; n2 < this.ExtraPlayerOptions.size(); ++n2) {
                ((CauseAndEffect)((Object[])this.ExtraPlayerOptions.elementAt(n2))[1]).GetTargetTerrains(n, nArray2);
                ((CauseAndEffect)((Object[])this.ExtraPlayerOptions.elementAt(n2))[2]).GetTargetTerrains(n, nArray2);
            }
        }
        this.AfterPickupItem.GetTargetTerrains(n, nArray2);
        this.AfterDropItem.GetTargetTerrains(n, nArray2);
        this.ChangeItem.GetTargetTerrains(n, nArray2);
        this.EndGameItem.GetTargetTerrains(n, nArray2);
        this.SelectUnitItem.GetTargetTerrains(n, nArray2);
        for (n2 = 0; n2 < this.GenericItems.length; ++n2) {
            this.GenericItems[n2].HitEffects.GetTargetTerrains(n, nArray2);
        }
        if (this.Units.length > 0) {
            for (n2 = 0; n2 < this.Units.length; ++n2) {
                this.Units[n2].DeathEffects.GetTargetTerrains(n, nArray2);
            }
        }
        this.ItemDestroyed.GetTargetTerrains(n, nArray2);
        this.TerrainDestroyed.GetTargetTerrains(n, nArray2);
        if (nArray2[0].length == 0) {
            nArray[n] = null;
            pointArray[n] = null;
            return;
        }
        nArray[n] = new int[nArray2[0].length];
        System.arraycopy(nArray2[0], 0, nArray[n], 0, nArray2[0].length);
        pointArray[n] = new Point[nArray2[0].length];
        for (n2 = 0; n2 < pointArray[n].length; ++n2) {
            pointArray[n][n2] = new Point(nArray2[1][n2], nArray2[2][n2]);
        }
    }

    private String GetJarPath() {
        this.getClass().getClassLoader();
        String string = ClassLoader.getSystemResource("LaserSquadScenarioEditor.class").toString();
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        string = string.substring(string.indexOf("file:/") + (System.getProperty("os.name").equals("Linux") ? 5 : 6));
        int n = string.indexOf("LaserSquadScenarioEditor.jar!/LaserSquadScenarioEditor.class");
        if (n != -1 && n == string.length() - 60) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("LaserSquadScenarioEditor.class")) != -1 && n == string.length() - 30) {
            string = string.substring(0, n);
        }
        return string;
    }

    public void CloseEditor() {
        if (!this.bImagePoolsAreUpdated) {
            this.lsmd3.show();
            this.CheckAndSaveImagePool();
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.bImagePoolsAreSaveing) {
            this.lsmd2.show();
            while (this.bImagePoolsAreSaveing) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.GetJarPath() + "EditorSettings.dat", "rw");
            randomAccessFile.seek(1L);
            int n = this.bImportImages ? 1 : 0;
            n += this.bRememberState ? 2 : 0;
            switch (this.getExtendedState()) {
                case 1: {
                    n += 4;
                    break;
                }
                case 6: {
                    n += 8;
                }
            }
            randomAccessFile.writeByte(n);
            Rectangle rectangle = this.getBounds();
            randomAccessFile.writeInt(rectangle.x);
            randomAccessFile.writeInt(rectangle.y);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(0);
    }

    public void StartEditor(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null) {
            this.lsmd = new LoadSaveMessageDialog((Frame)this, "Open scenario", "Opening file.");
        }
        this.lsmd2 = new LoadSaveMessageDialog((Frame)this, "Opening", "Loading image pool.");
        Thread thread = new Thread((Runnable)this, string == null ? "5" : "6" + string);
        thread.start();
        if (string != null) {
            this.lsmd.show();
            this.setTitle("Laser Squad Scenario Editor (" + string + ")");
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.CloseEditor();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("New Scenario")) {
            if (this.bHasChanged) {
                MessageBox messageBox = new MessageBox(this, "Warning!", "Creating new scenario will loose current changes.\nDo you want to save file before loading?", MessageBox.MB_YES + MessageBox.MB_NO + MessageBox.MB_CANCEL);
                if (messageBox.returnValue == MessageBox.MB_CANCEL) {
                    return;
                }
                if (messageBox.returnValue == MessageBox.MB_YES) {
                    this.SaveScenario(this.sFileName);
                }
            }
            this.NewScenario();
            this.ResetChildren();
            this.repaint();
            return;
        }
        if (actionEvent.getActionCommand().equals("Open Scenario")) {
            Dialog dialog;
            if (this.bHasChanged) {
                dialog = new MessageBox(this, "Warning!", "Opening scenario will loose current changes.\nDo you want to save file before loading?", MessageBox.MB_YES + MessageBox.MB_NO + MessageBox.MB_CANCEL);
                if (((MessageBox)dialog).returnValue == MessageBox.MB_CANCEL) {
                    return;
                }
                if (((MessageBox)dialog).returnValue == MessageBox.MB_YES) {
                    this.SaveScenario(this.sFileName);
                }
            }
            dialog = new FileDialog((Frame)this, "Select .scenario file", 0);
            ((FileDialog)dialog).setFilenameFilter(new LSScenarioEditorFileFilter(".scenario", (FileDialog)dialog));
            ((FileDialog)dialog).setFile("*.scenario");
            dialog.show();
            if (((FileDialog)dialog).getFile() == null) {
                return;
            }
            this.OpenScenario(((FileDialog)dialog).getDirectory() + ((FileDialog)dialog).getFile());
            return;
        }
        if (actionEvent.getActionCommand().equals("Save")) {
            this.SaveScenario(this.sFileName);
        }
        if (actionEvent.getActionCommand().equals("Save As")) {
            this.SaveScenario("");
        }
        if (actionEvent.getActionCommand().equals("Import Scenario")) {
            if (this.bHasChanged) {
                MessageBox messageBox = new MessageBox(this, "Warning!", "Importing scenario will loose current changes.\nDo you want to save file before loading?", MessageBox.MB_YES + MessageBox.MB_NO + MessageBox.MB_CANCEL);
                if (messageBox.returnValue == MessageBox.MB_CANCEL) {
                    return;
                }
                if (messageBox.returnValue == MessageBox.MB_YES) {
                    this.SaveScenario(this.sFileName);
                }
            }
            this.ImportScenario();
            this.repaint();
            return;
        }
        if (actionEvent.getActionCommand().equals("Export Scenario")) {
            this.ExportScenario();
        }
        if (actionEvent.getActionCommand().equals("Exit")) {
            this.CloseEditor();
            return;
        }
        if (actionEvent.getActionCommand().equals("Map")) {
            this.ChangeEditorSheet(0);
            return;
        }
        if (actionEvent.getActionCommand().equals("Units")) {
            this.ChangeEditorSheet(1);
            return;
        }
        if (actionEvent.getActionCommand().equals("Items")) {
            this.ChangeEditorSheet(2);
            return;
        }
        if (actionEvent.getActionCommand().equals("Teams")) {
            this.ChangeEditorSheet(3);
            return;
        }
        if (actionEvent.getActionCommand().equals("Scenario Details")) {
            this.ChangeEditorSheet(4);
            return;
        }
        if (actionEvent.getActionCommand().equals("Terrains")) {
            this.ChangeEditorSheet(5);
            return;
        }
        if (actionEvent.getActionCommand().equals("Generic Units")) {
            this.ChangeEditorSheet(6);
            return;
        }
        if (actionEvent.getActionCommand().equals("Generic Items")) {
            this.ChangeEditorSheet(7);
            return;
        }
        if (actionEvent.getActionCommand().equals("Regions")) {
            this.ChangeEditorSheet(8);
            return;
        }
        if (actionEvent.getActionCommand().equals("Nodes")) {
            this.ChangeEditorSheet(9);
            return;
        }
    }

    public boolean accept(File file, String string) {
        Class<?> clazz;
        if (!string.toLowerCase().endsWith(".class")) {
            return false;
        }
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            return false;
        }
        return clazz.getSuperclass().getName().equals("LaserSquadScenarioFile");
    }

    protected void SetClipboardContent(Image image) {
        this.clipImg = new ClipboardImage(image);
        this.getToolkit().getSystemClipboard().setContents(this.clipImg, this);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.clipImg = null;
    }

    public static void main(String[] stringArray) {
        LaserSquadScenarioEditor laserSquadScenarioEditor = new LaserSquadScenarioEditor();
        laserSquadScenarioEditor.show();
        if (stringArray.length > 0) {
            String string = new String();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    string = string.concat(" ");
                }
                string = string.concat(stringArray[i]);
            }
            laserSquadScenarioEditor.StartEditor(string);
        } else {
            laserSquadScenarioEditor.StartEditor(null);
        }
        if (laserSquadScenarioEditor.debug != null) {
            laserSquadScenarioEditor.ImportScenario();
            laserSquadScenarioEditor.ChangeEditorSheet(5);
            laserSquadScenarioEditor.repaint();
            laserSquadScenarioEditor.debug = null;
        }
    }
}

