/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

class MapEditor
extends Panel
implements ActionListener {
    private LaserSquadScenarioEditor lsse;
    private TerrainSelector ts;
    private TerrainDisplay td;
    private Button but;

    public MapEditor(LaserSquadScenarioEditor laserSquadScenarioEditor) {
        this.lsse = laserSquadScenarioEditor;
        this.td = new TerrainDisplay(this.lsse, this);
        this.add(this.td);
        this.ts = new TerrainSelector(this.lsse, this, 0);
        this.add(this.ts);
        this.but = new Button("Change to Target View");
        this.but.addActionListener(this);
        this.add(this.but);
    }

    protected void reset() {
        this.but.setLabel("Change to Target View");
        this.td.reset();
        this.ts.reset();
        this.repaint();
    }

    protected void updateDimensions() {
        this.td.updateDimensions();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, 0, n, n2);
        this.td.setBounds(0, 0, n - 181, n2);
        this.td.repaint();
        graphics.setColor(Color.BLACK);
        graphics.setFont(LaserSquadScenarioEditor.font);
        Point point = this.td.getPos();
        graphics.draw3DRect(n - 176, 17, 150, 36, false);
        if (point != null) {
            graphics.drawString("Terrain at " + point.x + "," + point.y + ":", n - 176, 14);
            StringTokenizer stringTokenizer = new StringTokenizer(this.lsse.Terrains[this.lsse.GetTerrainAt((int)point.x, (int)point.y)].name, "//", false);
            if (stringTokenizer.hasMoreTokens()) {
                graphics.drawString(stringTokenizer.nextToken(), n - 172, 31);
            }
            if (stringTokenizer.hasMoreTokens()) {
                graphics.drawString(stringTokenizer.nextToken(), n - 172, 47);
            }
        } else {
            graphics.drawString("Terrain:", n - 176, 14);
        }
        this.but.setBounds(n - 176, 58, 170, 30);
        n2 -= 93;
        this.ts.setBounds(n - 176, 93, 174, (n2 /= 34) * 34);
    }

    protected void NotifyClick(Rectangle rectangle) {
        Point point = new Point();
        int n = this.ts.GetPointer();
        for (int i = 0; i < rectangle.width; i += 32) {
            for (int j = 0; j < rectangle.height; j += 32) {
                point.setLocation((i + rectangle.x) / 32, (j + rectangle.y) / 32);
                if (this.lsse.Items != null) {
                    for (int k = 0; k < this.lsse.Items.length; ++k) {
                        if (!this.lsse.Items[k].Position.equals(point)) continue;
                        this.lsse.Items[k].TerrainUnder = n;
                    }
                }
                if (this.lsse.Map[point.x + point.y * this.lsse.MapWidth] >= this.lsse.Terrains.length) continue;
                this.lsse.Map[point.x + point.y * this.lsse.MapWidth] = n;
            }
        }
        this.repaint();
        this.td.repaint();
    }

    protected int GetSelectedTerrain() {
        return this.ts.GetPointer();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Change to Target View")) {
            this.but.setLabel("Change to Terrain View");
            this.td.bShowTerrain = false;
            this.td.RepaintOffScreenImage();
            this.td.repaint();
        } else {
            this.but.setLabel("Change to Target View");
            this.td.bShowTerrain = true;
            this.td.RepaintOffScreenImage();
            this.td.repaint();
        }
    }
}

