/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;

class MapResizer
extends Dialog
implements ActionListener,
KeyListener {
    private LaserSquadScenarioEditor lsse;
    private int job;
    private TextField tf = new TextField("", 4);
    protected int TerrainToInsert = -1;

    public MapResizer(LaserSquadScenarioEditor laserSquadScenarioEditor, int n, int n2, int n3) {
        super(laserSquadScenarioEditor, ((n & 2) == 0 ? "Insert" : "Delete") + " a " + ((n & 1) == 0 ? "Row" : "Column"), true);
        this.TerrainToInsert = n3;
        this.setBounds(laserSquadScenarioEditor.getInsets().left + laserSquadScenarioEditor.getX(), laserSquadScenarioEditor.getInsets().top + laserSquadScenarioEditor.getY(), 560, 400);
        this.setLayout(new GridLayout(0, 1));
        this.lsse = laserSquadScenarioEditor;
        this.job = n;
        switch (this.job) {
            case 0: {
                this.add(new Label("Enter Y value at which to insert a Row:"));
                break;
            }
            case 1: {
                this.add(new Label("Enter X value at which to insert a Column:"));
                break;
            }
            case 2: {
                this.add(new Label("Enter Y value at which to delete a Row:"));
                break;
            }
            default: {
                this.add(new Label("Enter X value at which to delete a Column:"));
            }
        }
        this.tf.addKeyListener(this);
        this.tf.setText(Integer.toString(n2));
        this.add(this.tf);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        Button button = new Button("Ok");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Cancel");
        button.addActionListener(this);
        panel.add(button);
        this.add(panel);
        this.pack();
        this.show();
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) && c != '\b') {
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Ok")) {
            int n = -1;
            try {
                n = Integer.parseInt(this.tf.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n < 0) {
                new MessageBox(this.lsse, "Invalid number", "Value must be a positive integer.", MessageBox.MB_OK);
                return;
            }
            int n2 = 0;
            int n3 = 0;
            switch (this.job) {
                case 0: {
                    if (n > this.lsse.MapHeight) {
                        new MessageBox(this.lsse, "Invalid number", "Can't be greater than number of Rows.", MessageBox.MB_OK);
                        return;
                    }
                    int[] nArray = new int[this.lsse.Map.length + this.lsse.MapWidth];
                    if (n != 0) {
                        System.arraycopy(this.lsse.Map, 0, nArray, 0, n * this.lsse.MapWidth);
                    }
                    if (n != this.lsse.MapHeight) {
                        System.arraycopy(this.lsse.Map, n * this.lsse.MapWidth, nArray, (n + 1) * this.lsse.MapWidth, (this.lsse.MapHeight - n) * this.lsse.MapWidth);
                    }
                    this.lsse.Map = nArray;
                    Arrays.fill(this.lsse.Map, n * this.lsse.MapWidth, (n + 1) * this.lsse.MapWidth, this.TerrainToInsert);
                    nArray = new int[this.lsse.DeploymentMap.length + this.lsse.MapWidth];
                    if (n != 0) {
                        System.arraycopy(this.lsse.DeploymentMap, 0, nArray, 0, n * this.lsse.MapWidth);
                    }
                    if (n != this.lsse.MapHeight) {
                        System.arraycopy(this.lsse.DeploymentMap, n * this.lsse.MapWidth, nArray, (n + 1) * this.lsse.MapWidth, (this.lsse.MapHeight - n) * this.lsse.MapWidth);
                    }
                    this.lsse.DeploymentMap = nArray;
                    if (this.lsse.Items != null) {
                        for (n2 = 0; n2 < this.lsse.Items.length; ++n2) {
                            if (this.lsse.Items[n2].Owner != null || this.lsse.Items[n2].Position.x == -1 || this.lsse.Items[n2].Position.y < n) continue;
                            ++this.lsse.Items[n2].Position.y;
                        }
                    }
                    if (this.lsse.Units.length != 0) {
                        for (n2 = 0; n2 < this.lsse.Units.length; ++n2) {
                            this.lsse.Units[n2].CheckDeploy(0, n);
                        }
                    }
                    n *= 32;
                    if (this.lsse.RegionBlocks != null) {
                        for (n2 = 0; n2 < this.lsse.RegionBlocks.length; ++n2) {
                            if (this.lsse.RegionBlocks[n2].y >= n) {
                                this.lsse.RegionBlocks[n2].y += 32;
                                continue;
                            }
                            if (this.lsse.RegionBlocks[n2].y + this.lsse.RegionBlocks[n2].height <= n) continue;
                            this.lsse.RegionBlocks[n2].height += 32;
                        }
                    }
                    n /= 32;
                    if (this.lsse.Nodes != null) {
                        for (n2 = 0; n2 < this.lsse.Nodes.length; ++n2) {
                            if (this.lsse.Nodes[n2].y < n) continue;
                            ++this.lsse.Nodes[n2].y;
                        }
                    }
                    this.lsse.CheckCAEChange(7, n);
                    ++this.lsse.MapHeight;
                    break;
                }
                case 1: {
                    int n4;
                    int n5;
                    if (n > this.lsse.MapWidth) {
                        new MessageBox(this.lsse, "Invalid number", "Can't be greater than number of Columns.", MessageBox.MB_OK);
                        return;
                    }
                    int[] nArray = new int[this.lsse.Map.length + this.lsse.MapHeight];
                    for (n5 = 0; n5 < this.lsse.MapHeight; ++n5) {
                        for (n4 = 0; n4 < this.lsse.MapWidth; ++n4) {
                            if (n4 == n) {
                                nArray[n3++] = this.TerrainToInsert;
                            }
                            nArray[n3++] = this.lsse.Map[n2++];
                        }
                        if (n4 != n) continue;
                        nArray[n3++] = this.TerrainToInsert;
                    }
                    this.lsse.Map = nArray;
                    nArray = new int[this.lsse.DeploymentMap.length + this.lsse.MapHeight];
                    n2 = 0;
                    n3 = 0;
                    for (n5 = 0; n5 < this.lsse.MapHeight; ++n5) {
                        for (n4 = 0; n4 < this.lsse.MapWidth; ++n4) {
                            if (n4 == n) {
                                nArray[n3++] = 0;
                            }
                            nArray[n3++] = this.lsse.DeploymentMap[n2++];
                        }
                        if (n4 != n) continue;
                        nArray[n3++] = 0;
                    }
                    this.lsse.DeploymentMap = nArray;
                    if (this.lsse.Items != null) {
                        for (n2 = 0; n2 < this.lsse.Items.length; ++n2) {
                            if (this.lsse.Items[n2].Owner != null || this.lsse.Items[n2].Position.x < n || this.lsse.Items[n2].Position.y == -1) continue;
                            ++this.lsse.Items[n2].Position.x;
                        }
                    }
                    if (this.lsse.Units.length != 0) {
                        for (n2 = 0; n2 < this.lsse.Units.length; ++n2) {
                            this.lsse.Units[n2].CheckDeploy(1, n);
                        }
                    }
                    n *= 32;
                    if (this.lsse.RegionBlocks != null) {
                        for (n2 = 0; n2 < this.lsse.RegionBlocks.length; ++n2) {
                            if (this.lsse.RegionBlocks[n2].x >= n) {
                                this.lsse.RegionBlocks[n2].x += 32;
                                continue;
                            }
                            if (this.lsse.RegionBlocks[n2].x + this.lsse.RegionBlocks[n2].width <= n) continue;
                            this.lsse.RegionBlocks[n2].width += 32;
                        }
                    }
                    n /= 32;
                    if (this.lsse.Nodes != null) {
                        for (n2 = 0; n2 < this.lsse.Nodes.length; ++n2) {
                            if (this.lsse.Nodes[n2].x < n) continue;
                            ++this.lsse.Nodes[n2].x;
                        }
                    }
                    this.lsse.CheckCAEChange(8, n);
                    ++this.lsse.MapWidth;
                    break;
                }
                case 2: {
                    int n6;
                    int n7;
                    if (n > this.lsse.MapHeight - 1) {
                        new MessageBox(this.lsse, "Invalid number", "Can't be greater than number of Rows.", MessageBox.MB_OK);
                        return;
                    }
                    int[] nArray = new int[this.lsse.Map.length - this.lsse.MapWidth];
                    for (n7 = 0; n7 < this.lsse.MapHeight; ++n7) {
                        if (n7 == n) {
                            n2 += this.lsse.MapWidth;
                            continue;
                        }
                        for (n6 = 0; n6 < this.lsse.MapWidth; ++n6) {
                            nArray[n3++] = this.lsse.Map[n2++];
                        }
                    }
                    this.lsse.Map = nArray;
                    nArray = new int[this.lsse.DeploymentMap.length - this.lsse.MapWidth];
                    n2 = 0;
                    n3 = 0;
                    for (n7 = 0; n7 < this.lsse.MapHeight; ++n7) {
                        if (n7 == n) {
                            n2 += this.lsse.MapWidth;
                            continue;
                        }
                        for (n6 = 0; n6 < this.lsse.MapWidth; ++n6) {
                            nArray[n3++] = this.lsse.DeploymentMap[n2++];
                        }
                    }
                    this.lsse.DeploymentMap = nArray;
                    if (this.lsse.Items != null) {
                        for (n2 = 0; n2 < this.lsse.Items.length; ++n2) {
                            if (this.lsse.Items[n2].Owner != null || this.lsse.Items[n2].Position.x == -1) continue;
                            if (this.lsse.Items[n2].Position.y == n) {
                                this.lsse.Items[n2].Position.setLocation(-1, -1);
                            }
                            if (this.lsse.Items[n2].Position.y <= n) continue;
                            --this.lsse.Items[n2].Position.y;
                        }
                    }
                    if (this.lsse.Units.length != 0) {
                        for (n2 = 0; n2 < this.lsse.Units.length; ++n2) {
                            this.lsse.Units[n2].CheckDeploy(2, n);
                        }
                    }
                    if (this.lsse.RegionBlocks != null) {
                        n *= 32;
                        n3 = 0;
                        for (n2 = 0; n2 < this.lsse.RegionBlocks.length; ++n2) {
                            if (this.lsse.RegionBlocks[n2].y > n) {
                                this.lsse.RegionBlocks[n2].y -= 32;
                            } else if (this.lsse.RegionBlocks[n2].y + this.lsse.RegionBlocks[n2].height > n) {
                                this.lsse.RegionBlocks[n2].height -= 32;
                            }
                            if (this.lsse.RegionBlocks[n2].y + this.lsse.RegionBlocks[n2].height >= this.lsse.MapHeight * 32) {
                                this.lsse.RegionBlocks[n2].height -= 32;
                            }
                            if (this.lsse.RegionBlocks[n2].height < 1) {
                                this.lsse.RegionBlocks[n2] = null;
                                continue;
                            }
                            ++n3;
                        }
                        if (n3 != this.lsse.RegionBlocks.length) {
                            if (n3 == 0) {
                                this.lsse.RegionBlocks = null;
                                this.lsse.RegionNumbers = null;
                            } else {
                                Rectangle[] rectangleArray = new Rectangle[n3];
                                nArray = new int[n3];
                                n3 = 0;
                                for (n2 = 0; n2 < this.lsse.RegionBlocks.length; ++n2) {
                                    if (this.lsse.RegionBlocks[n2] == null) continue;
                                    nArray[n3] = this.lsse.RegionNumbers[n2];
                                    rectangleArray[n3++] = this.lsse.RegionBlocks[n2];
                                }
                                this.lsse.RegionBlocks = rectangleArray;
                                this.lsse.RegionNumbers = nArray;
                            }
                        }
                        n /= 32;
                    }
                    if (this.lsse.Nodes != null) {
                        for (n2 = 0; n2 < this.lsse.Nodes.length; ++n2) {
                            if (this.lsse.Nodes[n2].y < n) continue;
                            --this.lsse.Nodes[n2].y;
                        }
                    }
                    --this.lsse.MapHeight;
                    break;
                }
                default: {
                    int n8;
                    int n9;
                    if (n > this.lsse.MapWidth - 1) {
                        new MessageBox(this.lsse, "Invalid number", "Can't be greater than number of Columns.", MessageBox.MB_OK);
                        return;
                    }
                    int[] nArray = new int[this.lsse.Map.length - this.lsse.MapHeight];
                    for (n9 = 0; n9 < this.lsse.MapHeight; ++n9) {
                        for (n8 = 0; n8 < this.lsse.MapWidth; ++n8) {
                            if (n8 == n) {
                                ++n2;
                                continue;
                            }
                            nArray[n3++] = this.lsse.Map[n2++];
                        }
                    }
                    this.lsse.Map = nArray;
                    nArray = new int[this.lsse.DeploymentMap.length - this.lsse.MapHeight];
                    n2 = 0;
                    n3 = 0;
                    for (n9 = 0; n9 < this.lsse.MapHeight; ++n9) {
                        for (n8 = 0; n8 < this.lsse.MapWidth; ++n8) {
                            if (n8 == n) {
                                ++n2;
                                continue;
                            }
                            nArray[n3++] = this.lsse.DeploymentMap[n2++];
                        }
                    }
                    this.lsse.DeploymentMap = nArray;
                    if (this.lsse.Items != null) {
                        for (n2 = 0; n2 < this.lsse.Items.length; ++n2) {
                            if (this.lsse.Items[n2].Owner != null || this.lsse.Items[n2].Position.y == -1) continue;
                            if (this.lsse.Items[n2].Position.x == n) {
                                this.lsse.Items[n2].Position.setLocation(-1, -1);
                            }
                            if (this.lsse.Items[n2].Position.x <= n) continue;
                            --this.lsse.Items[n2].Position.x;
                        }
                    }
                    if (this.lsse.Units.length != 0) {
                        for (n2 = 0; n2 < this.lsse.Units.length; ++n2) {
                            this.lsse.Units[n2].CheckDeploy(3, n);
                        }
                    }
                    if (this.lsse.RegionBlocks != null) {
                        n *= 32;
                        n3 = 0;
                        for (n2 = 0; n2 < this.lsse.RegionBlocks.length; ++n2) {
                            if (this.lsse.RegionBlocks[n2].x > n) {
                                this.lsse.RegionBlocks[n2].x -= 32;
                            } else if (this.lsse.RegionBlocks[n2].x + this.lsse.RegionBlocks[n2].width > n) {
                                this.lsse.RegionBlocks[n2].width -= 32;
                            }
                            if (this.lsse.RegionBlocks[n2].x + this.lsse.RegionBlocks[n2].width >= this.lsse.MapWidth * 32) {
                                this.lsse.RegionBlocks[n2].width -= 32;
                            }
                            if (this.lsse.RegionBlocks[n2].width < 1) {
                                this.lsse.RegionBlocks[n2] = null;
                                continue;
                            }
                            ++n3;
                        }
                        if (n3 != this.lsse.RegionBlocks.length) {
                            if (n3 == 0) {
                                this.lsse.RegionBlocks = null;
                                this.lsse.RegionNumbers = null;
                            } else {
                                Rectangle[] rectangleArray = new Rectangle[n3];
                                nArray = new int[n3];
                                n3 = 0;
                                for (n2 = 0; n2 < this.lsse.RegionBlocks.length; ++n2) {
                                    if (this.lsse.RegionBlocks[n2] == null) continue;
                                    nArray[n3] = this.lsse.RegionNumbers[n2];
                                    rectangleArray[n3++] = this.lsse.RegionBlocks[n2];
                                }
                                this.lsse.RegionBlocks = rectangleArray;
                                this.lsse.RegionNumbers = nArray;
                            }
                        }
                        n /= 32;
                    }
                    if (this.lsse.Nodes != null) {
                        for (n2 = 0; n2 < this.lsse.Nodes.length; ++n2) {
                            if (this.lsse.Nodes[n2].x < n) continue;
                            --this.lsse.Nodes[n2].x;
                        }
                    }
                    this.lsse.CheckCAEChange(10, n);
                    --this.lsse.MapWidth;
                }
            }
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.hide();
            this.dispose();
            return;
        }
    }
}

