/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class NodeChooser
extends Dialog
implements ActionListener,
WindowListener {
    private LaserSquadScenarioEditor lsse;
    private List lNodes;
    private NodeEditor parent;
    private Checkbox cbReturnLink;

    public NodeChooser(LaserSquadScenarioEditor laserSquadScenarioEditor, int n, NodeEditor nodeEditor) {
        super(laserSquadScenarioEditor, "Link to another Node", true);
        this.setBounds(laserSquadScenarioEditor.getInsets().left + laserSquadScenarioEditor.getX(), laserSquadScenarioEditor.getInsets().top + laserSquadScenarioEditor.getY(), 250, 400);
        this.lsse = laserSquadScenarioEditor;
        this.parent = nodeEditor;
        this.add((Component)new Label("Which Node do you want to link to:"), "North");
        this.lNodes = new List();
        this.lNodes.setMultipleMode(true);
        for (int i = 0; i < laserSquadScenarioEditor.Nodes.length; ++i) {
            if (i == n || ScenarioEditorUtility.arrayPos(laserSquadScenarioEditor.NodeLinks[n], i) != -1) continue;
            this.lNodes.add(Integer.toString(i));
        }
        this.add((Component)this.lNodes, "Center");
        Panel panel = new Panel();
        this.cbReturnLink = new Checkbox("Add Return Link");
        this.cbReturnLink.setState(true);
        panel.add(this.cbReturnLink);
        panel.setLayout(new FlowLayout());
        Button button = new Button("Ok");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Cancel");
        button.addActionListener(this);
        panel.add(button);
        this.add((Component)panel, "South");
        this.addWindowListener(this);
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Ok")) {
            String[] stringArray = this.lNodes.getSelectedItems();
            if (stringArray.length != 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    int n;
                    try {
                        n = Integer.parseInt(stringArray[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = -1;
                    }
                    this.parent.AddLink(n, this.cbReturnLink.getState());
                }
            }
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.hide();
            this.dispose();
            return;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.hide();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

