/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class NodeEditor
extends Panel
implements ActionListener,
ItemListener,
Runnable {
    private LaserSquadScenarioEditor lsse;
    private TerrainDisplay td;
    private Button butAddNode;
    private Button butRemoveNode;
    private Button butAddLink;
    private Button butRemoveLink;
    private Choice cNodes;
    private List lLinks;

    public NodeEditor(LaserSquadScenarioEditor laserSquadScenarioEditor) {
        this.lsse = laserSquadScenarioEditor;
        this.td = new TerrainDisplay(laserSquadScenarioEditor, this);
        this.add(this.td);
        this.cNodes = new Choice();
        this.cNodes.setFont(LaserSquadScenarioEditor.font);
        if (laserSquadScenarioEditor.Nodes != null) {
            for (int i = 0; i < laserSquadScenarioEditor.Nodes.length; ++i) {
                this.cNodes.add(Integer.toString(i));
            }
            this.cNodes.select(0);
            this.td.SetHighlightPoint(0);
        } else {
            this.cNodes.setEnabled(false);
            this.td.SetHighlightPoint(-1);
        }
        this.cNodes.addItemListener(this);
        this.add(this.cNodes);
        this.butAddNode = new Button("Add");
        this.butAddNode.addActionListener(this);
        this.add(this.butAddNode);
        this.butRemoveNode = new Button("Delete");
        this.butRemoveNode.addActionListener(this);
        this.add(this.butRemoveNode);
        this.lLinks = new List();
        this.lLinks.setFont(LaserSquadScenarioEditor.font);
        this.FillLinkList();
        this.lLinks.addItemListener(this);
        this.add(this.lLinks);
        this.butAddLink = new Button("Add");
        this.butAddLink.addActionListener(this);
        this.add(this.butAddLink);
        this.butRemoveLink = new Button("Delete");
        this.butRemoveLink.addActionListener(this);
        this.add(this.butRemoveLink);
        new Thread(this).start();
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.cNodes.getSelectedIndex() != -1) {
            this.td.CenterOn(this.lsse.Nodes[this.cNodes.getSelectedIndex()]);
        } else {
            this.td.updateDimensions();
        }
        this.repaint();
    }

    protected void reset() {
        this.remove(this.cNodes);
        this.cNodes = new Choice();
        this.cNodes.setFont(LaserSquadScenarioEditor.font);
        if (this.lsse.Nodes != null) {
            for (int i = 0; i < this.lsse.Nodes.length; ++i) {
                this.cNodes.add(Integer.toString(i));
            }
            this.cNodes.select(0);
            this.td.SetHighlightPoint(0);
        } else {
            this.cNodes.setEnabled(false);
            this.td.SetHighlightPoint(-1);
        }
        this.cNodes.addItemListener(this);
        this.add(this.cNodes);
        this.td.reset();
        this.FillLinkList();
        if (this.cNodes.getSelectedIndex() != -1) {
            this.td.CenterOn(this.lsse.Nodes[this.cNodes.getSelectedIndex()]);
        } else {
            this.td.updateDimensions();
        }
        this.repaint();
    }

    private void FillLinkList() {
        this.lLinks.removeAll();
        int n = this.cNodes.getSelectedIndex();
        if (this.lsse.Nodes != null && this.lsse.NodeLinks[n].length > 0) {
            for (int i = 0; i < this.lsse.NodeLinks[n].length; ++i) {
                this.lLinks.add("To " + Integer.toString(this.lsse.NodeLinks[n][i]));
            }
        }
        if (this.lLinks.getItemCount() > 0) {
            this.lLinks.select(0);
        }
    }

    protected int GetSelectedLink() {
        return this.lLinks.getSelectedIndex();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, 0, n, n2);
        this.td.setBounds(0, 0, n - 181, n2);
        this.td.repaint();
        graphics.setColor(Color.BLACK);
        graphics.setFont(LaserSquadScenarioEditor.font);
        graphics.drawString("Node:", n - 176, 21);
        this.cNodes.setLocation(n - 100, 5);
        this.butAddNode.setBounds(n - 176, 33, 80, 25);
        this.butRemoveNode.setBounds(n - 86, 33, 80, 25);
        this.lLinks.setBounds(n - 176, 63, 170, n2 - 35 - 63);
        this.butAddLink.setBounds(n - 176, n2 - 30, 80, 25);
        this.butRemoveLink.setBounds(n - 86, n2 - 30, 80, 25);
    }

    protected void AddLink(int n, boolean bl) {
        int n2 = this.cNodes.getSelectedIndex();
        this.lsse.NodeLinks[n2] = ScenarioEditorUtility.arrayAdd(this.lsse.NodeLinks[n2], n);
        if (bl && ScenarioEditorUtility.arrayPos(this.lsse.NodeLinks[n], n2) == -1) {
            this.lsse.NodeLinks[n] = ScenarioEditorUtility.arrayAdd(this.lsse.NodeLinks[n], n2);
        }
        this.FillLinkList();
        this.lLinks.select(this.lsse.NodeLinks[n2].length - 1);
        if (this.cNodes.getSelectedIndex() != -1) {
            this.td.CenterOn(this.lsse.Nodes[this.cNodes.getSelectedIndex()]);
        } else {
            this.td.updateDimensions();
        }
    }

    protected void SetNodePosition(Point point) {
        int n = this.cNodes.getSelectedIndex();
        if (n != -1) {
            this.lsse.Nodes[n] = point;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butAddNode) {
            this.lsse.AddNode(this.td.GetCenterPoint());
            this.remove(this.cNodes);
            this.cNodes = new Choice();
            this.cNodes.setFont(LaserSquadScenarioEditor.font);
            for (int i = 0; i < this.lsse.Nodes.length; ++i) {
                this.cNodes.add(Integer.toString(i));
            }
            this.cNodes.select(this.lsse.Nodes.length - 1);
            this.cNodes.addItemListener(this);
            this.add(this.cNodes);
            this.td.SetHighlightPoint(this.lsse.Nodes.length - 1);
            this.td.CenterOn(this.lsse.Nodes[this.lsse.Nodes.length - 1]);
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butRemoveNode && this.lsse.Nodes != null) {
            int n = this.cNodes.getSelectedIndex();
            this.remove(this.cNodes);
            this.cNodes = new Choice();
            this.cNodes.setFont(LaserSquadScenarioEditor.font);
            this.lsse.RemoveNode(n);
            if (this.lsse.Nodes == null) {
                this.cNodes.setEnabled(false);
            } else {
                for (int i = 0; i < this.lsse.Nodes.length; ++i) {
                    this.cNodes.add(Integer.toString(i));
                }
                this.cNodes.select(n >= this.lsse.Nodes.length ? this.lsse.Nodes.length - 1 : n);
            }
            this.cNodes.addItemListener(this);
            this.add(this.cNodes);
            this.FillLinkList();
            this.td.SetHighlightPoint(this.cNodes.getSelectedIndex());
            if (this.cNodes.getSelectedIndex() != -1) {
                this.td.CenterOn(this.lsse.Nodes[this.cNodes.getSelectedIndex()]);
            } else {
                this.td.updateDimensions();
            }
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butAddLink && this.lsse.Nodes != null) {
            new NodeChooser(this.lsse, this.cNodes.getSelectedIndex(), this);
            return;
        }
        if (actionEvent.getSource() == this.butRemoveLink && this.lLinks.getSelectedIndex() != -1) {
            int n = this.cNodes.getSelectedIndex();
            int n2 = this.lLinks.getSelectedIndex();
            this.lsse.NodeLinks[n] = ScenarioEditorUtility.arrayDeleteElementAt(this.lsse.NodeLinks[n], n2);
            this.FillLinkList();
            if (n2 == this.lLinks.getItemCount()) {
                --n2;
            }
            if (n2 >= 0) {
                this.lLinks.select(n2);
            }
            this.td.updateDimensions();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.cNodes) {
            this.td.SetHighlightPoint(this.cNodes.getSelectedIndex());
            this.FillLinkList();
            if (this.cNodes.getSelectedIndex() != -1) {
                this.td.CenterOn(this.lsse.Nodes[this.cNodes.getSelectedIndex()]);
            } else {
                this.td.updateDimensions();
            }
        }
        if (itemEvent.getSource() == this.lLinks) {
            if (this.cNodes.getSelectedIndex() != -1) {
                this.td.CenterOn(this.lsse.Nodes[this.cNodes.getSelectedIndex()]);
            } else {
                this.td.updateDimensions();
            }
        }
    }
}

