/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class PullDownCheckBoxList
extends Dialog
implements AdjustmentListener,
MouseListener,
ItemListener {
    private LaserSquadScenarioEditor lsse;
    private UnitEditorPanel parent;
    private Scrollbar sb;
    private int mode;
    private EditorUnit euUnit;
    private int iFontHeight;
    private int iMaxLength;
    private int iRows;
    private Image PDImage = null;
    private Graphics PDGraph;
    private int PDWidth = -1;
    private int PDHeight = -1;
    private Checkbox[] cbFlags;
    private String[] text;

    public PullDownCheckBoxList(LaserSquadScenarioEditor laserSquadScenarioEditor, UnitEditorPanel unitEditorPanel, int n, EditorUnit editorUnit, FontMetrics fontMetrics) {
        super(laserSquadScenarioEditor, "PullDownCheckBoxList", false);
        int n2;
        this.lsse = laserSquadScenarioEditor;
        this.setUndecorated(true);
        this.mode = n;
        this.euUnit = editorUnit;
        this.parent = unitEditorPanel;
        this.iFontHeight = fontMetrics.getHeight();
        this.text = new String[n == 0 ? laserSquadScenarioEditor.MaxDifficultyLevel + 1 : 16];
        this.iMaxLength = 0;
        for (n2 = 0; n2 < this.text.length; ++n2) {
            this.text[n2] = n == 0 ? new String(n2 == 0 ? "2 Player:" : "Level " + n2 + ":") : new String("Flag " + n2 + ":");
            if (fontMetrics.stringWidth(this.text[n2]) <= this.iMaxLength) continue;
            this.iMaxLength = fontMetrics.stringWidth(this.text[n2]);
        }
        this.cbFlags = new Checkbox[this.text.length];
        n2 = 0;
        int n3 = 1;
        while (n2 < this.cbFlags.length) {
            this.cbFlags[n2] = new Checkbox();
            this.cbFlags[n2].addItemListener(this);
            this.cbFlags[n2].setBackground(Color.WHITE);
            this.add(this.cbFlags[n2]);
            this.cbFlags[n2].setState(n == 0 ? (editorUnit.DifficultyLevelsAllowedOn & n3) == n3 : (editorUnit.UserDefinedFlags & n3) == n3);
            ++n2;
            n3 <<= 1;
        }
        int n4 = this.text.length * this.iFontHeight + (n == 0 ? 159 : 185) > unitEditorPanel.getHeight() ? (unitEditorPanel.getHeight() - (n == 0 ? 159 : 185)) / this.iFontHeight : (this.iRows = this.text.length);
        if (this.iRows < this.text.length) {
            this.sb = new Scrollbar(1, 0, this.iRows, 0, this.text.length);
            this.sb.setBlockIncrement(this.iRows);
            this.add(this.sb);
            this.sb.setBounds(149, 1, 20, this.iFontHeight * this.iRows);
            this.sb.addAdjustmentListener(this);
            this.sb.addMouseListener(this);
        } else {
            this.sb = null;
        }
        this.addMouseListener(this);
        unitEditorPanel.addMouseListener(this);
        this.show();
        n3 = this.iMaxLength + (this.sb == null ? 31 : 51);
        if (n3 < 150) {
            n3 = 150;
        }
        this.setBounds(laserSquadScenarioEditor.getInsets().left + laserSquadScenarioEditor.getX() + unitEditorPanel.getX() + 5, laserSquadScenarioEditor.getInsets().top + laserSquadScenarioEditor.getY() + (n == 0 ? 157 : 183), n3, this.iFontHeight * this.iRows + 2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.PDWidth || n4 != this.PDHeight) {
            this.PDWidth = n3;
            this.PDHeight = n4;
            this.PDImage = this.createImage(n3, n4);
            this.PDGraph = this.PDImage.getGraphics();
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        int n;
        int n2 = 0;
        if (this.PDImage == null) {
            return;
        }
        this.PDGraph.setColor(Color.WHITE);
        this.PDGraph.fillRect(0, 0, this.PDWidth - 1, this.PDHeight - 1);
        this.PDGraph.setColor(Color.BLACK);
        this.PDGraph.drawRect(0, 0, this.PDWidth - 1, this.PDHeight - 1);
        this.PDGraph.setFont(LaserSquadScenarioEditor.font);
        int n3 = this.PDGraph.getFontMetrics().getAscent();
        if (this.sb != null) {
            n2 = this.sb.getValue();
            for (n = 0; n < this.cbFlags.length; ++n) {
                this.cbFlags[n].setVisible(false);
            }
        }
        for (n = 0; n < this.iRows && n2 < this.text.length; ++n, ++n2) {
            this.PDGraph.drawString(this.text[n2], 5, this.iFontHeight * n + n3);
            this.cbFlags[n2].setVisible(true);
            this.cbFlags[n2].setBounds(10 + this.iMaxLength, this.iFontHeight * n + n3 - 15, 15, 15);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.PDGraph.setColor(Color.BLACK);
        this.PDGraph.drawLine(0, 0, 0, 1);
        if (this.PDImage != null) {
            graphics.drawImage(this.PDImage, 0, 0, null);
        }
        if (this.sb != null) {
            this.sb.setBounds(this.PDWidth - 21, 1, 20, this.PDHeight - 2);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        for (int i = 0; i < this.cbFlags.length; ++i) {
            if (itemEvent.getSource() != this.cbFlags[i]) continue;
            int n = this.mode == 0 ? this.euUnit.DifficultyLevelsAllowedOn : this.euUnit.UserDefinedFlags;
            n -= n & 1 << i;
            if (this.cbFlags[i].getState()) {
                n += 1 << i;
            }
            if (this.mode == 0) {
                this.euUnit.DifficultyLevelsAllowedOn = n;
            } else {
                this.euUnit.UserDefinedFlags = n;
            }
            return;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() != this.parent) {
            return;
        }
        this.parent.removeMouseListener(this);
        this.hide();
        this.dispose();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.sb && mouseEvent.getX() <= 0) {
            return;
        }
        if (mouseEvent.getComponent() == this && mouseEvent.getX() < this.getWidth() && mouseEvent.getX() >= 0 && mouseEvent.getY() < this.getHeight() && mouseEvent.getY() >= 0) {
            return;
        }
        for (int i = 0; i < this.cbFlags.length; ++i) {
            if (mouseEvent.getComponent() != this.cbFlags[i]) continue;
            int n = this.cbFlags[i].getY() + mouseEvent.getY();
            int n2 = this.cbFlags[i].getX() + mouseEvent.getX();
            if (n2 >= this.getWidth() || n2 < 0 || n >= this.getHeight() || n < 0) continue;
            return;
        }
        this.parent.removeMouseListener(this);
        this.hide();
        this.dispose();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

