/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

class PullDownList
extends Dialog
implements AdjustmentListener,
MouseListener,
Runnable {
    private LaserSquadScenarioEditor lsse;
    private PullDown parent;
    private Scrollbar sb;
    private int[] items;
    private int Selected;
    private boolean bShowTerrain;
    private Vector AnimationDetails = new Vector();
    private Thread PullDownAnnimator = null;
    private Image PDImage = null;
    private Graphics PDGraph;
    private int PDWidth = -1;
    private int PDHeight = -1;

    public PullDownList(LaserSquadScenarioEditor laserSquadScenarioEditor, PullDown pullDown, int[] nArray, int n, boolean bl) {
        super(laserSquadScenarioEditor, "PullDownList", false);
        this.lsse = laserSquadScenarioEditor;
        this.parent = pullDown;
        this.setUndecorated(true);
        this.items = nArray;
        this.Selected = n;
        this.bShowTerrain = bl;
        this.sb = new Scrollbar(1, this.Selected, nArray.length > 4 ? 4 : nArray.length, 0, nArray.length);
        this.sb.setBlockIncrement(nArray.length > 4 ? 4 : nArray.length);
        this.add(this.sb);
        this.sb.setBounds(149, 1, 16, 32 * (nArray.length > 4 ? 4 : nArray.length));
        this.sb.addAdjustmentListener(this);
        this.addMouseListener(this);
        this.sb.addMouseListener(this);
        this.show();
        this.setBounds(laserSquadScenarioEditor.getInsets().left + laserSquadScenarioEditor.getX() + pullDown.getX(), laserSquadScenarioEditor.getInsets().top + laserSquadScenarioEditor.getY() + pullDown.getY(), 182, 34 * (nArray.length > 4 ? 4 : nArray.length) + 2);
    }

    public PullDownList(LaserSquadScenarioEditor laserSquadScenarioEditor, PullDown pullDown, int[] nArray, int n, boolean bl, CAEUnitEditorWindow cAEUnitEditorWindow) {
        super(cAEUnitEditorWindow, "PullDownList", false);
        this.lsse = laserSquadScenarioEditor;
        this.parent = pullDown;
        this.setUndecorated(true);
        this.items = nArray;
        this.Selected = n;
        this.bShowTerrain = bl;
        this.sb = new Scrollbar(1, this.Selected, nArray.length > 4 ? 4 : nArray.length, 0, nArray.length);
        this.sb.setBlockIncrement(nArray.length > 4 ? 4 : nArray.length);
        this.add(this.sb);
        this.sb.setBounds(149, 1, 16, 32 * (nArray.length > 4 ? 4 : nArray.length));
        this.sb.addAdjustmentListener(this);
        this.addMouseListener(this);
        this.sb.addMouseListener(this);
        this.show();
        this.setBounds(pullDown.getLocationOnScreen().x, pullDown.getLocationOnScreen().y, 182, 34 * (nArray.length > 4 ? 4 : nArray.length) + 2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.PDWidth || n4 != this.PDHeight) {
            this.PDWidth = n3;
            this.PDHeight = n4;
            this.PDImage = this.createImage(n3, n4);
            this.PDGraph = this.PDImage.getGraphics();
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        if (this.PullDownAnnimator != null) {
            this.PullDownAnnimator.interrupt();
        }
        this.PullDownAnnimator = null;
        this.AnimationDetails.clear();
        if (this.PDImage == null) {
            return;
        }
        this.PDGraph.setColor(new Color(240, 240, 240));
        this.PDGraph.fillRect(0, 0, this.PDWidth - 1, this.PDHeight - 1);
        this.PDGraph.setColor(Color.BLACK);
        this.PDGraph.drawRect(0, 0, this.PDWidth - 1, this.PDHeight - 1);
        this.PDGraph.setFont(LaserSquadScenarioEditor.font);
        int n = 0;
        for (int i = this.sb.getValue(); n < 4 && i < this.items.length; ++n, ++i) {
            if (this.items[i] == -1) {
                this.PDGraph.drawString("None", 6, 23 + n * 34);
            } else if (this.bShowTerrain) {
                this.lsse.Terrains[this.items[i]].DisplayDetails(this.PDGraph, 2, 2 + n * 34, this.AnimationDetails);
            } else {
                this.lsse.GenericItems[this.items[i]].DisplayDetails(this.PDGraph, 2, 2 + n * 34, this.AnimationDetails);
            }
            if (i != this.Selected) continue;
            this.PDGraph.setColor(Color.RED);
            this.PDGraph.drawRect(1, 1 + n * 34, this.PDWidth - 17, 33);
            this.PDGraph.setColor(Color.BLACK);
        }
        if (!this.AnimationDetails.isEmpty()) {
            this.PullDownAnnimator = new Thread((Runnable)this, "PullDownAnnimator");
            this.PullDownAnnimator.start();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.PDGraph.setColor(Color.BLACK);
        this.PDGraph.drawLine(0, 0, 0, 1);
        if (this.PDImage != null) {
            graphics.drawImage(this.PDImage, 0, 0, null);
        }
        this.sb.setBounds(this.PDWidth - 15, 1, 14, this.PDHeight - 2);
    }

    public void run() {
        while (this.PullDownAnnimator != null && !this.AnimationDetails.isEmpty()) {
            for (int i = 0; i < this.AnimationDetails.size(); i += 3) {
                int[] nArray = (int[])this.AnimationDetails.elementAt(i);
                if (nArray[1] > 0) {
                    nArray[1] = nArray[1] - 1;
                    continue;
                }
                nArray[0] = nArray[0] + 1;
                Image[] imageArray = (Image[])this.AnimationDetails.elementAt(i + 1);
                int[] nArray2 = (int[])this.AnimationDetails.elementAt(i + 2);
                if (nArray[0] == nArray2.length) {
                    nArray[0] = 0;
                }
                nArray[1] = nArray2[nArray[0]];
                this.PDGraph.drawImage(imageArray[nArray[0]], nArray[2], nArray[3], null);
                this.repaint(nArray[2], nArray[3], 32, 32);
            }
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getY() - 1;
        n /= 34;
        this.parent.NotifySelectedChange(n += this.sb.getValue());
        this.hide();
        this.dispose();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this && mouseEvent.getX() >= 167 && mouseEvent.getX() < 200) {
            return;
        }
        if (mouseEvent.getComponent() == this.sb && mouseEvent.getX() <= 0) {
            return;
        }
        this.hide();
        this.dispose();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

