/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

class PullDownValueBoxList
extends Dialog
implements AdjustmentListener,
MouseListener,
KeyListener,
TextListener {
    private LaserSquadScenarioEditor lsse;
    private TeamEditor parent;
    private Scrollbar sb;
    private int mode;
    private EditorTeam etTeam;
    private int iMaxLength;
    private int iRows;
    private Image PDImage = null;
    private Graphics PDGraph;
    private int PDWidth = -1;
    private int PDHeight = -1;
    private TextField[] tfValues;
    private String[] text;

    public PullDownValueBoxList(LaserSquadScenarioEditor laserSquadScenarioEditor, TeamEditor teamEditor, int n, EditorTeam editorTeam, FontMetrics fontMetrics) {
        super(laserSquadScenarioEditor, "PullDownValueBoxList", false);
        int n2;
        this.lsse = laserSquadScenarioEditor;
        this.setUndecorated(true);
        this.mode = n;
        this.etTeam = editorTeam;
        this.parent = teamEditor;
        this.text = new String[n == 0 ? laserSquadScenarioEditor.MaxDifficultyLevel + 1 : laserSquadScenarioEditor.MaxDifficultyLevel];
        this.iMaxLength = 0;
        for (n2 = 0; n2 < this.text.length; ++n2) {
            this.text[n2] = n == 0 ? new String(n2 == 0 ? "2 Player:" : "Level " + n2 + ":") : new String("Level " + (n2 + 1) + ":");
            if (fontMetrics.stringWidth(this.text[n2]) <= this.iMaxLength) continue;
            this.iMaxLength = fontMetrics.stringWidth(this.text[n2]);
        }
        this.tfValues = new TextField[this.text.length];
        for (n2 = 0; n2 < this.tfValues.length; ++n2) {
            this.tfValues[n2] = new TextField(Integer.toString(n == 0 ? (n2 == 0 ? editorTeam.StartCredits : editorTeam.CreditsAtDifficultyLevel[n2 - 1]) : editorTeam.MemoryLength[n2]), 3 - n);
            this.tfValues[n2].setFont(LaserSquadScenarioEditor.font);
            this.tfValues[n2].addKeyListener(this);
            this.tfValues[n2].addTextListener(this);
            this.tfValues[n2].addMouseListener(this);
            this.add(this.tfValues[n2]);
        }
        int n3 = this.iRows = this.text.length * 20 + 96 > teamEditor.getHeight() ? (teamEditor.getHeight() - 96) / 20 : this.text.length;
        if (this.iRows < this.text.length) {
            this.sb = new Scrollbar(1, 0, this.iRows, 0, this.text.length);
            this.sb.setBlockIncrement(this.iRows);
            this.add(this.sb);
            this.sb.setBounds(149, 1, 20, 20 * this.iRows);
            this.sb.addAdjustmentListener(this);
            this.sb.addMouseListener(this);
        } else {
            this.sb = null;
        }
        this.addMouseListener(this);
        teamEditor.addMouseListener(this);
        this.show();
        n2 = this.iMaxLength + (this.sb == null ? 56 : 76);
        if (n2 < (n == 0 ? 150 : 160)) {
            n2 = n == 0 ? 150 : 160;
        }
        this.setBounds(laserSquadScenarioEditor.getInsets().left + laserSquadScenarioEditor.getX() + (n == 0 ? 5 : 170), laserSquadScenarioEditor.getInsets().top + laserSquadScenarioEditor.getY() + 90, n2, 20 * this.iRows + 6);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.PDWidth || n4 != this.PDHeight) {
            this.PDWidth = n3;
            this.PDHeight = n4;
            this.PDImage = this.createImage(n3, n4);
            this.PDGraph = this.PDImage.getGraphics();
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        int n;
        int n2 = 0;
        if (this.PDImage == null) {
            return;
        }
        this.PDGraph.setColor(Color.WHITE);
        this.PDGraph.fillRect(0, 0, this.PDWidth - 1, this.PDHeight - 1);
        this.PDGraph.setColor(Color.BLACK);
        this.PDGraph.drawRect(0, 0, this.PDWidth - 1, this.PDHeight - 1);
        this.PDGraph.setFont(LaserSquadScenarioEditor.font);
        int n3 = this.PDGraph.getFontMetrics().getAscent();
        if (this.sb != null) {
            n2 = this.sb.getValue();
            for (n = 0; n < this.tfValues.length; ++n) {
                this.tfValues[n].setVisible(false);
            }
        }
        for (n = 0; n < this.iRows && n2 < this.text.length; ++n, ++n2) {
            this.PDGraph.drawString(this.text[n2], 5, 20 * n + 16);
            this.tfValues[n2].setVisible(true);
            this.tfValues[n2].setBounds(10 + this.iMaxLength, 20 * n + 3, 40, 20);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.PDGraph.setColor(Color.BLACK);
        this.PDGraph.drawLine(0, 0, 0, 1);
        if (this.PDImage != null) {
            graphics.drawImage(this.PDImage, 0, 0, null);
        }
        if (this.sb != null) {
            this.sb.setBounds(this.PDWidth - 21, 1, 20, this.PDHeight - 2);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        int n = 0;
        for (int i = 0; i < this.tfValues.length; ++i) {
            if (textEvent.getSource() != this.tfValues[i]) continue;
            try {
                n = Integer.parseInt(this.tfValues[i].getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n > 4094 || n < 0) {
                n = 0;
            }
            if (this.mode == 1) {
                this.etTeam.MemoryLength[i] = n;
            } else if (i == 0) {
                this.etTeam.StartCredits = n;
            } else {
                this.etTeam.CreditsAtDifficultyLevel[i - 1] = n;
            }
            return;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) && c != '\b') {
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            keyEvent.consume();
        }
        if (keyEvent.getKeyCode() == 38) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n;
        if (keyEvent.getKeyCode() == 40) {
            for (n = 0; n < this.tfValues.length; ++n) {
                if (keyEvent.getComponent() != this.tfValues[n] || n >= this.tfValues.length - 1) continue;
                if (this.sb != null && ++n - this.sb.getValue() >= this.iRows) {
                    this.sb.setValue(this.sb.getValue() + 1);
                    this.RepaintOffScreenImage();
                    this.repaint();
                }
                this.tfValues[n].requestFocus();
                break;
            }
            keyEvent.consume();
        }
        if (keyEvent.getKeyCode() == 38) {
            for (n = 0; n < this.tfValues.length; ++n) {
                if (keyEvent.getComponent() != this.tfValues[n] || n <= 0) continue;
                if (this.sb != null && --n < this.sb.getValue()) {
                    this.sb.setValue(this.sb.getValue() - 1);
                    this.RepaintOffScreenImage();
                    this.repaint();
                }
                this.tfValues[n].requestFocus();
                break;
            }
            keyEvent.consume();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() != this.parent) {
            return;
        }
        this.parent.removeMouseListener(this);
        this.hide();
        this.dispose();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.sb && mouseEvent.getX() <= 0) {
            return;
        }
        if (mouseEvent.getComponent() == this && mouseEvent.getX() < this.getWidth() && mouseEvent.getX() >= 0 && mouseEvent.getY() < this.getHeight() && mouseEvent.getY() >= 0) {
            return;
        }
        for (int i = 0; i < this.tfValues.length; ++i) {
            if (mouseEvent.getComponent() != this.tfValues[i]) continue;
            int n = this.tfValues[i].getY() + mouseEvent.getY();
            int n2 = this.tfValues[i].getX() + mouseEvent.getX();
            if (n2 >= this.getWidth() || n2 < 0 || n >= this.getHeight() || n < 0) continue;
            return;
        }
        this.parent.removeMouseListener(this);
        this.hide();
        this.dispose();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

