/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class RegionEditor
extends Panel
implements ActionListener,
ItemListener,
Runnable {
    private LaserSquadScenarioEditor lsse;
    private TerrainDisplay td;
    private Button butAddRegion;
    private Button butRemoveRegion;
    private Button butAddRect;
    private Button butRemoveRect;
    private Button butToFront;
    private Button butToBack;
    private Choice cRegions;
    private List lRegions;

    public RegionEditor(LaserSquadScenarioEditor laserSquadScenarioEditor) {
        this.lsse = laserSquadScenarioEditor;
        this.td = new TerrainDisplay(laserSquadScenarioEditor, this);
        this.add(this.td);
        this.cRegions = new Choice();
        this.cRegions.setFont(LaserSquadScenarioEditor.font);
        if (laserSquadScenarioEditor.NumberOfRegions != 0) {
            for (int i = 0; i < laserSquadScenarioEditor.NumberOfRegions; ++i) {
                this.cRegions.add(Integer.toString(i + 1));
            }
            this.cRegions.select(0);
        } else {
            this.cRegions.setEnabled(false);
        }
        this.cRegions.addItemListener(this);
        this.add(this.cRegions);
        this.butAddRegion = new Button("Add");
        this.butAddRegion.addActionListener(this);
        this.add(this.butAddRegion);
        this.butRemoveRegion = new Button("Delete");
        this.butRemoveRegion.addActionListener(this);
        this.add(this.butRemoveRegion);
        this.lRegions = new List();
        this.lRegions.setFont(LaserSquadScenarioEditor.font);
        this.FillBlockList();
        this.lRegions.addItemListener(this);
        this.add(this.lRegions);
        this.butAddRect = new Button("Add");
        this.butAddRect.addActionListener(this);
        this.add(this.butAddRect);
        this.butRemoveRect = new Button("Delete");
        this.butRemoveRect.addActionListener(this);
        this.add(this.butRemoveRect);
        this.butToFront = new Button("Move Block Forward");
        this.butToFront.addActionListener(this);
        this.add(this.butToFront);
        this.butToBack = new Button("Move Block Backward");
        this.butToBack.addActionListener(this);
        this.add(this.butToBack);
        this.td.SetRect(this.GetSelectedBlock());
        new Thread(this).start();
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.GetSelectedBlock() != null) {
            this.td.CenterOn(new Point((int)(this.GetSelectedBlock().getCenterX() / 32.0), (int)(this.GetSelectedBlock().getCenterY() / 32.0)));
        } else {
            this.td.updateDimensions();
        }
        this.repaint();
    }

    protected void reset() {
        this.remove(this.cRegions);
        this.cRegions = new Choice();
        this.cRegions.setFont(LaserSquadScenarioEditor.font);
        if (this.lsse.NumberOfRegions > 0) {
            for (int i = 0; i < this.lsse.NumberOfRegions; ++i) {
                this.cRegions.add(Integer.toString(i + 1));
            }
            this.cRegions.select(0);
        } else {
            this.cRegions.setEnabled(false);
        }
        this.cRegions.addItemListener(this);
        this.add(this.cRegions);
        this.td.reset();
        this.FillBlockList();
        this.td.SetRect(this.GetSelectedBlock());
        if (this.GetSelectedBlock() != null) {
            this.td.CenterOn(new Point((int)(this.GetSelectedBlock().getCenterX() / 32.0), (int)(this.GetSelectedBlock().getCenterY() / 32.0)));
        } else {
            this.td.updateDimensions();
        }
        this.repaint();
    }

    private void FillBlockList() {
        this.lRegions.removeAll();
        int n = this.GetSelectedRegion();
        if (this.lsse.RegionBlocks != null) {
            for (int i = 0; i < this.lsse.RegionBlocks.length; ++i) {
                if (this.lsse.RegionNumbers[i] != n) continue;
                this.lRegions.add("Block " + Integer.toString(i) + " (" + Integer.toString(this.lsse.RegionNumbers[i]) + ")");
            }
        }
        if (this.lRegions.getItemCount() > 0) {
            this.lRegions.select(0);
        }
    }

    protected int GetSelectedRegion() {
        return this.cRegions.getSelectedIndex() + 1;
    }

    protected void SetBlock(Rectangle rectangle) {
        int n = this.lRegions.getSelectedIndex();
        int n2 = this.GetSelectedRegion();
        for (int i = 0; i < this.lsse.RegionNumbers.length; ++i) {
            if (this.lsse.RegionNumbers[i] != n2) continue;
            if (n == 0) {
                this.lsse.RegionBlocks[i] = new Rectangle(rectangle);
                return;
            }
            --n;
        }
    }

    protected Rectangle GetSelectedBlock() {
        if (this.lsse.RegionNumbers == null) {
            return null;
        }
        int n = this.lRegions.getSelectedIndex();
        int n2 = this.GetSelectedRegion();
        for (int i = 0; i < this.lsse.RegionNumbers.length; ++i) {
            if (this.lsse.RegionNumbers[i] != n2) continue;
            if (n == 0) {
                return new Rectangle(this.lsse.RegionBlocks[i]);
            }
            --n;
        }
        return null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, 0, n, n2);
        this.td.setBounds(0, 0, n - 181, n2);
        this.td.repaint();
        graphics.setColor(Color.BLACK);
        graphics.setFont(LaserSquadScenarioEditor.font);
        graphics.drawString("Region:", n - 176, 21);
        this.cRegions.setLocation(n - 100, 5);
        this.butAddRegion.setBounds(n - 176, 33, 80, 25);
        this.butRemoveRegion.setBounds(n - 86, 33, 80, 25);
        this.lRegions.setBounds(n - 176, 63, 170, n2 - 95 - 63);
        this.butAddRect.setBounds(n - 176, n2 - 90, 80, 25);
        this.butRemoveRect.setBounds(n - 86, n2 - 90, 80, 25);
        this.butToFront.setBounds(n - 176, n2 - 60, 170, 25);
        this.butToBack.setBounds(n - 176, n2 - 30, 170, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butAddRegion) {
            int n = this.cRegions.getSelectedIndex();
            this.remove(this.cRegions);
            this.cRegions = new Choice();
            this.cRegions.setFont(LaserSquadScenarioEditor.font);
            this.lsse.AddRegion();
            for (int i = 0; i < this.lsse.NumberOfRegions; ++i) {
                this.cRegions.add(Integer.toString(i + 1));
            }
            if (n < 0) {
                n = 0;
            }
            this.cRegions.select(n);
            this.cRegions.addItemListener(this);
            this.add(this.cRegions);
            this.td.SetRect(this.GetSelectedBlock());
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butRemoveRegion && this.lsse.NumberOfRegions > 0) {
            int n = this.cRegions.getSelectedIndex();
            this.remove(this.cRegions);
            this.cRegions = new Choice();
            this.cRegions.setFont(LaserSquadScenarioEditor.font);
            --this.lsse.NumberOfRegions;
            this.lsse.RemoveRegion(n);
            if (this.lsse.NumberOfRegions > 0) {
                int n2;
                for (n2 = 0; n2 < this.lsse.NumberOfRegions; ++n2) {
                    this.cRegions.add(Integer.toString(n2 + 1));
                }
                if (this.lsse.RegionBlocks != null) {
                    int[] nArray;
                    ++n;
                    int n3 = 0;
                    for (n2 = 0; n2 < this.lsse.RegionBlocks.length; ++n2) {
                        if (this.lsse.RegionNumbers[n2] == n) continue;
                        ++n3;
                    }
                    Rectangle[] rectangleArray = n3 == 0 ? null : new Rectangle[n3];
                    int[] nArray2 = nArray = n3 == 0 ? null : new int[n3];
                    if (n3 > 0) {
                        n3 = 0;
                        for (n2 = 0; n2 < this.lsse.RegionBlocks.length; ++n2) {
                            if (this.lsse.RegionNumbers[n2] == n) continue;
                            nArray[n3] = this.lsse.RegionNumbers[n2];
                            if (nArray[n3] > n) {
                                int n4 = n3;
                                nArray[n4] = nArray[n4] - 1;
                            }
                            rectangleArray[n3++] = this.lsse.RegionBlocks[n2];
                        }
                    }
                    this.lsse.RegionBlocks = rectangleArray;
                    this.lsse.RegionNumbers = nArray;
                    --n;
                }
            } else {
                this.cRegions.setEnabled(false);
                this.lsse.RegionBlocks = null;
                n = -1;
            }
            this.cRegions.addItemListener(this);
            this.add(this.cRegions);
            if (n != -1) {
                this.cRegions.select(n >= this.lsse.NumberOfRegions ? this.lsse.NumberOfRegions - 1 : n);
            }
            this.FillBlockList();
            this.td.SetRect(this.GetSelectedBlock());
            if (this.GetSelectedBlock() != null) {
                this.td.CenterOn(new Point((int)(this.GetSelectedBlock().getCenterX() / 32.0), (int)(this.GetSelectedBlock().getCenterY() / 32.0)));
            } else {
                this.td.updateDimensions();
            }
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butAddRect && this.lsse.NumberOfRegions > 0) {
            Rectangle[] rectangleArray = new Rectangle[this.lsse.RegionBlocks == null ? 1 : this.lsse.RegionBlocks.length + 1];
            int[] nArray = new int[rectangleArray.length];
            if (this.lsse.RegionBlocks != null) {
                System.arraycopy(this.lsse.RegionBlocks, 0, rectangleArray, 0, this.lsse.RegionBlocks.length);
                System.arraycopy(this.lsse.RegionNumbers, 0, nArray, 0, this.lsse.RegionNumbers.length);
            }
            int n = this.cRegions.getSelectedIndex() + 1;
            rectangleArray[rectangleArray.length - 1] = this.td.GetCenter();
            nArray[nArray.length - 1] = n;
            this.lsse.RegionBlocks = rectangleArray;
            this.lsse.RegionNumbers = nArray;
            this.FillBlockList();
            int n5 = -1;
            for (int i = 0; i < this.lsse.RegionBlocks.length; ++i) {
                if (this.lsse.RegionNumbers[i] != n) continue;
                ++n5;
            }
            if (n5 >= 0) {
                this.lRegions.select(n5);
            }
            this.td.SetRect(this.GetSelectedBlock());
            this.td.CenterOn(new Point((int)(this.GetSelectedBlock().getCenterX() / 32.0), (int)(this.GetSelectedBlock().getCenterY() / 32.0)));
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butRemoveRect && this.lRegions.getItemCount() > 0) {
            Rectangle[] rectangleArray = new Rectangle[this.lsse.RegionBlocks.length - 1];
            int[] nArray = new int[rectangleArray.length];
            int n = this.lRegions.getSelectedIndex();
            int n6 = this.cRegions.getSelectedIndex() + 1;
            int n7 = -1;
            int n8 = 0;
            for (int i = 0; i < this.lsse.RegionBlocks.length; ++i) {
                if (this.lsse.RegionNumbers[i] == n6) {
                    ++n7;
                }
                if (n7 == n) continue;
                rectangleArray[n8] = this.lsse.RegionBlocks[i];
                nArray[n8++] = this.lsse.RegionNumbers[i];
            }
            this.lsse.RegionBlocks = rectangleArray;
            this.lsse.RegionNumbers = nArray;
            this.FillBlockList();
            if (n == this.lRegions.getItemCount()) {
                --n;
            }
            if (n >= 0) {
                this.lRegions.select(n);
            }
            this.td.SetRect(this.GetSelectedBlock());
            if (this.GetSelectedBlock() != null) {
                this.td.CenterOn(new Point((int)(this.GetSelectedBlock().getCenterX() / 32.0), (int)(this.GetSelectedBlock().getCenterY() / 32.0)));
            } else {
                this.td.updateDimensions();
            }
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butToFront && this.lRegions.getItemCount() > 0) {
            int n;
            int n9 = this.lRegions.getSelectedIndex();
            int n10 = this.GetSelectedRegion();
            for (n = 0; n < this.lsse.RegionNumbers.length; ++n) {
                if (this.lsse.RegionNumbers[n] != n10) continue;
                if (n9 == 0) break;
                --n9;
            }
            if (n == 0) {
                return;
            }
            Rectangle rectangle = this.lsse.RegionBlocks[n - 1];
            this.lsse.RegionBlocks[n - 1] = this.lsse.RegionBlocks[n];
            this.lsse.RegionBlocks[n] = rectangle;
            n9 = this.lsse.RegionNumbers[n - 1];
            this.lsse.RegionNumbers[n - 1] = this.lsse.RegionNumbers[n];
            this.lsse.RegionNumbers[n] = n9;
            this.FillBlockList();
            n9 = n - 1;
            n10 = 0;
            for (n = 0; n < n9; ++n) {
                if (this.lsse.RegionNumbers[n] != this.lsse.RegionNumbers[n9]) continue;
                ++n10;
            }
            this.lRegions.select(n10);
            this.td.updateDimensions();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butToBack && this.lRegions.getItemCount() > 0) {
            int n;
            int n11 = this.lRegions.getSelectedIndex();
            int n12 = this.GetSelectedRegion();
            for (n = 0; n < this.lsse.RegionNumbers.length; ++n) {
                if (this.lsse.RegionNumbers[n] != n12) continue;
                if (n11 == 0) break;
                --n11;
            }
            if (n == this.lsse.RegionNumbers.length - 1) {
                return;
            }
            Rectangle rectangle = this.lsse.RegionBlocks[n + 1];
            this.lsse.RegionBlocks[n + 1] = this.lsse.RegionBlocks[n];
            this.lsse.RegionBlocks[n] = rectangle;
            n11 = this.lsse.RegionNumbers[n + 1];
            this.lsse.RegionNumbers[n + 1] = this.lsse.RegionNumbers[n];
            this.lsse.RegionNumbers[n] = n11;
            this.FillBlockList();
            n11 = n + 1;
            n12 = 0;
            for (n = 0; n < n11; ++n) {
                if (this.lsse.RegionNumbers[n] != this.lsse.RegionNumbers[n11]) continue;
                ++n12;
            }
            this.lRegions.select(n12);
            this.td.updateDimensions();
            this.repaint();
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.cRegions) {
            this.FillBlockList();
            this.td.SetRect(this.GetSelectedBlock());
            if (this.GetSelectedBlock() != null) {
                this.td.CenterOn(new Point((int)(this.GetSelectedBlock().getCenterX() / 32.0), (int)(this.GetSelectedBlock().getCenterY() / 32.0)));
            } else {
                this.td.updateDimensions();
            }
        }
        if (itemEvent.getSource() == this.lRegions) {
            this.td.SetRect(this.GetSelectedBlock());
            if (this.GetSelectedBlock() != null) {
                this.td.CenterOn(new Point((int)(this.GetSelectedBlock().getCenterX() / 32.0), (int)(this.GetSelectedBlock().getCenterY() / 32.0)));
            } else {
                this.td.updateDimensions();
            }
        }
    }
}

