/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

class RoutinesEditorWindow
extends Dialog
implements WindowListener,
ActionListener,
ItemListener {
    private LaserSquadScenarioEditor lsse;
    private Panel parent;
    private CauseAndEffect[] caeRoutines;
    private String[] sNames;
    private List lRoutines;
    private TextField tfNewName;
    private Button butApply;

    public RoutinesEditorWindow(LaserSquadScenarioEditor laserSquadScenarioEditor, Panel panel) {
        super(laserSquadScenarioEditor, "Routine Editor", true);
        Object object;
        this.lsse = laserSquadScenarioEditor;
        this.parent = panel;
        this.addWindowListener(this);
        this.lRoutines = new List(0, false);
        this.caeRoutines = new CauseAndEffect[laserSquadScenarioEditor.CAERoutines.size()];
        this.sNames = new String[laserSquadScenarioEditor.CAERoutines.size()];
        if (laserSquadScenarioEditor.CAERoutines.size() > 0) {
            for (int i = 0; i < laserSquadScenarioEditor.CAERoutines.size(); ++i) {
                object = (Object[])laserSquadScenarioEditor.CAERoutines.elementAt(i);
                this.sNames[i] = new String((String)object[0]);
                this.caeRoutines[i] = new CauseAndEffect((CauseAndEffect)object[1]);
                this.lRoutines.add(this.sNames[i]);
            }
        }
        this.lRoutines.setFont(LaserSquadScenarioEditor.font);
        this.lRoutines.addItemListener(this);
        this.add("East", this.lRoutines);
        Panel panel2 = new Panel(new FlowLayout(0));
        object = new Panel();
        Button button = new Button("New Routine");
        button.addActionListener(this);
        ((Container)object).add(button);
        button = new Button("Delete Routine");
        button.addActionListener(this);
        ((Container)object).add(button);
        panel2.add((Component)object);
        object = new Panel();
        this.tfNewName = new TextField(20);
        ((Container)object).add(this.tfNewName);
        button = new Button("Rename");
        button.addActionListener(this);
        ((Container)object).add(button);
        panel2.add((Component)object);
        object = new Panel();
        button = new Button("Edit Routine");
        button.addActionListener(this);
        ((Container)object).add(button);
        panel2.add((Component)object);
        this.add("Center", panel2);
        panel2 = new Panel();
        button = new Button("OK");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Cancel");
        button.addActionListener(this);
        panel2.add(button);
        this.butApply = new Button("Apply Changes");
        this.butApply.setEnabled(false);
        this.butApply.addActionListener(this);
        panel2.add(this.butApply);
        this.add("South", panel2);
        this.setBounds(laserSquadScenarioEditor.getX() + (laserSquadScenarioEditor.getWidth() - 450) / 2, laserSquadScenarioEditor.getY() + (laserSquadScenarioEditor.getHeight() - 300) / 2, 450, 300);
        this.show();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.lRoutines.getSelectedIndex();
        if (itemEvent.getStateChange() == 1 && n != -1) {
            this.tfNewName.setText(this.sNames[n]);
        }
    }

    protected CauseAndEffect getCAEtoEdit(int n) {
        return this.caeRoutines[n];
    }

    protected void setCAEChanged(int n, CauseAndEffect causeAndEffect) {
        this.caeRoutines[n] = causeAndEffect;
        this.butApply.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.lRoutines.getSelectedIndex();
        if (actionEvent.getActionCommand().equals("New Routine")) {
            int n2 = 1;
            for (n = 0; n < this.sNames.length; ++n) {
                if (!this.sNames[n].equals("New Routine " + n2)) continue;
                ++n2;
                n = -1;
            }
            this.lRoutines.add("New Routine " + n2);
            String[] stringArray = new String[this.sNames.length + 1];
            System.arraycopy(this.sNames, 0, stringArray, 0, this.sNames.length);
            stringArray[this.sNames.length] = "New Routine " + n2;
            this.sNames = stringArray;
            CauseAndEffect[] causeAndEffectArray = new CauseAndEffect[this.caeRoutines.length + 1];
            System.arraycopy(this.caeRoutines, 0, causeAndEffectArray, 0, this.caeRoutines.length);
            causeAndEffectArray[this.caeRoutines.length] = new CauseAndEffect(this.lsse);
            this.caeRoutines = causeAndEffectArray;
            this.butApply.setEnabled(true);
            return;
        }
        if (actionEvent.getActionCommand().equals("Delete Routine")) {
            if (n == -1) {
                new MessageBox(this.lsse, "Error!", "Select a Routine to Delete.", MessageBox.MB_OK);
                return;
            }
            this.lRoutines.remove(n);
            String[] stringArray = new String[this.sNames.length - 1];
            CauseAndEffect[] causeAndEffectArray = new CauseAndEffect[this.caeRoutines.length - 1];
            if (n != 0) {
                System.arraycopy(this.sNames, 0, stringArray, 0, n);
                System.arraycopy(this.caeRoutines, 0, causeAndEffectArray, 0, n);
            }
            if (n != stringArray.length) {
                System.arraycopy(this.sNames, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.caeRoutines, n + 1, causeAndEffectArray, n, causeAndEffectArray.length - n);
            }
            this.sNames = stringArray;
            this.caeRoutines = causeAndEffectArray;
            this.butApply.setEnabled(true);
            return;
        }
        if (actionEvent.getActionCommand().equals("Rename")) {
            if (n == -1) {
                new MessageBox(this.lsse, "Error!", "Select a Routine to Rename.", MessageBox.MB_OK);
                return;
            }
            if (this.tfNewName.getText().equals("")) {
                new MessageBox(this.lsse, "Error!", "Need a new name for Routine.", MessageBox.MB_OK);
                return;
            }
            for (int i = 0; i < this.sNames.length; ++i) {
                if (i == n || !this.sNames[i].equals(this.tfNewName.getText())) continue;
                new MessageBox(this.lsse, "Error!", "That name is already used for another Routine.", MessageBox.MB_OK);
                return;
            }
            this.sNames[n] = this.tfNewName.getText();
            this.lRoutines.replaceItem(this.sNames[n], n);
            this.butApply.setEnabled(true);
            return;
        }
        if (actionEvent.getActionCommand().equals("Edit Routine")) {
            if (n == -1) {
                new MessageBox(this.lsse, "Error!", "Select a Routine to Edit.", MessageBox.MB_OK);
                return;
            }
            new CauseAndEffectWindow(this.lsse, this, "Edit \"" + this.sNames[n] + "\"", 13, n);
            return;
        }
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("OK") || actionEvent.getActionCommand().equals("Apply Changes")) {
            Vector<Object[]> vector = new Vector<Object[]>();
            n = 0;
            while (n < this.sNames.length) {
                Object[] objectArray = new Object[]{this.sNames[n], this.caeRoutines[n++]};
                vector.add(objectArray);
            }
            this.lsse.CAERoutines = vector;
            this.butApply.setEnabled(false);
            if (actionEvent.getActionCommand().equals("OK")) {
                this.hide();
                this.dispose();
            }
            return;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.hide();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

