/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

class ScenarioEditor
extends Panel
implements TextListener,
KeyListener,
ActionListener,
ItemListener,
MouseListener {
    private LaserSquadScenarioEditor lsse;
    private TextField tfName;
    private TextField tfMaxTurns;
    private TextField tfDifficulty;
    private TextField tfOptionName;
    private int SEWidth = -1;
    private int SEHeight = -1;
    private Image SEImage = null;
    private Graphics SEGraph;
    private ArrowButton abTBUp;
    private ArrowButton abTBDown;
    private TextArea taIntro;
    private Button butMove;
    private Button butEndTurn;
    private Button butStartUp;
    private Button butPickUp;
    private Button butDrop;
    private Button butAddOption;
    private Button butRemoveOption;
    private Button butEditCause;
    private Button butEditEffect;
    private Button butSelectEffect;
    private Button butChangeEffect;
    private Button butEndEffect;
    private Button butTerrainDestroyEffect;
    private Button butItemDestroyEffect;
    private Button butRoutinesEdit;
    private Button butArraysEdit;
    private Choice cOptions;
    private int iImageChange;
    private Choice cArmours;
    private TextField tfAFront;
    private TextField tfARight;
    private TextField tfALeft;
    private TextField tfARear;
    private TextField tfAWeight;
    private TextField tfACarry;
    private TextField[] tfACost;
    private int xPos;
    private Checkbox cbDisplayHidden;

    public ScenarioEditor(LaserSquadScenarioEditor laserSquadScenarioEditor) {
        int n;
        this.lsse = laserSquadScenarioEditor;
        this.tfName = new TextField("", 17);
        this.tfName.setFont(LaserSquadScenarioEditor.font);
        this.tfName.addTextListener(this);
        this.add(this.tfName);
        this.cbDisplayHidden = new Checkbox("Show Hidden Moves");
        this.cbDisplayHidden.setState(false);
        this.cbDisplayHidden.setFont(LaserSquadScenarioEditor.font);
        this.cbDisplayHidden.addItemListener(this);
        this.add(this.cbDisplayHidden);
        this.butMove = new Button("Move Effects");
        this.butMove.addActionListener(this);
        this.add(this.butMove);
        this.butEndTurn = new Button("Turn End Effects");
        this.butEndTurn.addActionListener(this);
        this.add(this.butEndTurn);
        this.butStartUp = new Button("Start Game Effects");
        this.butStartUp.addActionListener(this);
        this.add(this.butStartUp);
        this.butEndEffect = new Button("End Game Effects");
        this.butEndEffect.addActionListener(this);
        this.add(this.butEndEffect);
        this.butPickUp = new Button("Pickup Item Effects");
        this.butPickUp.addActionListener(this);
        this.add(this.butPickUp);
        this.butDrop = new Button("Drop Item Effects");
        this.butDrop.addActionListener(this);
        this.add(this.butDrop);
        this.butChangeEffect = new Button("Change Item Effects");
        this.butChangeEffect.addActionListener(this);
        this.add(this.butChangeEffect);
        this.butSelectEffect = new Button("Select Unit Effects");
        this.butSelectEffect.addActionListener(this);
        this.add(this.butSelectEffect);
        this.butTerrainDestroyEffect = new Button("Terrain Destroyed Effects");
        this.butTerrainDestroyEffect.addActionListener(this);
        this.add(this.butTerrainDestroyEffect);
        this.butItemDestroyEffect = new Button("Item Destroyed Effects");
        this.butItemDestroyEffect.addActionListener(this);
        this.add(this.butItemDestroyEffect);
        this.butRoutinesEdit = new Button("Edit Routines");
        this.butRoutinesEdit.addActionListener(this);
        this.add(this.butRoutinesEdit);
        this.butArraysEdit = new Button("Edit Arrays");
        this.butArraysEdit.addActionListener(this);
        this.add(this.butArraysEdit);
        this.tfMaxTurns = new TextField("", 4);
        this.tfMaxTurns.setFont(LaserSquadScenarioEditor.font);
        this.tfMaxTurns.addKeyListener(this);
        this.tfMaxTurns.addTextListener(this);
        this.add(this.tfMaxTurns);
        this.tfDifficulty = new TextField("", 2);
        this.tfDifficulty.setFont(LaserSquadScenarioEditor.font);
        this.tfDifficulty.addKeyListener(this);
        this.tfDifficulty.addTextListener(this);
        this.add(this.tfDifficulty);
        this.abTBUp = new ArrowButton(true);
        this.abTBUp.addActionListener(this);
        this.add(this.abTBUp);
        this.abTBDown = new ArrowButton(false);
        this.abTBDown.addActionListener(this);
        this.add(this.abTBDown);
        this.taIntro = new TextArea("", 10, 40, 1);
        this.taIntro.setFont(LaserSquadScenarioEditor.font);
        this.taIntro.addTextListener(this);
        this.add(this.taIntro);
        this.cOptions = new Choice();
        this.cOptions.setFont(LaserSquadScenarioEditor.font);
        if (laserSquadScenarioEditor.ExtraPlayerOptions.size() != 0) {
            for (n = 0; n < laserSquadScenarioEditor.ExtraPlayerOptions.size(); ++n) {
                this.cOptions.add((String)((Object[])laserSquadScenarioEditor.ExtraPlayerOptions.elementAt(n))[0]);
            }
            this.cOptions.select(0);
        }
        this.cOptions.addItemListener(this);
        this.add(this.cOptions);
        this.tfOptionName = new TextField("", 8);
        this.tfOptionName.setFont(LaserSquadScenarioEditor.font);
        this.tfOptionName.addTextListener(this);
        this.add(this.tfOptionName);
        this.butAddOption = new Button("Add New Option");
        this.butAddOption.addActionListener(this);
        this.add(this.butAddOption);
        this.butRemoveOption = new Button("Remove Option");
        this.butRemoveOption.addActionListener(this);
        this.add(this.butRemoveOption);
        this.butEditCause = new Button("Edit Requirements");
        this.butEditCause.addActionListener(this);
        this.add(this.butEditCause);
        this.butEditEffect = new Button("Edit Effects");
        this.butEditEffect.addActionListener(this);
        this.add(this.butEditEffect);
        this.cArmours = new Choice();
        this.cArmours.setFont(LaserSquadScenarioEditor.font);
        this.cArmours.add("No Armour");
        this.cArmours.add("Armour 1");
        this.cArmours.add("Armour 2");
        this.cArmours.add("Armour 3");
        this.cArmours.add("Armour 4");
        this.cArmours.select(0);
        this.cArmours.addItemListener(this);
        this.add(this.cArmours);
        this.tfAFront = new TextField("", 4);
        this.tfAFront.setFont(LaserSquadScenarioEditor.font);
        this.tfAFront.addTextListener(this);
        this.tfAFront.addKeyListener(this);
        this.add(this.tfAFront);
        this.tfARight = new TextField("", 4);
        this.tfARight.setFont(LaserSquadScenarioEditor.font);
        this.tfARight.addTextListener(this);
        this.tfARight.addKeyListener(this);
        this.add(this.tfARight);
        this.tfALeft = new TextField("", 4);
        this.tfALeft.setFont(LaserSquadScenarioEditor.font);
        this.tfALeft.addTextListener(this);
        this.tfALeft.addKeyListener(this);
        this.add(this.tfALeft);
        this.tfARear = new TextField("", 4);
        this.tfARear.setFont(LaserSquadScenarioEditor.font);
        this.tfARear.addTextListener(this);
        this.tfARear.addKeyListener(this);
        this.add(this.tfARear);
        this.tfAWeight = new TextField("", 4);
        this.tfAWeight.setFont(LaserSquadScenarioEditor.font);
        this.tfAWeight.addTextListener(this);
        this.tfAWeight.addKeyListener(this);
        this.add(this.tfAWeight);
        this.tfACarry = new TextField("", 4);
        this.tfACarry.setFont(LaserSquadScenarioEditor.font);
        this.tfACarry.addTextListener(this);
        this.tfACarry.addKeyListener(this);
        this.add(this.tfACarry);
        this.tfACost = new TextField[laserSquadScenarioEditor.Teams.length];
        for (n = 0; n < laserSquadScenarioEditor.Teams.length; ++n) {
            this.tfACost[n] = new TextField("", 4);
            this.tfACost[n].setFont(LaserSquadScenarioEditor.font);
            this.tfACost[n].addTextListener(this);
            this.tfACost[n].addKeyListener(this);
            this.add(this.tfACost[n]);
        }
        this.addMouseListener(this);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.SEWidth || n4 != this.SEHeight) {
            this.SEWidth = n3;
            this.SEHeight = n4;
            this.SEImage = this.createImage(n3, n4);
            this.SEGraph = this.SEImage.getGraphics();
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    private void RepaintOffScreenImage() {
        if (this.SEGraph == null) {
            return;
        }
        this.SEGraph.setColor(new Color(240, 240, 240));
        this.SEGraph.fillRect(0, 0, this.SEWidth, this.SEHeight);
        this.SEGraph.setColor(Color.BLACK);
        this.SEGraph.setFont(LaserSquadScenarioEditor.font);
        this.SEGraph.drawString("Scenario Name:", 5, 14);
        this.tfName.setText(this.lsse.ScenarioName);
        this.cbDisplayHidden.setState((this.lsse.iScenarioFlags & 1) == 1);
        this.SEGraph.drawString("Maximum Number Of Turns:", 5, 34);
        this.tfMaxTurns.setText(this.lsse.MaxNumberOfTurns == 65535 ? "-" : Integer.toString(this.lsse.MaxNumberOfTurns));
        this.SEGraph.drawString("Maximum Difficulty Level:", 5, 54);
        this.tfDifficulty.setText(Integer.toString(this.lsse.MaxDifficultyLevel));
        this.SEGraph.drawString("Number of Terrain Bands: " + Integer.toString(this.lsse.Terrains[0].MovementCost.length), 5, 74);
        this.SEGraph.drawString("Cursor:", 600, 29);
        this.SEGraph.drawImage(this.lsse.ICursor, 670, 10, null);
        this.SEGraph.drawString("Impact", 305, 69);
        this.SEGraph.drawString("Flash:", 305, 89);
        this.SEGraph.drawImage(this.lsse.IHitImages[0], 370, 60, null);
        this.SEGraph.drawImage(this.lsse.IHitImages[1], 410, 60, null);
        this.SEGraph.drawImage(this.lsse.IHitImages[2], 450, 60, null);
        this.SEGraph.drawImage(this.lsse.IHitImages[3], 490, 60, null);
        this.SEGraph.drawString("Damage", 600, 69);
        this.SEGraph.drawString("Flash:", 600, 89);
        this.SEGraph.drawImage(this.lsse.IDamageImages[0], 670, 60, null);
        this.SEGraph.drawImage(this.lsse.IDamageImages[1], 710, 60, null);
        this.SEGraph.drawString("Introduction Text:", 5, 95);
        this.taIntro.setText(this.lsse.sIntroductionText);
        this.SEGraph.drawString("Extra Menu Options:", 5, 280);
        if (this.lsse.ExtraPlayerOptions.size() == 0) {
            this.cOptions.setEnabled(false);
            this.tfOptionName.setEnabled(false);
            this.butRemoveOption.setEnabled(false);
            this.butEditCause.setEnabled(false);
            this.butEditEffect.setEnabled(false);
            this.tfOptionName.setText("");
        } else {
            this.cOptions.setEnabled(true);
            this.tfOptionName.setEnabled(true);
            this.butRemoveOption.setEnabled(true);
            this.butEditCause.setEnabled(true);
            this.butEditEffect.setEnabled(true);
            this.tfOptionName.setText((String)((Object[])this.lsse.ExtraPlayerOptions.elementAt(this.cOptions.getSelectedIndex()))[0]);
        }
        this.SEGraph.drawString("Armour:", 5, 340);
        this.SEGraph.drawString("Weight:", 140, 360);
        this.tfAWeight.setText(Integer.toString(this.lsse.Armours[this.cArmours.getSelectedIndex()].Weight));
        this.SEGraph.drawString("Carry:", 140, 385);
        this.tfACarry.setText(Integer.toString(this.lsse.Armours[this.cArmours.getSelectedIndex()].Carry));
        this.SEGraph.drawString("Front:", 400, 360);
        this.tfAFront.setText(Integer.toString(this.lsse.Armours[this.cArmours.getSelectedIndex()].Front));
        this.SEGraph.drawString("Left:", 300, 385);
        this.tfALeft.setText(Integer.toString(this.lsse.Armours[this.cArmours.getSelectedIndex()].Left));
        this.SEGraph.drawString("Right:", 500, 385);
        this.tfARight.setText(Integer.toString(this.lsse.Armours[this.cArmours.getSelectedIndex()].Right));
        this.SEGraph.drawString("Rear:", 400, 410);
        this.tfARear.setText(Integer.toString(this.lsse.Armours[this.cArmours.getSelectedIndex()].Rear));
        this.SEGraph.drawString("Team Cost:", 5, 410);
        this.xPos = 5;
        for (int i = 0; i < this.lsse.Teams.length; ++i) {
            if (this.lsse.Teams[i].name.length() > this.xPos) {
                this.xPos = this.lsse.Teams[i].name.length();
            }
            this.SEGraph.drawString(this.lsse.Teams[i].name, 5, 430 + i * 20);
            this.tfACost[i].setText(Integer.toString(this.lsse.Armours[this.cArmours.getSelectedIndex()].Cost[i]));
        }
        this.xPos *= 11;
    }

    public void paint(Graphics graphics) {
        this.SEGraph.setColor(new Color(240, 240, 240));
        this.SEGraph.drawLine(0, 0, 0, 1);
        graphics.drawImage(this.SEImage, 0, 0, null);
        this.tfName.setBounds(145, 1, 250, 20);
        this.cbDisplayHidden.setBounds(410, 1, 190, 20);
        this.tfMaxTurns.setBounds(245, 21, 60, 20);
        this.tfDifficulty.setBounds(255, 41, 30, 20);
        this.abTBUp.setBounds(270, 61, 10, 10);
        this.abTBDown.setBounds(270, 71, 10, 10);
        this.taIntro.setBounds(5, 100, this.getSize().width - 10, 160);
        this.cOptions.setLocation(5, 290);
        this.tfOptionName.setBounds(190, 292, 160, 20);
        this.butAddOption.setLocation(350, 265);
        this.butRemoveOption.setLocation(470, 265);
        this.butEditCause.setLocation(350, 292);
        this.butEditEffect.setLocation(470, 292);
        this.butMove.setLocation(635, 265);
        this.butEndTurn.setLocation(635, 295);
        this.butStartUp.setLocation(635, 335);
        this.butEndEffect.setLocation(635, 365);
        this.butPickUp.setLocation(635, 405);
        this.butDrop.setLocation(635, 435);
        this.butChangeEffect.setLocation(635, 465);
        this.butSelectEffect.setLocation(635, 505);
        this.butTerrainDestroyEffect.setLocation(460, 475);
        this.butItemDestroyEffect.setLocation(460, 505);
        this.butRoutinesEdit.setLocation(350, 475);
        this.butArraysEdit.setLocation(350, 505);
        this.cArmours.setLocation(5, 345);
        this.tfAWeight.setBounds(210, 347, 60, 20);
        this.tfACarry.setBounds(200, 372, 60, 20);
        this.tfAFront.setBounds(460, 347, 60, 20);
        this.tfALeft.setBounds(350, 372, 60, 20);
        this.tfARight.setBounds(560, 372, 60, 20);
        this.tfARear.setBounds(450, 397, 60, 20);
        for (int i = 0; i < this.lsse.Teams.length; ++i) {
            this.tfACost[i].setBounds(this.xPos, 417 + i * 20, 60, 20);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.cOptions) {
            this.tfOptionName.setText((String)((Object[])this.lsse.ExtraPlayerOptions.elementAt(this.cOptions.getSelectedIndex()))[0]);
        }
        if (itemEvent.getSource() == this.cArmours) {
            this.RepaintOffScreenImage();
            this.repaint();
        }
        if (itemEvent.getSource() == this.cbDisplayHidden) {
            this.lsse.iScenarioFlags = itemEvent.getStateChange() == 1 ? (this.lsse.iScenarioFlags |= 1) : (this.lsse.iScenarioFlags -= this.lsse.iScenarioFlags & 1);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        int n;
        int n2;
        if (textEvent.getSource() == this.tfName && textEvent.getID() == 900) {
            n2 = this.tfName.getCaretPosition();
            this.lsse.ScenarioName = new String(this.tfName.getText().toUpperCase());
            if (this.lsse.ScenarioName.length() > 24) {
                this.lsse.ScenarioName = this.lsse.ScenarioName.substring(0, 24);
            }
            if (!this.tfName.getText().equals(this.lsse.ScenarioName)) {
                this.tfName.setText(this.lsse.ScenarioName);
                this.tfName.setCaretPosition(n2);
            }
        }
        if (textEvent.getSource() == this.tfMaxTurns && textEvent.getID() == 900) {
            try {
                n2 = Integer.parseInt(this.tfMaxTurns.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 65535;
            }
            if (n2 > 65535 || n2 < 0) {
                n2 = 65535;
            }
            this.lsse.MaxNumberOfTurns = n2;
            if (!this.tfMaxTurns.getText().equals(this.lsse.MaxNumberOfTurns == 65535 ? "-" : Integer.toString(this.lsse.MaxNumberOfTurns))) {
                this.tfMaxTurns.setText(this.lsse.MaxNumberOfTurns == 65535 ? "-" : Integer.toString(this.lsse.MaxNumberOfTurns));
            }
            return;
        }
        if (textEvent.getSource() == this.tfDifficulty) {
            try {
                n2 = Integer.parseInt(this.tfDifficulty.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            if (n2 == this.lsse.MaxDifficultyLevel) {
                return;
            }
            for (int i = 0; i < this.lsse.Teams.length; ++i) {
                int[] nArray = new int[n2];
                System.arraycopy(this.lsse.Teams[i].CreditsAtDifficultyLevel, 0, nArray, 0, this.lsse.MaxDifficultyLevel > n2 ? n2 : this.lsse.MaxDifficultyLevel);
                this.lsse.Teams[i].CreditsAtDifficultyLevel = nArray;
                nArray = new int[n2];
                System.arraycopy(this.lsse.Teams[i].MemoryLength, 0, nArray, 0, this.lsse.MaxDifficultyLevel > n2 ? n2 : this.lsse.MaxDifficultyLevel);
                this.lsse.Teams[i].MemoryLength = nArray;
            }
            this.lsse.MaxDifficultyLevel = n2;
            return;
        }
        if (textEvent.getSource() == this.taIntro && textEvent.getID() == 900) {
            this.lsse.sIntroductionText = new String(this.taIntro.getText());
        }
        if (textEvent.getSource() == this.tfOptionName && textEvent.getID() == 900 && this.lsse.ExtraPlayerOptions.size() != 0) {
            n = this.cOptions.getSelectedIndex();
            Object[] objectArray = (Object[])this.lsse.ExtraPlayerOptions.elementAt(n);
            n2 = this.tfOptionName.getCaretPosition();
            objectArray[0] = new String(this.tfOptionName.getText().toUpperCase());
            this.lsse.ExtraPlayerOptions.setElementAt(objectArray, n);
            if (!this.cOptions.getItem(n).equals((String)objectArray[0])) {
                this.tfOptionName.setText((String)objectArray[0]);
                this.tfOptionName.setCaretPosition(n2);
                this.remove(this.cOptions);
                this.cOptions = new Choice();
                this.cOptions.setFont(LaserSquadScenarioEditor.font);
                for (n2 = 0; n2 < this.lsse.ExtraPlayerOptions.size(); ++n2) {
                    this.cOptions.add((String)((Object[])this.lsse.ExtraPlayerOptions.elementAt(n2))[0]);
                }
                this.cOptions.select(n);
                this.cOptions.addItemListener(this);
                this.add(this.cOptions);
                this.repaint();
            }
        }
        if (textEvent.getSource() == this.tfAWeight && textEvent.getID() == 900) {
            try {
                n2 = Integer.parseInt(this.tfAWeight.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.lsse.Armours[this.cArmours.getSelectedIndex()].Weight = n2;
            return;
        }
        if (textEvent.getSource() == this.tfACarry && textEvent.getID() == 900) {
            try {
                n2 = Integer.parseInt(this.tfACarry.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.lsse.Armours[this.cArmours.getSelectedIndex()].Carry = n2;
            return;
        }
        if (textEvent.getSource() == this.tfAFront && textEvent.getID() == 900) {
            try {
                n2 = Integer.parseInt(this.tfAFront.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.lsse.Armours[this.cArmours.getSelectedIndex()].Front = n2;
            return;
        }
        if (textEvent.getSource() == this.tfALeft && textEvent.getID() == 900) {
            try {
                n2 = Integer.parseInt(this.tfALeft.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.lsse.Armours[this.cArmours.getSelectedIndex()].Left = n2;
            return;
        }
        if (textEvent.getSource() == this.tfARight && textEvent.getID() == 900) {
            try {
                n2 = Integer.parseInt(this.tfARight.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.lsse.Armours[this.cArmours.getSelectedIndex()].Right = n2;
            return;
        }
        if (textEvent.getSource() == this.tfARear && textEvent.getID() == 900) {
            try {
                n2 = Integer.parseInt(this.tfARear.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.lsse.Armours[this.cArmours.getSelectedIndex()].Rear = n2;
            return;
        }
        for (n = 0; n < this.lsse.Teams.length; ++n) {
            if (textEvent.getSource() != this.tfACost[n] || textEvent.getID() != 900) continue;
            try {
                n2 = Integer.parseInt(this.tfACost[n].getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.lsse.Armours[this.cArmours.getSelectedIndex()].Cost[n] = n2;
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.lsse.Terrains[0].MovementCost.length - 1;
        if (actionEvent.getSource() == this.abTBUp) {
            for (int i = 0; i < this.lsse.Terrains.length; ++i) {
                this.lsse.Terrains[i].MovementCost = ScenarioEditorUtility.arrayAdd(this.lsse.Terrains[i].MovementCost, 0);
            }
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.abTBDown && n > 0) {
            int n2;
            for (n2 = 0; n2 < this.lsse.Terrains.length; ++n2) {
                this.lsse.Terrains[n2].MovementCost = ScenarioEditorUtility.arrayDeleteElementAt(this.lsse.Terrains[n2].MovementCost, n);
            }
            if (this.lsse.Units.length != 0) {
                for (n2 = 0; n2 < this.lsse.Units.length; ++n2) {
                    if (this.lsse.Units[n2].TerrainMovementBand != n) continue;
                    --this.lsse.Units[n2].TerrainMovementBand;
                }
            }
            this.lsse.CheckCAEChange(6, n);
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butMove) {
            new CauseAndEffectWindow(this.lsse, this, "Pre-Movement effects", 0, 0);
        }
        if (actionEvent.getSource() == this.butEndTurn) {
            new CauseAndEffectWindow(this.lsse, this, "End of Turn effects", 2, 0);
        }
        if (actionEvent.getSource() == this.butStartUp) {
            new CauseAndEffectWindow(this.lsse, this, "Start of Game effects", 4, 0);
        }
        if (actionEvent.getSource() == this.butPickUp) {
            new CauseAndEffectWindow(this.lsse, this, "Effects when pick up an item", 6, 0);
        }
        if (actionEvent.getSource() == this.butDrop) {
            new CauseAndEffectWindow(this.lsse, this, "Effects when drop an item", 7, 0);
        }
        if (actionEvent.getSource() == this.butChangeEffect) {
            new CauseAndEffectWindow(this.lsse, this, "Effects when change an item", 8, 0);
        }
        if (actionEvent.getSource() == this.butEndEffect) {
            new CauseAndEffectWindow(this.lsse, this, "Effects when Game Ends", 9, 0);
        }
        if (actionEvent.getSource() == this.butSelectEffect) {
            new CauseAndEffectWindow(this.lsse, this, "Effects when unit is selected", 10, 0);
        }
        if (actionEvent.getSource() == this.butTerrainDestroyEffect) {
            new CauseAndEffectWindow(this.lsse, this, "Effects when Terrain is destroyed", 11, 0);
        }
        if (actionEvent.getSource() == this.butItemDestroyEffect) {
            new CauseAndEffectWindow(this.lsse, this, "Effects when Item is destroyed", 12, 0);
        }
        if (actionEvent.getSource() == this.butAddOption) {
            Object[] objectArray = new Object[]{new String("/Q0D0DOPTION"), new CauseAndEffect(this.lsse), new CauseAndEffect(this.lsse)};
            this.lsse.ExtraPlayerOptions.add(objectArray);
            n = this.lsse.ExtraPlayerOptions.size() == 1 ? 0 : this.cOptions.getSelectedIndex();
            this.remove(this.cOptions);
            this.cOptions = new Choice();
            this.cOptions.setFont(LaserSquadScenarioEditor.font);
            for (int i = 0; i < this.lsse.ExtraPlayerOptions.size(); ++i) {
                this.cOptions.add((String)((Object[])this.lsse.ExtraPlayerOptions.elementAt(i))[0]);
            }
            this.cOptions.select(n);
            this.cOptions.addItemListener(this);
            this.add(this.cOptions);
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butRemoveOption) {
            n = this.cOptions.getSelectedIndex();
            this.lsse.ExtraPlayerOptions.removeElementAt(n);
            this.remove(this.cOptions);
            this.cOptions = new Choice();
            this.cOptions.setFont(LaserSquadScenarioEditor.font);
            if (this.lsse.ExtraPlayerOptions.size() > 0) {
                for (int i = 0; i < this.lsse.ExtraPlayerOptions.size(); ++i) {
                    this.cOptions.add((String)((Object[])this.lsse.ExtraPlayerOptions.elementAt(i))[0]);
                }
                this.cOptions.select(n == 0 ? 0 : n - 1);
            }
            this.cOptions.addItemListener(this);
            this.add(this.cOptions);
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butEditCause) {
            new CauseAndEffectWindow(this.lsse, this, "Is Menu Option Allowed?", 5, this.cOptions.getSelectedIndex() * 2);
        }
        if (actionEvent.getSource() == this.butEditEffect) {
            new CauseAndEffectWindow(this.lsse, this, "Effects of Menu option", 5, 1 + this.cOptions.getSelectedIndex() * 2);
        }
        if (actionEvent.getSource() == this.butRoutinesEdit) {
            new RoutinesEditorWindow(this.lsse, this);
        }
        if (actionEvent.getSource() == this.butArraysEdit) {
            new ArraysEditorWindow(this.lsse, this);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) && c != '\b' && c != '-') {
            keyEvent.consume();
        }
        if (c == '-' && keyEvent.getSource() != this.tfMaxTurns) {
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    protected void NotifyChangePic(Image image) {
        if (this.iImageChange < 5) {
            this.lsse.IHitImages[this.iImageChange - 1] = image;
        }
        if (this.iImageChange == 5) {
            this.lsse.ICursor = image;
        }
        if (this.iImageChange > 5) {
            this.lsse.IDamageImages[this.iImageChange - 6] = image;
        }
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.iImageChange = 0;
        if (n >= 370 && n < 402 && n2 >= 60 && n2 < 92) {
            this.iImageChange = 1;
        }
        if (n >= 410 && n < 442 && n2 >= 60 && n2 < 92) {
            this.iImageChange = 2;
        }
        if (n >= 450 && n < 482 && n2 >= 60 && n2 < 92) {
            this.iImageChange = 3;
        }
        if (n >= 490 && n < 522 && n2 >= 60 && n2 < 92) {
            this.iImageChange = 4;
        }
        if (this.iImageChange != 0) {
            new ImageSelector(this.lsse, this, 11, "Select Impact picture", this.lsse.IHitImages[this.iImageChange - 1]);
            return;
        }
        if (n >= 670 && n < 702 && n2 >= 10 && n2 < 42) {
            this.iImageChange = 5;
        }
        if (this.iImageChange == 5) {
            new ImageSelector(this.lsse, this, 11, "Select Cursor picture", this.lsse.ICursor);
            return;
        }
        if (n >= 670 && n < 702 && n2 >= 60 && n2 < 92) {
            this.iImageChange = 6;
        }
        if (n >= 710 && n < 742 && n2 >= 60 && n2 < 92) {
            this.iImageChange = 7;
        }
        if (this.iImageChange != 0) {
            new ImageSelector(this.lsse, this, 11, "Select Damage picture", this.lsse.IDamageImages[this.iImageChange - 6]);
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

