/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

class ScenarioEditorUtility {
    ScenarioEditorUtility() {
    }

    public static int arrayPos(int[] nArray, int n) {
        if (nArray == null || nArray.length == 0) {
            return -1;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int[] arrayAdd(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray.length] = n;
        return nArray2;
    }

    public static int[] arrayDeleteElementAt(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length - 1];
        if (nArray.length == 0) {
            return nArray2;
        }
        if (n != 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n != nArray.length - 1) {
            System.arraycopy(nArray, n + 1, nArray2, n, nArray.length - n - 1);
        }
        return nArray2;
    }

    public static int[] arrayDeleteItem(int[] nArray, int n) {
        return (n = ScenarioEditorUtility.arrayPos(nArray, n)) == -1 ? nArray : ScenarioEditorUtility.arrayDeleteElementAt(nArray, n);
    }

    public static boolean ImagesIdentical(Image image, Image image2) {
        int[] nArray = new int[1024];
        int[] nArray2 = new int[1024];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 32, 32, nArray, 0, 32);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        pixelGrabber = new PixelGrabber(image2, 0, 0, 32, 32, nArray2, 0, 32);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return Arrays.equals(nArray, nArray2);
    }

    public static boolean ScannerImagesIdentical(Image image, Image image2) {
        int[] nArray = new int[36];
        int[] nArray2 = new int[36];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 6, 6, nArray, 0, 6);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        pixelGrabber = new PixelGrabber(image2, 0, 0, 6, 6, nArray2, 0, 6);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return Arrays.equals(nArray, nArray2);
    }

    public static void WriteArray(DataOutputStream dataOutputStream, int[] nArray) throws IOException {
        dataOutputStream.writeInt(nArray == null ? 0 : nArray.length);
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            dataOutputStream.writeInt(nArray[i]);
        }
    }

    public static void WriteMapImage(DataOutputStream dataOutputStream, Image image) throws IOException {
        int[] nArray = new int[1024];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 32, 32, nArray, 0, 32);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (int i = 0; i < 1024; ++i) {
            dataOutputStream.writeInt(nArray[i]);
        }
    }

    public static void WriteScannerImage(DataOutputStream dataOutputStream, Image image) throws IOException {
        int[] nArray = new int[36];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 6, 6, nArray, 0, 6);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (int i = 0; i < 36; ++i) {
            dataOutputStream.writeInt(nArray[i]);
        }
    }

    public static void WriteMapPicArray(DataOutputStream dataOutputStream, Image[] imageArray) throws IOException {
        dataOutputStream.writeInt(imageArray == null ? 0 : imageArray.length);
        if (imageArray == null) {
            return;
        }
        for (int i = 0; i < imageArray.length; ++i) {
            ScenarioEditorUtility.WriteMapImage(dataOutputStream, imageArray[i]);
        }
    }

    public static void WriteScannerPicArray(DataOutputStream dataOutputStream, Image[] imageArray) throws IOException {
        dataOutputStream.writeInt(imageArray == null ? 0 : imageArray.length);
        if (imageArray == null) {
            return;
        }
        for (int i = 0; i < imageArray.length; ++i) {
            ScenarioEditorUtility.WriteScannerImage(dataOutputStream, imageArray[i]);
        }
    }

    public static int[] ReadArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = dataInputStream.readInt();
        }
        return nArray;
    }

    public static Image ReadMapImage(DataInputStream dataInputStream) throws IOException {
        int[] nArray = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(32, 32, nArray, 0, 32));
    }

    public static Image ReadScannerImage(DataInputStream dataInputStream) throws IOException {
        int[] nArray = new int[36];
        for (int i = 0; i < 36; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(6, 6, nArray, 0, 6));
    }

    public static Image[] ReadMapPicArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        Image[] imageArray = new Image[n];
        for (n = 0; n < imageArray.length; ++n) {
            imageArray[n] = ScenarioEditorUtility.ReadMapImage(dataInputStream);
        }
        return imageArray;
    }

    public static Image[] ReadScannerPicArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        Image[] imageArray = new Image[n];
        for (n = 0; n < imageArray.length; ++n) {
            imageArray[n] = ScenarioEditorUtility.ReadScannerImage(dataInputStream);
        }
        return imageArray;
    }

    public static void AddTarget(int[][] nArray, int n, Point point) {
        if (nArray[0].length != 0) {
            for (int i = 0; i < nArray[0].length; ++i) {
                if (nArray[0][i] != n || nArray[1][i] != point.x || nArray[2][i] != point.y) continue;
                return;
            }
        }
        nArray[0] = ScenarioEditorUtility.arrayAdd(nArray[0], n);
        nArray[1] = ScenarioEditorUtility.arrayAdd(nArray[1], point.x);
        nArray[2] = ScenarioEditorUtility.arrayAdd(nArray[2], point.y);
    }
}

