/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;

class TargetTerrainPanel
extends Panel
implements AdjustmentListener,
MouseListener,
ItemListener,
ActionListener,
Runnable {
    private LaserSquadScenarioEditor lsse;
    private TerrainDisplay td;
    private TargetTerrainDialog parent;
    private Image TTLImage = null;
    private Graphics TTLGraph;
    private int TTLWidth = -1;
    private int TTLHeight = -1;
    private int pointer = -1;
    private int iTargets;
    private Scrollbar sb;
    private int[] Nodes;
    private int[] xPos;
    private int[] yPos;
    private Panel panMode = new Panel();
    private Panel panAddRemove = new Panel();
    private boolean bMode = true;

    public TargetTerrainPanel(LaserSquadScenarioEditor laserSquadScenarioEditor, TargetTerrainDialog targetTerrainDialog, EditorUnit editorUnit) {
        this.lsse = laserSquadScenarioEditor;
        this.parent = targetTerrainDialog;
        this.td = new TerrainDisplay(laserSquadScenarioEditor, this);
        this.add(this.td);
        this.iTargets = editorUnit.TargetTerrainsClosestNodes == null ? 0 : editorUnit.TargetTerrainsClosestNodes.length;
        this.Nodes = new int[this.iTargets];
        this.xPos = new int[this.iTargets];
        this.yPos = new int[this.iTargets];
        if (this.iTargets != 0) {
            System.arraycopy(editorUnit.TargetTerrainsClosestNodes, 0, this.Nodes, 0, this.iTargets);
            for (int i = 0; i < this.iTargets; ++i) {
                this.xPos[i] = editorUnit.TargetTerrainsPositions[i].x;
                this.yPos[i] = editorUnit.TargetTerrainsPositions[i].y;
            }
            this.td.SetRect(new Rectangle(this.xPos[0] * 32, this.yPos[0] * 32, 32, 32));
            this.td.SetHighlightPoint(this.Nodes[0]);
            this.pointer = 0;
        } else {
            this.td.SetRect(new Rectangle(-1, -1, 0, 0));
            this.td.SetHighlightPoint(-1);
        }
        this.sb = new Scrollbar(1, 0, 1, 0, this.iTargets);
        this.sb.addAdjustmentListener(this);
        this.add(this.sb);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        Checkbox checkbox = new Checkbox("Target Select", checkboxGroup, true);
        checkbox.addItemListener(this);
        this.panMode.add(checkbox);
        checkbox = new Checkbox("Node Select", checkboxGroup, false);
        checkbox.addItemListener(this);
        this.panMode.add(checkbox);
        this.add(this.panMode);
        Button button = new Button("Add");
        button.addActionListener(this);
        this.panAddRemove.add(button);
        button = new Button("Remove");
        button.addActionListener(this);
        this.panAddRemove.add(button);
        this.add(this.panAddRemove);
        this.addMouseListener(this);
        new Thread(this).start();
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.iTargets != 0) {
            this.td.CenterOn(new Point(this.xPos[0], this.yPos[0]));
        }
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.TTLWidth || n4 != this.TTLHeight) {
            this.TTLWidth = n3;
            this.TTLHeight = n4;
            this.TTLImage = this.createImage(183, n4);
            this.TTLGraph = this.TTLImage == null ? null : this.TTLImage.getGraphics();
            this.RepaintOffScreenImage();
            this.repaint();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        int n = this.TTLHeight;
        if (this.TTLGraph == null) {
            return;
        }
        this.TTLGraph.setColor(Color.WHITE);
        this.TTLGraph.fillRect(0, 0, 190, n);
        this.sb.setVisibleAmount(n /= 34);
        if (this.sb.getMaximum() != this.iTargets) {
            this.sb.setMaximum(this.iTargets);
        }
        this.TTLGraph.setColor(Color.BLACK);
        this.TTLGraph.setFont(LaserSquadScenarioEditor.font);
        int n2 = this.sb.getValue();
        if (n2 != -1) {
            int n3 = 0;
            int n4 = 14;
            while (n3 < n && n2 < this.iTargets) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.lsse.Terrains[this.lsse.GetTerrainAt((int)this.xPos[n2], (int)this.yPos[n2])].name, "//", false);
                if (stringTokenizer.hasMoreTokens()) {
                    this.TTLGraph.drawString(stringTokenizer.nextToken(), 1, n4);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    this.TTLGraph.drawString(stringTokenizer.nextToken(), 1, n4 + 16);
                }
                this.TTLGraph.drawString(Integer.toString(this.xPos[n2]) + "," + Integer.toString(this.yPos[n2]), 101, n4);
                this.TTLGraph.drawString("Node:" + Integer.toString(this.Nodes[n2]), 101, n4 + 16);
                if (n2 == this.pointer) {
                    this.TTLGraph.setColor(Color.RED);
                    this.TTLGraph.drawRect(0, n3 * 34, 182, 33);
                    this.TTLGraph.setColor(Color.BLACK);
                }
                ++n3;
                ++n2;
                n4 += 34;
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.TTLGraph.setColor(Color.WHITE);
        this.TTLGraph.drawLine(this.TTLWidth - 18, 1, this.TTLWidth - 18, 2);
        if (this.TTLImage != null) {
            graphics.drawImage(this.TTLImage, this.TTLWidth - 200, 0, null);
        }
        this.sb.setBounds(this.TTLWidth - 16, 0, 16, this.TTLHeight - 30);
        this.td.setBounds(0, 0, this.TTLWidth - 200, this.TTLHeight - 25);
        this.panMode.setBounds(0, this.TTLHeight - 30, this.TTLWidth - 200, 30);
        this.panAddRemove.setBounds(this.TTLWidth - 200, this.TTLHeight - 30, 200, 30);
    }

    protected void SetTargetsForUnit(EditorUnit editorUnit) {
        if (this.iTargets == 0) {
            editorUnit.TargetTerrainsClosestNodes = null;
            editorUnit.TargetTerrainsPositions = null;
            return;
        }
        editorUnit.TargetTerrainsClosestNodes = new int[this.iTargets];
        editorUnit.TargetTerrainsPositions = new Point[this.iTargets];
        System.arraycopy(this.Nodes, 0, editorUnit.TargetTerrainsClosestNodes, 0, this.iTargets);
        for (int i = 0; i < this.iTargets; ++i) {
            editorUnit.TargetTerrainsPositions[i] = new Point(this.xPos[i], this.yPos[i]);
        }
    }

    protected void NotifyClick(Point point) {
        if (this.xPos.length == 0) {
            return;
        }
        if (this.bMode) {
            this.xPos[this.pointer] = point.x;
            this.yPos[this.pointer] = point.y;
            this.td.SetRect(new Rectangle(this.xPos[this.pointer] * 32, this.yPos[this.pointer] * 32, 32, 32));
        } else {
            int n;
            for (n = 0; n < this.lsse.Nodes.length && !this.lsse.Nodes[n].equals(point); ++n) {
            }
            if (n != this.lsse.Nodes.length) {
                this.Nodes[this.pointer] = n;
                this.td.SetHighlightPoint(n);
            }
        }
        this.td.RepaintOffScreenImage();
        this.td.repaint();
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (((Button)actionEvent.getSource()).getLabel().equals("Add")) {
            this.Nodes = ScenarioEditorUtility.arrayAdd(this.Nodes, -1);
            this.xPos = ScenarioEditorUtility.arrayAdd(this.xPos, this.td.GetCenterPoint().x);
            this.yPos = ScenarioEditorUtility.arrayAdd(this.yPos, this.td.GetCenterPoint().y);
            ++this.iTargets;
            this.pointer = this.iTargets - 1;
            this.td.SetHighlightPoint(this.Nodes[this.pointer]);
            this.td.SetRect(new Rectangle(this.xPos[this.pointer] * 32, this.yPos[this.pointer] * 32, 32, 32));
            this.td.RepaintOffScreenImage();
            this.td.repaint();
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (((Button)actionEvent.getSource()).getLabel().equals("Remove") && this.iTargets != 0) {
            this.Nodes = ScenarioEditorUtility.arrayDeleteElementAt(this.Nodes, this.pointer);
            this.xPos = ScenarioEditorUtility.arrayDeleteElementAt(this.xPos, this.pointer);
            this.yPos = ScenarioEditorUtility.arrayDeleteElementAt(this.yPos, this.pointer);
            --this.iTargets;
            this.pointer = this.iTargets - 1;
            if (this.iTargets == 0) {
                this.td.SetHighlightPoint(-1);
                this.td.SetRect(new Rectangle(-1, -1, 0, 0));
            } else {
                this.td.SetHighlightPoint(this.Nodes[this.pointer]);
                this.td.SetRect(new Rectangle(this.xPos[this.pointer] * 32, this.yPos[this.pointer] * 32, 32, 32));
                this.td.CenterOn(new Point(this.xPos[this.pointer], this.yPos[this.pointer]));
            }
            this.td.RepaintOffScreenImage();
            this.td.repaint();
            this.RepaintOffScreenImage();
            this.repaint();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (((Checkbox)itemEvent.getSource()).getLabel().equals("Target Select")) {
            this.bMode = true;
        }
        if (((Checkbox)itemEvent.getSource()).getLabel().equals("Node Select")) {
            this.bMode = false;
        }
        this.td.setTargetTerrainMode(this.bMode);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (n < 0 || n > this.getSize().width - 16) {
            return;
        }
        n = mouseEvent.getY();
        int n2 = this.getSize().height / 34;
        if (n < 0 || n > (n2 *= 34)) {
            return;
        }
        n = mouseEvent.getY() / 34;
        if ((n += this.sb.getValue()) >= this.iTargets) {
            return;
        }
        this.pointer = n;
        this.RepaintOffScreenImage();
        this.repaint();
        this.td.SetHighlightPoint(this.Nodes[this.pointer]);
        this.td.SetRect(new Rectangle(this.xPos[this.pointer] * 32, this.yPos[this.pointer] * 32, 32, 32));
        this.td.CenterOn(new Point(this.xPos[this.pointer], this.yPos[this.pointer]));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

