/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Arrays;

class TeamEditor
extends Panel
implements TextListener,
MouseListener,
ItemListener,
KeyListener,
ActionListener {
    private LaserSquadScenarioEditor lsse;
    private TextField tfName;
    private Button butAdd;
    private Button butRemove;
    private Button butCopy;
    private Button butAddTerrain;
    private Button butRemoveTerrain;
    private Button butDeploy;
    private Button butCredits;
    private Button butMemory;
    private int TEWidth = -1;
    private int TEHeight = -1;
    private Image TEImage = null;
    private Graphics TEGraph;
    private TeamSelector ts;
    private Choice cColour;
    private static final Color[] colourData = new Color[]{new Color(0), new Color(192), new Color(0xC00000), new Color(0xC000C0), new Color(49152), new Color(49344), new Color(0xC0C000), new Color(0xC0C0C0), new Color(0), new Color(255), new Color(0xFF0000), new Color(0xFF00FF), new Color(65280), new Color(65535), new Color(0xFFFF00), new Color(0xFFFFFF)};
    private TextField tfVPs;
    private PullDown pdCanDestroy;
    private Checkbox cbHuman;
    private Checkbox cbComputer;
    private Checkbox cbMorraleImunity;
    private TextArea taDeploy;
    private TextArea taVictory;

    public TeamEditor(LaserSquadScenarioEditor laserSquadScenarioEditor) {
        this.lsse = laserSquadScenarioEditor;
        this.ts = new TeamSelector(laserSquadScenarioEditor, this);
        this.add(this.ts);
        this.butAdd = new Button("Add new Team");
        this.butAdd.addActionListener(this);
        this.add(this.butAdd);
        this.butCopy = new Button("Copy Team");
        this.butCopy.addActionListener(this);
        this.add(this.butCopy);
        this.butRemove = new Button("Remove Team");
        this.butRemove.addActionListener(this);
        this.add(this.butRemove);
        this.tfName = new TextField("", 17);
        this.tfName.setFont(LaserSquadScenarioEditor.font);
        this.tfName.addTextListener(this);
        this.add(this.tfName);
        this.cColour = new Choice();
        this.cColour.setFont(LaserSquadScenarioEditor.font);
        this.cColour.add("Blue");
        this.cColour.add("Red");
        this.cColour.add("Magenta");
        this.cColour.add("Green");
        this.cColour.add("Cyan");
        this.cColour.add("Yellow");
        this.cColour.add("White");
        this.cColour.add("Light Blue");
        this.cColour.add("Light Red");
        this.cColour.add("Light Magenta");
        this.cColour.add("Light Green");
        this.cColour.add("Light Cyan");
        this.cColour.add("Light Yellow");
        this.cColour.add("Light White");
        this.cColour.addItemListener(this);
        this.add(this.cColour);
        this.tfVPs = new TextField("", 3);
        this.tfVPs.setFont(LaserSquadScenarioEditor.font);
        this.tfVPs.addKeyListener(this);
        this.tfVPs.addTextListener(this);
        this.add(this.tfVPs);
        this.cbHuman = new Checkbox("Can be Human");
        this.cbHuman.setFont(LaserSquadScenarioEditor.font);
        this.cbHuman.addItemListener(this);
        this.add(this.cbHuman);
        this.butCredits = new Button("Edit Team's Credits");
        this.butCredits.addActionListener(this);
        this.add(this.butCredits);
        this.cbComputer = new Checkbox("Can be Computer");
        this.cbComputer.setFont(LaserSquadScenarioEditor.font);
        this.cbComputer.addItemListener(this);
        this.add(this.cbComputer);
        this.butMemory = new Button("Edit unit's memory length");
        this.butMemory.addActionListener(this);
        this.add(this.butMemory);
        this.cbMorraleImunity = new Checkbox("Immune to Morrale");
        this.cbMorraleImunity.setFont(LaserSquadScenarioEditor.font);
        this.cbMorraleImunity.addItemListener(this);
        this.add(this.cbMorraleImunity);
        this.pdCanDestroy = new PullDown(laserSquadScenarioEditor, this);
        this.add(this.pdCanDestroy);
        this.butAddTerrain = new Button("Add");
        this.butAddTerrain.addActionListener(this);
        this.add(this.butAddTerrain);
        this.butRemoveTerrain = new Button("Remove");
        this.butRemoveTerrain.addActionListener(this);
        this.add(this.butRemoveTerrain);
        this.taDeploy = new TextArea("", 10, 40, 1);
        this.taDeploy.setFont(LaserSquadScenarioEditor.font);
        this.taDeploy.addTextListener(this);
        this.add(this.taDeploy);
        this.taVictory = new TextArea("", 10, 40, 1);
        this.taVictory.setFont(LaserSquadScenarioEditor.font);
        this.taVictory.addTextListener(this);
        this.add(this.taVictory);
        this.butDeploy = new Button("Deployment");
        this.butDeploy.addActionListener(this);
        this.add(this.butDeploy);
        this.addMouseListener(this);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.TEWidth || n4 != this.TEHeight) {
            this.TEWidth = n3;
            this.TEHeight = n4;
            this.TEImage = this.createImage(n3, n4);
            this.TEGraph = this.TEImage.getGraphics();
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    private void RepaintOffScreenImage() {
        EditorTeam editorTeam = this.lsse.Teams[this.ts.getPos()];
        if (this.TEGraph == null) {
            return;
        }
        this.TEGraph.setColor(new Color(240, 240, 240));
        this.TEGraph.fillRect(0, 0, this.TEWidth, this.TEHeight);
        this.TEGraph.setColor(Color.BLACK);
        this.TEGraph.setFont(LaserSquadScenarioEditor.font);
        this.TEGraph.drawString("Team Name:", 5, 14);
        this.tfName.setText(editorTeam.name);
        this.TEGraph.drawString("Scanner image:", 340, 14);
        this.TEGraph.drawImage(editorTeam.ScannerPic, 480, 5, 492, 17, 0, 0, 6, 6, null);
        this.TEGraph.drawString("Deploy image:", 5, 44);
        this.TEGraph.drawImage(editorTeam.iDeployPic, 140, 24, null);
        this.TEGraph.drawString("Border Colour:", 200, 44);
        this.TEGraph.setColor(colourData[editorTeam.ColourOfBorders]);
        this.TEGraph.fillRect(340, 30, 20, 20);
        this.cColour.select(editorTeam.ColourOfBorders - (editorTeam.ColourOfBorders > 7 ? 2 : 1));
        this.TEGraph.setColor(Color.BLACK);
        this.TEGraph.drawString("Victory Points For Killing Team:", 5, 70);
        this.tfVPs.setText(Integer.toString(editorTeam.VictoryPointsForWipeingOutEntirelyTeam));
        this.cbHuman.setState((editorTeam.flags & 1) == 1);
        this.cbComputer.setState((editorTeam.flags & 2) == 2);
        this.cbMorraleImunity.setState((editorTeam.flags & 4) == 4);
        this.TEGraph.setColor(Color.BLACK);
        this.TEGraph.drawString("Terrains that", 5, 142);
        this.TEGraph.drawString("can destroy:", 5, 162);
        this.pdCanDestroy.reset(editorTeam.TerrainsCanDestroyToMoveThrough, 0);
        this.TEGraph.drawString("Deployment text:", 5, 185);
        this.taDeploy.setText(editorTeam.DeploymentText == null ? "" : editorTeam.DeploymentText);
        this.TEGraph.drawString("Victory Condition text:", 5, 305);
        this.taVictory.setText(editorTeam.VictoryText == null ? "" : editorTeam.VictoryText);
    }

    public void paint(Graphics graphics) {
        int n = this.TEHeight;
        this.butAdd.setBounds(this.TEWidth - 176, 3, 170, 25);
        this.butCopy.setBounds(this.TEWidth - 176, 31, 170, 25);
        this.butRemove.setBounds(this.TEWidth - 176, 59, 170, 25);
        n -= 87;
        this.ts.setBounds(this.TEWidth - 187, 87, 187, (n /= 34) * 34);
        this.TEGraph.setColor(new Color(240, 240, 240));
        this.TEGraph.drawLine(0, 0, 0, 1);
        graphics.drawImage(this.TEImage, 0, 0, null);
        this.tfName.setBounds(105, 1, 180, 20);
        this.cColour.setLocation(365, 28);
        this.tfVPs.setBounds(325, 55, 40, 20);
        this.cbHuman.setLocation(375, 55);
        this.butCredits.setBounds(5, 90, 150, 25);
        this.cbComputer.setLocation(375, 77);
        this.butMemory.setBounds(170, 90, 160, 25);
        this.cbMorraleImunity.setLocation(375, 102);
        this.pdCanDestroy.setBounds(140, 133, 182, 34);
        this.butAddTerrain.setBounds(332, 135, 60, 30);
        this.butRemoveTerrain.setBounds(402, 135, 60, 30);
        this.taDeploy.setBounds(5, 190, this.TEWidth - 197, 100);
        this.taVictory.setBounds(5, 310, this.TEWidth - 197, 100);
        this.butDeploy.setBounds(5, 420, 100, 25);
    }

    protected void TeamSelectorNotifyChange() {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void ChangeDeployPic(Image image) {
        this.lsse.Teams[this.ts.getPos()].iDeployPic = image;
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void ChangeScannerPic(Image image) {
        this.lsse.Teams[this.ts.getPos()].ScannerPic = image;
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void reset() {
        this.ts.RepaintOffScreenImage();
        this.ts.repaint();
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void NotifyAddCanDestroyTerrain(int n) {
        EditorTeam editorTeam = this.lsse.Teams[this.ts.getPos()];
        if (editorTeam.TerrainsCanDestroyToMoveThrough == null) {
            editorTeam.TerrainsCanDestroyToMoveThrough = new int[1];
            editorTeam.TerrainsCanDestroyToMoveThrough[0] = n;
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (ScenarioEditorUtility.arrayPos(editorTeam.TerrainsCanDestroyToMoveThrough, n) != -1) {
            return;
        }
        editorTeam.TerrainsCanDestroyToMoveThrough = ScenarioEditorUtility.arrayAdd(editorTeam.TerrainsCanDestroyToMoveThrough, n);
        Arrays.sort(editorTeam.TerrainsCanDestroyToMoveThrough);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    private void AddTeam(EditorTeam editorTeam) {
        int[] nArray;
        int n;
        EditorTeam[] editorTeamArray = new EditorTeam[this.lsse.Teams.length + 1];
        System.arraycopy(this.lsse.Teams, 0, editorTeamArray, 0, this.lsse.Teams.length);
        editorTeamArray[this.lsse.Teams.length] = editorTeam;
        this.lsse.Teams = editorTeamArray;
        for (n = 0; n < this.lsse.Terrains.length; ++n) {
            nArray = new int[this.lsse.Teams.length];
            System.arraycopy(this.lsse.Terrains[n].VictoryPoints, 0, nArray, 0, this.lsse.Teams.length - 1);
            this.lsse.Terrains[n].VictoryPoints = nArray;
            nArray = new int[this.lsse.Teams.length];
            System.arraycopy(this.lsse.Terrains[n].Morrale, 0, nArray, 0, this.lsse.Teams.length - 1);
            this.lsse.Terrains[n].Morrale = nArray;
        }
        for (n = 0; n < this.lsse.GenericItems.length; ++n) {
            nArray = new int[this.lsse.Teams.length];
            System.arraycopy(this.lsse.GenericItems[n].Cost, 0, nArray, 0, this.lsse.Teams.length - 1);
            this.lsse.GenericItems[n].Cost = nArray;
            nArray = new int[this.lsse.Teams.length];
            System.arraycopy(this.lsse.GenericItems[n].ThreatValue, 0, nArray, 0, this.lsse.Teams.length - 1);
            this.lsse.GenericItems[n].ThreatValue = nArray;
        }
        for (n = 0; n < this.lsse.Units.length; ++n) {
            nArray = new int[this.lsse.Teams.length];
            System.arraycopy(this.lsse.Units[n].VictoryPoint, 0, nArray, 0, this.lsse.Teams.length - 1);
            this.lsse.Units[n].VictoryPoint = nArray;
            nArray = new int[this.lsse.Teams.length];
            System.arraycopy(this.lsse.Units[n].MorraleValue, 0, nArray, 0, this.lsse.Teams.length - 1);
            this.lsse.Units[n].MorraleValue = nArray;
        }
        for (n = 0; n < 5; ++n) {
            nArray = new int[this.lsse.Teams.length];
            System.arraycopy(this.lsse.Armours[n].Cost, 0, nArray, 0, this.lsse.Teams.length - 1);
            this.lsse.Armours[n].Cost = nArray;
        }
        this.lsse.CheckCAEChange(5, 0);
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        EditorTeam editorTeam = this.lsse.Teams[this.ts.getPos()];
        if (actionEvent.getSource() == this.butCredits) {
            new PullDownValueBoxList(this.lsse, this, 0, editorTeam, this.TEGraph.getFontMetrics());
            return;
        }
        if (actionEvent.getSource() == this.butMemory) {
            new PullDownValueBoxList(this.lsse, this, 1, editorTeam, this.TEGraph.getFontMetrics());
            return;
        }
        if (actionEvent.getSource() == this.butAddTerrain) {
            new TerrainSelectorWindow(this.lsse, this, 0, "Select destroyable", 0, 0, 4);
            return;
        }
        if (actionEvent.getSource() == this.butRemoveTerrain && editorTeam.TerrainsCanDestroyToMoveThrough != null) {
            editorTeam.TerrainsCanDestroyToMoveThrough = (int[])(editorTeam.TerrainsCanDestroyToMoveThrough.length == 1 ? null : ScenarioEditorUtility.arrayDeleteElementAt(editorTeam.TerrainsCanDestroyToMoveThrough, this.pdCanDestroy.GetSelected()));
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butAdd) {
            editorTeam = new EditorTeam();
            editorTeam.name = new String("NEW TEAM");
            editorTeam.flags = 1;
            editorTeam.ColourOfBorders = 14;
            editorTeam.VictoryPointsForWipeingOutEntirelyTeam = 100;
            editorTeam.StartCredits = 200;
            editorTeam.iDeployPic = this.createImage(32, 32);
            editorTeam.iDeployPic.getGraphics().setColor(Color.BLACK);
            editorTeam.iDeployPic.getGraphics().fillRect(0, 0, 32, 32);
            editorTeam.ScannerPic = this.createImage(6, 6);
            editorTeam.ScannerPic.getGraphics().setColor(Color.BLACK);
            editorTeam.ScannerPic.getGraphics().fillRect(0, 0, 6, 6);
            this.lsse.AddImageToScannerPool(editorTeam.ScannerPic);
            editorTeam.MemoryLength = new int[this.lsse.MaxDifficultyLevel];
            this.AddTeam(editorTeam);
            this.reset();
            return;
        }
        if (actionEvent.getSource() == this.butCopy && this.lsse.Teams.length > 1) {
            this.AddTeam(new EditorTeam(editorTeam));
            this.reset();
            return;
        }
        if (actionEvent.getSource() == this.butRemove && this.lsse.Teams.length > 1) {
            int n;
            int n2 = this.ts.getPos();
            EditorTeam[] editorTeamArray = new EditorTeam[this.lsse.Teams.length - 1];
            if (n2 != 0) {
                System.arraycopy(this.lsse.Teams, 0, editorTeamArray, 0, n2);
            }
            if (n2 != this.lsse.Teams.length - 1) {
                System.arraycopy(this.lsse.Teams, n2 + 1, editorTeamArray, n2, this.lsse.Teams.length - 1 - n2);
            }
            this.lsse.Teams = editorTeamArray;
            for (n = 0; n < this.lsse.Terrains.length; ++n) {
                this.lsse.Terrains[n].VictoryPoints = ScenarioEditorUtility.arrayDeleteElementAt(this.lsse.Terrains[n].VictoryPoints, n2);
                this.lsse.Terrains[n].Morrale = ScenarioEditorUtility.arrayDeleteElementAt(this.lsse.Terrains[n].Morrale, n2);
            }
            for (n = 0; n < this.lsse.GenericItems.length; ++n) {
                this.lsse.GenericItems[n].Cost = ScenarioEditorUtility.arrayDeleteElementAt(this.lsse.GenericItems[n].Cost, n2);
                this.lsse.GenericItems[n].ThreatValue = ScenarioEditorUtility.arrayDeleteElementAt(this.lsse.GenericItems[n].ThreatValue, n2);
            }
            for (n = 0; n < this.lsse.Units.length; ++n) {
                if (this.lsse.Units[n].TeamNumber >= n2 && this.lsse.Units[n].TeamNumber > 0) {
                    --this.lsse.Units[n].TeamNumber;
                }
                this.lsse.Units[n].VictoryPoint = ScenarioEditorUtility.arrayDeleteElementAt(this.lsse.Units[n].VictoryPoint, n2);
                this.lsse.Units[n].MorraleValue = ScenarioEditorUtility.arrayDeleteElementAt(this.lsse.Units[n].MorraleValue, n2);
            }
            for (n = 0; n < 5; ++n) {
                this.lsse.Armours[n].Cost = ScenarioEditorUtility.arrayDeleteElementAt(this.lsse.Armours[n].Cost, n2);
            }
            this.lsse.CheckCAEChange(4, 0);
            this.reset();
            return;
        }
        if (actionEvent.getSource() == this.butDeploy) {
            new DeployMapEditorDialog(this.lsse, this, this.ts.getPos());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) && c != '\b') {
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        EditorTeam editorTeam = this.lsse.Teams[this.ts.getPos()];
        if (itemEvent.getSource() == this.cColour) {
            editorTeam.ColourOfBorders = this.cColour.getSelectedIndex();
            editorTeam.ColourOfBorders = editorTeam.ColourOfBorders + (editorTeam.ColourOfBorders > 6 ? 2 : 1);
            this.RepaintOffScreenImage();
            this.repaint();
        }
        if (itemEvent.getSource() == this.cbHuman) {
            editorTeam.flags = itemEvent.getStateChange() == 1 ? (editorTeam.flags |= 1) : (editorTeam.flags &= 0xFFFFE);
            return;
        }
        if (itemEvent.getSource() == this.cbComputer) {
            editorTeam.flags = itemEvent.getStateChange() == 1 ? (editorTeam.flags |= 2) : (editorTeam.flags &= 0xFFFFD);
            return;
        }
        if (itemEvent.getSource() == this.cbMorraleImunity) {
            editorTeam.flags = itemEvent.getStateChange() == 1 ? (editorTeam.flags |= 4) : (editorTeam.flags &= 0xFFFFB);
            return;
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        int n = 0;
        int n2 = this.ts.getPos();
        if (textEvent.getSource() == this.tfName && textEvent.getID() == 900) {
            n = this.tfName.getCaretPosition();
            this.lsse.Teams[n2].name = new String(this.tfName.getText().toUpperCase());
            if (this.lsse.Teams[n2].name.length() > 17) {
                this.lsse.Teams[n2].name = this.lsse.Teams[n2].name.substring(0, 17);
            }
            if (!this.tfName.getText().equals(this.lsse.Teams[n2].name)) {
                this.tfName.setText(this.lsse.Teams[n2].name);
                this.tfName.setCaretPosition(n);
            }
            this.ts.RepaintOffScreenImage();
            this.ts.repaint();
        }
        if (textEvent.getSource() == this.tfVPs) {
            try {
                n = Integer.parseInt(this.tfVPs.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n > 4094 || n < 0) {
                n = 0;
            }
            this.lsse.Teams[n2].VictoryPointsForWipeingOutEntirelyTeam = n;
            return;
        }
        if (textEvent.getSource() == this.taDeploy && textEvent.getID() == 900) {
            this.lsse.Teams[n2].DeploymentText = new String(this.taDeploy.getText());
        }
        if (textEvent.getSource() == this.taVictory && textEvent.getID() == 900) {
            this.lsse.Teams[n2].VictoryText = new String(this.taVictory.getText());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n >= 140 && n < 172 && n2 >= 24 && n2 < 56) {
            new ImageSelector(this.lsse, this, 7, "Select Deployment Picture", this.lsse.Teams[this.ts.getPos()].iDeployPic);
        }
        if (n >= 480 && n < 492 && n2 >= 5 && n2 < 17) {
            new ImageSelector(this.lsse, this, 8, "Select Team Scanner Picture", this.lsse.Teams[this.ts.getPos()].ScannerPic);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

