/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class TeamSelector
extends Panel
implements AdjustmentListener,
MouseListener {
    private LaserSquadScenarioEditor lsse;
    private TeamEditor parent;
    private int TSWidth = -1;
    private int TSHeight = -1;
    private Image TSImage = null;
    private Graphics TSGraph;
    private int position;
    private Scrollbar sb;

    public TeamSelector(LaserSquadScenarioEditor laserSquadScenarioEditor, TeamEditor teamEditor) {
        this.lsse = laserSquadScenarioEditor;
        this.parent = teamEditor;
        this.sb = new Scrollbar(1, 0, 1, 0, laserSquadScenarioEditor.Teams.length);
        this.sb.addAdjustmentListener(this);
        this.add(this.sb);
        this.position = 0;
        this.addMouseListener(this);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.TSWidth || n4 != this.TSHeight) {
            this.TSWidth = n3;
            this.TSHeight = n4;
            this.TSImage = this.createImage(n3, n4);
            this.TSGraph = this.TSImage.getGraphics();
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void RepaintOffScreenImage() {
        if (this.TSGraph == null) {
            return;
        }
        if (this.position >= this.lsse.Teams.length) {
            this.position = this.lsse.Teams.length - 1;
        }
        this.TSGraph.setColor(Color.WHITE);
        this.TSGraph.fillRect(0, 0, this.TSWidth, this.TSHeight);
        int n = this.TSHeight - 69;
        this.sb.setVisibleAmount(n /= 34);
        this.TSGraph.setColor(Color.BLACK);
        this.TSGraph.setFont(LaserSquadScenarioEditor.font);
        int n2 = this.sb.getValue();
        for (int i = 0; i < n && i + n2 < this.lsse.Teams.length; ++i) {
            this.TSGraph.drawString(this.lsse.Teams[i + n2].name, 1, 20 + i * 34);
            if (i + n2 != this.position) continue;
            this.TSGraph.setColor(Color.RED);
            this.TSGraph.drawRect(0, i * 34, 170, 33);
            this.TSGraph.setColor(Color.BLACK);
        }
    }

    public void paint(Graphics graphics) {
        this.sb.setBounds(this.TSWidth - 16, 0, 16, this.TSHeight);
        this.TSGraph.setColor(Color.WHITE);
        this.TSGraph.drawLine(2, 2, 1, 1);
        graphics.drawImage(this.TSImage, 0, 0, null);
    }

    protected int getPos() {
        return this.position;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n > 0 && n < this.TSWidth - 17 && (n2 /= 34) < this.lsse.Teams.length) {
            this.position = n2;
            this.RepaintOffScreenImage();
            this.repaint();
            this.parent.TeamSelectorNotifyChange();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

