/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Paint;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Vector;

class TerrainDisplay
extends Panel
implements AdjustmentListener,
MouseMotionListener,
MouseListener,
Runnable,
ActionListener {
    private LaserSquadScenarioEditor lsse;
    private Scrollbar sbH;
    private Scrollbar sbV;
    private Point Highlight = new Point(-1, -1);
    private Container holder;
    protected boolean bShowTerrain = true;
    private boolean bViewItems = false;
    private Vector AnimationDetails = new Vector(10, 1);
    private Image TDImage = null;
    private Graphics TDGraph;
    private int TDWidth = -1;
    private int TDHeight = -1;
    private Thread TerrainAnnimator = null;
    private int function = -1;
    private PopupMenu popup;
    private Point pPopupPos = new Point(-1, -1);
    private boolean bInPopup = false;
    private boolean bFirstDraw = true;
    private boolean bShowTargetTerrains = true;
    private Rectangle rRect;
    private Rectangle rRectTemp = new Rectangle();
    private Rectangle rRectDraw;
    private int iDragMode = 0;
    private int iCursorMode = 0;
    private int iCurrentNode = -1;
    private Paint pRed;
    private Paint pYellow;
    private Paint pGreen;
    private Image imgEmpty;
    private static Cursor[] curResize = new Cursor[]{new Cursor(0), new Cursor(10), new Cursor(11), null, new Cursor(8), new Cursor(6), new Cursor(7), null, new Cursor(9), new Cursor(4), new Cursor(5)};

    public TerrainDisplay(LaserSquadScenarioEditor laserSquadScenarioEditor, Container container) {
        this.lsse = laserSquadScenarioEditor;
        this.holder = container;
        this.imgEmpty = this.lsse.createImage(32, 32);
        Graphics graphics = this.imgEmpty.getGraphics();
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, 32, 32);
        graphics.setColor(Color.RED);
        graphics.drawLine(0, 0, 31, 31);
        graphics.drawLine(0, 31, 31, 0);
        BufferedImage bufferedImage = new BufferedImage(32, 32, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(255, 0, 0, 128));
        graphics2D.fillRect(0, 0, 32, 32);
        Rectangle rectangle = new Rectangle(0, 0, 32, 32);
        this.pRed = new TexturePaint(bufferedImage, rectangle);
        bufferedImage = new BufferedImage(32, 32, 2);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.YELLOW);
        graphics2D.drawLine(0, 31, 31, 0);
        this.pYellow = new TexturePaint(bufferedImage, rectangle);
        bufferedImage = new BufferedImage(32, 32, 2);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(0, 255, 0, 128));
        graphics2D.fillRect(0, 0, 32, 32);
        this.pGreen = new TexturePaint(bufferedImage, rectangle);
        if (this.holder.getClass().getName().equals("MapEditor")) {
            this.function = 0;
        }
        if (this.holder.getClass().getName().equals("ItemEditor")) {
            this.function = 1;
            this.bViewItems = true;
        }
        if (this.holder.getClass().getName().equals("AutoDeployDialog")) {
            this.function = 2;
            this.rRect = ((AutoDeployDialog)this.holder).rRect;
            this.rRect.x *= 32;
            this.rRect.y *= 32;
            this.rRect.width *= 32;
            this.rRect.height *= 32;
            this.rRectDraw = new Rectangle(this.rRect);
        }
        if (this.holder.getClass().getName().equals("DeployMapEditorDialog")) {
            this.function = 3;
        }
        if (this.holder.getClass().getName().equals("RegionEditor")) {
            this.function = 4;
            this.rRect = new Rectangle();
            this.rRectDraw = new Rectangle();
        }
        if (this.holder.getClass().getName().equals("NodeEditor")) {
            this.function = 5;
        }
        if (this.holder.getClass().getName().equals("TargetTerrainPanel")) {
            this.function = 6;
            this.rRect = new Rectangle(-1, -1, 0, 0);
            this.rRectDraw = new Rectangle();
        }
        if (this.holder.getClass().getName().equals("UnitPatrolPanel")) {
            this.function = 7;
        }
        this.sbH = new Scrollbar(0, 0, 1, 0, this.lsse.MapWidth);
        this.sbH.addAdjustmentListener(this);
        this.add(this.sbH);
        this.sbV = new Scrollbar(1, 0, 1, 0, this.lsse.MapHeight);
        this.sbV.addAdjustmentListener(this);
        this.add(this.sbV);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        if (this.function == 0) {
            this.popup = new PopupMenu("Map Options");
            MenuItem menuItem = new MenuItem("Insert Row");
            menuItem.addActionListener(this);
            this.popup.add(menuItem);
            menuItem = new MenuItem("Insert Column");
            menuItem.addActionListener(this);
            this.popup.add(menuItem);
            menuItem = new MenuItem("Remove Row");
            menuItem.addActionListener(this);
            this.popup.add(menuItem);
            menuItem = new MenuItem("Remove Column");
            menuItem.addActionListener(this);
            this.popup.add(menuItem);
            menuItem = new MenuItem("-");
            this.popup.add(menuItem);
            menuItem = new MenuItem("View Items");
            menuItem.addActionListener(this);
            this.popup.add(menuItem);
            menuItem = new MenuItem("Hide Items");
            menuItem.addActionListener(this);
            this.popup.add(menuItem);
            this.add(this.popup);
        }
    }

    protected void SetRect(Rectangle rectangle) {
        if (rectangle == null) {
            this.rRect.setBounds(-1, -1, 0, 0);
            this.rRectDraw.setBounds(-1, -1, 0, 0);
        } else {
            this.rRect.setBounds(rectangle);
            this.rRectDraw.setBounds(rectangle);
        }
    }

    protected void setTargetTerrainMode(boolean bl) {
        if (this.bShowTargetTerrains == bl) {
            return;
        }
        this.bShowTargetTerrains = bl;
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected Rectangle GetCenter() {
        return new Rectangle((this.sbH.getValue() + (this.TDWidth - 16) / 64) * 32, (this.sbV.getValue() + (this.TDHeight - 16) / 64) * 32, 32, 32);
    }

    protected Point GetCenterPoint() {
        return new Point(this.sbH.getValue() + (this.TDWidth - 16) / 64, this.sbV.getValue() + (this.TDHeight - 16) / 64);
    }

    private void StartPopupMenu(MouseEvent mouseEvent) {
        if (this.function != 0) {
            return;
        }
        this.bInPopup = true;
        this.popup.getItem(5).setEnabled(!this.bViewItems);
        this.popup.getItem(6).setEnabled(this.bViewItems);
        this.pPopupPos.x = mouseEvent.getX() / 32 + this.sbH.getValue();
        this.pPopupPos.y = mouseEvent.getY() / 32 + this.sbV.getValue();
        this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private boolean bClickShutPopup(MouseEvent mouseEvent) {
        return this.bInPopup;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MapResizer mapResizer;
        if (actionEvent.getActionCommand().equals("Insert Row")) {
            mapResizer = new MapResizer(this.lsse, 0, this.pPopupPos.y, ((MapEditor)this.holder).GetSelectedTerrain());
            this.updateDimensions();
            this.repaint();
            this.bInPopup = false;
        }
        if (actionEvent.getActionCommand().equals("Insert Column")) {
            mapResizer = new MapResizer(this.lsse, 1, this.pPopupPos.x, ((MapEditor)this.holder).GetSelectedTerrain());
            this.updateDimensions();
            this.repaint();
            this.bInPopup = false;
        }
        if (actionEvent.getActionCommand().equals("Remove Row")) {
            mapResizer = new MapResizer(this.lsse, 2, this.pPopupPos.y, 0);
            this.updateDimensions();
            this.repaint();
            this.bInPopup = false;
        }
        if (actionEvent.getActionCommand().equals("Remove Column")) {
            mapResizer = new MapResizer(this.lsse, 3, this.pPopupPos.x, 0);
            this.updateDimensions();
            this.repaint();
            this.bInPopup = false;
        }
        if (actionEvent.getActionCommand().equals("View Items")) {
            this.bViewItems = true;
            this.RepaintOffScreenImage();
            this.repaint();
            this.bInPopup = false;
        }
        if (actionEvent.getActionCommand().equals("Hide Items")) {
            this.bViewItems = false;
            this.RepaintOffScreenImage();
            this.repaint();
            this.bInPopup = false;
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.TDWidth || n4 != this.TDHeight) {
            this.TDWidth = n3;
            this.TDHeight = n4;
            this.TDImage = this.createImage(n3 - 16, n4 - 16);
            this.TDGraph = this.TDImage.getGraphics();
            if (this.bFirstDraw && this.function == 2) {
                int n5 = this.TDWidth - 16;
                int n6 = this.TDHeight - 16;
                this.sbH.setValue((int)(this.rRect.getCenterX() / 32.0 - (double)(n5 /= 64)));
                this.sbV.setValue((int)(this.rRect.getCenterY() / 32.0 - (double)(n6 /= 64)));
                this.bFirstDraw = false;
            }
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        int n2;
        int n3;
        int n4;
        if (this.TDGraph == null) {
            return;
        }
        if (this.TerrainAnnimator != null) {
            this.TerrainAnnimator.interrupt();
        }
        this.TerrainAnnimator = null;
        this.AnimationDetails.clear();
        int n5 = this.TDWidth - 16;
        int n6 = this.TDHeight - 16;
        this.TDGraph.setColor(new Color(240, 240, 240));
        this.TDGraph.fillRect(n5, n6, 16, 16);
        n6 /= 32;
        if ((n5 /= 32) + this.sbH.getValue() >= this.lsse.MapWidth) {
            this.sbH.setValue(this.lsse.MapWidth - n5 < 0 ? 0 : this.lsse.MapWidth - n5);
        }
        if (n6 + this.sbV.getValue() >= this.lsse.MapHeight) {
            this.sbV.setValue(this.lsse.MapHeight - n6 < 0 ? 0 : this.lsse.MapHeight - n6);
        }
        int n7 = this.sbV.getValue() * this.lsse.MapWidth;
        for (n4 = 0; n4 <= n6; ++n4) {
            n3 = this.sbH.getValue();
            for (n2 = 0; n2 <= n5; ++n2) {
                if (n3 >= this.lsse.MapWidth || n3 + n7 >= this.lsse.Map.length) {
                    this.TDGraph.drawImage(this.imgEmpty, n2 * 32, n4 * 32, null);
                } else {
                    n = this.lsse.Map[n3 + n7];
                    if (this.function == 3 && ((DeployMapEditorDialog)this.holder).bDeploymentMap[n3 + n7]) {
                        this.TDGraph.drawImage(this.lsse.Teams[((DeployMapEditorDialog)this.holder).iTeam].iDeployPic, n2 * 32, n4 * 32, null);
                    } else {
                        if (n >= this.lsse.Terrains.length) {
                            if (this.bViewItems) {
                                this.lsse.GenericItems[n - this.lsse.Terrains.length].DisplayImage(this.TDGraph, n2 * 32, n4 * 32, null, !this.bShowTerrain);
                            } else {
                                n = this.lsse.GetTerrainAt(n3, this.sbV.getValue() + n4);
                            }
                        }
                        if (n < this.lsse.Terrains.length) {
                            this.lsse.Terrains[n].DisplayImage(this.TDGraph, n2 * 32, n4 * 32, this.AnimationDetails, this.function == 0 && !this.bShowTerrain);
                        }
                    }
                }
                ++n3;
            }
            n7 += this.lsse.MapWidth;
        }
        if (this.function == 2) {
            object4 = (Graphics2D)this.TDGraph;
            object3 = ((Graphics2D)object4).getPaint();
            n2 = this.rRectDraw.x - this.sbH.getValue() * 32;
            n4 = this.rRectDraw.y - this.sbV.getValue() * 32;
            ((Graphics2D)object4).setPaint(this.pRed);
            ((Graphics)object4).fillRect(n2, n4, this.rRectDraw.width, this.rRectDraw.height);
            ((Graphics2D)object4).setPaint((Paint)object3);
            this.TDGraph.setColor(Color.RED);
            this.TDGraph.drawRect(n2, n4, this.rRectDraw.width, this.rRectDraw.height);
        }
        if (this.function == 4 && this.lsse.RegionBlocks != null && this.rRect.x != -1 && (n = ((RegionEditor)this.holder).GetSelectedRegion()) != 0) {
            n3 = this.sbH.getValue() * 32;
            n7 = this.sbV.getValue() * 32;
            object4 = new Area();
            for (n2 = this.lsse.RegionNumbers.length - 1; n2 >= 0; --n2) {
                if (this.lsse.RegionNumbers[n2] == n) {
                    ((Area)object4).add(new Area(new Rectangle(this.lsse.RegionBlocks[n2].x - n3, this.lsse.RegionBlocks[n2].y - n7, this.lsse.RegionBlocks[n2].width, this.lsse.RegionBlocks[n2].height)));
                    continue;
                }
                ((Area)object4).subtract(new Area(new Rectangle(this.lsse.RegionBlocks[n2].x - n3, this.lsse.RegionBlocks[n2].y - n7, this.lsse.RegionBlocks[n2].width, this.lsse.RegionBlocks[n2].height)));
            }
            object3 = (Graphics2D)this.TDGraph;
            object2 = ((Graphics2D)object3).getPaint();
            ((Graphics2D)object3).setPaint(this.pGreen);
            ((Graphics2D)object3).fill((Shape)object4);
            ((Graphics2D)object3).setPaint((Paint)object2);
            ((Graphics)object3).setColor(Color.GREEN);
            ((Graphics2D)object3).draw((Shape)object4);
            this.rRectDraw.translate(-n3, -n7);
            if (this.rRectDraw != null) {
                ((Graphics2D)object3).setPaint(this.pRed);
                ((Graphics2D)object3).fill(this.rRectDraw);
                ((Graphics2D)object3).setPaint((Paint)object2);
                ((Graphics)object3).setColor(Color.RED);
                ((Graphics2D)object3).draw(this.rRectDraw);
            }
            this.rRectDraw.translate(n3, n7);
        }
        if (this.function == 5 && this.lsse.Nodes != null) {
            object = null;
            Graphics2D graphics2D = (Graphics2D)this.TDGraph;
            graphics2D.setFont(LaserSquadScenarioEditor.font);
            object4 = graphics2D.getFontMetrics();
            Paint paint = graphics2D.getPaint();
            n3 = this.sbH.getValue();
            n7 = this.sbV.getValue();
            n = (32 - ((FontMetrics)object4).getHeight()) / 2 + ((FontMetrics)object4).getLeading() + ((FontMetrics)object4).getAscent();
            for (n2 = 0; n2 < this.lsse.Nodes.length; ++n2) {
                if (this.lsse.Nodes[n2].x < n3 || this.lsse.Nodes[n2].x >= n3 + n5 || this.lsse.Nodes[n2].y < n7 || this.lsse.Nodes[n2].y >= n7 + n6 || n2 != this.iCurrentNode && this.lsse.Nodes[n2].equals(this.lsse.Nodes[this.iCurrentNode])) continue;
                object2 = new Ellipse2D.Double((this.lsse.Nodes[n2].x - n3) * 32, (this.lsse.Nodes[n2].y - n7) * 32, 32.0, 32.0);
                object3 = Integer.toString(n2);
                graphics2D.setPaint(n2 == this.iCurrentNode ? this.pRed : this.pGreen);
                graphics2D.fill((Shape)object2);
                graphics2D.setPaint(paint);
                graphics2D.setColor(n2 == this.iCurrentNode ? Color.RED : Color.GREEN);
                graphics2D.draw((Shape)object2);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString((String)object3, (this.lsse.Nodes[n2].x - n3) * 32 + (32 - ((FontMetrics)object4).stringWidth((String)object3)) / 2, (this.lsse.Nodes[n2].y - n7) * 32 + n);
            }
            graphics2D.setColor(Color.GREEN);
            int n8 = ((NodeEditor)this.holder).GetSelectedLink();
            for (int i = 0; i < this.lsse.NodeLinks.length; ++i) {
                if (this.lsse.NodeLinks[i].length <= 0) continue;
                for (n = 0; n < this.lsse.NodeLinks[i].length; ++n) {
                    if (i != this.iCurrentNode && this.lsse.NodeLinks[i][n] == this.iCurrentNode && ScenarioEditorUtility.arrayPos(this.lsse.NodeLinks[this.iCurrentNode], i) != -1) continue;
                    double d = Math.atan2(this.lsse.Nodes[i].y - this.lsse.Nodes[this.lsse.NodeLinks[i][n]].y, this.lsse.Nodes[i].x - this.lsse.Nodes[this.lsse.NodeLinks[i][n]].x);
                    n4 = (int)(Math.sin(d) * 16.0);
                    n2 = (int)(Math.cos(d) * 16.0);
                    if (i == this.iCurrentNode) {
                        graphics2D.setColor(Color.RED);
                        if (n8 == n) {
                            object = graphics2D.getStroke();
                            graphics2D.setStroke(new BasicStroke(3.0f));
                        }
                        graphics2D.drawLine((this.lsse.Nodes[i].x - n3) * 32 + 16 - n2, (this.lsse.Nodes[i].y - n7) * 32 + 16 - n4, (this.lsse.Nodes[this.lsse.NodeLinks[i][n]].x - n3) * 32 + 16 + n2, (this.lsse.Nodes[this.lsse.NodeLinks[i][n]].y - n7) * 32 + 16 + n4);
                        graphics2D.setColor(Color.GREEN);
                        if (n8 != n) continue;
                        graphics2D.setStroke((Stroke)object);
                        continue;
                    }
                    graphics2D.drawLine((this.lsse.Nodes[i].x - n3) * 32 + 16 - n2, (this.lsse.Nodes[i].y - n7) * 32 + 16 - n4, (this.lsse.Nodes[this.lsse.NodeLinks[i][n]].x - n3) * 32 + 16 + n2, (this.lsse.Nodes[this.lsse.NodeLinks[i][n]].y - n7) * 32 + 16 + n4);
                }
            }
        }
        if (this.function == 6 && this.rRect.x != -1 && this.bShowTargetTerrains) {
            object4 = (Graphics2D)this.TDGraph;
            object3 = ((Graphics2D)object4).getPaint();
            n2 = this.rRect.x - this.sbH.getValue() * 32;
            n4 = this.rRect.y - this.sbV.getValue() * 32;
            ((Graphics2D)object4).setPaint(this.pRed);
            ((Graphics)object4).fillRect(n2 - 1, n4 - 1, 33, 33);
            ((Graphics2D)object4).setPaint((Paint)object3);
            this.TDGraph.setColor(Color.RED);
            this.TDGraph.drawRect(n2 - 1, n4 - 1, 33, 33);
        }
        if (this.function == 6 && this.rRect.x != -1 && !this.bShowTargetTerrains) {
            object = (Graphics2D)this.TDGraph;
            ((Graphics)object).setFont(LaserSquadScenarioEditor.font);
            object4 = ((Graphics)object).getFontMetrics();
            Paint paint = ((Graphics2D)object).getPaint();
            n3 = this.sbH.getValue();
            n7 = this.sbV.getValue();
            n = (32 - ((FontMetrics)object4).getHeight()) / 2 + ((FontMetrics)object4).getLeading() + ((FontMetrics)object4).getAscent();
            for (n2 = 0; n2 < this.lsse.Nodes.length; ++n2) {
                if (this.lsse.Nodes[n2].x < n3 || this.lsse.Nodes[n2].x >= n3 + n5 || this.lsse.Nodes[n2].y < n7 || this.lsse.Nodes[n2].y >= n7 + n6 || n2 != this.iCurrentNode && this.iCurrentNode != -1 && this.lsse.Nodes[n2].equals(this.lsse.Nodes[this.iCurrentNode])) continue;
                object2 = new Ellipse2D.Double((this.lsse.Nodes[n2].x - n3) * 32, (this.lsse.Nodes[n2].y - n7) * 32, 32.0, 32.0);
                object3 = Integer.toString(n2);
                ((Graphics2D)object).setPaint(n2 == this.iCurrentNode ? this.pRed : this.pGreen);
                ((Graphics2D)object).fill((Shape)object2);
                ((Graphics2D)object).setPaint(paint);
                ((Graphics)object).setColor(n2 == this.iCurrentNode ? Color.RED : Color.GREEN);
                ((Graphics2D)object).draw((Shape)object2);
                ((Graphics)object).setColor(Color.BLACK);
                ((Graphics2D)object).drawString((String)object3, (this.lsse.Nodes[n2].x - n3) * 32 + (32 - ((FontMetrics)object4).stringWidth((String)object3)) / 2, (this.lsse.Nodes[n2].y - n7) * 32 + n);
            }
        }
        if (this.function == 7 && this.lsse.Nodes != null) {
            Graphics2D graphics2D = (Graphics2D)this.TDGraph;
            graphics2D.setFont(LaserSquadScenarioEditor.font);
            object4 = graphics2D.getFontMetrics();
            Paint paint = graphics2D.getPaint();
            n3 = this.sbH.getValue();
            n7 = this.sbV.getValue();
            n = (32 - ((FontMetrics)object4).getHeight()) / 2 + ((FontMetrics)object4).getLeading() + ((FontMetrics)object4).getAscent();
            for (n2 = 0; n2 < this.lsse.Nodes.length; ++n2) {
                if (this.lsse.Nodes[n2].x < n3 || this.lsse.Nodes[n2].x >= n3 + n5 || this.lsse.Nodes[n2].y < n7 || this.lsse.Nodes[n2].y >= n7 + n6 || this.iCurrentNode != -1 && n2 != this.iCurrentNode && this.lsse.Nodes[n2].equals(this.lsse.Nodes[this.iCurrentNode])) continue;
                object2 = new Ellipse2D.Double((this.lsse.Nodes[n2].x - n3) * 32, (this.lsse.Nodes[n2].y - n7) * 32, 32.0, 32.0);
                object3 = Integer.toString(n2);
                graphics2D.setPaint(n2 == this.iCurrentNode ? this.pRed : this.pGreen);
                graphics2D.fill((Shape)object2);
                graphics2D.setPaint(paint);
                graphics2D.setColor(n2 == this.iCurrentNode ? Color.RED : Color.GREEN);
                graphics2D.draw((Shape)object2);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString((String)object3, (this.lsse.Nodes[n2].x - n3) * 32 + (32 - ((FontMetrics)object4).stringWidth((String)object3)) / 2, (this.lsse.Nodes[n2].y - n7) * 32 + n);
            }
            graphics2D.setColor(Color.GREEN);
            for (int i = 0; i < this.lsse.NodeLinks.length; ++i) {
                if (this.lsse.NodeLinks[i].length <= 0) continue;
                for (n = 0; n < this.lsse.NodeLinks[i].length; ++n) {
                    if (i != this.iCurrentNode && this.lsse.NodeLinks[i][n] == this.iCurrentNode && ScenarioEditorUtility.arrayPos(this.lsse.NodeLinks[this.iCurrentNode], i) != -1) continue;
                    double d = Math.atan2(this.lsse.Nodes[i].y - this.lsse.Nodes[this.lsse.NodeLinks[i][n]].y, this.lsse.Nodes[i].x - this.lsse.Nodes[this.lsse.NodeLinks[i][n]].x);
                    n4 = (int)(Math.sin(d) * 16.0);
                    n2 = (int)(Math.cos(d) * 16.0);
                    graphics2D.setColor(i == this.iCurrentNode ? Color.RED : Color.GREEN);
                    graphics2D.drawLine((this.lsse.Nodes[i].x - n3) * 32 + 16 - n2, (this.lsse.Nodes[i].y - n7) * 32 + 16 - n4, (this.lsse.Nodes[this.lsse.NodeLinks[i][n]].x - n3) * 32 + 16 + n2, (this.lsse.Nodes[this.lsse.NodeLinks[i][n]].y - n7) * 32 + 16 + n4);
                }
            }
        }
        if (!this.AnimationDetails.isEmpty()) {
            this.TerrainAnnimator = new Thread((Runnable)this, "TerrainAnnimator");
            this.TerrainAnnimator.start();
        }
    }

    public void run() {
        while (this.TerrainAnnimator != null && !this.AnimationDetails.isEmpty()) {
            for (int i = 0; i < this.AnimationDetails.size(); i += 3) {
                int[] nArray = (int[])this.AnimationDetails.elementAt(i);
                if (nArray[1] > 0) {
                    nArray[1] = nArray[1] - 1;
                    continue;
                }
                nArray[0] = nArray[0] + 1;
                Image[] imageArray = (Image[])this.AnimationDetails.elementAt(i + 1);
                int[] nArray2 = (int[])this.AnimationDetails.elementAt(i + 2);
                if (nArray[0] == nArray2.length) {
                    nArray[0] = 0;
                }
                nArray[1] = nArray2[nArray[0]];
                this.TDGraph.drawImage(imageArray[nArray[0]], nArray[2], nArray[3], null);
                this.repaint(nArray[2], nArray[3], 32, 32);
            }
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    protected Point getPos() {
        if (this.Highlight.x == -1) {
            return null;
        }
        if (this.Highlight.x / 32 + this.sbH.getValue() >= this.lsse.MapWidth || this.Highlight.y / 32 + this.sbV.getValue() >= this.lsse.MapHeight) {
            return null;
        }
        return new Point(this.Highlight.x / 32 + this.sbH.getValue(), this.Highlight.y / 32 + this.sbV.getValue());
    }

    protected Rectangle getRect() {
        return new Rectangle(this.rRect.x / 32, this.rRect.y / 32, this.rRect.width / 32, this.rRect.height / 32);
    }

    protected void reset() {
        this.bShowTerrain = true;
        this.Highlight.x = -1;
        this.sbH.setValues(0, 1, 0, this.lsse.MapWidth);
        this.sbV.setValues(0, 1, 0, this.lsse.MapHeight);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void CenterOn(Point point) {
        int n = this.TDWidth - 16;
        int n2 = this.TDHeight - 16;
        this.sbH.setValue(point.x - (n /= 64));
        this.sbV.setValue(point.y - (n2 /= 64));
        this.updateDimensions();
    }

    protected void updateDimensions() {
        int n = this.TDWidth - 16;
        int n2 = this.TDHeight - 16;
        this.sbH.setValues(this.sbH.getValue() + (n /= 32) > this.lsse.MapWidth ? this.lsse.MapWidth - n : this.sbH.getValue(), 1, 0, this.lsse.MapWidth);
        this.sbV.setValues(this.sbV.getValue() + n2 > this.lsse.MapHeight ? this.lsse.MapHeight - (n2 /= 32) : this.sbV.getValue(), 1, 0, this.lsse.MapHeight);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void NotifyHighlightChange(Point point) {
        this.Highlight.x = point.x == -1 ? -1 : point.x * 32;
        this.Highlight.y = point.y == -1 ? -1 : point.y * 32;
        this.repaint();
    }

    protected void SetHighlightPoint(int n) {
        this.iCurrentNode = n;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Paint paint;
        Graphics2D graphics2D;
        int n3 = this.TDWidth - 16;
        int n4 = this.TDHeight - 16;
        this.sbH.setBounds(0, n4, n3, 16);
        this.sbV.setBounds(n3, 0, 16, n4);
        this.sbH.setVisibleAmount(n3 /= 32);
        this.sbV.setVisibleAmount(n4 /= 32);
        this.TDGraph.setColor(new Color(240, 240, 240));
        this.TDGraph.drawLine(0, 0, 0, 1);
        if (this.TDImage != null) {
            graphics.drawImage(this.TDImage, 0, 0, null);
        }
        if ((this.function == 0 || this.function == 6) && this.Highlight.x != -1 && this.iDragMode == 0) {
            graphics.setColor(Color.RED);
            graphics.drawRect(this.Highlight.x, this.Highlight.y, 32, 32);
        }
        if (this.function == 0 && this.Highlight.x != -1 && this.iDragMode != 0) {
            graphics2D = (Graphics2D)graphics;
            paint = graphics2D.getPaint();
            n2 = this.rRectDraw.x - this.sbH.getValue() * 32;
            n = this.rRectDraw.y - this.sbV.getValue() * 32;
            graphics2D.setPaint(this.pRed);
            graphics2D.fillRect(n2, n, this.rRectDraw.width, this.rRectDraw.height);
            graphics2D.setPaint(paint);
            graphics.setColor(Color.RED);
            graphics.drawRect(n2, n, this.rRectDraw.width, this.rRectDraw.height);
            n2 = this.rRectTemp.x - this.sbH.getValue() * 32;
            n = this.rRectTemp.y - this.sbV.getValue() * 32;
            graphics2D.setPaint(this.pYellow);
            graphics2D.fillRect(n2, n, this.rRectTemp.width, this.rRectTemp.height);
            graphics2D.setPaint(paint);
            graphics.setColor(Color.YELLOW);
            graphics.drawRect(n2, n, this.rRectTemp.width, this.rRectTemp.height);
        }
        if (this.function == 1 && this.Highlight.x != -1 && this.Highlight.y != -1) {
            graphics.setColor(Color.RED);
            graphics.drawRect(this.Highlight.x - this.sbH.getValue() * 32, this.Highlight.y - this.sbV.getValue() * 32, 32, 32);
        }
        if ((this.function == 2 || this.function == 4) && this.Highlight.x != -1 && this.Highlight.y != -1 && this.rRect.x != -1) {
            graphics2D = (Graphics2D)graphics;
            paint = graphics2D.getPaint();
            n2 = this.rRectTemp.x - this.sbH.getValue() * 32;
            n = this.rRectTemp.y - this.sbV.getValue() * 32;
            graphics2D.setPaint(this.pYellow);
            graphics2D.fillRect(n2, n, this.rRectTemp.width, this.rRectTemp.height);
            graphics2D.setPaint(paint);
            graphics.setColor(Color.YELLOW);
            graphics.drawRect(n2, n, this.rRectTemp.width, this.rRectTemp.height);
        }
    }

    private void DoDragRectangle() {
        switch (this.iDragMode & 3) {
            case 1: {
                this.rRectTemp.x = this.Highlight.x > this.rRect.x + this.rRect.width ? this.rRect.x + this.rRect.width : this.Highlight.x;
                this.rRectTemp.width = this.Highlight.x > this.rRect.x + this.rRect.width ? this.Highlight.x - (this.rRect.x + this.rRect.width) : this.rRect.x + this.rRect.width - this.Highlight.x;
                break;
            }
            case 2: {
                this.rRectTemp.x = this.Highlight.x > this.rRect.x ? this.rRect.x : this.Highlight.x;
                this.rRectTemp.width = this.Highlight.x > this.rRect.x ? this.Highlight.x - this.rRect.x : this.rRect.x - this.Highlight.x;
                break;
            }
            default: {
                this.rRectTemp.x = this.rRect.x;
                this.rRectTemp.width = this.rRect.width;
            }
        }
        switch (this.iDragMode & 0xC) {
            case 4: {
                this.rRectTemp.y = this.Highlight.y > this.rRect.y + this.rRect.height ? this.rRect.y + this.rRect.height : this.Highlight.y;
                this.rRectTemp.height = this.Highlight.y > this.rRect.y + this.rRect.height ? this.Highlight.y - (this.rRect.y + this.rRect.height) : this.rRect.y + this.rRect.height - this.Highlight.y;
                break;
            }
            case 8: {
                this.rRectTemp.y = this.Highlight.y > this.rRect.y ? this.rRect.y : this.Highlight.y;
                this.rRectTemp.height = this.Highlight.y > this.rRect.y ? this.Highlight.y - this.rRect.y : this.rRect.y - this.Highlight.y;
                break;
            }
            default: {
                this.rRectTemp.y = this.rRect.y;
                this.rRectTemp.height = this.rRect.height;
            }
        }
        int n = this.rRectTemp.x + 16 & 0xFFFFE0;
        int n2 = this.rRectTemp.y + 16 & 0xFFFFE0;
        int n3 = this.rRectTemp.width + 15 & 0xFFFFE0;
        int n4 = this.rRectTemp.height + 15 & 0xFFFFE0;
        if ((n != this.rRectDraw.x || n2 != this.rRectDraw.y || n3 != this.rRectDraw.width || n4 != this.rRectDraw.height) && n3 != 0 && n4 != 0 && (n + n3) / 32 <= this.lsse.MapWidth && (n2 + n4) / 32 <= this.lsse.MapHeight) {
            this.rRectDraw.x = n;
            this.rRectDraw.y = n2;
            this.rRectDraw.width = n3;
            this.rRectDraw.height = n4;
            this.RepaintOffScreenImage();
        }
        this.repaint();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.function != 2 && this.function != 4 && this.function != 0 || this.iDragMode == 0) {
            return;
        }
        this.Highlight.setLocation(mouseEvent.getX() + this.sbH.getValue() * 32, mouseEvent.getY() + this.sbV.getValue() * 32);
        this.DoDragRectangle();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.function == 4 || this.function == 2) {
            int n = 0;
            int n2 = mouseEvent.getX() + this.sbH.getValue() * 32;
            int n3 = mouseEvent.getY() + this.sbV.getValue() * 32;
            if ((n2 - 4 & 0xFFF8) == (this.rRect.x - 4 & 0xFFF8) && n3 >= this.rRect.y - 4 && n3 < this.rRect.y + this.rRect.height + 4) {
                n = 1;
            }
            if ((n2 - 4 & 0xFFF8) == (this.rRect.x + this.rRect.width - 4 & 0xFFF8) && n3 >= this.rRect.y - 4 && n3 < this.rRect.y + this.rRect.height + 4) {
                n = 2;
            }
            if ((n3 - 4 & 0xFFF8) == (this.rRect.y - 4 & 0xFFF8) && n2 >= this.rRect.x - 4 && n2 < this.rRect.x + this.rRect.width + 4) {
                n += 4;
            }
            if ((n3 - 4 & 0xFFF8) == (this.rRect.y + this.rRect.height - 4 & 0xFFF8) && n2 >= this.rRect.x - 4 && n2 < this.rRect.x + this.rRect.width + 4) {
                n += 8;
            }
            if (n == this.iCursorMode) {
                return;
            }
            this.iCursorMode = n;
            this.setCursor(curResize[n]);
            return;
        }
        if (this.function != 0 && this.function != 6) {
            return;
        }
        int n = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        if (n >= this.TDWidth - 16 || n4 >= this.TDHeight - 16) {
            return;
        }
        if ((n &= 0xFFE0) == this.Highlight.x && (n4 &= 0xFFE0) == this.Highlight.y) {
            return;
        }
        this.Highlight.x = n;
        this.Highlight.y = n4;
        this.holder.repaint();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.bInPopup) {
            return;
        }
        if (mouseEvent.getX() / 32 + this.sbH.getValue() >= this.lsse.MapWidth || mouseEvent.getY() / 32 + this.sbV.getValue() >= this.lsse.MapHeight) {
            return;
        }
        if (this.function == 1) {
            this.Highlight.setLocation(mouseEvent.getX() & 0xFFE0, mouseEvent.getY() & 0xFFE0);
            ((ItemEditor)this.holder).TerrainDisplayNotifyingChange();
            this.repaint();
            return;
        }
        if (this.function == 3) {
            int n = (mouseEvent.getX() >> 5) + this.sbH.getValue() + ((mouseEvent.getY() >> 5) + this.sbV.getValue()) * this.lsse.MapWidth;
            ((DeployMapEditorDialog)this.holder).bDeploymentMap[n] = !((DeployMapEditorDialog)this.holder).bDeploymentMap[n];
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.iDragMode != 0 || this.function == 0 || this.function == 6) {
            this.iDragMode = 0;
            if (this.function != 0) {
                this.rRect.setBounds(this.rRectDraw);
            }
            if (this.function == 4) {
                ((RegionEditor)this.holder).SetBlock(this.rRectDraw);
            }
            this.setCursor(curResize[0]);
            this.Highlight.setLocation(-1, -1);
            if (this.function == 2 || this.function == 4) {
                this.RepaintOffScreenImage();
            }
            this.holder.repaint();
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.iDragMode = 0;
            this.StartPopupMenu(mouseEvent);
            return;
        }
        if (this.bInPopup) {
            this.bInPopup = false;
            return;
        }
        if (this.function != 2 && this.function != 4 && this.function != 0) {
            return;
        }
        if (this.function == 4 && this.rRect.x == -1) {
            return;
        }
        int n = mouseEvent.getX() + this.sbH.getValue() * 32;
        int n2 = mouseEvent.getY() + this.sbV.getValue() * 32;
        if (n / 32 >= this.lsse.MapWidth || n2 / 32 >= this.lsse.MapHeight) {
            return;
        }
        this.iDragMode = 0;
        if (this.function == 0) {
            this.rRect = new Rectangle(n & 0xFFE0, n2 & 0xFFE0, 32, 32);
            this.rRectDraw = new Rectangle(this.rRect);
            this.iDragMode = n - this.rRect.x < 16 ? 2 : 1;
            this.iDragMode += n2 - this.rRect.y < 16 ? 8 : 4;
        } else {
            if ((n - 4 & 0xFFF8) == (this.rRect.x - 4 & 0xFFF8)) {
                this.iDragMode = 1;
            }
            if ((n - 4 & 0xFFF8) == (this.rRect.x + this.rRect.width - 4 & 0xFFF8)) {
                this.iDragMode = 2;
            }
            if ((n2 - 4 & 0xFFF8) == (this.rRect.y - 4 & 0xFFF8)) {
                this.iDragMode += 4;
            }
            if ((n2 - 4 & 0xFFF8) == (this.rRect.y + this.rRect.height - 4 & 0xFFF8)) {
                this.iDragMode += 8;
            }
        }
        if (this.iDragMode == 0) {
            return;
        }
        this.Highlight.setLocation(n, n2);
        this.DoDragRectangle();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.iDragMode = 0;
            this.StartPopupMenu(mouseEvent);
            return;
        }
        if (this.bInPopup) {
            return;
        }
        if (this.function == 5 && mouseEvent.getX() / 32 + this.sbH.getValue() < this.lsse.MapWidth && mouseEvent.getY() / 32 + this.sbV.getValue() < this.lsse.MapHeight) {
            ((NodeEditor)this.holder).SetNodePosition(new Point(mouseEvent.getX() / 32 + this.sbH.getValue(), mouseEvent.getY() / 32 + this.sbV.getValue()));
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (this.function == 7) {
            ((UnitPatrolPanel)this.holder).NotifyClick(new Point(mouseEvent.getX() / 32 + this.sbH.getValue(), mouseEvent.getY() / 32 + this.sbV.getValue()));
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (!(this.iDragMode == 0 && this.function != 6 || this.bInPopup)) {
            this.rRect.setBounds(this.rRectDraw);
            if (this.function == 4) {
                ((RegionEditor)this.holder).SetBlock(this.rRectDraw);
            }
            if (this.function == 0) {
                ((MapEditor)this.holder).NotifyClick(this.rRectDraw);
            }
            if (this.function == 6 && this.rRect.x != -1 && this.getPos() != null) {
                ((TargetTerrainPanel)this.holder).NotifyClick(this.getPos());
                if (this.bShowTargetTerrains) {
                    this.rRect.setLocation(this.Highlight);
                }
            }
            this.iDragMode = 0;
            if (this.function != 0 && this.function != 6) {
                this.Highlight.setLocation(-1, -1);
            }
            if (this.function == 2 || this.function == 4 || this.function == 0) {
                this.RepaintOffScreenImage();
            }
            this.repaint();
        }
    }
}

