/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

class TerrainEditor
extends Panel
implements ActionListener,
Runnable,
KeyListener,
TextListener,
MouseListener,
ItemListener {
    private LaserSquadScenarioEditor lsse;
    private TerrainSelector ts;
    private Button butAdd;
    private Button butCopy;
    private Button butRemove;
    private Button butAnim1;
    private Button butAnim2;
    private Button butAddKey;
    private Button butRemoveKey;
    private PullDown ipdKey;
    private TextArea taName;
    private TextField tfStrength;
    private TextField tfProtect;
    private TextField tfAbsorbed;
    private TextField tfExplode;
    private TextField tfMaxHideSize;
    private Checkbox cbIsOpenable;
    private Checkbox cbCanHide;
    private Checkbox cbWillExplode;
    private Checkbox cbCanMoveThrough;
    private Checkbox cbCanSeeThrough;
    private Checkbox cbCanShootThrough;
    private Checkbox cbIsOpen;
    private Checkbox cbIsClosed;
    private Checkbox cbIsLocked;
    private Checkbox cbIsUnlocked;
    private Vector AnimationDetails = new Vector(10, 1);
    private Image TEImage = null;
    private Graphics TEGraph;
    private int TEWidth = -1;
    private int TEHeight = -1;
    private Thread TerrainAnnimator = null;
    private TextField[] tfVP;
    private TextField[] tfM;
    private TextField[] tfMov;
    private int xPos;
    private int yPos;
    private int iLastSelected = -1;

    public TerrainEditor(LaserSquadScenarioEditor laserSquadScenarioEditor) {
        int n;
        this.lsse = laserSquadScenarioEditor;
        this.ts = new TerrainSelector(this.lsse, this, 0);
        this.add(this.ts);
        this.butAdd = new Button("Add new Terrain");
        this.butAdd.addActionListener(this);
        this.add(this.butAdd);
        this.butCopy = new Button("Copy Terrain");
        this.butCopy.addActionListener(this);
        this.add(this.butCopy);
        this.butRemove = new Button("Remove Terrain");
        this.butRemove.addActionListener(this);
        this.add(this.butRemove);
        this.taName = new TextArea("", 2, 8, 3);
        this.taName.setFont(LaserSquadScenarioEditor.font);
        this.add(this.taName);
        this.taName.addTextListener(this);
        this.butAnim1 = new Button("Animate Terrain Picture");
        this.butAnim1.addActionListener(this);
        this.add(this.butAnim1);
        this.butAnim2 = new Button("Animate Target Picture");
        this.butAnim2.addActionListener(this);
        this.add(this.butAnim2);
        this.tfStrength = new TextField(4);
        this.tfStrength.setFont(LaserSquadScenarioEditor.font);
        this.tfStrength.addKeyListener(this);
        this.tfStrength.addTextListener(this);
        this.add(this.tfStrength);
        this.tfProtect = new TextField(4);
        this.tfProtect.setFont(LaserSquadScenarioEditor.font);
        this.tfProtect.addKeyListener(this);
        this.tfProtect.addTextListener(this);
        this.add(this.tfProtect);
        this.tfAbsorbed = new TextField(4);
        this.tfAbsorbed.setFont(LaserSquadScenarioEditor.font);
        this.tfAbsorbed.addKeyListener(this);
        this.tfAbsorbed.addTextListener(this);
        this.add(this.tfAbsorbed);
        this.tfExplode = new TextField(4);
        this.tfExplode.setFont(LaserSquadScenarioEditor.font);
        this.tfExplode.addKeyListener(this);
        this.tfExplode.addTextListener(this);
        this.add(this.tfExplode);
        this.tfMaxHideSize = new TextField(4);
        this.tfMaxHideSize.setFont(LaserSquadScenarioEditor.font);
        this.tfMaxHideSize.addKeyListener(this);
        this.tfMaxHideSize.addTextListener(this);
        this.add(this.tfMaxHideSize);
        this.cbIsOpenable = new Checkbox("Is Openable");
        this.cbIsOpenable.setFont(LaserSquadScenarioEditor.font);
        this.cbIsOpenable.addItemListener(this);
        this.add(this.cbIsOpenable);
        this.cbCanHide = new Checkbox("Hiden Items");
        this.cbCanHide.setFont(LaserSquadScenarioEditor.font);
        this.cbCanHide.addItemListener(this);
        this.add(this.cbCanHide);
        this.cbWillExplode = new Checkbox("Explodes");
        this.cbWillExplode.setFont(LaserSquadScenarioEditor.font);
        this.cbWillExplode.addItemListener(this);
        this.add(this.cbWillExplode);
        this.cbCanMoveThrough = new Checkbox("Is Route");
        this.cbCanMoveThrough.setFont(LaserSquadScenarioEditor.font);
        this.cbCanMoveThrough.addItemListener(this);
        this.add(this.cbCanMoveThrough);
        this.cbCanSeeThrough = new Checkbox("Transparent");
        this.cbCanSeeThrough.setFont(LaserSquadScenarioEditor.font);
        this.cbCanSeeThrough.addItemListener(this);
        this.add(this.cbCanSeeThrough);
        this.cbCanShootThrough = new Checkbox("Shoot Through");
        this.cbCanShootThrough.setFont(LaserSquadScenarioEditor.font);
        this.cbCanShootThrough.addItemListener(this);
        this.add(this.cbCanShootThrough);
        this.cbIsOpen = new Checkbox("Open");
        this.cbIsOpen.setFont(LaserSquadScenarioEditor.font);
        this.cbIsOpen.addItemListener(this);
        this.add(this.cbIsOpen);
        this.cbIsClosed = new Checkbox("Closed");
        this.cbIsClosed.setFont(LaserSquadScenarioEditor.font);
        this.cbIsClosed.addItemListener(this);
        this.add(this.cbIsClosed);
        this.cbIsLocked = new Checkbox("Locked");
        this.cbIsLocked.setFont(LaserSquadScenarioEditor.font);
        this.cbIsLocked.addItemListener(this);
        this.add(this.cbIsLocked);
        this.cbIsUnlocked = new Checkbox("Unlocked");
        this.cbIsUnlocked.setFont(LaserSquadScenarioEditor.font);
        this.cbIsUnlocked.addItemListener(this);
        this.add(this.cbIsUnlocked);
        this.ipdKey = new PullDown(this.lsse, this, null, 0);
        this.add(this.ipdKey);
        this.butAddKey = new Button("Add key");
        this.butAddKey.addActionListener(this);
        this.add(this.butAddKey);
        this.butRemoveKey = new Button("Remove Key");
        this.butRemoveKey.addActionListener(this);
        this.add(this.butRemoveKey);
        this.tfVP = new TextField[this.lsse.Teams.length];
        this.tfM = new TextField[this.lsse.Teams.length];
        for (n = 0; n < this.tfVP.length; ++n) {
            this.tfVP[n] = new TextField(3);
            this.tfVP[n].setFont(LaserSquadScenarioEditor.font);
            this.tfVP[n].addKeyListener(this);
            this.tfVP[n].addTextListener(this);
            this.add(this.tfVP[n]);
            this.tfM[n] = new TextField(3);
            this.tfM[n].setFont(LaserSquadScenarioEditor.font);
            this.tfM[n].addKeyListener(this);
            this.tfM[n].addTextListener(this);
            this.add(this.tfM[n]);
        }
        this.tfMov = new TextField[this.lsse.Terrains[0].MovementCost.length];
        for (n = 0; n < this.tfMov.length; ++n) {
            this.tfMov[n] = new TextField(3);
            this.tfMov[n].setFont(LaserSquadScenarioEditor.font);
            this.tfMov[n].addKeyListener(this);
            this.tfMov[n].addTextListener(this);
            this.add(this.tfMov[n]);
        }
        this.addMouseListener(this);
        this.setBackground(new Color(240, 240, 240));
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.TEWidth || n4 != this.TEHeight) {
            this.TEWidth = n3;
            this.TEHeight = n4;
            this.TEImage = this.createImage(n3 - 176, n4);
            this.TEGraph = this.TEImage.getGraphics();
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    private void RepaintOffScreenImage() {
        int n;
        int n2 = this.ts.GetPointer();
        int n3 = this.lsse.Terrains[n2].WhatItBecomesWhenDestroyed;
        if (this.TerrainAnnimator != null) {
            this.TerrainAnnimator.interrupt();
        }
        this.TerrainAnnimator = null;
        this.AnimationDetails.clear();
        if (this.TEGraph == null) {
            return;
        }
        this.TEGraph.setColor(new Color(240, 240, 240));
        this.TEGraph.fillRect(0, 0, this.TEWidth, this.TEHeight);
        this.TEGraph.setColor(Color.BLACK);
        this.TEGraph.setFont(LaserSquadScenarioEditor.font);
        this.TEGraph.drawString("Terrain", 5, 14);
        this.TEGraph.drawString("Name:", 5, 30);
        StringTokenizer stringTokenizer = new StringTokenizer(this.lsse.Terrains[n2].name, "//", false);
        String string = new String((stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "") + (this.lsse.Terrains[n2].name.indexOf("//") != -1 ? "\r\n" : "") + (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : ""));
        this.taName.setText(string);
        if (n3 != 65535 && n2 != 0) {
            this.TEGraph.drawString("Becomes if", 190, 14);
            this.TEGraph.drawString("Destroyed:", 190, 30);
            this.TEGraph.drawRect(299, 0, 150, 33);
            this.lsse.Terrains[n3].DisplayDetails(this.TEGraph, 300, 1, this.AnimationDetails);
        }
        this.TEGraph.drawString("Terrain image:", 5, 67);
        this.lsse.Terrains[n2].DisplayImage(this.TEGraph, 150, 46, this.AnimationDetails, false);
        this.TEGraph.drawString("Target image:", 5, 101);
        this.lsse.Terrains[n2].DisplayImage(this.TEGraph, 150, 82, this.AnimationDetails, true);
        this.TEGraph.drawString("Scanner image:", 380, 67);
        this.TEGraph.drawImage(this.lsse.Terrains[n2].ScannerPic, 520, 58, 532, 70, 0, 0, 6, 6, null);
        this.TEGraph.drawString("Strength:", 5, 135);
        this.tfStrength.setText(this.lsse.Terrains[n2].Strength == 4095 ? "-" : Integer.toString(this.lsse.Terrains[n2].Strength));
        this.tfStrength.setEditable(n2 != 0);
        this.TEGraph.drawString("Protection:", 5, 155);
        this.tfProtect.setText(Integer.toString(this.lsse.Terrains[n2].ProtectionToUnit));
        this.TEGraph.drawString("Force absorbed:", 180, 135);
        this.tfAbsorbed.setText(Integer.toString(this.lsse.Terrains[n2].ForceAbsorbed));
        this.TEGraph.drawString("Explosive force:", 180, 155);
        this.tfExplode.setEditable((this.lsse.Terrains[n2].flags & 8) == 8);
        if ((this.lsse.Terrains[n2].flags & 8) == 0) {
            this.lsse.Terrains[n2].ExplosionForce = 0;
        }
        this.tfExplode.setText((this.lsse.Terrains[n2].flags & 8) == 0 ? "-" : Integer.toString(this.lsse.Terrains[n2].ExplosionForce));
        this.TEGraph.drawString("Max Hide Size:", 180, 175);
        this.tfMaxHideSize.setEditable((this.lsse.Terrains[n2].flags & 4) == 4);
        if ((this.lsse.Terrains[n2].flags & 4) == 0) {
            this.lsse.Terrains[n2].MaxHideSize = 0;
        }
        this.tfMaxHideSize.setText((this.lsse.Terrains[n2].flags & 4) == 0 ? "-" : Integer.toString(this.lsse.Terrains[n2].MaxHideSize));
        this.cbIsOpenable.setState(this.lsse.Terrains[n2].ChangesToWhenOpenedOrClosed != 65535 || this.lsse.Terrains[n2].ChangesToWhenLockedOrUnlocked != 65535);
        this.cbCanHide.setState((this.lsse.Terrains[n2].flags & 4) == 4);
        this.cbWillExplode.setState((this.lsse.Terrains[n2].flags & 8) == 8);
        this.cbCanMoveThrough.setState((this.lsse.Terrains[n2].flags & 0x10) == 0);
        this.cbCanSeeThrough.setState((this.lsse.Terrains[n2].flags & 0x40) == 0);
        this.cbCanShootThrough.setState((this.lsse.Terrains[n2].flags & 0x20) == 0);
        this.yPos = 316;
        if (this.lsse.Terrains[n2].ChangesToWhenOpenedOrClosed != 65535 || this.lsse.Terrains[n2].ChangesToWhenLockedOrUnlocked != 65535) {
            this.cbIsOpen.setState((this.lsse.Terrains[n2].flags & 3) == 0);
            this.cbIsOpen.setEnabled(true);
            this.cbIsClosed.setState((this.lsse.Terrains[n2].flags & 1) == 1);
            this.cbIsClosed.setEnabled(true);
            this.cbIsLocked.setState((this.lsse.Terrains[n2].flags & 3) == 3);
            this.cbIsLocked.setEnabled(true);
            this.cbIsUnlocked.setState((this.lsse.Terrains[n2].flags & 3) == 1);
            this.cbIsUnlocked.setEnabled(true);
            n3 = this.lsse.Terrains[n2].ChangesToWhenOpenedOrClosed;
            if ((this.lsse.Terrains[n2].flags & 3) != 3) {
                this.TEGraph.drawString("Becomes when", 140, 238);
                this.TEGraph.drawString((this.lsse.Terrains[n2].flags & 1) == 1 ? "opened:" : "closed:", 140, 254);
                this.TEGraph.drawRect(275, 224, 150, 33);
                this.lsse.Terrains[n3].DisplayDetails(this.TEGraph, 276, 225, this.AnimationDetails);
            }
            n3 = this.lsse.Terrains[n2].ChangesToWhenLockedOrUnlocked;
            if ((this.lsse.Terrains[n2].flags & 3) != 0 && n3 != 65535) {
                this.TEGraph.drawString("Becomes when", 140, 278);
                this.TEGraph.drawString((this.lsse.Terrains[n2].flags & 2) == 2 ? "unlocked:" : "locked:", 140, 294);
                this.TEGraph.drawRect(275, 264, 150, 33);
                this.lsse.Terrains[n3].DisplayDetails(this.TEGraph, 276, 265, this.AnimationDetails);
            }
            this.TEGraph.drawString("Keys:", 5, 324);
            this.ipdKey.setVisible(true);
            this.butAddKey.setVisible(true);
            this.butRemoveKey.setVisible(true);
            this.yPos = 359;
        } else {
            this.cbIsOpen.setState(false);
            this.cbIsOpen.setEnabled(false);
            this.cbIsClosed.setState(false);
            this.cbIsClosed.setEnabled(false);
            this.cbIsLocked.setState(false);
            this.cbIsLocked.setEnabled(false);
            this.cbIsUnlocked.setState(false);
            this.cbIsUnlocked.setEnabled(false);
            this.ipdKey.setVisible(false);
            this.butAddKey.setVisible(false);
            this.butRemoveKey.setVisible(false);
        }
        this.TEGraph.drawString("Team:", 5, this.yPos + 16);
        this.xPos = 5;
        for (n = 0; n < this.lsse.Teams.length; ++n) {
            if (this.lsse.Teams[n].name.length() > this.xPos) {
                this.xPos = this.lsse.Teams[n].name.length();
            }
            this.TEGraph.drawString(this.lsse.Teams[n].name, 5, this.yPos + 32 + n * 20);
        }
        ++this.xPos;
        this.xPos *= 11;
        this.TEGraph.drawString("Victory", this.xPos, this.yPos);
        this.TEGraph.drawString("Points:", this.xPos, this.yPos + 16);
        this.TEGraph.drawString("Morale", this.xPos + 88, this.yPos);
        this.TEGraph.drawString("Value:", this.xPos + 88, this.yPos + 16);
        for (n = 0; n < this.lsse.Teams.length; ++n) {
            this.tfVP[n].setText(Integer.toString(this.lsse.Terrains[n2].VictoryPoints[n]));
            this.tfM[n].setText(Integer.toString(this.lsse.Terrains[n2].Morrale[n]));
        }
        this.TEGraph.drawString("Terrain", this.xPos + 200, this.yPos);
        this.TEGraph.drawString("band:", this.xPos + 200, this.yPos + 16);
        this.TEGraph.drawString("Movement", this.xPos + 288, this.yPos);
        this.TEGraph.drawString("Cost:", this.xPos + 288, this.yPos + 16);
        for (n = 0; n < this.tfMov.length; ++n) {
            this.TEGraph.drawString(Integer.toString(n), this.xPos + 200, this.yPos + 32 + n * 20);
            this.tfMov[n].setText(this.lsse.Terrains[n2].MovementCost[n] == 4095 ? "-" : Integer.toString(this.lsse.Terrains[n2].MovementCost[n]));
        }
        if (!this.AnimationDetails.isEmpty()) {
            this.TerrainAnnimator = new Thread((Runnable)this, "TerrainAnnimator");
            this.TerrainAnnimator.start();
        }
    }

    public void run() {
        while (this.TerrainAnnimator != null && !this.AnimationDetails.isEmpty()) {
            for (int i = 0; i < this.AnimationDetails.size(); i += 3) {
                int[] nArray = (int[])this.AnimationDetails.elementAt(i);
                if (nArray[1] > 0) {
                    nArray[1] = nArray[1] - 1;
                    continue;
                }
                nArray[0] = nArray[0] + 1;
                Image[] imageArray = (Image[])this.AnimationDetails.elementAt(i + 1);
                int[] nArray2 = (int[])this.AnimationDetails.elementAt(i + 2);
                if (nArray[0] == nArray2.length) {
                    nArray[0] = 0;
                }
                nArray[1] = nArray2[nArray[0]];
                this.TEGraph.drawImage(imageArray[nArray[0]], nArray[2], nArray[3], null);
                this.repaint(nArray[2], nArray[3], 32, 32);
            }
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    protected void Reset() {
        int n;
        for (n = 0; n < this.tfVP.length; ++n) {
            this.remove(this.tfVP[n]);
            this.remove(this.tfM[n]);
        }
        this.tfVP = new TextField[this.lsse.Teams.length];
        this.tfM = new TextField[this.lsse.Teams.length];
        for (n = 0; n < this.tfVP.length; ++n) {
            this.tfVP[n] = new TextField(3);
            this.tfVP[n].setFont(LaserSquadScenarioEditor.font);
            this.tfVP[n].addKeyListener(this);
            this.tfVP[n].addTextListener(this);
            this.add(this.tfVP[n]);
            this.tfM[n] = new TextField(3);
            this.tfM[n].setFont(LaserSquadScenarioEditor.font);
            this.tfM[n].addKeyListener(this);
            this.tfM[n].addTextListener(this);
            this.add(this.tfM[n]);
        }
        for (n = 0; n < this.tfMov.length; ++n) {
            this.remove(this.tfMov[n]);
        }
        this.tfMov = new TextField[this.lsse.Terrains[0].MovementCost.length];
        for (n = 0; n < this.tfMov.length; ++n) {
            this.tfMov[n] = new TextField(3);
            this.tfMov[n].setFont(LaserSquadScenarioEditor.font);
            this.tfMov[n].addKeyListener(this);
            this.tfMov[n].addTextListener(this);
            this.add(this.tfMov[n]);
        }
        this.iLastSelected = -1;
        this.ipdKey.reset(null, 0);
        this.ts.reset();
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n;
        int n2 = this.TEWidth;
        int n3 = this.TEHeight;
        this.butAdd.setBounds(n2 - 176, 3, 170, 25);
        this.butCopy.setBounds(n2 - 176, 31, 170, 25);
        this.butRemove.setBounds(n2 - 176, 59, 170, 25);
        n3 -= 87;
        this.ts.setBounds(n2 - 176, 87, 174, (n3 /= 34) * 34);
        this.TEGraph.setColor(new Color(240, 240, 240));
        this.TEGraph.drawLine(0, 0, 0, 1);
        graphics.drawImage(this.TEImage, 0, 0, null);
        this.taName.setBounds(86, 1, 90, 41);
        this.butAnim1.setBounds(190, 47, 170, 30);
        this.butAnim2.setBounds(190, 83, 170, 30);
        this.tfStrength.setBounds(115, 122, 60, 20);
        this.tfProtect.setBounds(115, 142, 60, 20);
        this.tfAbsorbed.setBounds(340, 122, 60, 20);
        this.tfExplode.setBounds(340, 142, 60, 20);
        this.tfMaxHideSize.setBounds(340, 162, 60, 20);
        this.cbIsOpenable.setBounds(5, 182, 125, 20);
        this.cbWillExplode.setBounds(140, 182, 125, 20);
        this.cbCanMoveThrough.setBounds(275, 182, 160, 20);
        this.cbCanSeeThrough.setBounds(5, 202, 125, 20);
        this.cbCanHide.setBounds(140, 202, 125, 20);
        this.cbCanShootThrough.setBounds(275, 202, 160, 20);
        this.cbIsOpen.setBounds(5, 222, 125, 20);
        this.cbIsClosed.setBounds(5, 242, 125, 20);
        this.cbIsLocked.setBounds(5, 262, 125, 20);
        this.cbIsUnlocked.setBounds(5, 282, 125, 20);
        this.ipdKey.setBounds(60, 302, 182, 34);
        this.butAddKey.setBounds(251, 303, 60, 32);
        this.butRemoveKey.setBounds(321, 303, 80, 32);
        for (n = 0; n < this.lsse.Teams.length; ++n) {
            this.tfVP[n].setBounds(this.xPos, this.yPos + 19 + n * 20, 45, 20);
            this.tfM[n].setBounds(this.xPos + 88, this.yPos + 19 + n * 20, 45, 20);
        }
        for (n = 0; n < this.tfMov.length; ++n) {
            this.tfMov[n].setBounds(this.xPos + 288, this.yPos + 19 + n * 20, 45, 20);
        }
    }

    protected void NotifyClick() {
        if (this.iLastSelected != this.ts.GetPointer()) {
            this.iLastSelected = this.ts.GetPointer();
            this.ipdKey.reset(this.lsse.Terrains[this.iLastSelected].Keys, 0);
        }
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void NotifyDestroyedTerrainChange(int n) {
        this.lsse.Terrains[this.ts.GetPointer()].WhatItBecomesWhenDestroyed = n;
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void NotifyOCTerrainChange(int n) {
        this.lsse.Terrains[this.ts.GetPointer()].ChangesToWhenOpenedOrClosed = n;
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void NotifyLUTerrainChange(int n) {
        this.lsse.Terrains[this.ts.GetPointer()].ChangesToWhenLockedOrUnlocked = n;
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void ChangeMapPic(Image image) {
        this.lsse.Terrains[this.ts.GetPointer()].MapPic = image;
        this.lsse.Terrains[this.ts.GetPointer()].AnnimationPics = null;
        this.lsse.CheckCAEChange(1, this.ts.GetPointer());
        this.ts.adjustmentValueChanged(null);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void ChangeTargetPic(Image image) {
        this.lsse.Terrains[this.ts.GetPointer()].TargetPic = image;
        this.lsse.Terrains[this.ts.GetPointer()].TargettingAnnimationPics = null;
        this.ts.adjustmentValueChanged(null);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void ChangeMapAnnimation(Image[] imageArray, int[] nArray) {
        this.lsse.Terrains[this.ts.GetPointer()].AnnimationPics = imageArray;
        if (imageArray != null) {
            this.lsse.Terrains[this.ts.GetPointer()].MapPic = imageArray[0];
        }
        this.lsse.Terrains[this.ts.GetPointer()].AnnimationTimes = nArray;
        if (imageArray != null && imageArray.length == 1) {
            this.lsse.Terrains[this.ts.GetPointer()].AnnimationPics = null;
            this.lsse.Terrains[this.ts.GetPointer()].AnnimationTimes = null;
        }
        this.ts.adjustmentValueChanged(null);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void ChangeTargetAnnimation(Image[] imageArray, int[] nArray) {
        this.lsse.Terrains[this.ts.GetPointer()].TargettingAnnimationPics = imageArray;
        if (imageArray != null) {
            this.lsse.Terrains[this.ts.GetPointer()].TargetPic = imageArray[0];
        }
        this.lsse.Terrains[this.ts.GetPointer()].TargettingAnnimationTimes = nArray;
        if (imageArray != null && imageArray.length == 1) {
            this.lsse.Terrains[this.ts.GetPointer()].TargettingAnnimationPics = null;
            this.lsse.Terrains[this.ts.GetPointer()].TargettingAnnimationTimes = null;
        }
        this.ts.adjustmentValueChanged(null);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void ChangeScannerPic(Image image) {
        this.lsse.Terrains[this.ts.GetPointer()].ScannerPic = image;
        this.ts.adjustmentValueChanged(null);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void NotifyAddKeyChange(int n) {
        int n2 = this.ts.GetPointer();
        if (this.lsse.Terrains[n2].Keys == null) {
            this.lsse.Terrains[n2].Keys = new int[1];
            this.lsse.Terrains[n2].Keys[0] = n;
        } else {
            int n3;
            for (n3 = 0; n3 < this.lsse.Terrains[n2].Keys.length && this.lsse.Terrains[n2].Keys[n3] != n; ++n3) {
            }
            if (n3 == this.lsse.Terrains[n2].Keys.length) {
                this.lsse.Terrains[n2].Keys = ScenarioEditorUtility.arrayAdd(this.lsse.Terrains[n2].Keys, n);
            }
        }
        this.ipdKey.reset(this.lsse.Terrains[n2].Keys, this.ipdKey.GetSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int[] nArray;
        Image[] imageArray;
        int n2 = this.ts.GetPointer();
        if (actionEvent.getSource() == this.butAnim1) {
            if (this.lsse.Terrains[n2].AnnimationPics == null) {
                imageArray = new Image[1];
                nArray = new int[1];
                imageArray[0] = this.lsse.Terrains[n2].MapPic;
                nArray[0] = 0;
                new AnnimationEditor(this.lsse, this, 1, "Animate Map Picture", imageArray, nArray);
            } else {
                new AnnimationEditor(this.lsse, this, 1, "Animate Map Picture", this.lsse.Terrains[n2].AnnimationPics, this.lsse.Terrains[n2].AnnimationTimes);
            }
        }
        if (actionEvent.getSource() == this.butAnim2) {
            if (this.lsse.Terrains[n2].TargettingAnnimationPics == null) {
                imageArray = new Image[1];
                nArray = new int[1];
                imageArray[0] = this.lsse.Terrains[n2].TargetPic;
                nArray[0] = 0;
                new AnnimationEditor(this.lsse, this, 2, "Animate Targeting Picture", imageArray, nArray);
            } else {
                new AnnimationEditor(this.lsse, this, 2, "Animate Targeting Picture", this.lsse.Terrains[n2].TargettingAnnimationPics, this.lsse.Terrains[n2].TargettingAnnimationTimes);
            }
        }
        if (actionEvent.getSource() == this.butAdd) {
            imageArray = new EditorTerrain();
            imageArray.MapPic = this.createImage(32, 32);
            imageArray.MapPic.getGraphics().setColor(Color.BLACK);
            imageArray.MapPic.getGraphics().fillRect(0, 0, 32, 32);
            imageArray.TargetPic = imageArray.MapPic;
            this.lsse.AddImageToPool(imageArray.MapPic);
            imageArray.ScannerPic = this.createImage(6, 6);
            imageArray.ScannerPic.getGraphics().setColor(Color.BLACK);
            imageArray.ScannerPic.getGraphics().fillRect(0, 0, 6, 6);
            this.lsse.AddImageToScannerPool(imageArray.ScannerPic);
            imageArray.name = new String("NEW//TERRAIN");
            imageArray.Strength = 4095;
            imageArray.WhatItBecomesWhenDestroyed = 65535;
            imageArray.ForceAbsorbed = 0;
            imageArray.ProtectionToUnit = 0;
            imageArray.flags = 0;
            imageArray.MaxHideSize = 0;
            imageArray.ExplosionForce = 0;
            imageArray.ChangesToWhenOpenedOrClosed = 65535;
            imageArray.ChangesToWhenLockedOrUnlocked = 65535;
            imageArray.Keys = null;
            imageArray.VictoryPoints = new int[this.lsse.Teams.length];
            Arrays.fill(imageArray.VictoryPoints, 0);
            imageArray.Morrale = new int[this.lsse.Teams.length];
            Arrays.fill(imageArray.Morrale, 0);
            imageArray.MovementCost = new int[this.lsse.Terrains[0].MovementCost.length];
            Arrays.fill(imageArray.MovementCost, 4);
            imageArray.AnnimationPics = null;
            imageArray.AnnimationTimes = null;
            imageArray.TargettingAnnimationPics = null;
            imageArray.TargettingAnnimationTimes = null;
            this.lsse.AddTerrainToPool((EditorTerrain)imageArray);
            for (n = 0; n < this.lsse.Map.length; ++n) {
                if (this.lsse.Map[n] < this.lsse.Terrains.length) continue;
                int n3 = n;
                this.lsse.Map[n3] = this.lsse.Map[n3] + 1;
            }
            this.ts.RepaintOffScreenImage();
            this.ts.repaint();
        }
        if (actionEvent.getSource() == this.butCopy) {
            this.lsse.AddTerrainToPool(new EditorTerrain(this.lsse.Terrains[n2]));
            for (n = 0; n < this.lsse.Map.length; ++n) {
                if (this.lsse.Map[n] < this.lsse.Terrains.length) continue;
                int n4 = n;
                this.lsse.Map[n4] = this.lsse.Map[n4] + 1;
            }
            this.ts.RepaintOffScreenImage();
            this.ts.repaint();
        }
        if (actionEvent.getSource() == this.butRemove) {
            if (n2 == 0) {
                return;
            }
            for (n = 0; n < this.lsse.Map.length; ++n) {
                if (this.lsse.Map[n] == n2) {
                    this.lsse.Map[n] = 0;
                }
                if (this.lsse.Map[n] <= n2) continue;
                int n5 = n;
                this.lsse.Map[n5] = this.lsse.Map[n5] - 1;
            }
            if (this.lsse.Items != null) {
                for (n = 0; n < this.lsse.Items.length; ++n) {
                    if (this.lsse.Items[n].TerrainUnder == n2) {
                        this.lsse.Items[n].TerrainUnder = 0;
                    }
                    if (this.lsse.Items[n].TerrainUnder <= n2 || this.lsse.Items[n].TerrainUnder >= 65535) continue;
                    --this.lsse.Items[n].TerrainUnder;
                }
            }
            for (n = 0; n < this.lsse.Terrains.length; ++n) {
                if (this.lsse.Terrains[n].WhatItBecomesWhenDestroyed == n2) {
                    this.lsse.Terrains[n].WhatItBecomesWhenDestroyed = 0;
                }
                if (this.lsse.Terrains[n].WhatItBecomesWhenDestroyed > n2 && this.lsse.Terrains[n].WhatItBecomesWhenDestroyed < 65535) {
                    --this.lsse.Terrains[n].WhatItBecomesWhenDestroyed;
                }
                if (this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed == n2) {
                    this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed = 0;
                }
                if (this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed > n2 && this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed < 65535) {
                    --this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed;
                }
                if (this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked == n2) {
                    this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked = 0;
                }
                if (this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked <= n2 || this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked >= 65535) continue;
                --this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked;
            }
            for (n = 0; n < this.lsse.Teams.length; ++n) {
                if (this.lsse.Teams[n].TerrainsCanDestroyToMoveThrough == null) continue;
                this.lsse.Teams[n].TerrainsCanDestroyToMoveThrough = ScenarioEditorUtility.arrayDeleteItem(this.lsse.Teams[n].TerrainsCanDestroyToMoveThrough, n2);
                if (this.lsse.Teams[n].TerrainsCanDestroyToMoveThrough.length == 0) {
                    this.lsse.Teams[n].TerrainsCanDestroyToMoveThrough = null;
                    continue;
                }
                for (int i = 0; i < this.lsse.Teams[n].TerrainsCanDestroyToMoveThrough.length; ++i) {
                    if (this.lsse.Teams[n].TerrainsCanDestroyToMoveThrough[i] <= n2) continue;
                    int n6 = i;
                    this.lsse.Teams[n].TerrainsCanDestroyToMoveThrough[n6] = this.lsse.Teams[n].TerrainsCanDestroyToMoveThrough[n6] - 1;
                }
            }
            this.lsse.RemoveTerrainFromPool(this.lsse.Terrains[n2]);
            this.lsse.CheckCAEChange(0, n2);
            this.ts.RecheckPointer();
            this.ts.RepaintOffScreenImage();
            this.ts.repaint();
            this.RepaintOffScreenImage();
            this.repaint();
        }
        if (actionEvent.getSource() == this.butAddKey) {
            new ItemSelectorWindow(this.lsse, this, 0, "Select New Key", 0);
        }
        if (actionEvent.getSource() == this.butRemoveKey) {
            n = 0;
            if (this.lsse.Terrains[n2].Keys != null && this.lsse.Terrains[n2].Keys.length == 1) {
                this.lsse.Terrains[n2].Keys = null;
            }
            if (this.lsse.Terrains[n2].Keys != null) {
                n = this.ipdKey.GetSelected();
                this.lsse.Terrains[n2].Keys = ScenarioEditorUtility.arrayDeleteElementAt(this.lsse.Terrains[n2].Keys, n);
                if (n == this.lsse.Terrains[n2].Keys.length) {
                    --n;
                }
            }
            this.ipdKey.reset(this.lsse.Terrains[n2].Keys, n);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        int n = 0;
        int n2 = this.ts.GetPointer();
        if (textEvent.getSource() == this.taName && textEvent.getID() == 900) {
            n = this.taName.getCaretPosition();
            StringBuffer stringBuffer = new StringBuffer(this.taName.getText().toUpperCase());
            if (stringBuffer.indexOf("\r\n") > 8 || stringBuffer.indexOf("\r\n") == -1 && stringBuffer.length() > 8) {
                stringBuffer.insert(8, "\r\n");
                if (n > stringBuffer.indexOf("\r\n")) {
                    n += 2;
                }
            }
            if (stringBuffer.indexOf("\r\n") != -1) {
                stringBuffer.replace(stringBuffer.indexOf("\r\n"), stringBuffer.indexOf("\r\n") + 2, "//");
            }
            if (!stringBuffer.toString().equals(this.lsse.Terrains[n2].name)) {
                while (stringBuffer.indexOf("\r\n") != -1) {
                    stringBuffer.delete(stringBuffer.indexOf("\r\n"), stringBuffer.indexOf("\r\n") + 2);
                }
                if (stringBuffer.indexOf("//") != -1 && stringBuffer.length() > stringBuffer.indexOf("//") + 10) {
                    stringBuffer.setLength(stringBuffer.indexOf("//") + 10);
                }
                if (n > stringBuffer.indexOf("//") && stringBuffer.indexOf("//") != -1) {
                    --n;
                }
                this.lsse.Terrains[n2].name = stringBuffer.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(this.lsse.Terrains[n2].name, "//", false);
                String string = new String((stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "") + (stringBuffer.indexOf("//") != -1 ? "\r\n" : "") + (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : ""));
                this.taName.setText(string);
                this.ts.RepaintOffScreenImage();
                this.ts.repaint();
                this.taName.setCaretPosition(n);
            }
            return;
        }
        if (textEvent.getSource() == this.tfStrength && textEvent.getID() == 900) {
            try {
                n = Integer.parseInt(this.tfStrength.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 4095;
            }
            if (n >= 4095 || n < 0) {
                n = 4095;
            }
            int n3 = this.lsse.Terrains[n2].Strength;
            int n4 = this.tfStrength.getCaretPosition();
            this.lsse.Terrains[n2].Strength = n;
            if (n3 == 4095 && n != 4095) {
                this.lsse.Terrains[n2].WhatItBecomesWhenDestroyed = 0;
                this.RepaintOffScreenImage();
                this.repaint();
            }
            if (n == 4095 && n3 != 4095) {
                this.lsse.Terrains[n2].WhatItBecomesWhenDestroyed = 65535;
                this.RepaintOffScreenImage();
                this.repaint();
            }
            this.tfStrength.setCaretPosition(n4);
            return;
        }
        if (textEvent.getSource() == this.tfProtect && textEvent.getID() == 900) {
            try {
                n = Integer.parseInt(this.tfProtect.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n > 4094 || n < 0) {
                n = 0;
            }
            this.lsse.Terrains[n2].ProtectionToUnit = n;
            return;
        }
        if (textEvent.getSource() == this.tfAbsorbed && textEvent.getID() == 900) {
            try {
                n = Integer.parseInt(this.tfAbsorbed.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n > 4094 || n < 0) {
                n = 0;
            }
            this.lsse.Terrains[n2].ForceAbsorbed = n;
            return;
        }
        if (textEvent.getSource() == this.tfExplode && textEvent.getID() == 900) {
            try {
                n = Integer.parseInt(this.tfExplode.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n > 4094 || n < 0) {
                n = 0;
            }
            this.lsse.Terrains[n2].ExplosionForce = n;
            return;
        }
        if (textEvent.getSource() == this.tfMaxHideSize && textEvent.getID() == 900) {
            try {
                n = Integer.parseInt(this.tfMaxHideSize.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n > 4094 || n < 0) {
                n = 0;
            }
            this.lsse.Terrains[n2].MaxHideSize = n;
            return;
        }
        if (textEvent.getID() == 900) {
            int n5;
            for (n5 = 0; n5 < this.tfVP.length; ++n5) {
                if (textEvent.getSource() != this.tfVP[n5]) continue;
                try {
                    n = Integer.parseInt(this.tfVP[n5].getText());
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                this.lsse.Terrains[n2].VictoryPoints[n5] = n;
                return;
            }
            for (n5 = 0; n5 < this.tfM.length; ++n5) {
                if (textEvent.getSource() != this.tfM[n5]) continue;
                try {
                    n = Integer.parseInt(this.tfM[n5].getText());
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                this.lsse.Terrains[n2].Morrale[n5] = n;
                return;
            }
            for (n5 = 0; n5 < this.tfMov.length; ++n5) {
                if (textEvent.getSource() != this.tfMov[n5]) continue;
                try {
                    n = Integer.parseInt(this.tfMov[n5].getText());
                }
                catch (NumberFormatException numberFormatException) {
                    n = 4095;
                }
                if (n < 0) {
                    n = 4095;
                }
                this.lsse.Terrains[n2].MovementCost[n5] = n;
                return;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.ts.GetPointer();
        if (itemEvent.getID() != 701) {
            return;
        }
        if (itemEvent.getSource() == this.cbIsOpenable) {
            if (itemEvent.getStateChange() == 1) {
                this.lsse.Terrains[n].flags &= 0xFFFFC;
                this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed = 0;
            } else {
                this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed = 65535;
            }
            this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked = 65535;
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (itemEvent.getSource() == this.cbWillExplode) {
            this.lsse.Terrains[n].flags = itemEvent.getStateChange() == 1 ? (this.lsse.Terrains[n].flags |= 8) : (this.lsse.Terrains[n].flags &= 0xFFFF7);
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (itemEvent.getSource() == this.cbCanMoveThrough) {
            this.lsse.Terrains[n].flags = itemEvent.getStateChange() == 1 ? (this.lsse.Terrains[n].flags &= 0xFFFEF) : (this.lsse.Terrains[n].flags |= 0x10);
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (itemEvent.getSource() == this.cbCanSeeThrough) {
            this.lsse.Terrains[n].flags = itemEvent.getStateChange() == 1 ? (this.lsse.Terrains[n].flags &= 0xFFFBF) : (this.lsse.Terrains[n].flags |= 0x40);
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (itemEvent.getSource() == this.cbCanHide) {
            this.lsse.Terrains[n].flags = itemEvent.getStateChange() == 1 ? (this.lsse.Terrains[n].flags |= 4) : (this.lsse.Terrains[n].flags &= 0xFFFFB);
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (itemEvent.getSource() == this.cbCanShootThrough) {
            this.lsse.Terrains[n].flags = itemEvent.getStateChange() == 1 ? (this.lsse.Terrains[n].flags &= 0xFFFDF) : (this.lsse.Terrains[n].flags |= 0x20);
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (itemEvent.getSource() == this.cbIsOpen) {
            this.lsse.Terrains[n].flags &= 0xFFFFC;
            if (itemEvent.getStateChange() == 2) {
                this.lsse.Terrains[n].flags |= 1;
                this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked = 0;
            } else {
                this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked = 65535;
            }
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (itemEvent.getSource() == this.cbIsClosed) {
            this.lsse.Terrains[n].flags &= 0xFFFFC;
            if (itemEvent.getStateChange() == 1) {
                this.lsse.Terrains[n].flags |= 1;
                this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked = 0;
            } else {
                this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked = 65535;
                if (this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed == 65535) {
                    this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed = 0;
                }
            }
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (itemEvent.getSource() == this.cbIsLocked) {
            this.lsse.Terrains[n].flags &= 0xFFFFC;
            this.lsse.Terrains[n].flags |= 1;
            if (itemEvent.getStateChange() == 1) {
                this.lsse.Terrains[n].flags |= 2;
                this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed = 65535;
                if (this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked == 65535) {
                    this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked = 0;
                }
            } else {
                this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed = 0;
            }
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (itemEvent.getSource() == this.cbIsUnlocked) {
            this.lsse.Terrains[n].flags &= 0xFFFFC;
            this.lsse.Terrains[n].flags |= 1;
            if (itemEvent.getStateChange() == 2) {
                this.lsse.Terrains[n].flags |= 2;
                this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed = 65535;
            } else {
                this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed = 0;
                if (this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked == 65535) {
                    this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked = 0;
                }
            }
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) && c != '-' && c != '\b') {
            keyEvent.consume();
        }
        if (c == '-' && (keyEvent.getSource() == this.tfProtect || keyEvent.getSource() == this.tfAbsorbed || keyEvent.getSource() == this.tfExplode || keyEvent.getSource() == this.tfMaxHideSize)) {
            keyEvent.consume();
        }
        this.ts.adjustmentValueChanged(null);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.ts.GetPointer();
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        if (mouseEvent.getX() >= 299 && mouseEvent.getX() < 449 && mouseEvent.getY() >= 0 && mouseEvent.getY() < 33) {
            if (this.lsse.Terrains[n].Strength != 4095) {
                new TerrainSelectorWindow(this.lsse, this, this.lsse.Terrains[n].WhatItBecomesWhenDestroyed, "Select Destroyed terrain", 299, 0, 1);
            }
            this.repaint();
            return;
        }
        if (mouseEvent.getX() >= 150 && mouseEvent.getX() < 182 && mouseEvent.getY() >= 46 && mouseEvent.getY() < 78) {
            new ImageSelector(this.lsse, this, 1, "Select map picture", this.lsse.Terrains[n].MapPic);
        }
        if (mouseEvent.getX() >= 520 && mouseEvent.getX() < 532 && mouseEvent.getY() >= 58 && mouseEvent.getY() < 70) {
            new ImageSelector(this.lsse, this, 9, "Select Terrain Scanner picture", this.lsse.Terrains[n].ScannerPic);
        }
        if (mouseEvent.getX() >= 150 && mouseEvent.getX() < 182 && mouseEvent.getY() >= 82 && mouseEvent.getY() < 114) {
            new ImageSelector(this.lsse, this, 2, "Select target picture", this.lsse.Terrains[n].TargetPic);
        }
        if (mouseEvent.getX() >= 275 && mouseEvent.getX() < 425 && mouseEvent.getY() >= 224 && mouseEvent.getY() < 257) {
            if (this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed != 65535) {
                new TerrainSelectorWindow(this.lsse, this, this.lsse.Terrains[n].ChangesToWhenOpenedOrClosed, (this.lsse.Terrains[n].flags & 1) == 1 ? "Becomes when opened" : "Becomes when closed", 275, 0, 2);
            }
            this.repaint();
        }
        if (mouseEvent.getX() >= 275 && mouseEvent.getX() < 425 && mouseEvent.getY() >= 264 && mouseEvent.getY() < 297) {
            if (this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked != 65535) {
                new TerrainSelectorWindow(this.lsse, this, this.lsse.Terrains[n].ChangesToWhenLockedOrUnlocked, (this.lsse.Terrains[n].flags & 2) == 2 ? "Becomes when unlocked" : "Becomes when locked", 275, 0, 3);
            }
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

