/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

class TerrainSelector
extends Panel
implements AdjustmentListener,
MouseListener,
Runnable {
    private LaserSquadScenarioEditor lsse;
    private Container holder;
    private int pointer;
    private Scrollbar sb;
    private Vector AnimationDetails = new Vector(10, 1);
    private Image TSImage = null;
    private Graphics TSGraph;
    private int TSWidth = -1;
    private int TSHeight = -1;
    private Thread TerrainAnnimator = null;

    public TerrainSelector(LaserSquadScenarioEditor laserSquadScenarioEditor, Container container, int n) {
        this.lsse = laserSquadScenarioEditor;
        this.holder = container;
        this.pointer = n;
        this.sb = new Scrollbar(1, n, 1, 0, this.lsse.Terrains.length);
        this.sb.addAdjustmentListener(this);
        this.add(this.sb);
        this.addMouseListener(this);
        this.setBackground(new Color(240, 240, 240));
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.TSWidth || n4 != this.TSHeight) {
            this.TSWidth = n3;
            this.TSHeight = n4;
            this.TSImage = this.createImage(n3 - 16, n4);
            this.TSGraph = this.TSImage == null ? null : this.TSImage.getGraphics();
            this.RepaintOffScreenImage();
            this.repaint();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        if (this.TerrainAnnimator != null) {
            this.TerrainAnnimator.interrupt();
        }
        this.TerrainAnnimator = null;
        this.AnimationDetails.clear();
        int n = this.TSHeight;
        if (this.TSGraph == null) {
            return;
        }
        this.TSGraph.setColor(Color.WHITE);
        this.TSGraph.fillRect(0, 0, 160, n);
        this.sb.setBounds(158, 0, 16, n);
        this.sb.setVisibleAmount(n /= 34);
        if (this.sb.getMaximum() != this.lsse.Terrains.length) {
            this.sb.setMaximum(this.lsse.Terrains.length);
        }
        this.TSGraph.setColor(Color.BLACK);
        this.TSGraph.setFont(LaserSquadScenarioEditor.font);
        int n2 = this.sb.getValue();
        if (n2 >= 0) {
            for (int i = 0; i < n && i + n2 < this.lsse.Terrains.length; ++i) {
                this.lsse.Terrains[i + n2].DisplayDetails(this.TSGraph, 0, 1 + i * 34, this.AnimationDetails);
                if (i + n2 != this.pointer) continue;
                this.TSGraph.setColor(Color.RED);
                this.TSGraph.drawRect(0, i * 34, this.TSWidth - 17, 33);
                this.TSGraph.setColor(Color.BLACK);
            }
        }
        if (!this.AnimationDetails.isEmpty()) {
            this.TerrainAnnimator = new Thread((Runnable)this, "TerrainAnnimator");
            this.TerrainAnnimator.start();
        }
    }

    public void run() {
        while (this.TerrainAnnimator != null && !this.AnimationDetails.isEmpty()) {
            for (int i = 0; i < this.AnimationDetails.size(); i += 3) {
                int[] nArray = (int[])this.AnimationDetails.elementAt(i);
                if (nArray[1] > 0) {
                    nArray[1] = nArray[1] - 1;
                    continue;
                }
                nArray[0] = nArray[0] + 1;
                Image[] imageArray = (Image[])this.AnimationDetails.elementAt(i + 1);
                int[] nArray2 = (int[])this.AnimationDetails.elementAt(i + 2);
                if (nArray[0] == nArray2.length) {
                    nArray[0] = 0;
                }
                nArray[1] = nArray2[nArray[0]];
                this.TSGraph.drawImage(imageArray[nArray[0]], nArray[2], nArray[3], null);
                this.repaint(nArray[2], nArray[3], 32, 32);
            }
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    protected void reset() {
        this.pointer = 0;
        this.sb.setValues(0, 1, 0, this.lsse.Terrains.length);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.TSGraph.setColor(Color.WHITE);
        this.TSGraph.drawLine(this.TSWidth - 18, 1, this.TSWidth - 18, 2);
        if (this.TSImage != null) {
            graphics.drawImage(this.TSImage, 0, 0, null);
        }
        this.sb.setBounds(158, 0, 16, this.TSHeight);
    }

    public int GetPointer() {
        return this.pointer;
    }

    protected void RecheckPointer() {
        if (this.pointer >= this.lsse.Terrains.length) {
            --this.pointer;
        }
        if (this.pointer < 0) {
            this.pointer = 0;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (n < 0 || n > this.getSize().width - 16) {
            return;
        }
        n = mouseEvent.getY();
        int n2 = this.getSize().height / 34;
        if (n < 0 || n > (n2 *= 34)) {
            return;
        }
        n = mouseEvent.getY() / 34;
        if ((n += this.sb.getValue()) >= this.lsse.Terrains.length) {
            return;
        }
        this.pointer = n;
        this.RepaintOffScreenImage();
        this.repaint();
        if (this.holder.getClass().getName().equals("TerrainEditor")) {
            ((TerrainEditor)this.holder).NotifyClick();
        }
        if (mouseEvent.getClickCount() == 2 && this.holder.getClass().getName().equals("TerrainSelectorWindow")) {
            ((TerrainSelectorWindow)this.holder).InformParentOfChange();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

