/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.StringTokenizer;

class UnitEditorPanel
extends Panel
implements ActionListener,
TextListener,
KeyListener,
MouseListener,
ItemListener {
    private LaserSquadScenarioEditor lsse;
    private Container parent;
    private int UEWidth = -1;
    private int UEHeight = -1;
    private Image UEImage = null;
    private Graphics UEGraph;
    private PullDown pdHeld;
    private Button butSetMax;
    private Button butDeathEffects;
    private Button butAutoDeploy;
    private Button butEditEquipment;
    private Button butTargetTerrains;
    private Button butPatrol;
    private Button butLevels;
    private Button butFlags;
    private TextArea uName;
    private TextField tfStrength;
    private TextField tfAgility;
    private TextField tfWeaponSkill;
    private TextField tfCloseCombatDamage;
    private TextField tfToughness;
    private TextField tfSize;
    private TextField tfMaxSizeCanCarry;
    private TextField tfFatigue;
    private TextField tfMAP;
    private TextField tfCCon;
    private TextField tfMCon;
    private TextField tfCStam;
    private TextField tfMStam;
    private TextField tfCMor;
    private TextField tfMMor;
    private TextField tfStartRound;
    private TextField tfRegions;
    private TextField tfMinAimed;
    private TextField tfMinSnap;
    private Choice cTeams;
    private Choice cTerrainBand;
    private Choice cRegions;
    private Checkbox cbCanEquip;
    private Checkbox cbItemsLostWithUnit;
    private Checkbox cbImmuneToMorrale;
    private Checkbox cbManualDeploy;
    private Checkbox cbCantPickUpDrop;
    private Checkbox cbCantPickUpDropChange;
    private Checkbox cbThreatArmour;
    private Checkbox cbThreatIgnoreItems;
    private Checkbox cbDontReseveAPs;
    private Checkbox cbAlwaysReserveAPs;
    private Checkbox cbMoveSafely;
    private Checkbox cbPatrolsRatherThanThreats;
    private Checkbox cbAttackVisible;
    private Checkbox cbAutoWeaponReload;
    private Checkbox cbAttackTerrain;
    private Checkbox cbThreatIgnoreRegion;
    private Checkbox cbIgnoreZeroThreat;
    private TextField[] tfM;
    private TextField[] tfVP;
    private int xPos;
    private int yPos;
    private TextField tfAFront;
    private TextField tfALeft;
    private TextField tfARight;
    private TextField tfARear;
    private TextField tfAWeight;
    private EditorUnit euUnit = null;

    public UnitEditorPanel(LaserSquadScenarioEditor laserSquadScenarioEditor, Container container) {
        int n;
        this.lsse = laserSquadScenarioEditor;
        this.parent = container;
        this.setBackground(new Color(240, 240, 240));
        this.uName = new TextArea("", 2, 8, 3);
        this.uName.setFont(LaserSquadScenarioEditor.font);
        this.uName.addTextListener(this);
        this.add(this.uName);
        this.pdHeld = new PullDown(laserSquadScenarioEditor, this);
        if (container.getClass().getName().equals("CAEUnitEditorWindow")) {
            this.pdHeld.caeuew = (CAEUnitEditorWindow)container;
        }
        this.add(this.pdHeld);
        this.cTeams = new Choice();
        this.cTeams.setFont(LaserSquadScenarioEditor.font);
        this.cTeams.addItemListener(this);
        for (n = 0; n < laserSquadScenarioEditor.Teams.length; ++n) {
            this.cTeams.add(laserSquadScenarioEditor.Teams[n].name);
        }
        this.add(this.cTeams);
        this.butDeathEffects = new Button("Death Effects");
        this.butDeathEffects.addActionListener(this);
        this.add(this.butDeathEffects);
        this.butEditEquipment = new Button("Edit Equipment");
        this.butEditEquipment.addActionListener(this);
        this.add(this.butEditEquipment);
        this.tfStrength = new TextField(4);
        this.tfStrength.setFont(LaserSquadScenarioEditor.font);
        this.tfStrength.addKeyListener(this);
        this.tfStrength.addTextListener(this);
        this.add(this.tfStrength);
        this.tfAgility = new TextField(4);
        this.tfAgility.setFont(LaserSquadScenarioEditor.font);
        this.tfAgility.addKeyListener(this);
        this.tfAgility.addTextListener(this);
        this.add(this.tfAgility);
        this.tfSize = new TextField(4);
        this.tfSize.setFont(LaserSquadScenarioEditor.font);
        this.tfSize.addKeyListener(this);
        this.tfSize.addTextListener(this);
        this.add(this.tfSize);
        this.tfFatigue = new TextField(4);
        this.tfFatigue.setFont(LaserSquadScenarioEditor.font);
        this.tfFatigue.addKeyListener(this);
        this.tfFatigue.addTextListener(this);
        this.add(this.tfFatigue);
        this.tfWeaponSkill = new TextField(4);
        this.tfWeaponSkill.setFont(LaserSquadScenarioEditor.font);
        this.tfWeaponSkill.addKeyListener(this);
        this.tfWeaponSkill.addTextListener(this);
        this.add(this.tfWeaponSkill);
        this.tfCloseCombatDamage = new TextField(4);
        this.tfCloseCombatDamage.setFont(LaserSquadScenarioEditor.font);
        this.tfCloseCombatDamage.addKeyListener(this);
        this.tfCloseCombatDamage.addTextListener(this);
        this.add(this.tfCloseCombatDamage);
        this.tfToughness = new TextField(4);
        this.tfToughness.setFont(LaserSquadScenarioEditor.font);
        this.tfToughness.addKeyListener(this);
        this.tfToughness.addTextListener(this);
        this.add(this.tfToughness);
        this.tfMaxSizeCanCarry = new TextField(4);
        this.tfMaxSizeCanCarry.setFont(LaserSquadScenarioEditor.font);
        this.tfMaxSizeCanCarry.addKeyListener(this);
        this.tfMaxSizeCanCarry.addTextListener(this);
        this.add(this.tfMaxSizeCanCarry);
        this.butAutoDeploy = new Button("Autodeploy Area");
        this.butAutoDeploy.addActionListener(this);
        this.add(this.butAutoDeploy);
        this.tfMAP = new TextField(4);
        this.tfMAP.setFont(LaserSquadScenarioEditor.font);
        this.tfMAP.addKeyListener(this);
        this.tfMAP.addTextListener(this);
        this.add(this.tfMAP);
        this.tfCCon = new TextField(4);
        this.tfCCon.setFont(LaserSquadScenarioEditor.font);
        this.tfCCon.addKeyListener(this);
        this.tfCCon.addTextListener(this);
        this.add(this.tfCCon);
        this.tfMCon = new TextField(4);
        this.tfMCon.setFont(LaserSquadScenarioEditor.font);
        this.tfMCon.addKeyListener(this);
        this.tfMCon.addTextListener(this);
        this.add(this.tfMCon);
        this.tfCStam = new TextField(4);
        this.tfCStam.setFont(LaserSquadScenarioEditor.font);
        this.tfCStam.addKeyListener(this);
        this.tfCStam.addTextListener(this);
        this.add(this.tfCStam);
        this.tfMStam = new TextField(4);
        this.tfMStam.setFont(LaserSquadScenarioEditor.font);
        this.tfMStam.addKeyListener(this);
        this.tfMStam.addTextListener(this);
        this.add(this.tfMStam);
        this.tfCMor = new TextField(4);
        this.tfCMor.setFont(LaserSquadScenarioEditor.font);
        this.tfCMor.addKeyListener(this);
        this.tfCMor.addTextListener(this);
        this.add(this.tfCMor);
        this.tfMMor = new TextField(4);
        this.tfMMor.setFont(LaserSquadScenarioEditor.font);
        this.tfMMor.addKeyListener(this);
        this.tfMMor.addTextListener(this);
        this.add(this.tfMMor);
        this.butLevels = new Button("Edit Levels Allowed on");
        this.butLevels.addActionListener(this);
        this.add(this.butLevels);
        this.cTerrainBand = new Choice();
        this.cTerrainBand.setFont(LaserSquadScenarioEditor.font);
        for (n = 0; n < laserSquadScenarioEditor.Terrains[0].MovementCost.length; ++n) {
            this.cTerrainBand.add(Integer.toString(n));
        }
        this.cTerrainBand.addItemListener(this);
        this.add(this.cTerrainBand);
        this.butSetMax = new Button("Set to Max");
        this.butSetMax.addActionListener(this);
        this.add(this.butSetMax);
        this.butFlags = new Button("Edit User Defined Flags");
        this.butFlags.addActionListener(this);
        this.add(this.butFlags);
        this.tfStartRound = new TextField(3);
        this.tfStartRound.setFont(LaserSquadScenarioEditor.font);
        this.tfStartRound.addKeyListener(this);
        this.tfStartRound.addTextListener(this);
        this.add(this.tfStartRound);
        this.cbCanEquip = new Checkbox("Can be Equiped");
        this.cbCanEquip.setFont(LaserSquadScenarioEditor.font);
        this.cbCanEquip.addItemListener(this);
        this.add(this.cbCanEquip);
        this.cbItemsLostWithUnit = new Checkbox("Items Lost With Unit");
        this.cbItemsLostWithUnit.setFont(LaserSquadScenarioEditor.font);
        this.cbItemsLostWithUnit.addItemListener(this);
        this.add(this.cbItemsLostWithUnit);
        this.cbImmuneToMorrale = new Checkbox("No Morrale Loss");
        this.cbImmuneToMorrale.setFont(LaserSquadScenarioEditor.font);
        this.cbImmuneToMorrale.addItemListener(this);
        this.add(this.cbImmuneToMorrale);
        this.cbManualDeploy = new Checkbox("Manual Deploy");
        this.cbManualDeploy.setFont(LaserSquadScenarioEditor.font);
        this.cbManualDeploy.addItemListener(this);
        this.add(this.cbManualDeploy);
        this.cbCantPickUpDrop = new Checkbox("Can't Pickup or Drop");
        this.cbCantPickUpDrop.setFont(LaserSquadScenarioEditor.font);
        this.cbCantPickUpDrop.addItemListener(this);
        this.add(this.cbCantPickUpDrop);
        this.cbCantPickUpDropChange = new Checkbox("Can't Change Items");
        this.cbCantPickUpDropChange.setFont(LaserSquadScenarioEditor.font);
        this.cbCantPickUpDropChange.addItemListener(this);
        this.add(this.cbCantPickUpDropChange);
        this.tfVP = new TextField[laserSquadScenarioEditor.Teams.length];
        this.tfM = new TextField[laserSquadScenarioEditor.Teams.length];
        for (n = 0; n < this.tfVP.length; ++n) {
            this.tfVP[n] = new TextField(3);
            this.tfVP[n].setFont(LaserSquadScenarioEditor.font);
            this.tfVP[n].addKeyListener(this);
            this.tfVP[n].addTextListener(this);
            this.add(this.tfVP[n]);
            this.tfM[n] = new TextField(3);
            this.tfM[n].setFont(LaserSquadScenarioEditor.font);
            this.tfM[n].addKeyListener(this);
            this.tfM[n].addTextListener(this);
            this.add(this.tfM[n]);
        }
        this.tfAFront = new TextField(3);
        this.tfAFront.setFont(LaserSquadScenarioEditor.font);
        this.tfAFront.addKeyListener(this);
        this.tfAFront.addTextListener(this);
        this.add(this.tfAFront);
        this.tfALeft = new TextField(3);
        this.tfALeft.setFont(LaserSquadScenarioEditor.font);
        this.tfALeft.addKeyListener(this);
        this.tfALeft.addTextListener(this);
        this.add(this.tfALeft);
        this.tfARight = new TextField(3);
        this.tfARight.setFont(LaserSquadScenarioEditor.font);
        this.tfARight.addKeyListener(this);
        this.tfARight.addTextListener(this);
        this.add(this.tfARight);
        this.tfARear = new TextField(3);
        this.tfARear.setFont(LaserSquadScenarioEditor.font);
        this.tfARear.addKeyListener(this);
        this.tfARear.addTextListener(this);
        this.add(this.tfARear);
        this.tfAWeight = new TextField(3);
        this.tfAWeight.setFont(LaserSquadScenarioEditor.font);
        this.tfAWeight.addKeyListener(this);
        this.tfAWeight.addTextListener(this);
        this.add(this.tfAWeight);
        this.cbThreatArmour = new Checkbox("Ignore Armour burdon in Threat");
        this.cbThreatArmour.setFont(LaserSquadScenarioEditor.font);
        this.cbThreatArmour.addItemListener(this);
        this.add(this.cbThreatArmour);
        this.cbThreatIgnoreItems = new Checkbox("Ignore Items carried in Threat");
        this.cbThreatIgnoreItems.setFont(LaserSquadScenarioEditor.font);
        this.cbThreatIgnoreItems.addItemListener(this);
        this.add(this.cbThreatIgnoreItems);
        this.cbDontReseveAPs = new Checkbox("Patrol in-cautiously");
        this.cbDontReseveAPs.setFont(LaserSquadScenarioEditor.font);
        this.cbDontReseveAPs.addItemListener(this);
        this.add(this.cbDontReseveAPs);
        this.cbAlwaysReserveAPs = new Checkbox("Always reserve APs");
        this.cbAlwaysReserveAPs.setFont(LaserSquadScenarioEditor.font);
        this.cbAlwaysReserveAPs.addItemListener(this);
        this.add(this.cbAlwaysReserveAPs);
        this.cbMoveSafely = new Checkbox("Move Cautiously");
        this.cbMoveSafely.setFont(LaserSquadScenarioEditor.font);
        this.cbMoveSafely.addItemListener(this);
        this.add(this.cbMoveSafely);
        this.cbPatrolsRatherThanThreats = new Checkbox("Patrol rather than find threat");
        this.cbPatrolsRatherThanThreats.setFont(LaserSquadScenarioEditor.font);
        this.cbPatrolsRatherThanThreats.addItemListener(this);
        this.add(this.cbPatrolsRatherThanThreats);
        this.cbAttackVisible = new Checkbox("Attacks Nearest Visible Enemy");
        this.cbAttackVisible.setFont(LaserSquadScenarioEditor.font);
        this.cbAttackVisible.addItemListener(this);
        this.add(this.cbAttackVisible);
        this.cbAutoWeaponReload = new Checkbox("Weapon Auto-reloads");
        this.cbAutoWeaponReload.setFont(LaserSquadScenarioEditor.font);
        this.cbAutoWeaponReload.addItemListener(this);
        this.add(this.cbAutoWeaponReload);
        this.cbAttackTerrain = new Checkbox("Attacks Terrain");
        this.cbAttackTerrain.setFont(LaserSquadScenarioEditor.font);
        this.cbAttackTerrain.addItemListener(this);
        this.add(this.cbAttackTerrain);
        this.cbThreatIgnoreRegion = new Checkbox("Ignore Region in Threat");
        this.cbThreatIgnoreRegion.setFont(LaserSquadScenarioEditor.font);
        this.cbThreatIgnoreRegion.addItemListener(this);
        this.add(this.cbThreatIgnoreRegion);
        this.cbIgnoreZeroThreat = new Checkbox("Ignore 0 threat units");
        this.cbIgnoreZeroThreat.setFont(LaserSquadScenarioEditor.font);
        this.cbIgnoreZeroThreat.addItemListener(this);
        this.add(this.cbIgnoreZeroThreat);
        this.butTargetTerrains = new Button("Edit Target Terrains");
        this.butTargetTerrains.addActionListener(this);
        this.add(this.butTargetTerrains);
        this.butPatrol = new Button("Patrol Route");
        this.butPatrol.addActionListener(this);
        this.add(this.butPatrol);
        this.cRegions = new Choice();
        this.cRegions.setFont(LaserSquadScenarioEditor.font);
        this.cRegions.addItemListener(this);
        if (laserSquadScenarioEditor.NumberOfRegions > 0) {
            for (n = 1; n <= laserSquadScenarioEditor.NumberOfRegions; ++n) {
                this.cRegions.add("Region " + Integer.toString(n));
            }
            this.cRegions.select(0);
        }
        this.add(this.cRegions);
        this.tfRegions = new TextField(3);
        this.tfRegions.setFont(LaserSquadScenarioEditor.font);
        this.tfRegions.addKeyListener(this);
        this.tfRegions.addTextListener(this);
        this.add(this.tfRegions);
        this.tfMinAimed = new TextField(3);
        this.tfMinAimed.setFont(LaserSquadScenarioEditor.font);
        this.tfMinAimed.addKeyListener(this);
        this.tfMinAimed.addTextListener(this);
        this.add(this.tfMinAimed);
        this.tfMinSnap = new TextField(3);
        this.tfMinSnap.setFont(LaserSquadScenarioEditor.font);
        this.tfMinSnap.addKeyListener(this);
        this.tfMinSnap.addTextListener(this);
        this.add(this.tfMinSnap);
        this.addMouseListener(this);
    }

    protected void Reset() {
        int n;
        for (n = 0; n < this.tfVP.length; ++n) {
            this.remove(this.tfVP[n]);
            this.remove(this.tfM[n]);
        }
        this.tfVP = new TextField[this.lsse.Teams.length];
        this.tfM = new TextField[this.lsse.Teams.length];
        for (n = 0; n < this.tfVP.length; ++n) {
            this.tfVP[n] = new TextField(3);
            this.tfVP[n].setFont(LaserSquadScenarioEditor.font);
            this.tfVP[n].addKeyListener(this);
            this.tfVP[n].addTextListener(this);
            this.add(this.tfVP[n]);
            this.tfM[n] = new TextField(3);
            this.tfM[n].setFont(LaserSquadScenarioEditor.font);
            this.tfM[n].addKeyListener(this);
            this.tfM[n].addTextListener(this);
            this.add(this.tfM[n]);
        }
        this.remove(this.cTerrainBand);
        this.cTerrainBand = new Choice();
        this.cTerrainBand.setFont(LaserSquadScenarioEditor.font);
        for (n = 0; n < this.lsse.Terrains[0].MovementCost.length; ++n) {
            this.cTerrainBand.add(Integer.toString(n));
        }
        this.cTerrainBand.addItemListener(this);
        this.add(this.cTerrainBand);
        this.remove(this.cTeams);
        this.cTeams = new Choice();
        this.cTeams.setFont(LaserSquadScenarioEditor.font);
        this.cTeams.addItemListener(this);
        for (n = 0; n < this.lsse.Teams.length; ++n) {
            this.cTeams.add(this.lsse.Teams[n].name);
        }
        this.add(this.cTeams);
        this.remove(this.cRegions);
        this.cRegions = new Choice();
        this.cRegions.setFont(LaserSquadScenarioEditor.font);
        this.cRegions.addItemListener(this);
        if (this.lsse.NumberOfRegions > 0) {
            for (n = 1; n <= this.lsse.NumberOfRegions; ++n) {
                this.cRegions.add("Region " + Integer.toString(n));
            }
            this.cRegions.select(0);
        }
        this.add(this.cRegions);
        this.repaint();
    }

    protected void SetEditorUnit(EditorUnit editorUnit) {
        this.euUnit = editorUnit;
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected EditorUnit GetEditorUnit() {
        return this.euUnit;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.UEWidth || n4 != this.UEHeight) {
            this.UEWidth = n3;
            this.UEHeight = n4;
            this.UEImage = this.createImage(n3, n4);
            this.UEGraph = this.UEImage.getGraphics();
            this.RepaintOffScreenImage();
        }
        super.setBounds(n, n2, n3, n4);
    }

    private void RepaintOffScreenImage() {
        int n;
        if (this.UEGraph == null) {
            return;
        }
        this.UEGraph.setColor(new Color(240, 240, 240));
        this.UEGraph.fillRect(0, 0, this.UEWidth, this.UEHeight);
        this.UEGraph.setColor(Color.BLACK);
        this.UEGraph.setFont(LaserSquadScenarioEditor.font);
        if (this.euUnit == null) {
            int n2;
            this.uName.setVisible(false);
            this.pdHeld.setVisible(false);
            this.butEditEquipment.setVisible(false);
            this.cTeams.setVisible(false);
            this.butDeathEffects.setVisible(false);
            this.butAutoDeploy.setVisible(false);
            this.tfStrength.setVisible(false);
            this.tfAgility.setVisible(false);
            this.tfSize.setVisible(false);
            this.tfFatigue.setVisible(false);
            this.tfWeaponSkill.setVisible(false);
            this.tfCloseCombatDamage.setVisible(false);
            this.tfToughness.setVisible(false);
            this.tfMaxSizeCanCarry.setVisible(false);
            this.tfMAP.setVisible(false);
            this.tfMCon.setVisible(false);
            this.tfCCon.setVisible(false);
            this.tfMStam.setVisible(false);
            this.tfCStam.setVisible(false);
            this.tfMMor.setVisible(false);
            this.tfCMor.setVisible(false);
            this.butLevels.setVisible(false);
            this.cTerrainBand.setVisible(false);
            this.butSetMax.setVisible(false);
            this.butFlags.setVisible(false);
            this.tfStartRound.setVisible(false);
            this.cbCanEquip.setVisible(false);
            this.cbManualDeploy.setVisible(false);
            this.cbCantPickUpDrop.setVisible(false);
            this.cbItemsLostWithUnit.setVisible(false);
            this.cbCantPickUpDropChange.setVisible(false);
            this.cbImmuneToMorrale.setVisible(false);
            for (n2 = 0; n2 < this.tfVP.length; ++n2) {
                this.tfVP[n2].setVisible(false);
            }
            for (n2 = 0; n2 < this.tfM.length; ++n2) {
                this.tfM[n2].setVisible(false);
            }
            this.tfAFront.setVisible(false);
            this.tfALeft.setVisible(false);
            this.tfARight.setVisible(false);
            this.tfARear.setVisible(false);
            this.tfAWeight.setVisible(false);
            this.cbThreatArmour.setVisible(false);
            this.cbThreatIgnoreItems.setVisible(false);
            this.cbDontReseveAPs.setVisible(false);
            this.cbAlwaysReserveAPs.setVisible(false);
            this.cbMoveSafely.setVisible(false);
            this.cbPatrolsRatherThanThreats.setVisible(false);
            this.cbAttackVisible.setVisible(false);
            this.cbAutoWeaponReload.setVisible(false);
            this.cbAttackTerrain.setVisible(false);
            this.cbThreatIgnoreRegion.setVisible(false);
            this.cbIgnoreZeroThreat.setVisible(false);
            this.butTargetTerrains.setVisible(false);
            this.butPatrol.setVisible(false);
            this.cRegions.setVisible(false);
            this.tfRegions.setVisible(false);
            this.tfMinAimed.setVisible(false);
            this.tfMinSnap.setVisible(false);
            return;
        }
        this.uName.setVisible(true);
        this.pdHeld.setVisible(true);
        this.butEditEquipment.setVisible(true);
        this.cTeams.setVisible(true);
        this.butDeathEffects.setVisible(true);
        this.butAutoDeploy.setVisible(true);
        this.tfStrength.setVisible(true);
        this.tfAgility.setVisible(true);
        this.tfSize.setVisible(true);
        this.tfFatigue.setVisible(true);
        this.tfWeaponSkill.setVisible(true);
        this.tfCloseCombatDamage.setVisible(true);
        this.tfToughness.setVisible(true);
        this.tfMaxSizeCanCarry.setVisible(true);
        this.tfMAP.setVisible(true);
        this.tfMCon.setVisible(true);
        this.tfCCon.setVisible(true);
        this.tfMStam.setVisible(true);
        this.tfCStam.setVisible(true);
        this.tfMMor.setVisible(true);
        this.tfCMor.setVisible(true);
        this.butLevels.setVisible(true);
        this.cTerrainBand.setVisible(true);
        this.butSetMax.setVisible(true);
        this.butFlags.setVisible(true);
        this.tfStartRound.setVisible(true);
        this.cbCanEquip.setVisible(true);
        this.cbManualDeploy.setVisible(true);
        this.cbCantPickUpDrop.setVisible(true);
        this.cbItemsLostWithUnit.setVisible(true);
        this.cbCantPickUpDropChange.setVisible(true);
        this.cbImmuneToMorrale.setVisible(true);
        for (n = 0; n < this.tfVP.length; ++n) {
            this.tfVP[n].setVisible(true);
        }
        for (n = 0; n < this.tfM.length; ++n) {
            this.tfM[n].setVisible(true);
        }
        this.tfAFront.setVisible(true);
        this.tfALeft.setVisible(true);
        this.tfARight.setVisible(true);
        this.tfARear.setVisible(true);
        this.tfAWeight.setVisible(true);
        this.cbThreatArmour.setVisible(true);
        this.cbThreatIgnoreItems.setVisible(true);
        this.cbDontReseveAPs.setVisible(true);
        this.cbAlwaysReserveAPs.setVisible(true);
        this.cbMoveSafely.setVisible(true);
        this.cbPatrolsRatherThanThreats.setVisible(true);
        this.cbAttackVisible.setVisible(true);
        this.cbAutoWeaponReload.setVisible(true);
        this.cbAttackTerrain.setVisible(true);
        this.cbThreatIgnoreRegion.setVisible(true);
        this.cbIgnoreZeroThreat.setVisible(true);
        this.butTargetTerrains.setVisible(true);
        this.butPatrol.setVisible(true);
        this.cRegions.setVisible(true);
        this.tfRegions.setVisible(true);
        this.tfMinAimed.setVisible(true);
        this.tfMinSnap.setVisible(true);
        this.UEGraph.drawString("Unit", 5, 14);
        this.UEGraph.drawString("Name:", 5, 30);
        StringTokenizer stringTokenizer = new StringTokenizer(this.euUnit.name, "//", false);
        String string = new String((stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "") + (this.euUnit.name.indexOf("//") != -1 ? "\r\n" : "") + (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : ""));
        this.uName.setText(string);
        this.UEGraph.drawString("Unit", 165, 14);
        this.UEGraph.drawString("Type:", 165, 30);
        this.UEGraph.drawRect(215, 0, 150, 33);
        this.lsse.GenericUnits[this.euUnit.UnitType].DisplayDetails(this.UEGraph, 216, 1, null);
        this.UEGraph.drawString("Item", 375, 14);
        this.UEGraph.drawString("Held:", 375, 30);
        this.pdHeld.reset(this.euUnit);
        this.UEGraph.drawString("Team:", 5, 65);
        this.cTeams.select(this.euUnit.TeamNumber);
        this.UEGraph.drawString("Strength:", 5, 90);
        this.tfStrength.setText(Integer.toString(this.euUnit.Strength));
        this.UEGraph.drawString("Agility:", 5, 110);
        this.tfAgility.setText(Integer.toString(this.euUnit.Agility));
        this.UEGraph.drawString("Size:", 5, 130);
        this.tfSize.setText(Integer.toString(this.euUnit.Size));
        this.UEGraph.drawString("Fatigue:", 5, 150);
        this.tfFatigue.setText(Integer.toString(this.euUnit.Fatigue));
        this.UEGraph.drawString("Weapon Skill:", 160, 90);
        this.tfWeaponSkill.setText(Integer.toString(this.euUnit.WeaponSkill));
        this.UEGraph.drawString("Hand Damage:", 160, 110);
        this.tfCloseCombatDamage.setText(Integer.toString(this.euUnit.CloseCombatDamage));
        this.UEGraph.drawString("Toughness:", 160, 130);
        this.tfToughness.setText(Integer.toString(this.euUnit.Toughness));
        this.UEGraph.drawString("Max Carry:", 160, 150);
        this.tfMaxSizeCanCarry.setText(Integer.toString(this.euUnit.MaxSizeCanCarry));
        this.UEGraph.drawString("Max:", 495, 70);
        this.UEGraph.drawString("Cur:", 548, 70);
        this.UEGraph.drawString("Action Points:", 355, 90);
        this.tfMAP.setText(Integer.toString(this.euUnit.MaxActionPoints));
        this.UEGraph.drawString("Constitution:", 355, 110);
        this.tfMCon.setText(Integer.toString(this.euUnit.MaxConstitution));
        this.tfCCon.setText(Integer.toString(this.euUnit.CurrentConstitution));
        this.UEGraph.drawString("Stamina:", 355, 130);
        this.tfMStam.setText(Integer.toString(this.euUnit.MaxStamina));
        this.tfCStam.setText(Integer.toString(this.euUnit.CurrentStamina));
        this.UEGraph.drawString("Morrale:", 355, 150);
        this.tfMMor.setText(Integer.toString(this.euUnit.MaxMorrale));
        this.tfCMor.setText(Integer.toString(this.euUnit.CurrentMorrale));
        this.UEGraph.drawString("Terrain Band:", 345, 175);
        this.cTerrainBand.select(this.euUnit.TerrainMovementBand);
        this.UEGraph.drawString("Start Round:", 345, 200);
        this.tfStartRound.setText(Integer.toString(this.euUnit.StartRound));
        this.cbCanEquip.setState((this.euUnit.Flags & 1) == 1);
        this.cbManualDeploy.setState((this.euUnit.Flags & 0x80) == 128);
        this.cbCantPickUpDrop.setState((this.euUnit.Flags & 2) == 2);
        this.cbItemsLostWithUnit.setState((this.euUnit.Flags & 8) == 8);
        this.cbCantPickUpDropChange.setState((this.euUnit.Flags & 4) == 4);
        this.cbImmuneToMorrale.setState((this.euUnit.Flags & 0x10) == 16);
        this.yPos = 264;
        this.UEGraph.drawString("Team:", 5, this.yPos + 16);
        this.xPos = 5;
        for (n = 0; n < this.lsse.Teams.length; ++n) {
            if (this.lsse.Teams[n].name.length() > this.xPos) {
                this.xPos = this.lsse.Teams[n].name.length();
            }
            this.UEGraph.drawString(this.lsse.Teams[n].name, 5, this.yPos + 32 + n * 20);
        }
        ++this.xPos;
        this.xPos *= 11;
        this.UEGraph.drawString("Victory", this.xPos, this.yPos);
        this.UEGraph.drawString("Points:", this.xPos, this.yPos + 16);
        this.UEGraph.drawString("Morale", this.xPos + 88, this.yPos);
        this.UEGraph.drawString("Value:", this.xPos + 88, this.yPos + 16);
        for (n = 0; n < this.lsse.Teams.length; ++n) {
            this.tfVP[n].setText(Integer.toString(this.euUnit.VictoryPoint[n]));
            this.tfM[n].setText(Integer.toString(this.euUnit.MorraleValue[n]));
        }
        this.UEGraph.drawString("Armour:", 355, 264);
        this.UEGraph.drawString("Front", 430, 264);
        this.tfAFront.setText(Integer.toString(this.euUnit.ArmourFront));
        this.UEGraph.drawString("Left", 355, 280);
        this.tfALeft.setText(Integer.toString(this.euUnit.ArmourLeft));
        this.UEGraph.drawString("Right", 505, 280);
        this.tfARight.setText(Integer.toString(this.euUnit.ArmourRight));
        this.UEGraph.drawString("Rear", 430, 296);
        this.tfARear.setText(Integer.toString(this.euUnit.ArmourRear));
        this.UEGraph.drawString("Weight", 355, 312);
        this.tfAWeight.setText(Integer.toString(this.euUnit.ArmourWeight));
        this.cbThreatArmour.setState((this.euUnit.Flags & 0x20) == 32);
        this.cbThreatIgnoreItems.setState((this.euUnit.Flags & 0x40) == 64);
        this.cbDontReseveAPs.setState((this.euUnit.Flags & 0x100) == 256);
        this.cbAlwaysReserveAPs.setState((this.euUnit.Flags & 0x200) == 512);
        this.cbMoveSafely.setState((this.euUnit.Flags & 0x400) == 1024);
        this.cbPatrolsRatherThanThreats.setState((this.euUnit.Flags & 0x800) == 2048);
        this.cbAttackVisible.setState((this.euUnit.Flags & 0x1000) == 4096);
        this.cbAutoWeaponReload.setState((this.euUnit.Flags & 0x2000) == 8192);
        this.cbAttackTerrain.setState((this.euUnit.Flags & 0x4000) == 16384);
        this.cbThreatIgnoreRegion.setState((this.euUnit.Flags & 0x8000) == 32768);
        this.cbIgnoreZeroThreat.setState((this.euUnit.Flags & 0x10000) == 65536);
        n *= 20;
        this.UEGraph.drawString("Value:", 490, n += 79 + this.yPos + 14);
        this.UEGraph.drawString("Min Aimed Range:", 350, n + 25);
        this.tfMinAimed.setText(Integer.toString(this.euUnit.MinAimedRange));
        this.UEGraph.drawString("Min Snap Range:", 350, n + 45);
        this.tfMinSnap.setText(Integer.toString(this.euUnit.MinSnapRange));
        this.cRegions.setEnabled(this.euUnit.RegionThreatValue != null);
        this.tfRegions.setEnabled(this.euUnit.RegionThreatValue != null);
        if (this.euUnit.RegionThreatValue != null) {
            this.tfRegions.setText(Integer.toString(this.euUnit.RegionThreatValue[this.cRegions.getSelectedIndex()]));
        }
    }

    protected CauseAndEffect GetCAE() {
        return this.euUnit.DeathEffects;
    }

    protected void SetDeathEffects(CauseAndEffect causeAndEffect) {
        this.euUnit.DeathEffects = causeAndEffect;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butLevels) {
            new PullDownCheckBoxList(this.lsse, this, 0, this.euUnit, this.UEGraph.getFontMetrics());
            return;
        }
        if (actionEvent.getSource() == this.butFlags) {
            new PullDownCheckBoxList(this.lsse, this, 1, this.euUnit, this.UEGraph.getFontMetrics());
            return;
        }
        if (actionEvent.getSource() == this.butEditEquipment) {
            new UnitItemEditor(this.lsse, this, this.euUnit);
            return;
        }
        if (actionEvent.getSource() == this.butAutoDeploy) {
            new AutoDeployDialog(this.lsse, this, new Rectangle(this.euUnit.StartX, this.euUnit.StartY, this.euUnit.StartDX, this.euUnit.StartDY));
            return;
        }
        if (actionEvent.getSource() == this.butSetMax) {
            this.euUnit.CurrentConstitution = this.euUnit.MaxConstitution;
            this.euUnit.CurrentStamina = this.euUnit.MaxStamina;
            this.euUnit.CurrentMorrale = this.euUnit.MaxMorrale;
            this.tfCCon.setText(this.tfMCon.getText());
            this.tfCStam.setText(this.tfMStam.getText());
            this.tfCMor.setText(this.tfMMor.getText());
            return;
        }
        if (actionEvent.getSource() == this.butDeathEffects) {
            new CauseAndEffectWindow(this.lsse, this, "Unit Death effects", 1, 0);
            return;
        }
        if (actionEvent.getSource() == this.butTargetTerrains) {
            new TargetTerrainDialog(this.lsse, this);
        }
        if (actionEvent.getSource() == this.butPatrol) {
            new UnitPatrolDialog(this.lsse, this);
        }
    }

    protected void SetAutoDeploy(Rectangle rectangle) {
        this.euUnit.StartX = rectangle.x;
        this.euUnit.StartY = rectangle.y;
        this.euUnit.StartDX = rectangle.width;
        this.euUnit.StartDY = rectangle.height;
    }

    protected void HeldItemChangeNotify(int n) {
        block5: {
            block4: {
                if (n == -1) {
                    this.euUnit.ItemHeld = null;
                }
                if (!this.parent.getClass().getName().equals("CAEUnitEditorWindow")) break block4;
                if (this.euUnit.ItemsHeld == null) break block5;
                for (int i = 0; i < this.euUnit.ItemsHeld.length; ++i) {
                    if (n != this.euUnit.ItemsHeld[i].GenericItemNumber) continue;
                    this.euUnit.ItemHeld = this.euUnit.ItemsHeld[i];
                    return;
                }
                break block5;
            }
            if (this.lsse.Items == null) {
                return;
            }
            for (int i = 0; i < this.lsse.Items.length; ++i) {
                if (this.lsse.Items[i].Owner != this.euUnit || n != this.lsse.Items[i].GenericItemNumber) continue;
                this.euUnit.ItemHeld = this.lsse.Items[i];
                return;
            }
        }
    }

    protected void NotifyItemChange(EditorItem[] editorItemArray) {
        int n;
        if (this.parent.getClass().getName().equals("CAEUnitEditorWindow")) {
            this.euUnit.ItemsHeld = editorItemArray;
            if (editorItemArray != null && this.euUnit.ItemHeld != null) {
                for (n = 0; n < editorItemArray.length && this.euUnit.ItemHeld.GenericItemNumber != editorItemArray[n].GenericItemNumber; ++n) {
                }
                this.euUnit.ItemHeld = null;
                if (n != editorItemArray.length) {
                    this.euUnit.ItemHeld = editorItemArray[n];
                }
            } else {
                this.euUnit.ItemHeld = null;
            }
        } else {
            int n2;
            int n3 = n2 = this.lsse.Items == null ? 0 : this.lsse.Items.length;
            if (n2 > 0) {
                while (n < this.lsse.Items.length) {
                    if (this.lsse.Items[n].Owner == this.euUnit) {
                        --n2;
                    }
                    ++n;
                }
            }
            if ((n2 += editorItemArray == null ? 0 : editorItemArray.length) == 0) {
                this.lsse.Items = null;
            } else {
                EditorItem[] editorItemArray2 = new EditorItem[n2];
                n2 = 0;
                if (this.lsse.Items != null) {
                    for (n = 0; n < this.lsse.Items.length; ++n) {
                        if (this.lsse.Items[n].Owner == this.euUnit) continue;
                        editorItemArray2[n2++] = this.lsse.Items[n];
                    }
                }
                if (editorItemArray != null) {
                    System.arraycopy(editorItemArray, 0, editorItemArray2, n2, editorItemArray.length);
                }
                this.lsse.Items = editorItemArray2;
            }
            if (this.lsse.Items != null && this.euUnit.ItemHeld != null) {
                for (n = 0; n < this.lsse.Items.length && (this.lsse.Items[n].Owner != this.euUnit || this.euUnit.ItemHeld.GenericItemNumber != this.lsse.Items[n].GenericItemNumber); ++n) {
                }
            }
            if (this.lsse.Items == null || n == this.lsse.Items.length) {
                this.euUnit.ItemHeld = null;
            }
        }
        this.RepaintOffScreenImage();
        this.repaint();
    }

    protected void NotifyUnitTypeChange(int n) {
        this.euUnit.UnitType = n;
        if (this.parent.getClass().getName().equals("UnitEditor")) {
            ((UnitEditor)this.parent).UpdateUnitSelector();
        }
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.cTeams && itemEvent.getStateChange() == 1) {
            this.euUnit.TeamNumber = this.cTeams.getSelectedIndex();
            return;
        }
        if (itemEvent.getSource() == this.cTerrainBand && itemEvent.getStateChange() == 1) {
            this.euUnit.TerrainMovementBand = this.cTerrainBand.getSelectedIndex();
        }
        if (itemEvent.getID() != 701) {
            return;
        }
        if (itemEvent.getSource() == this.cbCanEquip) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 1) : (this.euUnit.Flags &= 0xFFFFE);
            return;
        }
        if (itemEvent.getSource() == this.cbItemsLostWithUnit) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 8) : (this.euUnit.Flags &= 0xFFFF7);
            return;
        }
        if (itemEvent.getSource() == this.cbImmuneToMorrale) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x10) : (this.euUnit.Flags &= 0xFFFEF);
            return;
        }
        if (itemEvent.getSource() == this.cbManualDeploy) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x80) : (this.euUnit.Flags &= 0xFFF7F);
            return;
        }
        if (itemEvent.getSource() == this.cbCantPickUpDrop) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 2) : (this.euUnit.Flags &= 0xFFFFD);
            return;
        }
        if (itemEvent.getSource() == this.cbCantPickUpDropChange) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 4) : (this.euUnit.Flags &= 0xFFFFB);
            return;
        }
        if (itemEvent.getSource() == this.cbThreatArmour) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x20) : (this.euUnit.Flags &= 0xFFFDF);
            return;
        }
        if (itemEvent.getSource() == this.cbThreatIgnoreItems) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x40) : (this.euUnit.Flags &= 0xFFFBF);
            return;
        }
        if (itemEvent.getSource() == this.cbDontReseveAPs) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x100) : (this.euUnit.Flags &= 0xFFEFF);
            return;
        }
        if (itemEvent.getSource() == this.cbAlwaysReserveAPs) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x200) : (this.euUnit.Flags &= 0xFFDFF);
            return;
        }
        if (itemEvent.getSource() == this.cbMoveSafely) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x400) : (this.euUnit.Flags &= 0xFFBFF);
            return;
        }
        if (itemEvent.getSource() == this.cbPatrolsRatherThanThreats) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x800) : (this.euUnit.Flags &= 0xFF7FF);
            return;
        }
        if (itemEvent.getSource() == this.cbAttackVisible) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x1000) : (this.euUnit.Flags &= 0xFEFFF);
            return;
        }
        if (itemEvent.getSource() == this.cbAutoWeaponReload) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x2000) : (this.euUnit.Flags &= 0xFDFFF);
            return;
        }
        if (itemEvent.getSource() == this.cbAttackTerrain) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x4000) : (this.euUnit.Flags &= 0xFBFFF);
            return;
        }
        if (itemEvent.getSource() == this.cbThreatIgnoreRegion) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x8000) : (this.euUnit.Flags &= 0xF7FFF);
            return;
        }
        if (itemEvent.getSource() == this.cbIgnoreZeroThreat) {
            this.euUnit.Flags = itemEvent.getStateChange() == 1 ? (this.euUnit.Flags |= 0x10000) : (this.euUnit.Flags &= 0xEFFFF);
            return;
        }
        if (itemEvent.getSource() == this.cRegions && itemEvent.getStateChange() == 1) {
            int n = this.euUnit.RegionThreatValue == null ? 0 : this.euUnit.RegionThreatValue[this.cRegions.getSelectedIndex()];
            this.tfRegions.setText(Integer.toString(n));
            return;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!Character.isDigit(c) && c != '\b' && c != '-') {
            keyEvent.consume();
        }
        if (c == '-') {
            int n;
            for (n = 0; n < this.lsse.Teams.length && this.tfM[n] != keyEvent.getSource(); ++n) {
            }
            if (n == this.lsse.Teams.length) {
                keyEvent.consume();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void textValueChanged(TextEvent textEvent) {
        int n;
        int n2 = 0;
        if (textEvent.getID() != 900) {
            return;
        }
        if (textEvent.getSource() == this.uName) {
            n2 = this.uName.getCaretPosition();
            StringBuffer stringBuffer = new StringBuffer(this.uName.getText().toUpperCase());
            if (stringBuffer.indexOf("\r\n") > 8 || stringBuffer.indexOf("\r\n") == -1 && stringBuffer.length() > 8) {
                stringBuffer.insert(8, "\r\n");
                if (n2 > stringBuffer.indexOf("\r\n")) {
                    n2 += 2;
                }
            }
            if (stringBuffer.indexOf("\r\n") != -1) {
                stringBuffer.replace(stringBuffer.indexOf("\r\n"), stringBuffer.indexOf("\r\n") + 2, "//");
            }
            if (!stringBuffer.toString().equals(this.euUnit.name)) {
                while (stringBuffer.indexOf("\r\n") != -1) {
                    stringBuffer.delete(stringBuffer.indexOf("\r\n"), stringBuffer.indexOf("\r\n") + 2);
                }
                if (stringBuffer.indexOf("//") != -1 && stringBuffer.length() > stringBuffer.indexOf("//") + 10) {
                    stringBuffer.setLength(stringBuffer.indexOf("//") + 10);
                }
                if (n2 > stringBuffer.indexOf("//") && stringBuffer.indexOf("//") != -1) {
                    --n2;
                }
                this.euUnit.name = stringBuffer.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(this.euUnit.name, "//", false);
                String string = new String((stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "") + (stringBuffer.indexOf("//") != -1 ? "\r\n" : "") + (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : ""));
                this.uName.setText(string);
                if (this.parent.getClass().getName().equals("UnitEditor")) {
                    ((UnitEditor)this.parent).UpdateUnitSelector();
                }
                this.uName.setCaretPosition(n2);
            }
            return;
        }
        if (textEvent.getSource() == this.tfStrength) {
            try {
                n2 = Integer.parseInt(this.tfStrength.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.Strength = n2;
            return;
        }
        if (textEvent.getSource() == this.tfAgility) {
            try {
                n2 = Integer.parseInt(this.tfAgility.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.Agility = n2;
            return;
        }
        if (textEvent.getSource() == this.tfWeaponSkill) {
            try {
                n2 = Integer.parseInt(this.tfWeaponSkill.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.WeaponSkill = n2;
            return;
        }
        if (textEvent.getSource() == this.tfCloseCombatDamage) {
            try {
                n2 = Integer.parseInt(this.tfCloseCombatDamage.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.CloseCombatDamage = n2;
            return;
        }
        if (textEvent.getSource() == this.tfToughness) {
            try {
                n2 = Integer.parseInt(this.tfToughness.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.Toughness = n2;
            return;
        }
        if (textEvent.getSource() == this.tfSize) {
            try {
                n2 = Integer.parseInt(this.tfSize.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.Size = n2;
            return;
        }
        if (textEvent.getSource() == this.tfMaxSizeCanCarry) {
            try {
                n2 = Integer.parseInt(this.tfMaxSizeCanCarry.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.MaxSizeCanCarry = n2;
            return;
        }
        if (textEvent.getSource() == this.tfFatigue) {
            try {
                n2 = Integer.parseInt(this.tfFatigue.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.Fatigue = n2;
            return;
        }
        if (textEvent.getSource() == this.tfMAP) {
            try {
                n2 = Integer.parseInt(this.tfMAP.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.MaxActionPoints = n2;
            return;
        }
        if (textEvent.getSource() == this.tfCCon) {
            try {
                n2 = Integer.parseInt(this.tfCCon.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.CurrentConstitution = n2;
            return;
        }
        if (textEvent.getSource() == this.tfMCon) {
            try {
                n2 = Integer.parseInt(this.tfMCon.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.MaxConstitution = n2;
            return;
        }
        if (textEvent.getSource() == this.tfCStam) {
            try {
                n2 = Integer.parseInt(this.tfCStam.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.CurrentStamina = n2;
            return;
        }
        if (textEvent.getSource() == this.tfMStam) {
            try {
                n2 = Integer.parseInt(this.tfMStam.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.MaxStamina = n2;
            return;
        }
        if (textEvent.getSource() == this.tfCMor) {
            try {
                n2 = Integer.parseInt(this.tfCMor.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.CurrentMorrale = n2;
            return;
        }
        if (textEvent.getSource() == this.tfMMor) {
            try {
                n2 = Integer.parseInt(this.tfMMor.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.MaxMorrale = n2;
            return;
        }
        if (textEvent.getSource() == this.tfStartRound) {
            try {
                n2 = Integer.parseInt(this.tfStartRound.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.StartRound = n2;
            return;
        }
        if (textEvent.getSource() == this.tfAFront) {
            try {
                n2 = Integer.parseInt(this.tfAFront.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.ArmourFront = n2;
            return;
        }
        if (textEvent.getSource() == this.tfALeft) {
            try {
                n2 = Integer.parseInt(this.tfALeft.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.ArmourLeft = n2;
            return;
        }
        if (textEvent.getSource() == this.tfARight) {
            try {
                n2 = Integer.parseInt(this.tfARight.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.ArmourRight = n2;
            return;
        }
        if (textEvent.getSource() == this.tfARear) {
            try {
                n2 = Integer.parseInt(this.tfARear.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.ArmourRear = n2;
            return;
        }
        if (textEvent.getSource() == this.tfAWeight) {
            try {
                n2 = Integer.parseInt(this.tfAWeight.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.ArmourWeight = n2;
            return;
        }
        if (textEvent.getSource() == this.tfRegions && this.euUnit.RegionThreatValue != null) {
            try {
                n2 = Integer.parseInt(this.tfRegions.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.RegionThreatValue[this.cRegions.getSelectedIndex()] = n2;
            return;
        }
        if (textEvent.getSource() == this.tfMinAimed) {
            try {
                n2 = Integer.parseInt(this.tfMinAimed.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.MinAimedRange = n2;
            return;
        }
        if (textEvent.getSource() == this.tfMinSnap) {
            try {
                n2 = Integer.parseInt(this.tfMinSnap.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.MinSnapRange = n2;
            return;
        }
        for (n = 0; n < this.lsse.Teams.length; ++n) {
            if (this.tfM[n] != textEvent.getSource()) continue;
            try {
                n2 = Integer.parseInt(this.tfM[n].getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 2047) {
                n2 = 2047;
            }
            this.euUnit.MorraleValue[n] = n2;
            return;
        }
        for (n = 0; n < this.lsse.Teams.length; ++n) {
            if (this.tfVP[n] != textEvent.getSource()) continue;
            try {
                n2 = Integer.parseInt(this.tfVP[n].getText());
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 > 4094 || n2 < 0) {
                n2 = 0;
            }
            this.euUnit.VictoryPoint[n] = n2;
            return;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        this.UEGraph.setColor(new Color(240, 240, 240));
        this.UEGraph.drawLine(0, 0, 0, 1);
        graphics.drawImage(this.UEImage, 0, 0, null);
        if (this.euUnit == null) {
            return;
        }
        this.uName.setBounds(60, 1, 90, 41);
        this.pdHeld.setBounds(425, 0, 182, 34);
        this.butEditEquipment.setBounds(455, 34, 150, 25);
        this.cTeams.setLocation(55, 50);
        this.butDeathEffects.setBounds(260, 47, 80, 25);
        this.butAutoDeploy.setBounds(350, 47, 100, 25);
        this.tfStrength.setBounds(95, 77, 48, 20);
        this.tfAgility.setBounds(95, 97, 48, 20);
        this.tfSize.setBounds(95, 117, 48, 20);
        this.tfFatigue.setBounds(95, 137, 48, 20);
        this.tfWeaponSkill.setBounds(290, 77, 48, 20);
        this.tfCloseCombatDamage.setBounds(290, 97, 48, 20);
        this.tfToughness.setBounds(290, 117, 48, 20);
        this.tfMaxSizeCanCarry.setBounds(290, 137, 48, 20);
        this.tfMAP.setBounds(495, 77, 48, 20);
        this.tfMCon.setBounds(495, 97, 48, 20);
        this.tfCCon.setBounds(548, 97, 48, 20);
        this.tfMStam.setBounds(495, 117, 48, 20);
        this.tfCStam.setBounds(548, 117, 48, 20);
        this.tfMMor.setBounds(495, 137, 48, 20);
        this.tfCMor.setBounds(548, 137, 48, 20);
        this.butLevels.setBounds(5, 157, 150, 22);
        this.cTerrainBand.setLocation(475, 157);
        this.butSetMax.setBounds(540, 157, 65, 25);
        this.butFlags.setBounds(5, 183, 150, 22);
        this.tfStartRound.setBounds(475, 187, 48, 20);
        this.cbCanEquip.setLocation(5, 205);
        this.cbManualDeploy.setLocation(5, 225);
        this.cbCantPickUpDrop.setLocation(180, 205);
        this.cbItemsLostWithUnit.setLocation(180, 225);
        this.cbCantPickUpDropChange.setLocation(410, 205);
        this.cbImmuneToMorrale.setLocation(410, 225);
        for (n = 0; n < this.lsse.Teams.length; ++n) {
            this.tfVP[n].setBounds(this.xPos, this.yPos + 19 + n * 20, 45, 20);
            this.tfM[n].setBounds(this.xPos + 88, this.yPos + 19 + n * 20, 45, 20);
        }
        this.tfAFront.setBounds(480, 251, 48, 20);
        this.tfALeft.setBounds(395, 267, 48, 20);
        this.tfARight.setBounds(555, 267, 48, 20);
        this.tfARear.setBounds(470, 283, 48, 20);
        this.tfAWeight.setBounds(415, 299, 48, 20);
        n *= 20;
        this.butTargetTerrains.setBounds(350, n += 19 + this.yPos, 200, 25);
        this.butPatrol.setBounds(350, n + 30, 200, 25);
        this.cRegions.setLocation(350, n + 60);
        this.tfRegions.setBounds(550, n + 60, 50, 20);
        this.tfMinAimed.setBounds(510, n + 85, 50, 20);
        this.tfMinSnap.setBounds(510, n + 105, 50, 20);
        this.cbThreatArmour.setLocation(5, n);
        this.cbThreatIgnoreItems.setLocation(5, n += 20);
        this.cbDontReseveAPs.setLocation(5, n += 20);
        this.cbAlwaysReserveAPs.setLocation(5, n += 20);
        this.cbMoveSafely.setLocation(5, n += 20);
        this.cbPatrolsRatherThanThreats.setLocation(5, n += 20);
        this.cbAttackVisible.setLocation(5, n += 20);
        this.cbAutoWeaponReload.setLocation(5, n += 20);
        this.cbAttackTerrain.setLocation(5, n += 20);
        this.cbThreatIgnoreRegion.setLocation(5, n += 20);
        this.cbIgnoreZeroThreat.setLocation(5, n += 20);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.euUnit == null) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n >= 230 && n < 380 && n2 >= 0 && n2 < 33) {
            new UnitSelectorWindow(this.lsse, this, 0, "Select Unit Type", this.euUnit.UnitType);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

