/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

class UnitItemEditor
extends Dialog
implements ActionListener,
WindowListener {
    private LaserSquadScenarioEditor lsse;
    private Panel holder;
    private ItemSelector is;
    private ItemEditorPanel iep;
    private EditorUnit euUnit;
    protected EditorItem[] eiItems = null;
    private Button butOK;
    private Button butCancel;
    private Button butAdd;
    private Button butRemove;

    public UnitItemEditor(LaserSquadScenarioEditor laserSquadScenarioEditor, Panel panel, EditorUnit editorUnit) {
        super(laserSquadScenarioEditor, "Edit Unit's Items", true);
        int n;
        this.setBounds(laserSquadScenarioEditor.getInsets().left + laserSquadScenarioEditor.getX(), laserSquadScenarioEditor.getInsets().top + laserSquadScenarioEditor.getY(), 342 + this.getInsets().left + this.getInsets().right, 272 + this.getInsets().top + this.getInsets().bottom);
        this.lsse = laserSquadScenarioEditor;
        this.holder = panel;
        this.euUnit = editorUnit;
        Vector<EditorItem> vector = new Vector<EditorItem>();
        if (editorUnit.ItemsHeld != null) {
            for (n = 0; n < editorUnit.ItemsHeld.length; ++n) {
                vector.add(new EditorItem(editorUnit.ItemsHeld[n]));
            }
        }
        if (laserSquadScenarioEditor.Items != null) {
            for (n = 0; n < laserSquadScenarioEditor.Items.length; ++n) {
                if (laserSquadScenarioEditor.Items[n].Owner != editorUnit) continue;
                vector.add(new EditorItem(laserSquadScenarioEditor.Items[n]));
            }
        }
        if (vector.size() > 0) {
            this.eiItems = new EditorItem[vector.size()];
            for (n = 0; n < this.eiItems.length; ++n) {
                this.eiItems[n] = (EditorItem)vector.elementAt(n);
            }
        }
        this.setResizable(false);
        this.addWindowListener(this);
        this.is = new ItemSelector(laserSquadScenarioEditor, this, 0, 5);
        this.add(this.is);
        this.butOK = new Button("Ok");
        this.butOK.addActionListener(this);
        this.add(this.butOK);
        this.butCancel = new Button("Cancel");
        this.butCancel.addActionListener(this);
        this.add(this.butCancel);
        this.butAdd = new Button("Add Item");
        this.butAdd.addActionListener(this);
        this.add(this.butAdd);
        this.butRemove = new Button("Remove");
        this.butRemove.addActionListener(this);
        this.add(this.butRemove);
        this.iep = new ItemEditorPanel(laserSquadScenarioEditor, this, this.eiItems == null ? null : this.eiItems[0]);
        this.add(this.iep);
        this.show();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = this.getInsets().left;
        int n2 = this.getInsets().top;
        int n3 = this.getSize().height - n2 - this.getInsets().bottom;
        int n4 = this.getSize().width - n - this.getInsets().right;
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(n, n2, n4, n3);
        this.is.setBounds(n + n4 - 174, n2, 174, n3 - n3 % 34);
        this.iep.setBounds(n, n2, n4 - 174, 70);
        this.butAdd.setBounds(n + 5, n2 + n3 - 140, 80, 30);
        this.butRemove.setBounds(n + 5, n2 + n3 - 105, 80, 30);
        this.butOK.setBounds(n + 5, n2 + n3 - 70, 80, 30);
        this.butCancel.setBounds(n + 5, n2 + n3 - 35, 80, 30);
    }

    protected void ItemSelectorNotifyingChange() {
        this.iep.ChangeItem(this.eiItems == null ? null : this.eiItems[this.is.GetPointer()]);
        this.iep.RepaintOffScreenImage();
        this.iep.repaint();
    }

    protected void ItemEditorPanelNotifyingChange() {
        this.is.RecheckPointer();
        this.is.RepaintOffScreenImage();
        this.is.repaint();
    }

    protected void NotifyNewItem(int n) {
        EditorItem editorItem = new EditorItem();
        editorItem.GenericItemNumber = n;
        editorItem.Position = new Point(-1, -1);
        editorItem.bHidden = false;
        editorItem.Owner = this.euUnit;
        editorItem.AmmoLeftOrPrime = 0;
        editorItem.TerrainUnder = 65535;
        if (this.eiItems == null) {
            this.eiItems = new EditorItem[1];
            this.eiItems[0] = editorItem;
        } else {
            EditorItem[] editorItemArray = new EditorItem[this.eiItems.length + 1];
            System.arraycopy(this.eiItems, 0, editorItemArray, 0, this.eiItems.length);
            editorItemArray[this.eiItems.length] = editorItem;
            this.eiItems = editorItemArray;
        }
        this.ItemEditorPanelNotifyingChange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("Ok")) {
            ((UnitEditorPanel)this.holder).NotifyItemChange(this.eiItems);
            this.hide();
            this.dispose();
            return;
        }
        if (actionEvent.getActionCommand().equals("Add Item")) {
            new ItemSelectorWindow(this.lsse, this, 5, "Select new Item", 0);
        }
        if (actionEvent.getActionCommand().equals("Remove") && this.eiItems != null) {
            if (this.eiItems.length == 1) {
                this.eiItems = null;
            } else {
                EditorItem[] editorItemArray = new EditorItem[this.eiItems.length - 1];
                int n = this.is.GetPointer();
                if (n != 0) {
                    System.arraycopy(this.eiItems, 0, editorItemArray, 0, n);
                }
                if (n != this.eiItems.length - 1) {
                    System.arraycopy(this.eiItems, n + 1, editorItemArray, n, this.eiItems.length - n - 1);
                }
                this.eiItems = editorItemArray;
            }
            this.ItemEditorPanelNotifyingChange();
            this.ItemSelectorNotifyingChange();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.hide();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

