/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class UnitPatrolPanel
extends Panel
implements AdjustmentListener,
MouseListener,
ActionListener,
Runnable {
    private LaserSquadScenarioEditor lsse;
    private TerrainDisplay td;
    private UnitPatrolDialog parent;
    private Image UPPImage = null;
    private Graphics UPPGraph;
    private int UPPWidth = -1;
    private int UPPHeight = -1;
    private int pointer = -1;
    private int iNodes;
    private int iStartNode;
    private Scrollbar sb;
    private int[] Nodes;
    private Button butAdd;
    private Button butRemove;
    private Button butSet;

    public UnitPatrolPanel(LaserSquadScenarioEditor laserSquadScenarioEditor, UnitPatrolDialog unitPatrolDialog, EditorUnit editorUnit) {
        this.lsse = laserSquadScenarioEditor;
        this.parent = unitPatrolDialog;
        this.td = new TerrainDisplay(laserSquadScenarioEditor, this);
        this.add(this.td);
        this.iNodes = editorUnit.PatrolNodes == null ? 0 : editorUnit.PatrolNodes.length;
        this.Nodes = new int[this.iNodes];
        if (this.iNodes != 0) {
            System.arraycopy(editorUnit.PatrolNodes, 0, this.Nodes, 0, this.iNodes);
            this.iStartNode = editorUnit.InitialPatrolNode;
            this.td.SetHighlightPoint(this.Nodes[0]);
            this.pointer = 0;
        } else {
            this.td.SetHighlightPoint(-1);
        }
        this.sb = new Scrollbar(1, 0, 1, 0, this.iNodes);
        this.sb.addAdjustmentListener(this);
        this.add(this.sb);
        this.butAdd = new Button("Add");
        this.butAdd.addActionListener(this);
        this.add(this.butAdd);
        this.butRemove = new Button("Remove");
        this.butRemove.addActionListener(this);
        this.add(this.butRemove);
        this.butSet = new Button("Set First");
        this.butSet.addActionListener(this);
        this.add(this.butSet);
        this.addMouseListener(this);
        if (this.iNodes != 0) {
            new Thread(this).start();
        }
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.iNodes != 0) {
            this.td.CenterOn(new Point(this.lsse.Nodes[this.Nodes[0]]));
        }
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.UPPWidth || n4 != this.UPPHeight) {
            this.UPPWidth = n3;
            this.UPPHeight = n4;
            this.UPPImage = this.createImage(100, n4 - 65);
            this.UPPGraph = this.UPPImage == null ? null : this.UPPImage.getGraphics();
            this.RepaintOffScreenImage();
            this.repaint();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        if (this.UPPGraph == null) {
            return;
        }
        int n = this.UPPHeight - 65;
        this.UPPGraph.setColor(Color.WHITE);
        this.UPPGraph.fillRect(0, 0, 100, n);
        this.UPPGraph.setColor(Color.BLACK);
        this.UPPGraph.setFont(LaserSquadScenarioEditor.font);
        FontMetrics fontMetrics = this.UPPGraph.getFontMetrics();
        this.sb.setVisibleAmount(n /= 34);
        if (this.sb.getMaximum() != this.iNodes) {
            this.sb.setMaximum(this.iNodes);
        }
        int n2 = (32 - fontMetrics.getHeight()) / 2 + fontMetrics.getLeading() + fontMetrics.getAscent();
        int n3 = this.sb.getValue();
        if (n3 != -1) {
            int n4 = 0;
            int n5 = 0;
            while (n4 < n && n3 < this.iNodes) {
                this.UPPGraph.drawString(Integer.toString(n3), 1, n5 + n2);
                this.UPPGraph.setColor(n3 == this.iStartNode ? Color.RED : Color.GREEN);
                this.UPPGraph.fillOval(40, n5, 32, 32);
                this.UPPGraph.setColor(n3 == this.iStartNode ? new Color(128, 0, 0) : new Color(0, 128, 0));
                this.UPPGraph.drawOval(40, n5, 32, 32);
                this.UPPGraph.setColor(Color.BLACK);
                String string = Integer.toString(this.Nodes[n3]);
                this.UPPGraph.drawString(string, 40 + (32 - fontMetrics.stringWidth(string)) / 2, n5 + n2);
                if (n3 == this.pointer) {
                    this.UPPGraph.setColor(Color.RED);
                    this.UPPGraph.drawRect(0, n4 * 34, 99, 33);
                    this.UPPGraph.setColor(Color.BLACK);
                }
                ++n4;
                ++n3;
                n5 += 34;
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.UPPGraph.setColor(Color.WHITE);
        this.UPPGraph.drawLine(1, 1, 1, 2);
        if (this.UPPImage != null) {
            graphics.drawImage(this.UPPImage, this.UPPWidth - 117, 0, null);
        }
        this.sb.setBounds(this.UPPWidth - 16, 0, 16, this.UPPHeight - 65);
        this.td.setBounds(0, 0, this.UPPWidth - 118, this.UPPHeight);
        this.butAdd.setBounds(this.UPPWidth - 117, this.UPPHeight - 60, 40, 25);
        this.butRemove.setBounds(this.UPPWidth - 70, this.UPPHeight - 60, 60, 25);
        this.butSet.setBounds(this.UPPWidth - 117, this.UPPHeight - 30, 100, 25);
    }

    protected void SetUnitPatrolRoute(EditorUnit editorUnit) {
        if (this.iNodes == 0) {
            editorUnit.InitialPatrolNode = 0;
            editorUnit.PatrolNodes = null;
            return;
        }
        editorUnit.PatrolNodes = new int[this.iNodes];
        System.arraycopy(this.Nodes, 0, editorUnit.PatrolNodes, 0, this.iNodes);
        editorUnit.InitialPatrolNode = this.iStartNode;
    }

    protected void NotifyClick(Point point) {
        int n;
        if (this.lsse.Nodes == null && this.Nodes != null) {
            return;
        }
        for (n = 0; n < this.lsse.Nodes.length && !this.lsse.Nodes[n].equals(point); ++n) {
        }
        if (n == this.lsse.Nodes.length) {
            return;
        }
        this.Nodes[this.pointer] = n;
        this.td.SetHighlightPoint(n);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butAdd && this.lsse.Nodes != null) {
            this.Nodes = ScenarioEditorUtility.arrayAdd(this.Nodes, 0);
            ++this.iNodes;
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butRemove && this.iNodes != 0) {
            this.Nodes = ScenarioEditorUtility.arrayDeleteElementAt(this.Nodes, this.pointer);
            --this.iNodes;
            if (this.pointer == this.iNodes) {
                --this.pointer;
            }
            if (this.iNodes == 0) {
                this.td.SetHighlightPoint(-1);
            } else {
                this.td.SetHighlightPoint(this.Nodes[this.pointer]);
                this.td.CenterOn(this.lsse.Nodes[this.Nodes[this.pointer]]);
            }
            this.td.RepaintOffScreenImage();
            this.td.repaint();
            this.RepaintOffScreenImage();
            this.repaint();
            return;
        }
        if (actionEvent.getSource() == this.butSet && this.pointer != -1) {
            this.iStartNode = this.pointer;
            this.RepaintOffScreenImage();
            this.repaint();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (n < 0 || n > this.getSize().width - 16) {
            return;
        }
        n = mouseEvent.getY();
        int n2 = this.getSize().height / 34;
        if (n < 0 || n > (n2 *= 34)) {
            return;
        }
        n = mouseEvent.getY() / 34;
        if ((n += this.sb.getValue()) >= this.iNodes) {
            return;
        }
        this.pointer = n;
        this.RepaintOffScreenImage();
        this.repaint();
        this.td.SetHighlightPoint(this.Nodes[this.pointer]);
        this.td.CenterOn(this.lsse.Nodes[this.Nodes[this.pointer]]);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

