/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class UnitSelector
extends Panel
implements AdjustmentListener,
MouseListener {
    private LaserSquadScenarioEditor lsse;
    private Container holder;
    private int pointer;
    private Scrollbar sb;
    private Image USImage = null;
    private Graphics USGraph;
    private int USWidth = -1;
    private int USHeight = -1;
    private int View = 0;
    private int iSBMax;

    public UnitSelector(LaserSquadScenarioEditor laserSquadScenarioEditor, Container container, int n, int n2) {
        this.lsse = laserSquadScenarioEditor;
        this.holder = container;
        this.pointer = n;
        this.View = n2;
        int n3 = this.iSBMax = this.lsse.GenericUnits == null ? 0 : this.lsse.GenericUnits.length;
        if (this.View == 1) {
            this.iSBMax = this.lsse.Units.length;
        }
        this.sb = new Scrollbar(1, this.pointer, 1, 0, this.iSBMax);
        this.sb.addAdjustmentListener(this);
        this.add(this.sb);
        this.addMouseListener(this);
        this.setBackground(new Color(240, 240, 240));
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 > 30 && n4 > 30 && (n3 != this.USWidth || n4 != this.USHeight)) {
            this.USWidth = n3;
            this.USHeight = n4;
            this.USImage = this.createImage(n3 - 16, n4);
            this.USGraph = this.USImage.getGraphics();
            this.RepaintOffScreenImage();
            this.repaint();
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void RepaintOffScreenImage() {
        int n = this.USHeight;
        if (this.USGraph == null) {
            return;
        }
        this.USGraph.setColor(Color.WHITE);
        this.USGraph.fillRect(0, 0, this.USWidth, n);
        if (this.iSBMax == 0) {
            this.sb.setVisible(false);
            return;
        }
        this.sb.setVisible(true);
        this.sb.setBounds(158, 0, 16, n);
        this.sb.setVisibleAmount(n /= 34);
        if (this.sb.getMaximum() != this.iSBMax) {
            this.sb.setMaximum(this.iSBMax);
        }
        this.USGraph.setColor(Color.BLACK);
        this.USGraph.setFont(LaserSquadScenarioEditor.font);
        int n2 = this.sb.getValue();
        for (int i = 0; i < n && i + n2 < this.iSBMax; ++i) {
            if (this.View == 0) {
                this.lsse.GenericUnits[i + n2].DisplayDetails(this.USGraph, 1, 1 + i * 34, null);
            } else {
                this.lsse.Units[i + n2].DisplayDetails(this.USGraph, 1, 1 + i * 34, null);
            }
            if (i + n2 != this.pointer) continue;
            this.USGraph.setColor(Color.RED);
            this.USGraph.drawRect(0, i * 34, this.USWidth - 17, 33);
            this.USGraph.setColor(Color.BLACK);
        }
    }

    protected void reset() {
        this.pointer = 0;
        this.iSBMax = 0;
        if (this.View == 0 && this.lsse.GenericItems != null) {
            this.iSBMax = this.lsse.GenericUnits.length;
        }
        if (this.View == 1) {
            this.iSBMax = this.lsse.Units.length;
        }
        this.sb.setValues(0, 1, 0, this.iSBMax);
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.USImage != null) {
            this.USGraph.setColor(Color.WHITE);
            this.USGraph.drawLine(this.USWidth - 18, 1, this.USWidth - 18, 2);
            graphics.drawImage(this.USImage, 0, 0, null);
        }
        this.sb.setBounds(158, 0, 16, this.USHeight);
    }

    public int GetPointer() {
        return this.pointer;
    }

    protected void RecheckPointer() {
        this.iSBMax = 0;
        if (this.View == 0 && this.lsse.GenericUnits != null) {
            this.iSBMax = this.lsse.GenericUnits.length;
        }
        if (this.View == 1) {
            this.iSBMax = this.lsse.Units.length;
        }
        if (this.pointer >= this.iSBMax) {
            --this.pointer;
        }
        if (this.pointer < 0) {
            this.pointer = 0;
        }
        this.sb.setValues(this.pointer, 1, 0, this.iSBMax);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.RepaintOffScreenImage();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (n < 0 || n > this.getSize().width - 16) {
            return;
        }
        n = mouseEvent.getY();
        int n2 = this.getSize().height / 34;
        if (n < 0 || n > (n2 *= 34)) {
            return;
        }
        n = mouseEvent.getY() / 34;
        if ((n += this.sb.getValue()) >= this.iSBMax) {
            return;
        }
        this.pointer = n;
        this.RepaintOffScreenImage();
        this.repaint();
        if (this.holder.getClass().getName().equals("GenericUnitEditor")) {
            ((GenericUnitEditor)this.holder).NotifyClick();
        }
        if (this.holder.getClass().getName().equals("UnitEditor")) {
            ((UnitEditor)this.holder).NotifyClick();
        }
        if (mouseEvent.getClickCount() == 2 && this.holder.getClass().getName().equals("UnitSelectorWindow")) {
            ((UnitSelectorWindow)this.holder).InformParentOfChange();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

